module pbl_mym_option
  use pp_vardef
  use pbl_mym_option_symbol, only: mymodel3, my_length, full_impl, &
    & bh1991
  implicit none


!=======================================================================
! MY model options
!=======================================================================
  integer(4) ::  levflag = mymodel3

  integer(4) :: imp_mode = full_impl

  integer(4) :: tke_dlen = my_length
            ! switch to choose mixing length in the first order model
  integer(4) :: my_lowest_pd_surf = bh1991
            ! switch related to production terms at the lowest levels

  logical ::  l_tke_dlen_blackadar = .false.
            ! use the correction to the mixing length by Blackadar
            ! (valid only in the first order model)
  logical :: l_my_improved_closure = .true.
            ! use the improved closure constants in the MY model
            ! by Nakanishi and Niino.
            ! If False, use the original value from Mellor-Yamada(1982)
  logical :: l_my_condense = .true. 
            ! If TRUE, buoyancy parameters appearing in TKE production
            ! by buoyancy are evaluated with predicted variants
            ! assuming that fluctuation of heat and moisture can be
            ! described by the bi-normal probability distribution
            ! function. If false, buoyancy parameters calculated in the
            ! large scale clouds scheme (e.g. Smith, PC2...), are
            ! employed  to evaluate the buoyancy flux.
  logical :: l_shcu_buoy = .false.
            ! If TRUE, non-gradient buoyancy flux based on Lock and
            ! Mailhot(2006) is added.
  logical :: l_my_prod_adj = .true.
            ! If TRUE, production terms of covariance brought
            ! by the counter gradient terms are adjusted
            ! so that stability in integration can be secured.
  logical :: l_my_lowest_pd_surf_tqc = .false.
            ! If TRUE, the production terms for the covariaces are
            ! evaluated with surface fluxes. It is valid only when
            ! MY_lowest_pd_surf > 0.

contains
  subroutine pbl_mym_option_ini(levflag_in, imp_mode_in, tke_dlen_in, &
    & my_lowest_pd_surf_in, l_tke_dlen_blackadar_in, &
    & l_my_improved_closure_in, l_my_condense_in, l_shcu_buoy_in, &
    & l_my_prod_adj_in, l_my_lowest_pd_surf_tqc_in)
    implicit none

    integer(4), intent(in), optional :: levflag_in
    integer(4), intent(in), optional :: imp_mode_in
    integer(4), intent(in), optional :: tke_dlen_in
    integer(4), intent(in), optional :: my_lowest_pd_surf_in
    logical, intent(in), optional :: l_tke_dlen_blackadar_in
    logical, intent(in), optional :: l_my_improved_closure_in
    logical, intent(in), optional :: l_my_condense_in
    logical, intent(in), optional :: l_shcu_buoy_in
    logical, intent(in), optional :: l_my_prod_adj_in
    logical, intent(in), optional :: l_my_lowest_pd_surf_tqc_in

    if (present(levflag_in)) levflag = levflag_in
    if (present(imp_mode_in)) imp_mode = imp_mode_in
    if (present(tke_dlen_in)) tke_dlen = tke_dlen_in
    if (present(my_lowest_pd_surf_in)) &
      &   my_lowest_pd_surf = my_lowest_pd_surf_in
    
    if (present(l_tke_dlen_blackadar_in)) &
      &  l_tke_dlen_blackadar =  l_tke_dlen_blackadar_in
    if (present(l_my_improved_closure_in)) &
      & l_my_improved_closure = l_my_improved_closure_in
    if (present(l_my_condense_in)) l_my_condense = l_my_condense_in
    if (present(l_shcu_buoy_in)) l_shcu_buoy = l_shcu_buoy_in
    if (present(l_my_prod_adj_in)) l_my_prod_adj = l_my_prod_adj_in
    if (present(l_my_lowest_pd_surf_tqc_in)) &
      & l_my_lowest_pd_surf_tqc = l_my_lowest_pd_surf_tqc_in

  end subroutine pbl_mym_option_ini


end module pbl_mym_option
