module pp_monit
  use pp_vardef
  use pp_monit_type, only: pp_monit_meta_t, pp_monit_elem_len
  implicit none


  integer(4), save :: max_buf
  integer(4), save :: max_elem

  real(r_size), save :: monit_time
  real(r_size), save :: dt
  real(r_size), save :: dt_str = 1.0_r_size

!$OMP THREADPRIVATE(i_buf, i_elem, pp_monit_meta, monbuf)  

  integer(4), pointer, save :: i_buf
  integer(4), pointer, save :: i_elem

  type(pp_monit_meta_t), pointer, save :: pp_monit_meta(:)
  real(r_size), pointer, save :: monbuf(:)   ! max_buf 

  public :: pp_monit_ini
  public :: pp_monit_pre
  public :: pp_monit_store
  public :: pp_monit_get_buf_elem_num

  interface pp_monit_store
    module procedure pp_monit_store_0d
    module procedure pp_monit_store_1d
  end interface

  logical, save :: l_monit = .false.

contains
  subroutine pp_monit_ini(l_monit_in, dt_in, dt_str_in)
    use pp_vardef
    implicit none

    logical, intent(in) :: l_monit_in
    real(r_size), intent(in) :: dt_in
    real(r_size), intent(in), optional :: dt_str_in

    l_monit = l_monit_in
    dt = dt_in
    if (present(dt_str_in)) dt_str = dt_str_in

    return
  end subroutine pp_monit_ini

  subroutine pp_monit_pre(&
    & max_buf_in, max_elem_in, i_buf_in, i_elem_in, &
    & monbuf_in, pp_monit_meta_in)
    use pp_vardef
    implicit none

    integer(4), intent(in) :: max_buf_in
    integer(4), intent(in) :: max_elem_in
    
    integer(4), intent(in), target :: i_buf_in
    integer(4), intent(in), target :: i_elem_in

    real(r_size), intent(in), target :: monbuf_in(:)
    type(pp_monit_meta_t), intent(in), target :: pp_monit_meta_in(:)

    max_buf = max_buf_in
    max_elem = max_elem_in

    i_buf => i_buf_in
    i_elem => i_elem_in

    monbuf => monbuf_in
    pp_monit_meta => pp_monit_meta_in

    return
  end subroutine pp_monit_pre
  !
  subroutine pp_monit_set_time(monit_time_in)
    use pp_vardef
    implicit none

    real(r_size), intent(in) :: monit_time_in

    monit_time = monit_time_in
    return
  end subroutine pp_monit_set_time
  !
  subroutine pp_monit_store_0d(data, elem)
    use pp_vardef
    implicit none

    real(r_size), intent(in) :: data
    character(*), intent(in) :: elem

    real(r_size) :: data1(1)

    if (.not. l_monit) return

    data1(1) = data

    call pp_monit_store_1d(1, 1, 1, data1, elem)
    return
  end subroutine pp_monit_store_0d
  !
  subroutine pp_monit_store_1d(nz, kzst, kzen, data, elem)
    use pp_vardef
    implicit none

    integer(4), intent(in) :: nz
    integer(4), intent(in) :: kzst
    integer(4), intent(in) :: kzen
    real(r_size), intent(in) :: data(nz)
    character(*), intent(in) :: elem

    integer(4) :: kz
    real(r_size) :: mod_time
    character(pp_monit_elem_len) :: elem_tmp

    real(r_size), parameter :: eps = 1.0e-6_r_size

    if (.not. l_monit) return
    ! initial value is stored (count_str is initialized by 1)
    mod_time = mod(monit_time, dt_str)
    if (.not. (mod_time <  eps .or. dt_str - mod_time < eps)) return

    i_elem = i_elem + 1

    if (i_elem >= max_elem) then
      write(6, *) 'Error! Insufficient elem array size in pp_monit', &
        & i_elem, max_elem
      stop 98
    end if
    if (i_buf + 1 >= max_buf) then
      write(6, *) 'Error! Insufficient buffer size in pp_monit'
      stop 99
    end if

    do kz = kzst, kzen
      monbuf(i_buf + kz - kzst + 1) = data(kz)
    end do
    pp_monit_meta(i_elem)%stidx = i_buf + 1
    pp_monit_meta(i_elem)%kzst= kzst
    pp_monit_meta(i_elem)%kzen = kzen

    elem_tmp(1:pp_monit_elem_len) = ' '
    elem_tmp(1:len(elem)) = elem(1:len(elem))

    pp_monit_meta(i_elem)%elem = elem_tmp

    pp_monit_meta(i_elem)%monit_time = monit_time

    i_buf = i_buf + kzen - kzst + 1

    return
  end subroutine pp_monit_store_1d
  !
  subroutine pp_monit_store_p(kz, data, elem)
    use pp_vardef
    implicit none

    integer(4), intent(in) :: kz
    real(r_size), intent(in) :: data
    character(*), intent(in) :: elem

    real(r_size) :: mod_time
    character(pp_monit_elem_len) :: elem_tmp

    real(r_size), parameter :: eps = 1.0e-6_r_size

    if (.not. l_monit) return
    ! initial value is stored (count_str is initialized by 1)
    mod_time = mod(monit_time, dt_str)
    if (.not. (mod_time <  eps .or. dt_str - mod_time < eps)) return

    i_elem = i_elem + 1

    if (i_elem >= max_elem) then
      write(6, *) 'Error! Insufficient elem array size in pp_monit', &
        & i_elem, max_elem
      stop 98
    end if
    if (i_buf + 1 >= max_buf) then
      write(6, *) 'Error! Insufficient buffer size in pp_monit'
      stop 99
    end if

    monbuf(i_buf + 1) = data
    pp_monit_meta(i_elem)%stidx = i_buf + 1
    pp_monit_meta(i_elem)%kzst= kz
    pp_monit_meta(i_elem)%kzen = kz

    elem_tmp(1:pp_monit_elem_len) = ' '
    elem_tmp(1:len(elem)) = elem(1:len(elem))

    pp_monit_meta(i_elem)%elem = elem_tmp

    pp_monit_meta(i_elem)%monit_time = monit_time

    i_buf = i_buf + 1

    return
  end subroutine pp_monit_store_p

  subroutine pp_monit_get_buf_elem_num(n_elm, n_buf)
    implicit none

    integer(4), intent(out) :: n_elm
    integer(4), intent(out) :: n_buf

    n_elm = i_elem
    n_buf = i_buf
    return

  end subroutine pp_monit_get_buf_elem_num
  
end module pp_monit
