!--
!----------------------------------------------------------------------
!     Copyright (c) 2002-2013 SPMDOEL Development Group
!----------------------------------------------------------------------
!ɽ  wa_base_module_sjpack
!
!  spml/wa_base_module_sjpack ⥸塼ϵ̾Ǥήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 wa_module_sjpack β⥸塼Ǥ, ڥȥ׻
!  Ū Fortran90 ؿ󶡤. 
!
!  ̾ 1 إǥ w_base_module_sjpack ⥸塼¿إǥѤ
!  ĥΤǤ, ƱʣĤΥڥȥǡ, ʻǡ
!  ФѴԤ.
!
!   ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
!
!  Υ⥸塼Ȥˤä w_base_initial Ƥ
!  ȿ, ʻ򤷤Ƥɬפ. 
!
!
!  2009/09/05  ݹ  wa_base_module  SJPACK б¤
!      2013/02/12  ݹ  wa_StreamPotential2Vector,  
!                            wa_Vector2VorDiv Ƴ
!      2013/02/14  ݹ  wa_VectorCosLat2VorDiv Ƴ
!      2013/02/23  ݹ  wa_base_Finalize Ƴ
!
!++
module wa_base_module_sjpack
  !
  != wa_base_module_sjpack
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: wa_base_module_sjpack.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/wa_base_module_sjpack ⥸塼ϵ̾Ǥήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿 
  ! ⥸塼 wa_module_sjpack β⥸塼Ǥ, ڥȥ׻
  ! Ū Fortran90 ؿ󶡤. 
  !
  ! ̾ 1 إǥ w_base_module_sjpack ⥸塼¿إǥѤ
  ! ĥΤǤ, ƱʣĤΥڥȥǡ, ʻǡ
  ! ФѴԤ.
  !
  !  ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  ! ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  ! Υ⥸塼Ȥˤä w_base_initial Ƥ
  ! ȿ, ʻ򤷤Ƥɬפ. 
  !
  use dc_message
  use w_base_module_sjpack, only : im, jm, nm=>nn, xy_w, w_xy, &
                                   w_StreamPotential2Vector,   &
                                   w_Vector2VorDiv, w_VectorCosLat2VorDiv

  implicit none

  integer               :: km=16         ! Ʊ˽ǡ(ؤο).
                                         ! SNPACK ѥ롼ȤθߴΤ.
                                         ! wa_base_module_sjpack Ǥ
                                         ! Υѥ᥿ˤ¤ʤ.

  private

  public km                                    ! ؿ
  public wa_base_Initial                       ! ֥롼
  public wa_base_Finalize                      ! λ

  public xya_wa, wa_xya                        ! Ѵؿ
  public wa_StreamPotential2Vector             ! ήݥƥ󥷥뤫®پ׻
  public wa_Vector2VorDiv                      ! ®پ줫鱲ȯ׻
  public wa_VectorCosLat2VorDiv                ! ®پ줫鱲ȯ׻

  save km                                      ! ǡ(ؿ)򵭲

  contains
  !---------------  -----------------
    subroutine wa_base_initial(k_in)
      ! 
      ! SNPACK  wa_base_initial θߴΤΥߡ֥롼
      !
      integer,intent(in) :: k_in               !(in) ǡ(ؿ)

      km = k_in

      call MessageNotify('M','wa_base_initial',&
        'No need to set maximum level number and in wa_base_module_sjpack (2013/02/23) ')
            
    end subroutine wa_base_Initial

  !--------------- Ѵ -----------------

    function xya_wa(wa_data,ipow,iflag)    ! Ĵ´ؿڥȥ -> ʻ
      !
      ! ڥȥǡʻҥǡѴ(¿).
      !
      real(8), intent(in)   :: wa_data(:,:)
      !(in) ڥȥǡ((nm+1)*(nm+1),:)
      !
      real(8)               :: xya_wa(0:im-1,1:jm,size(wa_data,2))
      !(out) ʻǡ(0:im-1,1:jm,:)
      !
      integer, intent(in), optional  :: ipow
      !(in) Ѥ 1/cos μ. ά 0. 
      integer, intent(in), optional  :: iflag
      !(in) Ѵμ
      !    0 : ̾Ѵ
      !   -1 : ʬѤѴ
      !    1 : ʬ cosա/ߦ ѤѴ
      !    2 : sinդѤѴ
      !    ά 0.
      !
      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0
      integer ipval, ifval
      integer k

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      do k=1,size(wa_data,2)
        xya_wa(:,:,k) = xy_w(wa_data(:,k),iflag=ifval,ipow=ipval)
      enddo

    end function xya_wa

    function wa_xya(xya_data,ipow,iflag) ! ʻ -> Ĵ´ؿڥȥ
      !
      ! ʻҥǡ饹ڥȥǡ()Ѵ(¿).
      !
      real(8), intent(in)   :: xya_data(0:,:,:)
      !(in) ʻǡ(0:im-1,1:jm,:)

      real(8)               :: wa_xya((nm+1)*(nm+1),size(xya_data,3))
      !(out) ڥȥǡ((nm+1)*(nm+1),:)

      integer, intent(in), optional  :: ipow
      !(in) ѴƱ˺Ѥ 1/cos μ. ά 0.

      integer, intent(in), optional  :: iflag
      ! Ѵμ
      !    0 : ̾Ѵ
      !   -1 : ʬѤѴ 
      !    1 : ʬ 1/cosա(f cos^2)/ߦ ѤѴ
      !    2 : sinդѤѴ
      !  ά 0.
      !
      integer, parameter  :: ipow_default  = 0      ! åǥե
      integer, parameter  :: iflag_default = 0      ! åǥե

      integer ipval, ifval
      integer k

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      do k=1,size(xya_data,3)
         wa_xya(:,k) = w_xy(xya_data(:,:,k),iflag=ifval,ipow=ipval)
      enddo

    end function wa_xya

  !----------- ®, ١ȯ, ήݥƥ󥷥׻ -------------

    subroutine wa_StreamPotential2Vector(wa_Psi, wa_Chi, xya_U, xya_V)
      !
      ! ήݥƥ󥷥(ڥȥǡ)®پ(ʻҥǡ)
      ! ()Ѵ(¿)
      !
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !   u cos =      ߦ/ߦ - cosբߦ/ߦ, 
      !   v cos = cosբߦ/ߦ +      ߦ/ߦ 
      !
      real(8), intent(in)   :: wa_Psi(:,:)
      !(in) ήؿ((nm+1)*(nm+1),:)

      real(8), intent(in)   :: wa_Chi(:,:)
      !(in) ®٥ݥƥ󥷥((nm+1)*(nm+1),:)

      real(8), intent(out)   :: xya_U(0:im-1,1:jm,size(wa_Psi,2))
      !(out) ®ٷʬ(0:im-1,1:jm,:)

      real(8), intent(out)   :: xya_V(0:im-1,1:jm,size(wa_Psi,2))
      !(out) ®ٰʬ(0:im-1,1:jm,:)

      integer :: k

      do k=1,size(wa_Psi,2)
         call w_StreamPotential2Vector &
              ( wa_Psi(:,k), wa_Chi(:,k), xya_U(:,:,k), xya_V(:,:,k) )
      enddo

    end subroutine wa_StreamPotential2Vector

    subroutine wa_Vector2VorDiv(xya_U, xya_V, wa_Vor, wa_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(¿)
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xya_U(0:,:,:)
      !(in) ®ٷʬ(0:im-1,1:jm,:)

      real(8), intent(in)   :: xya_V(0:,:,:)
      !(in) ®ٰʬ(0:im-1,1:jm,:)

      real(8), intent(out)   :: wa_Vor((nm+1)*(nm+1),size(xya_U,3))
      !(out) ήؿ
      real(8), intent(out)   :: wa_Div((nm+1)*(nm+1),size(xya_U,3))
      !(out) ®٥ݥƥ󥷥

      integer :: k

      do k=1,size(xya_U,3)
         call w_Vector2VorDiv &
               (xya_U(:,:,k), xya_V(:,:,k), wa_Vor(:,k), wa_Div(:,k))
      enddo
    end subroutine wa_Vector2VorDiv

    subroutine wa_VectorCosLat2VorDiv(xya_UCosLat, xya_VCosLat, wa_Vor, wa_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(¿)
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xya_UCosLat(0:,:,:)
      !(in) ®ٷʬ * cos(lat) (0:im-1,1:jm,:)

      real(8), intent(in)   :: xya_VCosLat(0:,:,:)
      !(in) ®ٰʬ * cos(lat) (0:im-1,1:jm,:)

      real(8), intent(out)   :: wa_Vor((nm+1)*(nm+1),size(xya_UCosLat,3))
      !(out) ήؿ
      real(8), intent(out)   :: wa_Div((nm+1)*(nm+1),size(xya_UCosLat,3))
      !(out) ®٥ݥƥ󥷥

      integer :: k

      do k=1,size(xya_UCosLat,3)
         call w_VectorCosLat2VorDiv &
               (xya_UCosLat(:,:,k), xya_VCosLat(:,:,k), wa_Vor(:,k), wa_Div(:,k))
      enddo
    end subroutine wa_VectorCosLat2VorDiv

  !--------------- λ -----------------
    subroutine wa_base_Finalize
      ! 
      !
      ! Υ֥롼ñȤѤΤǤʤ, 
      ! ̥֥롼 wa_Finalize Ѥ뤳.
      !
      call MessageNotify('M','wa_base_finalize',&
           'wa_base_module_sjpack is finalized (dummy, 2013/02/23) ')

    end subroutine wa_base_Finalize

end module wa_base_module_sjpack
