= 概要

dcpam を用いて入射フラックスの季節進行を求める.
dcpam5-20150217 で動作確認済.

= 同梱物

* ソースコード
  * dcpam_insol.f90
* conf/: サンプル設定ファイル
  * dcpam_insol_T21L16.conf
    * 現代の地球. 低解像度版.
  * dcpam_insol_T170L16.conf
    * 現代の地球. 高解像度版.
  * dcpam_insol_T170L16_MH_PMIP3.conf
    * PMIP3 による 6000 年前の地球. 高解像度版.
  * dcpam_insol_T170L16_LGM_PMIP3.conf
    * PMIP3 による 21000 年前の地球. 高解像度版.
* nc/: 出力例 (NetCDF)
  * 上記設定ファイルの dcpam_insol を ISRZM, 拡張子を nc に変えたものに対応.
* eps/, png/:  (eps, png)
  * 出力例の拡張子を eps, png に変えたものに対応.
  * 値がゼロ (極夜) の場所は白く塗っている.

= 使い方

* dcpam の src/main 以下に dcpam_insol.f90 を置く.
* Makefile の OBJS に
  "dcpam_insol.o dcpam_insol" を追記する.
* dcpam の make を行うと, 実行ファイル dcpam_insol が出来る.
* dcpam_insol および設定ファイルを適当な場所にコピーする.
  * 軌道要素の詳細は付録「地球の各時代における軌道要素」を参照
* 以下のように実行する
  * $ ./dcpam_insol -N=dcpam_insol_T21L16.conf
* 帯状平均された入射量が ISRZM.nc に記録される

= 注意点

設定ファイルの設定方法は DCPAM 本体に準ずる.
ただし太陽定数 SolarConst は
rad_short_income_nml ではなく
dcpam_insol_nml に記入する必要がある.
具体的にはサンプルの設定ファイルを参照のこと.

= 参考文献

* ((<"Paleoclimate Modelling Intercomparison Project Phase III"|URL:http://pmip3.lsce.ipsl.fr/>))

= 付録

== 地球の各時代における軌道要素

地球における, 代表的な時代の軌道要素を示す.
なお, 過去 100 万年, 未来 10 万年の任意の時代の軌道要素は
DCPAM の contrib/2013-09-26_noda_orbital_elements/
にあるプログラムを用いて近似値を得ることができる.

=== 現代 (dcpam default)

  EpsOrb               =   23.44d0,
  PerLonFromVE         =  282.768413d0,
  Eccentricity         =    0.016713d0,

=== mid-Holocene (6000 年前, PMIP3 より) 

  EpsOrb               =   24.105d0,
  PerLonFromVE         =  180.87d0,
  Eccentricity         =    0.018682d0,

=== LGM (21000 年前, PMIP3 より)

  EpsOrb               =   22.949d0,
  PerLonFromVE         =  294.42d0,
  Eccentricity         =    0.018994d0,

=== 2000 年 (Berger, 1978 の近似式より)

  ecc = 0.01670604554592944
  obl = 23.439801936465173
  peri-180 = 102.92155326701528

=== 1850 年 (Berger, 1978 の近似式より)

  ecc = 0.01676667705822194
  obl = 23.45931072233009
  peri-180 = 100.35294209395919

=== mid-Holocene (紀元前 4000 年. Berger, 1978 の近似式より)

  ecc = 0.018671872797703274
  obl = 24.10180474913882
  peri-180 = 1.6597153267281832

=== LGM (紀元前 19000 年. Berger, 1978 の近似式より)

  ecc = 0.019005285074771634
  obl = 22.957089810291265
  peri-180 = 114.97653713235356
