!== ¸ (APE; Aqua Planet Experiment) ƥȥץ
!
! Authors::   Yukiko YAMADA, Masaki ISHIWATARI
! Version::   $Id: dcpam_ape.f90,v 1.3 2007/06/09 14:37:08 momoko Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

program dcpam_ape
  !
  !dcpam ΥƥȥץȤƤο¸ 
  !(APE; Aqua Planet Experiment) ԤʤץǤ.
  !ߤ main/init.f90 ˤäƽͤ
  !ɬפޤ.
  !

  !----- NAMELIST ̾⥸塼 -----
  use nmlfile_mod, only: nmlfile_init, nmlfile_open, nmlfile_close

  !----- ʪ⥸塼 -----
  use constants_mod, only: SecPerDay

  !----- ¤λȥ⥸塼 -----
  use dycore_type_mod, only: DYCORE_VARS, DYCORE_DIMS, STRING, INTKIND, REKIND

  !----- ʻ⥸塼 -----
  use dycore_grid_mod, only: dycore_grid_init, dycore_grid_end, &
       &                     im, jm, km, nm

  !----- ǡI/O⥸塼 -----
  use dycore_in_mod,   only: dycore_in_init,                  &
       &                     dycore_in_dims, dycore_in_vars,  &
       &                     dycore_in_end
  use dycore_out_mod,  only: dycore_out_init, dycore_out_put, &
       &                     dycore_out_end

  !----- ϳز⥸塼 (DCPAM-APE ϳإᥤ⥸塼) -----
  use dcpam_ape_dynamics_mod, only: dcpam_ape_dynamics

  !----- ʪ⥸塼 (DCPAM-APE ʪᥤ⥸塼) -----
  use dcpam_ape_physics_mod, only: dcpam_ape_physics

  !----- ϳز⥸塼 (ڥȥǥ) -----
  use dycore_dynamics_mod, only: dycore_dynamics_init, &
       &                         dycore_dynamics_end

  !----- ֹե륿⥸塼 -----
  use dycore_time_mod, only: dycore_time_init, dycore_time_progress, &
       &                     dycore_time_end,  dycore_time_filter,   &
       &                     StepInterval, OutputStep, &
       &                     CurrentLoop, CurrentTime, DelTime

  !----- ǡ I/O ġ -----
    use io_gt4_out_mod , only: io_gt4_out_SetVars

  !----- ޥɥ饤ϥġ -----
  use dc_args, only: ARGS, Open, Debug, Help, Strict, Close

  !----- ǥХåѥġ -----
  use dc_trace,  only: SetDebug, DbgMessage, BeginSub, EndSub
  use dc_message,only: MessageNotify
  use dc_string, only: toChar, Printf

  implicit none

  logical :: CalcDynamics    = .true.  ! ϳإα黻
  logical :: CalcDiffusion   = .true.  ! Ȼα黻
  logical :: CalcHS94forcing = .false. ! Held and Suarez(1994) ˤ붯

  namelist /dcpam_ape_nml/ CalcDynamics, CalcDiffusion, CalcHS94forcing
    ! ¸Ԥ

  !-------------------------------------------------------------------
  !   ѿ
  !-------------------------------------------------------------------
  !----- ǡƤ (ּΤ߽) -----
  type(DYCORE_DIMS)          :: Dims       ! ǡ

  !----- ׻ʻǡƤ -----
  type(DYCORE_VARS)          :: Vars_b     ! ʻǡ(t-t)
  type(DYCORE_VARS)          :: Vars_n     ! ʻǡ(t)
  type(DYCORE_VARS)          :: Vars_a     ! ʻǡ(t+t)

  !----- ѿ -----
  !for time measure in temporarily
  real(REKIND) :: &
       & start_time_init, end_time_init, &
       & start_time_dynmcs, end_time_dynmcs, store_time_dynmcs = 0.0, &
       & start_time_physics, end_time_physics, store_time_physics = 0.0
  integer(INTKIND) :: dateval(1:8)

  !for nmlfile_mod
  integer(INTKIND)   :: nmlstat, nmlunit
  logical            :: nmlreadable

  !for dc_args
  type(ARGS) :: arg

  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: dcpam_ape.f90,v 1.3 2007/06/09 14:37:08 momoko Exp $'
  character(STRING),  parameter:: subname = "dcpam_ape"

continue
  !-------------------------------------------------------------------
  !   ǥХå⡼ɳ
  !-------------------------------------------------------------------
  call Open(arg)
  call Debug(arg); call Help(arg) ; call Strict(arg)
  call Close(arg)

  call BeginSub(subname, version=version)

  !-------------------------------------------------------------------
  !   use CPU_TIME
  !-------------------------------------------------------------------
  call cpu_time(start_time_init)

  !-------------------------------------------------------------------
  !   NAMELIST file Setting
  !-------------------------------------------------------------------
  call nmlfile_init('dcpam_ape.nml')

  !----------------------------------------------------------------
  !   Read init_nml
  !----------------------------------------------------------------
  call nmlfile_open(nmlunit, nmlreadable)
  if (nmlreadable) then
     read(nmlunit, nml=dcpam_ape_nml, iostat=nmlstat)
     call DbgMessage('Stat of NAMELIST dcpam_ape_nml Input is <%d>', &
          &           i=(/nmlstat/))
     write(0, nml=dcpam_ape_nml)
  else
     call DbgMessage('Not Read NAMELIST dcpam_ape_nml')
     call MessageNotify('W', subname, &
          & 'Can not Read NAMELIST dcpam_ape_nml. Force Use Default Value.')
  end if
  call nmlfile_close

  !-------------------------------------------------------------------
  !   ʻμ
  !-------------------------------------------------------------------
  call dycore_grid_init

  !-------------------------------------------------------------------
  !   ͥǡɤ߹ (gt4f90io ξ̥⥸塼)
  !     (ե̾ɤ߹ѿ NAMELIST ѹ)
  !-------------------------------------------------------------------
  call dycore_in_init
  call dycore_in_dims(  &
       & Dims          )  ! intent(out): ǡ

  call dycore_in_vars( &
       & Vars_b      , & ! intent(out): ʻǡ(t-t)
       & Vars_n    )     ! intent(out): ʻǡ(t)

  !-------------------------------------------------------------------
  !   ֡ ƥåפ˴ؤ
  !-------------------------------------------------------------------
  call dycore_time_init

  !-------------------------------------------------------------------
  !   ǡϤν
  !-------------------------------------------------------------------
  call dycore_out_init( &
       & Dims           ) ! intent(in): ǡ

  ! -- ʪʬ -- 
  call io_gt4_out_SetVars('GeoPot')
  call io_gt4_out_SetVars('Press')
  call io_gt4_out_SetVars('Rain')
  call io_gt4_out_SetVars('DPsDt')
  call io_gt4_out_SetVars('DNegQvapDt')
  call io_gt4_out_SetVars('DLscQvapDt')
  call io_gt4_out_SetVars('DLscTempDt')
  call io_gt4_out_SetVars('LscRain')
  call io_gt4_out_SetVars('DCumulusQvapDt')
  call io_gt4_out_SetVars('DCumulusTempDt')
  call io_gt4_out_SetVars('CumulusRain')
  call io_gt4_out_SetVars('DDryTempDt')
  call io_gt4_out_SetVars('TempFlux')
  call io_gt4_out_SetVars('LatentEnergyFlux')
  call io_gt4_out_SetVars('RadSFlux')
  call io_gt4_out_SetVars('RadLFlux')
  call io_gt4_out_SetVars('SurfTemp')
  call io_gt4_out_SetVars('DRadLTempDt')
  call io_gt4_out_SetVars('DRadSTempDt')
  call io_gt4_out_SetVars('DVerdiffVelLonDt')
  call io_gt4_out_SetVars('DVerdiffVelLatDt')
  call io_gt4_out_SetVars('DVerdiffTempDt')
  call io_gt4_out_SetVars('DVerdiffQvapDt')

  !-------------------------------------------------------------------
  !   ϳز黻ν
  !-------------------------------------------------------------------
  call dycore_dynamics_init( &
       & Dims              , & ! intent(in): ǡ
       & Vars_a          )     ! intent(out): ʻǡ(t+t)

  !-------------------------------------------------------------------
  !   use CPU_TIME
  !-------------------------------------------------------------------
  call cpu_time(end_time_init)
  call date_and_time(values=dateval)
  call Printf(6, &
       & 'Elapsed Time=<%r>, Start=<%r>, Stop=<%r>, ' // &
       & 'Now=<%d/%d/%d  %d:%d:%d>', &
       & r=(/end_time_init - start_time_init, &
       &     start_time_init, end_time_init/), &
       & i=(/dateval(1), dateval(2), dateval(3), &
       &     dateval(5), dateval(6), dateval(7)  /) )


  !-------------------------------------------------------------------
  !   ᥤ롼
  !-------------------------------------------------------------------
  MainLoop : do
     call BeginSub( subname, &
          & 'MainLoop : CurrentLoop=<%d>, CurrentTime=<%f>', &
          & i=(/CurrentLoop/), d=(/CurrentTime/) )

     !----------------------------------------------------------------
     !   ϳز黻
     !----------------------------------------------------------------
     call cpu_time(start_time_dynmcs)
     call dcpam_ape_dynamics( &
          & Dims          , &   ! intent(in)   : ǡ
          & Vars_b        , &   ! intent(in)   : ʻǡ(t-t)
          & Vars_n        , &   ! intent(in)   : ʻǡ(t)
          & Vars_a  )           ! intent(inout): ʻǡ(t+t)
     call cpu_time(end_time_dynmcs)
     
     !----------------------------------------------------------------
     !   ʪ黻
     !----------------------------------------------------------------
     call cpu_time(start_time_physics)
     call dcpam_ape_physics(  &
          & Dims          , &   ! intent(in)   : ǡ
          & Vars_a  )           ! intent(inout): ʻǡ(t+t)
     call cpu_time(end_time_physics)

     !----------------------------------------------------------------
     !   ե륿
     !----------------------------------------------------------------
     call dycore_time_filter( &
       & Vars_b           , & ! intent(in)   : ʻǡ(t-t)
       & Vars_n           , & ! intent(inout): ʻǡ(t)
       & Vars_a  )            ! intent(in)   : ʻǡ(t+t)

     !----------------------------------------------------------------
     !   ǡν
     !----------------------------------------------------------------
     call dycore_out_put( &
       & Vars_n  )            ! intent(in): ʻǡ(t)

     !----------------------------------------------------------------
     !   ﹹ
     !----------------------------------------------------------------
     call dycore_time_progress( &
       & Vars_b           , & ! intent(inout): ʻǡ(t-t)
       & Vars_n           , & ! intent(inout): ʻǡ(t)
       & Vars_a  )            ! intent(inout): ʻǡ(t+t)

     !-------------------------------------------------------------------
     !   use CPU_TIME
     !-------------------------------------------------------------------
     store_time_physics = store_time_physics &
          & + (end_time_physics - start_time_physics)
     store_time_dynmcs = store_time_dynmcs &
          & + (end_time_dynmcs - start_time_dynmcs)

     if ( mod(CurrentLoop, StepInterval) == 0 ) then
        call Printf(6, '')
        call Printf(6, '-- ***              ***  ')
        call Printf(6, '-- *** TIME         ***  ')
        call Printf(6, '-- ***      KEEPING ***  ')
        call Printf(6, '-- ***              ***  ')
        call Printf(6, &
             & '--CurrentLoop=<%d>, CurrentTime=<%f>, Day=<%f>', &
             & i=(/CurrentLoop/), d=(/CurrentTime, CurrentTime/SecPerDay /) )
        
        call Printf(6, '--Remaining Loop  ' // &
             & ': RemainingLoop=<%d>, RemainingTime=<%f>, Day=<%f>', &
             & i=(/StepInterval * OutputStep - CurrentLoop/), &
             & d=(/StepInterval * OutputStep * DelTime - CurrentTime , &
             &     ( StepInterval * OutputStep * DelTime &
             &        - CurrentTime ) / SecPerDay /)    )

        call date_and_time(values=dateval)
        call Printf(6, '--Current Time <%d/%d/%d  %d:%d:%d>', &
             & i=(/dateval(1), dateval(2), dateval(3), &
             &     dateval(5), dateval(6), dateval(7)  /) )

        call Printf(6, '--[Categoly]  : [Stored]       ' //  &
             &          '[Current]      [Start]        [Stop] '  )

        call Printf(6, '--Dynamics    : <%r> <%r> <%r> <%r> ',  &
             & r=(/store_time_dynmcs, &
             &     end_time_dynmcs - start_time_dynmcs, &
             &     start_time_dynmcs, end_time_dynmcs/)   )

        call Printf(6, '--Physics   : <%r> <%r> <%r> <%r> ',  &
             & r=(/store_time_physics, &
             &     end_time_physics - start_time_physics, &
             &     start_time_physics, end_time_physics/)   )

     end if

     !----------------------------------------------------------------
     !   롼פȴФɤȽ
     !----------------------------------------------------------------
     if ( CurrentLoop > StepInterval * OutputStep ) then
        exit MainLoop
     endif

     call EndSub(subname)
  enddo MainLoop

  call dycore_out_end

  call EndSub(subname)
end program dcpam_ape











