!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
!
!= Module dcpam_ape_physics_mod
!
!   * Developers: Morikawa Yasuhiro, Yamada Yukiko
!   * Version: $Id: dcpam_ape_physics.f90,v 1.11 2007/08/27 14:45:43 momoko Exp $
!   * Tag Name: $Name:  $
!   * Change History: 
!
!== Overview
!
!DCPAM-APE Physics Main module
!
!== Error Handling
!
!== Known Bugs
!
!== Note
! * The module for corrections of Surface pressure and specific humidity 
!   due to the change of atmospheric mass can be used if you nedd.
!   When you use the module, delete the comment at the part of
!   call physics_ps_correction( ....
!
!== Future Plans
! * xy_SurfTemp ϥᥤǴ褦ˤƥᥤ֤褦ˤ뤳.
!
!== Histrory
!  2007-5-12 M.Ishiwatari ͥ⥸塼iterface ѹ. xyr_Temp ɲ.
!  2007-5-17 M.Ishiwatari ѿ xyr_RadLFluxCorrected 
!

module dcpam_ape_physics_mod
  use type_mod,      only : STRING
  use grid_3d_mod,   only: im, jm, km
  implicit none
  private
  public :: dcpam_ape_physics       ! subroutines
  character(STRING),parameter:: version = &
       & '$Id: dcpam_ape_physics.f90,v 1.11 2007/08/27 14:45:43 momoko Exp $'
  character(STRING),parameter:: tagname = '$Name:  $'
  logical,save:: dcpam_ape_physics_initialized = .false.


contains

  subroutine dcpam_ape_physics( Dims, Vars_a )
    !
    ! Physics main module
    ! DCPAM-APE Physics Main module
    !
    use dycore_type_mod, only: DYCORE_VARS, DYCORE_DIMS, STRING, INTKIND, &
         &                     REKIND, DBKIND
    use grid_3d_mod,     only: im, jm, km
    use time_mod,    only: DelTime
    use spml_mod,    only: wa_Div_xya_xya, xya_wa, wa_xya, xy_w, w_xy, &
         & xya_GradLon_wa,xya_GradLat_wa, wa_LaplaInv_wa
    use constants_mod, only: R0
    use io_gt4_out_mod , only: io_gt4_out_Put
    use dc_trace,        only: BeginSub, EndSub, DbgMessage
    use physics_interpolate_mod, only: physics_interpolate_temp, &
         &                             physics_interpolate_geopot
    use physics_negq_mod, only: physics_negq
    use physics_lscond_mod, only: physics_lscond

    ! switch of cumulus parameterization
    use physics_cumulus_adjust_mod , only: physics_cumulus_adjust
    !use physics_cumulus_adjust_muchwater_mod , only: physics_cumulus_adjust
    !use physics_cumulus_none_mod , only: physics_cumulus_adjust

    use physics_dryadjust_mod , only: physics_dryadjust
    use physics_ground_mod, only: physics_ground
    use physics_radiation_main_mod, only: physics_radiation_main, &
         & physics_radiation_deltemp
    use physics_verdiff_main_mod, only: physics_verdiff_main
    use physics_surface_main_mod, only: physics_surface_main
    use physics_implicit_mod, only: physics_implicit_init, &
      & physics_implicit_integrate, &
      & physics_implicit_fluxcorrection

    ! switch of surface pressure correction 
    use physics_ps_correction_none_mod, only: physics_ps_correction
    !use physics_ps_correction_mod, only: physics_ps_correction

    ! switch of vertical filter
    use phys_vfilter_none_mod, only: phys_vfilter
    !use phys_vfilter_conserve_mod, only: phys_vfilter

    use dycore_grid_mod, only: nm

    implicit none
    type(DYCORE_DIMS), intent(in)   :: Dims   ! ǡ
    type(DYCORE_VARS), intent(inout):: Vars_a ! ʻǡ(t+t)
    character(STRING),  parameter:: subname = "dcpam_ape_physics"
    real(DBKIND) :: xyr_Temp(im,jm,km+1)    !  (Ⱦ)
    real(DBKIND) :: xyz_Press(im,jm,km)      !  ()
    real(DBKIND) :: xyr_Press(im,jm,km+1)    !  (Ⱦ)
    real(DBKIND) :: xyz_GeoPot(im,jm,km)     ! ݥƥ󥷥()
    real(DBKIND) :: xyr_GeoPot(im,jm,km+1)   ! ݥƥ󥷥(Ⱦ)
    real(DBKIND) :: xyz_DNegQvap1Dt(im,jm,km) ! 漾 (漾ѲΨ)
    real(DBKIND) :: xyz_DNegQvap2Dt(im,jm,km) ! 漾 (漾ѲΨ)
    real(DBKIND) :: xyz_DLscTempDt(im,jm,km) ! 絬϶ŷˤ벹ѲΨ
    real(DBKIND) :: xyz_DLscQvapDt(im,jm,km) ! 絬϶ŷˤ漾ѲΨ
    real(DBKIND) :: xy_LscRain(im,jm)        ! 絬϶ŷˤ߿
    real(DBKIND) :: xyz_DCumulusTempDt(im,jm,km) ! ѱˤ벹ѲΨ
    real(DBKIND) :: xyz_DCumulusQvapDt(im,jm,km) ! ѱˤ漾ѲΨ
    real(DBKIND) :: xy_CumulusRain(im,jm)    ! ѱˤ߿
    real(DBKIND) :: xyz_DDryTempDt(im,jm,km) ! ήĴˤ벹ѲΨ
    real(DBKIND) :: xy_Rain(im,jm)           ! cumulus + lsc ߿
    real(DBKIND) :: xy_Ps_b(im,jm)              ! ɽ̵

    real(DBKIND) :: xyz_DRadLTempDt(im,jm,km)  ! ĹȲǮΨ
    real(DBKIND) :: xyz_DRadSTempDt(im,jm,km)   ! ûȲǮΨ
! (2007-5-17 ) ۵
!    real(DBKIND) :: xy_SurfTemp(im,jm)          ! ɽ̲
    real(DBKIND),allocatable,save :: xy_SurfTemp(:,:)          ! ɽ̲
    real(DBKIND) :: xy_SurfAlbedo(im,jm)        ! ɽ٥
    real(DBKIND) :: xy_SurfHumidCoeff(im,jm)    ! ɽ
    real(DBKIND) :: xy_SurfRoughLength(im,jm)   ! ɽĹ
    real(DBKIND) :: xy_SurfHeatCapacity(im,jm)  ! ɽǮ
    real(DBKIND) :: xy_GroundTempFlux(im,jm)     ! Ǯեå
    real(DBKIND) :: xyr_RadLFlux(im,jm,km+1)           ! Ĺȥեå
    real(DBKIND) :: xyr_RadLFluxCorrected(im,jm,km+1) ! Ĺȥեå
    real(DBKIND) :: xyo_SurfRadLMatrix(im,jm,-1:1)     ! Աɽ
    real(DBKIND) :: xyro_DelRadLFlux(im,jm,km+1,0:1)   ! ĹɽѲ
    real(DBKIND) :: xyr_RadSFlux(im,jm,km+1)           ! ͥեå
    real(DBKIND) :: xyr_VelLonFlux(im,jm,km+1)         ! ®ٷʬեå
    real(DBKIND) :: xyr_VelLatFlux(im,jm,km+1) ! ®ٰʬեå
    real(DBKIND) :: xyr_TempFlux(im,jm,km+1)           ! ٥եå
    real(DBKIND) :: xyr_QvapFlux(im,jm,km+1)           ! 漾եå
    real(DBKIND) :: xyzo_VelMatrix(im,jm,km,-1:1)      ! ®ٱ
    real(DBKIND) :: xyzo_TempMatrix(im,jm,0:km,-1:1)   ! ٱ
    real(DBKIND) :: xyzo_QvapMatrix(im,jm,km,-1:1)     ! 漾
    real(DBKIND) :: xy_SurfVelMatrix(im,jm)            !  ®ٱ: ɽ
    real(DBKIND) :: xyoo_SurfTempMatrix(im,jm,0:1,-1:1) ! ٱ: ɽ
    real(DBKIND) :: xyoo_SurfQvapMatrix(im,jm,0:1,-1:1) ! 漾: ɽ
    real(DBKIND) :: xyz_DVerdiffVelLonDt(im,jm,km) ! ʬ ľȻ®
    real(DBKIND) :: xyz_DVerdiffVelLatDt(im,jm,km) ! ʬ ľȻ®
    real(DBKIND) :: xyz_DVerdiffTempDt(im,jm,km)       ! ľȻǮΨ
    real(DBKIND) :: xyz_DVerdiffSurfTempDt(im,jm)      ! ɽ ľȻǮΨ
    real(DBKIND) :: xyz_DVerdiffQvapDt(im,jm,km)       ! ľȻüΨ
    integer(INTKIND) :: xy_SurfCondition(im,jm)    ! ɽ
    integer(INTKIND) :: k
    real(DBKIND) :: wz_Psi_a((nm+1)*(nm+1), km) 
    real(DBKIND) :: wz_Chi_a((nm+1)*(nm+1), km)
    real(DBKIND) :: xyz_DTempDtVertFiltCons(im,jm,km) ! ѲΨ(ľե륿)
    real(DBKIND) :: xyz_DVelLonDtVertFiltCons(im,jm,km) ! ѲΨ(ľե륿)
    real(DBKIND) :: xyz_DVelLatDtVertFilstCons(im,jm,km) ! ѲΨ(ľե륿)

    continue


    !   Ͻ
    call BeginSub(subname)
  
    ! (2007-5-17 ) ۵֤ɲ.
    if (dcpam_ape_physics_initialized) then
    else
      allocate( xy_SurfTemp(im,jm) )
      dcpam_ape_physics_initialized = .true.
    endif


    ! 1. ʪ黻Ѥѿ
    xyz_DNegQvap1Dt = 0.0d0
    xyz_DNegQvap2Dt = 0.0d0
    xyz_DLscTempDt = 0.0d0
    xyz_DLscQvapDt = 0.0d0
    xy_LscRain     = 0.0d0
    xyz_DCumulusTempDt = 0.0d0
    xyz_DCumulusQvapDt = 0.0d0
    xy_CumulusRain = 0.0d0
    xyz_DDryTempDt = 0.0d0
    xy_Rain        = 0.0d0

    xy_Ps_b = Vars_a%xy_Ps

    !  2. ɽ
    call physics_ground( &
      & xy_SurfTemp        , &  !(inout) ɽ
      & xy_SurfAlbedo, &        !(out) ɽ٥
      & xy_SurfHumidCoeff, &    !(out) ɽ
      & xy_SurfRoughLength, &   !(out) ɽĹ
      & xy_SurfCondition, &     !(out) ɽ. 
      & xy_SurfHeatCapacity, &  !(out) ɽǮ
      & xy_GroundTempFlux, &    !(out) Ǯեå
      &  Dims%y_Lat%a_Dim     ) ! (in) ٺɸ

    !----------------------------------------------------------------
    !  3. Ⱦ sigma , ȹ٤λ (1)
    !----------------------------------------------------------------

    !----- Ⱦ sigma  -----
    call physics_interpolate_temp( &
      & xyr_Temp              , & ! (out)  (Ⱦ)
      & Vars_a%xyz_Temp       , & ! (in)  () (t+t)
      & Dims%z_Sigma%a_Dim    , & ! (in) ҥ٥()ɸ
      & Dims%r_Sigma%a_Dim    )   ! (in) ҥ٥(Ⱦ)ɸ

    !----- ȹ٤λ -----
    call physics_interpolate_geopot( &
      & xyz_Press            , & ! (out)  ()
      & xyr_Press            , & ! (out)  (Ⱦ)
      & xyz_GeoPot           , & ! (out) ݥƥ󥷥()
      & xyr_GeoPot           , & ! (out) ݥƥ󥷥(Ⱦ)
      & Vars_a%xy_Ps         , & ! (in) ɽ̵ (t+t)
      & Vars_a%xyz_Temp      , & ! (in)  () (t+t)
      & xyr_Temp             , & ! (in)  (Ⱦ)
      & Dims%z_Sigma%a_Dim   , & ! (in) ҥ٥()ɸ
      & Dims%r_Sigma%a_Dim   )   ! (in) ҥ٥(Ⱦ)ɸ

    !----------------------------------------------------------------
    !  4. ο(1)
    !----------------------------------------------------------------
    call physics_negq( &
      & Vars_a%xyz_Qvap      , & ! (inout) 漾 () (t+t)
      & xyz_DNegQvap1Dt      , & ! (inout) 漾Ѳ ()
      & xyr_Press            , & ! (in)  (Ⱦ)
      & 2.0d0*DelTime  )         ! (in) 2t

    !----------------------------------------------------------------
    !  5.  (ѱ)
    !----------------------------------------------------------------
    call physics_cumulus_adjust( &
      & Vars_a%xyz_Temp     , & ! (inout) 
      & Vars_a%xyz_Qvap     , & ! (inout) 漾
      & xy_CumulusRain      , & ! (out) ߿
      & xyz_DCumulusTempDt  , & ! (out) ѲΨ
      & xyz_DCumulusQvapDt  , & ! (out) 漾ѲΨ
      & xyz_Press           , & ! (in)  ()
      & xyr_Press           , & ! (in)  (Ⱦ)
      & 2.0d0*DelTime )         ! (in) 2t

    !----------------------------------------------------------------
    !  6.  (絬϶ŷ)
    !----------------------------------------------------------------
    call physics_lscond( &
      & Vars_a%xyz_Temp      , & ! (inout)  () (t+t)
      & Vars_a%xyz_Qvap      , & ! (inout) 漾 () (t+t)
      & xy_LscRain           , & ! (out) ߿
      & xyz_DLscTempDt       , & ! (out) ѲΨ
      & xyz_DLscQvapDt       , & ! (out) 漾ѲΨ
      & xyz_Press            , & ! (in)  ()
      & xyr_Press            , & ! (in)  (Ⱦ)
      & 2.0d0*DelTime  )         ! (in) 2t

    !----------------------------------------------------------------
    !  7. ο(2)
    !----------------------------------------------------------------
    call physics_negq( &
      & Vars_a%xyz_Qvap      , & ! (inout) 漾 () (t+t)
      & xyz_DNegQvap1Dt       , & ! (inout) 漾Ѳ ()
      & xyr_Press            , & ! (in)  (Ⱦ)
      & 2.0d0*DelTime  )         ! (in) 2t

    !----------------------------------------------------------------
    !  8. Ⱦ sigma , ȹ٤λ (2)
    !----------------------------------------------------------------

    !----- Ps η׻ʤ -----
!   (2007-7-10 )
!    ˤ.
!    ⤽, agcm5 ǤϤʤȤäƤʤ?
!    ˼???
!    do k = 1, km
!       Vars_a%xy_Ps(:,:) = Vars_a%xy_Ps(:,:) &
!            & + ( xyz_DLscQvapDt(:,:,k) &
!            &     + xyz_DCumulusQvapDt(:,:,k) &
!            &     + xyz_DNegQvap1Dt(:,:,k)     ) &
!            &  * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
!            &  * 2.0d0 * DelTime
!    end do

    !----- Ⱦ sigma  -----
    call physics_interpolate_temp( &
      & xyr_Temp              , & ! (out)  (Ⱦ)
      & Vars_a%xyz_Temp       , & ! (in)  () (t+t)
      & Dims%z_Sigma%a_Dim    , & ! (in) ҥ٥()ɸ
      & Dims%r_Sigma%a_Dim    )   ! (in) ҥ٥(Ⱦ)ɸ

    !----- ȹ٤λ -----
    call physics_interpolate_geopot( &
      & xyz_Press            , & ! (out)  ()
      & xyr_Press            , & ! (out)  (Ⱦ)
      & xyz_GeoPot           , & ! (out) ݥƥ󥷥()
      & xyr_GeoPot           , & ! (out) ݥƥ󥷥(Ⱦ)
      & Vars_a%xy_Ps         , & ! (in) ɽ̵ (t+t)
      & Vars_a%xyz_Temp      , & ! (in)  () (t+t)
      & xyr_Temp             , & ! (in)  (Ⱦ)
      & Dims%z_Sigma%a_Dim   , & ! (in) ҥ٥()ɸ
      & Dims%r_Sigma%a_Dim   )   ! (in) ҥ٥(Ⱦ)ɸ

    !----------------------------------------------------------------
    !  9. 
    !----------------------------------------------------------------
    call physics_implicit_init( &
      & xyr_VelLonFlux       , & ! (out) ®ٷʬեå
      & xyr_VelLatFlux       , & ! (out) ®ٰʬեå
      & xyr_TempFlux         , & ! (out) ٥եå
      & xyr_QvapFlux         , & ! (out) 漾եå
      & xyzo_VelMatrix       , & ! (out) ®ٱ
      & xyzo_TempMatrix      , & ! (out) ٱ
      & xyzo_QvapMatrix      , & ! (out) 漾
      & xyr_Press            , & ! (in)  (Ⱦ)
      & 2.0d0*DelTime        , & ! (in) t
      & xy_SurfHeatCapacity  , & ! (in) ɽǮ
      & xy_SurfCondition       ) ! (in) ɽ

    !----------------------------------------------------------------
    !  10.  flux
    !----------------------------------------------------------------
    call physics_radiation_main( &
      & xyr_RadLFlux              , & ! (out) Ĺȥեå
      & xyo_SurfRadLMatrix        , & ! (out) Աɽ
      & xyro_DelRadLFlux          , & ! (out) ĹɽѲ
      & xyr_RadSFlux              , & ! (out) ͥեå
      & Vars_a%xyz_Temp           , & ! (in) 
      & xyr_Temp                  , & ! (in) (Ⱦ)
      & xy_SurfTemp               , & ! (in) ɽ̲
      & Vars_a%xyz_Qvap           , & ! (in) 漾
      & xyr_Press                 , & ! (in) 
      & Dims%x_Lon%a_Dim          , & ! (in) 
      & Dims%y_Lat%a_Dim          , & ! (in) 
      & xy_SurfAlbedo             )   ! (in) ɽ٥

    !----------------------------------------------------------------
    !  11. ľȻ flux
    !----------------------------------------------------------------
    call physics_verdiff_main( &
      & xyr_VelLonFlux       , & ! (out) ®ٷʬեå
      & xyr_VelLatFlux       , & ! (out) ®ٰʬեå
      & xyr_TempFlux         , & ! (out) ٥եå
      & xyr_QvapFlux         , & ! (out) 漾եå
      & xyzo_VelMatrix       , & ! (inout) ®ٱ
      & xyzo_TempMatrix      , & ! (inout) ٱ
      & xyzo_QvapMatrix      , & ! (inout) 漾
      & Vars_a%xyz_VelLon    , & ! (in) ®ٷʬ
      & Vars_a%xyz_VelLat    , & ! (in) ®ٰʬ
      & Vars_a%xyz_Temp      , & ! (in)  ()
      & xyr_Temp             , & ! (in)  (Ⱦ)
      & Vars_a%xyz_Qvap      , & ! (in) 漾 ()
      & xyz_Press            , & ! (in)  ()
      & xyr_Press            , & ! (in)  (Ⱦ)
      & xyz_GeoPot           , & ! (in)  ()
      & xyr_GeoPot             ) ! (in)  (Ⱦ)

    !----------------------------------------------------------------
    !  12. ɽ flux
    !----------------------------------------------------------------
    call physics_surface_main( &
      & xyr_VelLonFlux       , & ! (inout) ®ٷʬեå
      & xyr_VelLatFlux       , & ! (inout) ®ٰʬեå
      & xyr_TempFlux         , & ! (inout) ٥եå
      & xyr_QvapFlux         , & ! (inout) 漾եå
      & xy_SurfVelMatrix     , & ! (out) ®ٱ: ɽ
      & xyoo_SurfTempMatrix  , & ! (out) ٱ: ɽ
      & xyoo_SurfQvapMatrix  , & ! (out) 漾: ɽ
      & Vars_a%xyz_VelLon    , & ! (in) ®ٷʬ
      & Vars_a%xyz_VelLat    , & ! (in) ®ٰʬ
      & Vars_a%xyz_Temp      , & ! (in)  ()
      & xyr_Temp             , & ! (in)  (Ⱦ)
      & xy_SurfTemp          , & ! (in) ɽ̲
      & Vars_a%xyz_Qvap      , & ! (in) 漾 ()
      & xyz_Press            , & ! (in)  ()
      & xyr_Press            , & ! (in)  (Ⱦ)
      & xyz_GeoPot           , & ! (in)  ()
      & xy_SurfHumidCoeff    , & ! (in) ɽ
      & xy_SurfRoughLength   , & ! (in) ɽĹ
      & xy_SurfCondition       ) ! (in) ɽ

    !----------------------------------------------------------------
    !  13. ѲΨη׻ (implicit)
    !----------------------------------------------------------------
    call physics_implicit_integrate( &
      & xyz_DVerdiffVelLonDt    , & ! (out) ʬ ľȻ®
      & xyz_DVerdiffVelLatDt    , & ! (out) ʬ ľȻ®
      & xyz_DVerdiffTempDt      , & ! (out) ľȻǮΨ
      & xyz_DVerdiffSurfTempDt  , & ! (out) ɽ ľȻǮΨ
      & xyz_DVerdiffQvapDt      , & ! (out) ľȻüΨ
      & xyr_VelLonFlux          , & ! (in) ®ٷʬեå
      & xyr_VelLatFlux          , & ! (in) ®ٰʬեå
      & xyr_TempFlux            , & ! (in) ٥եå
      & xyr_RadSFlux(:,:,1)     , & ! (in) ͥեå
      & xyr_RadLFlux(:,:,1)     , & ! (in) Ĺȥեå
      & xy_GroundTempFlux       , & ! (in) Ǯեå
      & xyr_QvapFlux            , & ! (in) 漾եå
      & xyzo_VelMatrix          , & ! (in) ®ٱ
      & xyzo_TempMatrix         , & ! (in) ٱ
      & xyzo_QvapMatrix         , & ! (in) 漾
      & xy_SurfVelMatrix        , & ! (in) ®ٱ: ɽ
      & xyoo_SurfTempMatrix     , & ! (in) ٱ: ɽ
      & xyoo_SurfQvapMatrix     , & ! (in) 漾: ɽ
      & xyo_SurfRadLMatrix      , & ! (in) Աɽ
      & 2.0d0*DelTime           , & ! (in) t
      & xy_SurfCondition          ) ! (in) ɽ

    ! (2006-7-30 ) ɲ
    ! եå
    call physics_implicit_fluxcorrection ( &
      & xyr_VelLonFlux, & !(inout)
      & xyr_VelLatFlux, & !(inout)
      & xyr_TempFlux, & !(inout)
      & xyr_QvapFlux, & !(inout)
      & xyz_DVerdiffVelLonDt, & !(in)
      & xyz_DVerdiffVelLatDt, & !(in)
      & xyz_DVerdiffTempDt, & !(in)
      & xyz_DVerdiffSurfTempDt, & !(in)
      & xyz_DVerdiffQvapDt, & !(in)
      & xyzo_VelMatrix, & !(in)
      & xyzo_TempMatrix, & !(in)
      & xyzo_QvapMatrix, & !(in)
      & xy_SurfVelMatrix, & !(in)
      & xyoo_SurfTempMatrix, & !(in)
      & xyoo_SurfQvapMatrix, & !(in)
      & 2.0d0*DelTime  & !(in)
      & )

    !----------------------------------------------------------------
    !  14. ͤˤ벹ѲΨ
    !----------------------------------------------------------------
    do k = 1, km+1
! (2007-5-17  ѹ)
!       xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k) &
!            &   + (xyz_DVerdiffSurfTempDt(:,:) * xyro_DelRadLFlux(:,:,k,0)  &
!            &     + xyz_DVerdiffTempDt(:,:,1) * xyro_DelRadLFlux(:,:,k,1) )&
!            &      * 2.0d0*DelTime
       xyr_RadLFluxCorrected(:,:,k) = xyr_RadLFlux(:,:,k) &
         &     + (xyz_DVerdiffSurfTempDt(:,:) * xyro_DelRadLFlux(:,:,k,0)  &
         &        + xyz_DVerdiffTempDt(:,:,1) * xyro_DelRadLFlux(:,:,k,1) )&
         &      * 2.0d0*DelTime
    end do

! (2007-5-17  ѹ)
!    call physics_radiation_deltemp( &
!      &  xyz_DRadLTempDt         , & ! (out) ĹȲǮΨ
!      &  xyz_DRadSTempDt         , & ! (out) ûȲǮΨ
!      &  xyr_RadLFlux            , & ! (in) Ĺȥեå
!      &  xyr_RadSFlux            , & ! (in) ûȥեå
!      &  xyr_Press                 )   ! (in)  (Ⱦ)
    call physics_radiation_deltemp( &
      &  xyz_DRadLTempDt         , & ! (out) ĹȲǮΨ
      &  xyz_DRadSTempDt         , & ! (out) ûȲǮΨ
      &  xyr_RadLFluxCorrected   , & ! (in) Ĺȥեå
      &  xyr_RadSFlux            , & ! (in) ûȥեå
      &  xyr_Press                 )   ! (in)  (Ⱦ)

    !----------------------------------------------------------------
    !  15. Ѳʬ­
    !      (2006-7-28 ) եåƤʤ餳
    !          ޤȤƤäƤ.
    !----------------------------------------------------------------
    ! (2007-5-17 ) ޤäȼʤ, 
    ! 2.0d0*DelTime ǤϤʤ, DelTime ʤΤ?

! (2007-5-17 ) ޤͳС
!    Vars_a%xyz_Temp = Vars_a%xyz_Temp               &
!         & +  ( xyz_DRadLTempDt + xyz_DRadSTempDt ) * 2.0d0*DelTime
!
!    Vars_a%xyz_Temp = Vars_a%xyz_Temp               &
!         & +  ( xyz_DVerdiffTempDt ) * 2.0d0* DelTime
!
!    Vars_a%xyz_Qvap = Vars_a%xyz_Qvap               &
!         & +  ( xyz_DVerdiffQvapDt ) * 2.0d0* DelTime
!
!    Vars_a%xyz_VelLon = Vars_a%xyz_VelLon               &
!         & +  ( xyz_DVerdiffVelLonDt ) * 2.0d0* DelTime
!    
!    Vars_a%xyz_VelLat = Vars_a%xyz_VelLat               &
!         & +  ( xyz_DVerdiffVelLatDt ) * 2.0d0* DelTime

! (2007-5-17 ) ϼȻפ.
    Vars_a%xyz_Temp = Vars_a%xyz_Temp               &
      & +  ( xyz_DRadLTempDt + xyz_DRadSTempDt ) * DelTime

    Vars_a%xyz_Temp = Vars_a%xyz_Temp               &
      & +  ( xyz_DVerdiffTempDt ) * DelTime

    Vars_a%xyz_Qvap = Vars_a%xyz_Qvap               &
      & +  ( xyz_DVerdiffQvapDt ) * DelTime

    Vars_a%xyz_VelLon = Vars_a%xyz_VelLon               &
      & +  ( xyz_DVerdiffVelLonDt ) * DelTime
    
    Vars_a%xyz_VelLat = Vars_a%xyz_VelLat               &
      & +  ( xyz_DVerdiffVelLatDt ) * DelTime

    ! (2006-7-28 ) ɲ.
    call physics_integrate_surftemp( & 
      &  xy_SurfTemp, & !(inout)
      &  xyr_RadLFlux, & !(inout)
      &  xyro_DelRadLFlux, & !(inout)
      &  xyz_DVerdiffSurfTempDt, & !(in)
      &  DelTime & !(in)
      &  )

    !----------------------------------------------------------------
    !  16. Ⱦ sigma , ȹ٤λ (3)
    !----------------------------------------------------------------

    !----- Ps η׻ʤ -----
!   (2007-7-10 )
!    ˤ.
!    ⤽, agcm5 ǤϤʤȤäƤʤ?
!    ˼???
!    do k = 1, km
!       Vars_a%xy_Ps(:,:) = Vars_a%xy_Ps(:,:) &
!            & +  xyz_DVerdiffQvapDt(:,:,k)  &
!            &   * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
!            &   * 2.0d0 * DelTime
!    end do

    !----- Ⱦ sigma  -----
    call physics_interpolate_temp( &
      & xyr_Temp              , & ! (out)  (Ⱦ)
      & Vars_a%xyz_Temp       , & ! (in)  () (t+t)
      & Dims%z_Sigma%a_Dim    , & ! (in) ҥ٥()ɸ
      & Dims%r_Sigma%a_Dim    )   ! (in) ҥ٥(Ⱦ)ɸ

    !----- ȹ٤λ -----
    call physics_interpolate_geopot( &
      & xyz_Press            , & ! (out)  ()
      & xyr_Press            , & ! (out)  (Ⱦ)
      & xyz_GeoPot           , & ! (out) ݥƥ󥷥()
      & xyr_GeoPot           , & ! (out) ݥƥ󥷥(Ⱦ)
      & Vars_a%xy_Ps         , & ! (in) ɽ̵ (t+t)
      & Vars_a%xyz_Temp      , & ! (in)  () (t+t)
      & xyr_Temp             , & ! (in)  (Ⱦ)
      & Dims%z_Sigma%a_Dim   , & ! (in) ҥ٥()ɸ
      & Dims%r_Sigma%a_Dim   )   ! (in) ҥ٥(Ⱦ)ɸ

    !----------------------------------------------------------------
    !  17. ήĴ
    !----------------------------------------------------------------
    call physics_dryadjust( &
      & Vars_a%xyz_Temp       , & ! (inout) 
      & xyz_DDryTempDt        , & ! (out) ѲΨ
      & xyz_Press             , & ! (in)  ()
      & xyr_Press             , & ! (in)  (Ⱦ)
      & 2.0d0*DelTime  )          ! (in) 2t

    ! ľե륿 
    !   / ڤ괹 use ʸѹƤʤ.
    call phys_vfilter( & 
      & Vars_a%xyz_Temp   , & !(inout)
      & Vars_a%xyz_VelLon , & !(inout)
      & Vars_a%xyz_VelLat , & !(inout)
      & xyr_Temp   , & !(in) 
      & xyr_Press  , & !(in)
      & 2.0d0*DelTime )   !(in)

    !----------------------------------------------------------------
    !  18. ο(3)
    !----------------------------------------------------------------
    call physics_negq( &
      & Vars_a%xyz_Qvap      , & ! (inout) 漾 () (t+t)
      & xyz_DNegQvap2Dt       , & ! (inout) 漾Ѳ ()
      & xyr_Press            , & ! (in)  (Ⱦ)
      & 2.0d0*DelTime  )         ! (in) 2t

    !----------------------------------------------------------------
    !  19. Ps η׻ʤ 
    !----------------------------------------------------------------
!   (2007-7-10 )
!    ˤ.
!    ⤽, agcm5 ǤϤʤȤäƤʤ?
!    ˼???
!    do k = 1, km
!       Vars_a%xy_Ps(:,:) = Vars_a%xy_Ps(:,:) &
!            & + xyz_DNegQvap2Dt(:,:,k) &
!            &  * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
!            &  * 2.0d0 * DelTime
!    end do

    ! ŷ롦߿ˤɽ̵Ѳ
    ! Ѥ/ʤڤ괹ˤ use ʸ񤭴뤳.
!    call physics_ps_correction( &
!      & Vars_a%xyz_Qvap   , & !(inout)
!      & Vars_a%xy_Ps, & !(inout)
!      & xyr_QvapFlux , & !(in)
!      & xyz_DCumulusQvapDt, & !(in)
!      & xyr_Press  , &  !(in)
!      & 2.0d0 * DelTime         ) !(in) 


    !----------------------------------------------------------------
    !  20. ѿ
    !----------------------------------------------------------------
    call io_gt4_out_Put(  'GeoPot', real(xyz_GeoPot(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'Press', real(xyz_Press(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'SurfTemp', real(xy_SurfTemp(:,:), DBKIND)  )

    call io_gt4_out_Put(  'DNegQvapDt',  &
         & real( (xyz_DNegQvap1Dt(:,:,:) + xyz_DNegQvap2Dt(:,:,:)), DBKIND)  )
    call io_gt4_out_Put(  'DLscTempDt',  &
         &                     real(xyz_DLscTempDt(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'DLscQvapDt',  &
         &                     real(xyz_DLscQvapDt(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'LscRain', real(xy_LscRain(:,:), DBKIND)  )

    call io_gt4_out_Put(  'DCumulusTempDt',  &
         &                     real(xyz_DCumulusTempDt(:,:,:), DBKIND)  )

    call io_gt4_out_Put(  'DCumulusQvapDt',  &
         &                     real(xyz_DCumulusQvapDt(:,:,:), DBKIND)  )

    call io_gt4_out_Put(  'CumulusRain', real(xy_CumulusRain(:,:), DBKIND)  )

    call io_gt4_out_Put(  'DDryTempDt',  &
         &                     real(xyz_DDryTempDt(:,:,:), DBKIND)  )


    ! 2007-05-16 M. Ishiwatari ɲ
    call io_gt4_out_Put(  'TempFlux',  &
         &                     real(xyr_TempFlux(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'LatentEnergyFlux',  &
         &                     real(xyr_QvapFlux(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'RadSFlux',  &
         &                     real(xyr_RadSFlux(:,:,:), DBKIND)  )
! (2007-5-17  ѹ)
!    call io_gt4_out_Put(  'RadLFlux',  &
!         &                     real(xyr_RadLFlux(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'RadLFlux',  &
         &                     real(xyr_RadLFluxCorrected(:,:,:), DBKIND)  )

    xy_Rain = xy_LscRain + xy_CumulusRain
    call io_gt4_out_Put(  'Rain', real(xy_Rain(:,:), DBKIND)  )

    call io_gt4_out_Put(  'DPsDt', & 
         & real( (Vars_a%xy_Ps(:,:) - xy_Ps_b(:,:)), DBKIND)  )

    call io_gt4_out_Put(  'DRadLTempDt', real(xyz_DRadLTempDt(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'DRadSTempDt', real(xyz_DRadSTempDt(:,:,:), DBKIND)  )
    call io_gt4_out_Put('DVerdiffVelLonDt',  &
         &                     real(xyz_DVerdiffVelLonDt(:,:,:), DBKIND) )
    call io_gt4_out_Put('DVerdiffVelLatDt', & 
         &                     real(xyz_DVerdiffVelLatDt(:,:,:), DBKIND) )
    call io_gt4_out_Put('DVerdiffTempDt', real(xyz_DVerdiffTempDt(:,:,:), DBKIND) )
    call io_gt4_out_Put('DVerdiffQvapDt', real(xyz_DVerdiffQvapDt(:,:,:), DBKIND) )

    !-------------------------------------------------------------------
    !  21. Generate Vorticity and Divergence from Velocity
    !-------------------------------------------------------------------
    
    Vars_a%xyz_Vor = &
      &  xya_wa( wa_Div_xya_xya( Vars_a%xyz_VelLat,-Vars_a%xyz_VelLon )/R0)
    Vars_a%xyz_Div = &
      & xya_wa( wa_Div_xya_xya( Vars_a%xyz_VelLon, Vars_a%xyz_VelLat ) /R0)
    
!    wz_Psi_a = wa_LaplaInv_wa(  wa_xya( Vars_a%xyz_Vor )  ) * R0**2
!    wz_Chi_a = wa_LaplaInv_wa(  wa_xya( Vars_a%xyz_Div )  ) * R0**2

!    Vars_a%xyz_VelLon = (  xya_GradLon_wa( wz_Chi_a ) &
!         &                - xya_GradLat_wa( wz_Psi_a )  ) / R0

!    Vars_a%xyz_VelLat = (  xya_GradLon_wa( wz_Psi_a ) &
!         &                + xya_GradLat_wa( wz_Chi_a )  ) / R0

!    Vars_a%xyz_Temp = xya_wa( wa_xya(Vars_a%xyz_Temp) )
!    Vars_a%xyz_Qvap = xya_wa( wa_xya(Vars_a%xyz_Qvap) )
!    Vars_a%xy_Ps = xy_w( w_xy(Vars_a%xy_Ps) )


    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)
    
  end subroutine dcpam_ape_physics

end module dcpam_ape_physics_mod
