!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
!
!= Module physics_integrate_surftemp
!
!   * Developers: 
!   * Version: 
!   * Tag Name: 
!   * Change History: 
!
!== Overview
!
!DCPAM-APE time integraion of surface temprature for implicite scheme
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!
  subroutine physics_integrate_surftemp( & 
    &  xy_SurfTemp, xyr_RadLFlux, xyro_DelRadLFlux, & !(inout)
    &  xyz_DVerdiffSurfTempDt, DelTime & !(in)
    &  )
    ! 
    ! 
    ! 
    use dycore_type_mod, only: STRING, INTKIND, DBKIND
    use grid_3d_mod,     only: im, jm, km
    use dc_trace,    only: BeginSub, EndSub
    implicit none
    real(DBKIND), intent(inout) :: xy_SurfTemp  ( im,jm )  !" ɽ̲
    real(DBKIND), intent(inout) :: xyr_RadLFlux ( im,jm,km+1 ) !" Ĺ
    real(DBKIND), intent(inout) :: xyro_DelRadLFlux( im,jm,km+1,0:1 )
                                    !" ɽĹȥեå 
    real(DBKIND), intent(in) :: xyz_DVerdiffSurfTempDt   ( im,jm )
                                    !" ɽѲΨ(ñ̻)
    real(DBKIND), intent(in) :: DelTime                   !" ֹߦt
    character(STRING),  parameter:: subname = "physics_integrate_surftemp"
    integer(INTKIND) :: k


    ! Ͻ
    call BeginSub(subname)

    ! 1. Ĺȥեå ( ɽեåʬ )  
    do k = 1, km+1
      xyr_RadLFlux(:,:,k) = xyr_RadLFlux( :,:,k ) &
        & + xyro_DelRadLFlux(:,:,k,0) * xyz_DVerdiffSurfTempDt(:,:) * DelTime
    enddo

    ! 2. ෸ѹ ɽʬ 1   
    do k = 1, km+1
      xyro_DelRadLFlux (:,:,k,0) &
        & = xyro_DelRadLFlux(:,:,k,0)/xy_SurfTemp(:,:)**3 
    enddo

    ! 3. ɽ̲ٻʬ
    xy_SurfTemp = xy_SurfTemp + xyz_DVerdiffSurfTempDt * DelTime 

    ! 4. ෸ѹ ɽʬ 2
    do k = 1, km+1
      xyro_DelRadLFlux(:,:,k,0) &
        & = xyro_DelRadLFlux(:,:,k,0 ) * xy_SurfTemp(:,:)**3 
    enddo

    ! λ
    call EndSub(subname)

  end subroutine physics_integrate_surftemp

