!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_lscond.f90 
! Ƿ絬϶ŷ
!
! History
!   2005/09/19 Yamada Yukiko     create
!   2006/11/18 Ishiwatari Masaki modify
!

module physics_lscond_mod

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: physics_lscond

contains

  subroutine physics_lscond( xyz_Temp, xyz_Qvap, xy_LscRain, &
    &               xyz_DLscTempDt, xyz_DLscQvapDt,    &
    &               xyz_Press, xyr_Press, DelTimePhy    )
    !
    !== Large scale condensation
    !=== TODO
    ! * (i,j,k) ˤ˰漾ѿ QvapSatIJK ˤƤ.
    !   ѿ̿̾롼뤫餹ɤʤ.
    !   ɤϤʤΤ???
    !
    use type_mod,      only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod,   only: im, jm, km
    use constants_mod, only: Cp    ,& ! 絤갵Ǯ 
      &                   EL    ,& ! ζŷǮ 
      &                   EpsV  ,& ! 絤ʬ
      &                   ES0   ,& ! ˰¾У
      &                   RVap  ,& ! 
      &                   Grav     ! ϲ®
    use physics_qvapsat_tetens, only: QvapSat, DQvapSatDTemp
    !use physics_qvapsat_nha92, only: QvapSat, DQvapSatDTemp
    use dc_trace, only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    real(DBKIND), intent(in) :: xyz_Press(im,jm,km)   !  ()
    real(DBKIND), intent(in) :: xyr_Press(im,jm,km+1) !  (Ⱦ)
    real(DBKIND), intent(in) :: DelTimePhy            ! 2t
    real(DBKIND), intent(out) :: xy_LscRain(im,jm)    ! ߿
    real(DBKIND), intent(out) :: xyz_DLscTempDt(im,jm,km) ! ѲΨ
    real(DBKIND), intent(out) :: xyz_DLscQvapDt(im,jm,km) ! 漾ѲΨ
    real(DBKIND), intent(inout) :: xyz_Temp(im,jm,km)     ! 
    real(DBKIND), intent(inout) :: xyz_Qvap(im,jm,km)     ! 漾

    character(STRING),  parameter:: subname = "physics_lscond"
    real(DBKIND) :: xyz_Qvap_b(im,jm,km)             ! Ĵ漾
    real(DBKIND) :: xyz_Temp_b(im,jm,km)             ! Ĵβ
    real(DBKIND) :: QvapSatIJK                       ! ˰漾  ˰º
    real(DBKIND) :: DQvapSatDTempIJK                 ! D(˰漾)/D()
    real(DBKIND) :: DelTemp, DelQvap 
    real(DBKIND), parameter     :: CrtlRH = 1.0d0   ! ׳м
    integer(INTKIND), parameter :: IterationMax = 3 ! ƥ졼

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i, j, k
    integer(INTKIND)    :: Iteration 

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   絬϶ŷ
    !----------------------------------------------------------------

    !----- Ĵ Qvap ¸ -----    
    xyz_Qvap_b  = xyz_Qvap
    xyz_Temp_b  = xyz_Temp

    !----- ѿ -----    
    xy_LscRain     = 0.0d0
    xyz_DLscTempDt = 0.0d0
    xyz_DLscQvapDt = 0.0d0
    
    !----- Ĵ ------    
    do k = km, 1, -1
       do i = 1, im
          do j = 1, jm
             
             ! 饦ڥμ˰漾׻
             QvapSatIJK = QvapSat( xyz_Temp(i,j,k), xyz_Press(i,j,k) ) 

             ! ˰¤Ƥ, ٤漾Ѳμ«׻
             if ( ( xyz_Qvap(i,j,k) / QvapSatIJK ) .GE. CrtlRH ) then

                do Iteration = 1, IterationMax

                   ! ˰漾׻
                   QvapSatIJK = QvapSat( xyz_Temp(i,j,k), xyz_Press(i,j,k) ) 
                   DQvapSatDTempIJK &
                     & = DQvapSatDTemp( xyz_Temp(i,j,k), xyz_Press(i,j,k) ) 
                   
                   ! ٤漾Ѳʬ Newton ˡǵ
                   DelTemp = EL / Cp * ( xyz_Qvap(i,j,k) - QvapSatIJK ) &
                     &   / ( 1. + EL / Cp * DQvapSatDTempIJK )
                   DelQvap  = DQvapSatDTempIJK * DelTemp 

                   ! Ĵ
                   xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
                   xyz_Qvap(i,j,k) = QvapSatIJK + DelQvap

                end do

            end if
          end do
       end do
    end do

    !----- 漾ѲΨ, ѲΨ, ߿̤λ ----- 
    do k = km, 1, -1
       do i = 1, im
          do j = 1, jm

             ! 漾ѲΨ
             xyz_DLscQvapDt(i,j,k) = xyz_DLscQvapDt(i,j,k) & 
               &  + ( xyz_Qvap(i,j,k) - xyz_Qvap_b(i,j,k) ) / DelTimePhy

             ! ѲΨ
             xyz_DLscTempDt(i,j,k) = xyz_DLscTempDt(i,j,k) &
               & + ( xyz_Temp(i,j,k) - xyz_Temp_b(i,j,k) ) / DelTimePhy

             ! ߿
             xy_LscRain(i,j) = xy_LscRain(i,j)  &
               & + ( xyz_Temp(i,j,k) - xyz_Temp_b(i,j,k) ) &
               & * CP / DelTimePhy                         &
               & * ( xyr_Press(i,j,k) - xyr_Press(i,j,k+1) ) /Grav
 
          end do
       end do
    end do
    
    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_lscond

end module physics_lscond_mod




