#!/usr/bin/env perl
# Fortran 90 dependency lister - for DCPAM project
# Copyright (C) by GFD Dennou Club, 2005.  all rights reserved.

for ($i = 0; $i < @ARGV; $i++) {
    if ($ARGV[$i] =~ /^-X/) {
        push @ignore, $';
        splice(@ARGV, $i, 1);
        $i--;
    }
}


while (<>) {
    next unless /^ *use (\w+)/i;
    $module = $1;
    $target = $ARGV;
    $module =~ tr/A-Z/a-z/;
    $target =~ tr/A-Z/a-z/;
    $module .= ".o";
    $target =~ s/\.[Ff](90)?$/.o/;
    next if ($target eq $module);
    $ignore = 0;
    for $ignfile (@ignore) {
        $ignore = 1 if $module eq $ignfile;
    }
    next if ($ignore);
    $depend{$target,$module} = 1;
}

foreach $key (sort keys %depend) {
    ($target, $module) = split(/$;/, $key);
    $s_depend{$target} .= " $module";
}

foreach $target (sort keys %s_depend) {
    print "$target:$s_depend{$target}\n";
}
exit 0;
