!= ϳز: ߥץꥷåȻʬѹ
!
!= Dynamical core: Matrices for semi-implicit time integration
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dyn_matrix.f90,v 1.11 2007/09/08 20:36:41 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dyn_matrix
  !
  != ϳز: ߥץꥷåȻʬѹ
  !
  != Dynamical core: Matrices for semi-implicit time integration
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ϳزˤ륻ߥץꥷåȻʬѤ LU ,
  !  LU ˤäϢΩ 1 .
  !
  ! Generate LU matrix for semi-implicit time integration in dynamical core.
  ! And solve linear simultaneous equation with the LU matrix.
  !
  !== Procedures List
  !
  ! Create        :: DYNMTX ѿν
  ! Solve         :: η׻
  ! Close         :: DYNMTX ѿνλ
  ! PutLine       :: DYNMTX ѿ˳ǼƤΰ
  ! initialized   :: DYNMTX ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! Create        :: Constructor of "DYNMTX"
  ! Solve         :: Calculate the solution
  ! Close         :: Deconstructor of "DYNMTX"
  ! PutLine       :: Print information of "DYNMTX"
  ! initialized   :: Check initialization of "DYNMTX"
  !
  !== Usage
  !
  ! Ϥ, DYNMTX ѿ, Create ǽԤޤ.
  ! LU  GetLU ˤƼƤ.
  ! Ǹ, DYNMTX ѿνλ Close ˤƹԤޤ.
  !
  ! First, initialize "DYNMTX" by "Create".
  ! Get LU matrix by GetLU.
  ! Finally, terminate "DYNMTX" by "Close".
  !

  use dc_types, only: DP
  implicit none
  private
  public:: DYNMTX, Create, Close, PutLine, initialized, Solve

  type DYNMTX
    !
    ! ޤ, Create  "DYNMTX" ѿꤷƲ.
    ! ꤵ줿 "DYNMTX" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "DYNMTX" variable by "Create" before usage.
    ! If you reuse "DYNMTX" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: nmax                      ! ȿ. 
                                        ! Maximum truncated wavenumber
    integer:: kmax                      ! ľؿ. 
                                        ! Number of vertical level
    real(DP), pointer:: wzz_siMtxLU(:,:,:) =>null()
                                        ! ߥץꥷåȹ LU ʬ. 
                                        ! LU decomposition for semi-implicit matrix
    integer, pointer:: wz_siMtxPiv(:,:) =>null()
                                        ! ߥץꥷåȹΥԥܥå. 
                                        ! Pivot for semi-implicit matrix
  end type DYNMTX

  character(*), parameter:: version = &
    & '$Name: dcpam4-20070909 $' // &
    & '$Id: dyn_matrix.f90,v 1.11 2007/09/08 20:36:41 morikawa Exp $'

  interface Create
    module procedure DynMatrixCreate
  end interface

  interface Close
    module procedure DynMatrixClose
  end interface

  interface PutLine
    module procedure DynMatrixPutLine
  end interface

  interface initialized
    module procedure DynMatrixInitialized
  end interface

  interface Solve
    module procedure DynMatrixSolve
  end interface

  interface NmlRead
    module procedure DynMatrixNmlRead
  end interface

!!$  interface Sample
!!$    module procedure DynMatrixSample
!!$  end interface

contains

  subroutine DynMatrixCreate( dyn_mtx, &
    & nmax, kmax, nmo, &
    & RPlanet, DelTime, &
    & zz_siMtxWH, zz_siMtxGCt, &
    & w_DiffVorDiv, w_DiffTherm, &
    & nmlfile, err )
    !
    ! DYNMTX ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! DYNMTX ѿꤷƤ.
    ! ʤ, Ϳ줿 *dyn_mtx* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#dyn_matrix_nml 򻲾ȤƤ. 
    !
    ! Constructor of "DYNMTX".
    ! Initialize *dyn_mtx* by this subroutine, 
    ! before other procedures are used, 
    ! Note that if *dyn_mtx* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#dyn_matrix_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_EALREADYINIT, &
      & DCPAM_ELMAXMISMATCH, DCPAM_ENEGATIVE
    use dc_string, only: toChar, PutLine
    use lumatrix, only: LUDecomp
    implicit none
    type(DYNMTX), intent(inout):: dyn_mtx
    integer, intent(in):: nmax ! ȿ. 
                               ! Maximum truncated wavenumber
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    integer, intent(in):: nmo (1:2, 0:nmax, 0:nmax)
                              ! ڥȥź. 
                              ! Spectral subscript expression
    real(DP), intent(in):: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
    real(DP), intent(in):: DelTime ! $ \Delta t $ . ॹƥå. Time step
    real(DP), intent(in):: zz_siMtxWH (0:kmax-1, 0:kmax-1)
                              ! $ W h $
    real(DP), intent(in):: zz_siMtxGCt (0:kmax-1, 0:kmax-1)
                              ! $ G C^{T} $ ( $ C = \Delta \sigma $ )
    real(DP), intent(in):: w_DiffVorDiv ((nmax+1)**2)
                              ! $ -K_{HD} [(-1)^{N_D/2}\nabla^{N_D}- (2/a^2)^{N_D/2}] $ . 
                              ! ư̿ʿȻ. 
                              ! Coefficient of horizontal momentum diffusion
    real(DP), intent(in):: w_DiffTherm ((nmax+1)**2)
                              ! $ -(-1)^{N_D/2}K_{HD}\nabla^{N_D} $ . 
                              ! Ǯ, ʿȻ. 
                              ! Coefficient of horizontal thermal and water diffusion
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#dyn_matrix_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#dyn_matrix_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: zz_siMtxM (0:kmax-1, 0:kmax-1)
                              !  $ \underline{M} $. 
                              ! Matrix $ \underline{M} $
    integer:: z_siMtxPivWork(0:kmax-1)
                              ! ΥԥܥåȺκѿ. 
                              ! Work variable for pivot
    real(DP) :: flapla        ! $ \nabla_{\sigma}^{2} $
    integer:: mmax            ! ȿ. 
                              ! Maximum truncated zonal wavenumber
    integer:: lmax            ! ȿ. 
                              ! Maximum truncated meridional wavenumber
    integer:: n, m, l, nm, k, kk, mxnm
                              ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynMatrixCreate'
  continue
    call BeginSub(subname, version)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (dyn_mtx % initialized) then
      stat = DCPAM_EALREADYINIT
      cause_c = 'DYNMTX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (nmax < 1) then
      stat = DCPAM_ENEGATIVE
      cause_c = 'nmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DCPAM_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    dyn_mtx % nmax = nmax
    dyn_mtx % kmax = kmax

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1=trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = dyn_mtx % param_i, &   ! (inout)
!!$        & param_r = dyn_mtx % param_r, &   ! (inout)
!!$        & param_c_ = dyn_mtx % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1=trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if


    !-----------------------------------------------------------------
    !  ߥץꥷåȹγ
    !  Allocate semi-implicit matrices
    !-----------------------------------------------------------------
    allocate( dyn_mtx % wzz_siMtxLU((nmax+1)**2, 0:kmax-1, 0:kmax-1) )
    allocate( dyn_mtx % wz_siMtxPiv((nmax+1)**2, 0:kmax-1) )

    mmax = nmax
    lmax = nmax
    mxnm = 0

    Loop_n: do n = 0, nmax
      flapla = - real(n) * real(n+1) / RPlanet**2

      !---------------------------------------------------------------
      !  ڥȥźμФ
      !  Fetch spectral subscript expression
      !---------------------------------------------------------------
      stat = DCPAM_ELMAXMISMATCH
      do m = 0, min(n,mmax)
        if ( n-m <= lmax ) then
          nm = nmo(1,m,n-m)
          stat = DC_NOERR
          exit
        endif
      end do
      if (stat /= DC_NOERR) then
        cause_c = 'n-m=' // toChar(n-m) // ', lmax=' // toChar(lmax)
        goto 999
      end if

      !---------------------------------------------------------------
      !   $ \underline{M} $ η׻
      !  Calculate matrix $ \underline{M} $
      !---------------------------------------------------------------
      do k = 0, kmax-1
        do  kk = 0, kmax-1
          zz_siMtxM ( k,kk ) = &
            & - DelTime**2 * flapla &
            &   * (   zz_siMtxWH( k,kk ) &
            &       + zz_siMtxGCt( k,kk ) &
            &         * ( 1.0_DP + DelTime * 2.0_DP * w_DiffTherm(nm) )  )
          if ( k == kk ) then
            zz_siMtxM ( k,kk ) = &
              & zz_siMtxM ( k,kk ) &
              & +   ( 1.0_DP + DelTime * 2.0_DP * w_DiffVorDiv(nm) ) &
              &   * ( 1.0_DP + DelTime * 2.0_DP * w_DiffTherm(nm) )
          endif
        end do
      end do

      !---------------------------------------------------------------
      !  LU ׻
      !  LU matrix calculation
      !---------------------------------------------------------------
      call LUDecomp( &
        & zz_siMtxM, & ! (inout)
        & z_siMtxPivWork ) ! (out)

      ! ߡͤ. ( kmax-1 Ϥޤ̤ʤ).
      ! Dummy value is subtituted. (Position kmax-1 is undefined yet).
      z_siMtxPivWork(kmax-1) = 0

!!$      write(*,*) 'n= ', n
!!$
!!$      do k = 0, kmax-1
!!$        do kk = 0, kmax-1
!!$          write(*,*) 'zz_siMtxM(', k+1, ',', kk+1, ')= ', zz_siMtxM(k,kk)
!!$        end do
!!$      end do

!!$      do k = 0, kmax-1
!!$        write(*,*) 'z_siMtxPivWork(', k, ')= ', z_siMtxPivWork(k)
!!$      end do

      !---------------------------------------------------------------
      !  εͤؤ
      !  Repack matrices
      !---------------------------------------------------------------
      do m = 0, mmax
        l = n - m
        if ( ( l >= 0 ) .and. ( l <= lmax ) ) then
          do k = 0, kmax-1
            do kk = 0, kmax-1
              dyn_mtx % wzz_siMtxLU ( nmo(1,m,l),k,kk ) = zz_siMtxM ( k,kk )
              dyn_mtx % wzz_siMtxLU ( nmo(2,m,l),k,kk ) = zz_siMtxM ( k,kk )
            end do
            dyn_mtx % wz_siMtxPiv ( nmo(1,m,l),k ) = z_siMtxPivWork ( k )
            dyn_mtx % wz_siMtxPiv ( nmo(2,m,l),k ) = z_siMtxPivWork ( k )
            mxnm = max( mxnm, nmo(1,m,l) )
            mxnm = max( mxnm, nmo(2,m,l) )
          end do
        endif
      end do

    end do Loop_n

    do nm = mxnm+1, (nmax+1)**2
      do k = 0, kmax-1
        do kk = 0, kmax-1
          dyn_mtx % wzz_siMtxLU ( nm,k,kk ) = zz_siMtxM ( k,kk )
        end do
        dyn_mtx % wz_siMtxPiv ( nm,k ) = z_siMtxPivWork ( k )
      end do
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    dyn_mtx % initialized = .true.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynMatrixCreate

  subroutine DynMatrixClose( dyn_mtx, err )
    !
    ! DYNMTX ѿνλԤޤ.
    ! ʤ, Ϳ줿 *dyn_mtx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "DYNMTX".
    ! Note that if *dyn_mtx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(DYNMTX), intent(inout):: dyn_mtx
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynMatrixClose'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_mtx % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNMTX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "DYNMTX" ξõ
    !  Clear the settings for "DYNMTX"
    !-----------------------------------------------------------------
    deallocate( dyn_mtx % wzz_siMtxLU )
    deallocate( dyn_mtx % wz_siMtxPiv )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    dyn_mtx % initialized = .false.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynMatrixClose

  subroutine DynMatrixPutLine( dyn_mtx, unit, indent, err )
    !
    !  *dyn_mtx* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *dyn_mtx*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dc_string, only: Printf, PutLine
    implicit none
    type(DYNMTX), intent(in):: dyn_mtx
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'DynMatrixPutLine'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if (present(indent)) then
      if (len(indent) /= 0) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "DYNMTX" ΰ
    !  Print the settings for "DYNMTX"
    !-----------------------------------------------------------------
    if (dyn_mtx % initialized) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<DYNMTX:: @initialized=%y>', &
        & l=(/dyn_mtx % initialized/))
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<DYNMTX:: @initialized=%y>', &
        & l=(/dyn_mtx % initialized/))
    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynMatrixPutLine

  logical function DynMatrixInitialized( dyn_mtx ) result(result)
    !
    ! *dyn_mtx* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *dyn_mtx* is initialized, .true. is returned.
    ! If *dyn_mtx* is not initialized, .false. is returned.
    !
    implicit none
    type(DYNMTX), intent(in):: dyn_mtx
  continue
    result = dyn_mtx % initialized
  end function DynMatrixInitialized

  subroutine DynMatrixSolve( dyn_mtx, &
    & wz_RSVector2Solution, &
    & err )
    !
    ! ե٥ȥȤƼä *wz_RSVector2Solution* 
    ! Create κݤ˺ LU , ԥܥåȤη׻Ԥ,
    ! β *wz_RSVector2Solution* Ȥ֤.
    !
    ! ʤ, Ϳ줿 *dyn_mtx*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate solution from given *wz_RSVector2Solution* as right hand
    ! vector and LU matrix and pivot that are created in "Create".
    ! The solution is returned to *wz_RSVector2Solution*.
    !
    ! If *dyn_mtx* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_string, only: PutLine
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use lumatrix, only: LUSolve
    implicit none
    type(DYNMTX), intent(inout):: dyn_mtx
    real(DP), intent(inout):: wz_RSVector2Solution((dyn_mtx%nmax+1)**2, 0:dyn_mtx%kmax-1)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'DynMatrixSolve'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. dyn_mtx % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'DYNMTX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  η׻
    !  Caluculate solution
    !-----------------------------------------------------------------
    wz_RSVector2Solution = &
      & LUSolve( dyn_mtx % wzz_siMtxLU, dyn_mtx % wz_siMtxPiv, &
      &          wz_RSVector2Solution )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DynMatrixSolve

  subroutine DynMatrixNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_string, only: PutLine
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /dyn_matrix_nml/ &
!!$      & param_i, param_r, param_c
                              ! dyn_matrix ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! dyn_matrix#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "dyn_matrix" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "dyn_matrix#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'DynMatrixNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = dyn_matrix_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1='dyn_matrix_nml', c2=trim(nmlfile) )
!!$      write(STDOUT, nml = dyn_matrix_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1='dyn_matrix_nml', c2=trim(nmlfile), &
!!$        & i=(/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine DynMatrixNmlRead


!!$  subroutine DynMatrixSample( dyn_mtx, err )
!!$    !--
!!$    ! DynMatrixSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *dyn_mtx*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of DynMatrixSample
!!$    !++
!!$    ! If *dyn_mtx* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine
!!$    use dc_types, only: STRING, STDOUT
!!$    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
!!$    implicit none
!!$    type(DYNMTX), intent(inout):: dyn_mtx
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'DynMatrixSample'
!!$  continue
!!$    call BeginSub(subname)
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if (.not. dyn_mtx % initialized) then
!!$      stat = DCPAM_ENOTINIT
!!$      cause_c = 'DYNMTX'
!!$      goto 999
!!$    end if
!!$
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError(stat, subname, err, cause_c)
!!$    call EndSub(subname)
!!$  end subroutine DynMatrixSample

end module dyn_matrix
