!= ¸
!
!= Aqua Planet Experiment
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_ape.f90,v 1.5 2007/09/04 01:35:52 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_ape
  !
  != ¸
  !
  != Aqua Planet Experiment
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 夬ʤƤ褦絤׻
  ! ɬפʪ׻ޤ. 
  ! ºݤˤΥ⥸塼Ƿ׻Ƥʪϰʲ̤Ǥ. 
  ! 
  ! * ʰ¿
  ! * ľȻ (Mellor and Yamada, 1974, ٥ 2)
  ! * ɽեå (Х륯ˡ)
  ! * ήĴ (Manabe et al., 1965)
  ! * ήĴ, 
  ! * Ƿ絬϶ŷ
  !
  ! Physical processes are calculated for calculation of
  ! atmosphere on a planet covered with water globally.
  ! Physical processes calculated in this module is as follows.
  !
  ! * Radiation process represented by band model
  ! * Vertical diffusion
  ! * Surface flux (bulk formulae)
  ! * Moist convective adjustment
  ! * Dry convective adjustment
  ! * Large scale condensation
  !
  !== Procedures List
  !
  ! Create        :: PHYAPE ѿν
  ! PhysicsAPE    :: ʪη׻
  ! Close         :: PHYAPE ѿνλ
  ! PutLine       :: PHYAPE ѿ˳ǼƤΰ
  ! initialized   :: PHYAPE ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYAPE"
  ! PhysicsAPE    :: Calculate physical processes
  ! Close         :: Deconstructor of "PHYAPE"
  ! PutLine       :: Print information of "PHYAPE"
  ! initialized   :: Check initialization of "PHYAPE"
  !
  !== Usage
  !
  ! ץλϤ, PHYAPE ѿ Create ǽޤ.
  ! , ʬ롼Ǳ, ȯ, , 漾, ɽ̵ 
  ! ( $ t+\Delta t $ )  PhysicsAPE ͿƤ. 
  ! ͤФʪα黻Ԥޤ.
  ! Ǹ, PHYAPE ѿνλ Close ˤƹԤޤ.
  !
  ! In the begging of program, initialize "PHYAPE" by "Create".
  ! Next, in the time integration loop, 
  ! provide vorticity, divergence, temperature, specific humidity, 
  ! surface pressure on $ t+\Delta t $ to PhysicsAPE. 
  ! Physical processes are calculate about the values.
  ! Finally, terminate "PHYAPE" by "Close".
  !

  use dc_types, only: DP, TOKEN
  implicit none
  private
  public:: PHYAPE, Create, Close, PutLine, initialized, PhysicsAPE

  type PHYAPE
    !
    ! ޤ, Create  "PHYAPE" ѿꤷƲ.
    ! ꤵ줿 "PHYAPE" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYAPE" variable by "Create" before usage.
    ! If you reuse "PHYAPE" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP), pointer:: x_Lon (:)
                              ! . Longitude
    real(DP), pointer:: y_Lat (:)
                              ! . Latitude
    real(DP), pointer:: z_Sigma (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), pointer:: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    type(PHYGRD):: phy_grd
    type(PHYINTPOL):: phy_intpol
    type(PHYNEGQ):: phy_negq
    type(PHYCUMAD):: phy_cumad
    type(PHYLSCOND):: phy_lscond
    type(PHYIMPL):: phy_impl
    type(PHYRADFLX):: phy_radflx
    type(PHYVDIF):: phy_vdif
    type(PHYSURFFLX):: phy_surfflx
    type(PHYDRY):: phy_dry
  end type PHYAPE

  character(*), parameter:: version = &
    & '$Name: dcpam4-20070909 $' // &
    & '$Id: phy_ape.f90,v 1.5 2007/09/04 01:35:52 morikawa Exp $'

  interface Create
    module procedure PhysApeCreate
  end interface

  interface Close
    module procedure PhysApeClose
  end interface

  interface PutLine
    module procedure PhysApePutLine
  end interface

  interface initialized
    module procedure PhysApeInitialized
  end interface

  interface PhysicsAPE
    module procedure PhysApePhysicsAPE
  end interface

  interface NmlRead
    module procedure PhysApeNmlRead
  end interface

!!$  interface Sample
!!$    module procedure PhysApeSample
!!$  end interface

contains

  subroutine PhysApeCreate( phy_ape, &
    & imax, jmax, kmax, &
    & x_Lon, y_Lat, z_Sigma, r_Sigma, &
    & DelTime, &
    & nmlfile, err )
    !
    ! PHYAPE ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYAPE ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_ape* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_ape_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYAPE".
    ! Initialize *phy_ape* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_ape* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_ape_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    implicit none
    type(PHYAPE), intent(inout):: phy_ape
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: x_Lon (0:imax-1)
                              ! . Longitude
    real(DP), intent(in):: y_Lat (0:jmax-1)
                              ! . Latitude
    real(DP), intent(in):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), intent(in):: r_Sigma (0:kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_ape_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_ape_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ɽ̥ǡ
    !  Data on surface
    real(DP):: xy_SurfTemp (0:imax-1, 0:jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP):: xy_SurfAlbedo (0:imax-1, 0:jmax-1)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP):: xy_SurfHumidCoeff (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP):: xy_SurfRoughLength (0:imax-1, 0:jmax-1)
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP):: xy_SurfHeatCapacity (0:imax-1, 0:jmax-1)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP):: xy_GroundTempFlux (0:imax-1, 0:jmax-1)
                              ! Ǯեå. 
                              ! Ground temperature flux
    integer:: xy_SurfCondition (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface condition

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhysApeCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_ape % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYAPE'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (DelTime < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'DelTime'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    phy_ape % imax = imax
    phy_ape % jmax = jmax
    phy_ape % kmax = kmax

    !-----------------------------------------------------------------
    !  ɸ
    !  Configure axes
    !-----------------------------------------------------------------
    allocate( phy_ape % x_Lon (0:imax-1) )
    phy_ape % x_Lon = x_Lon

    allocate( phy_ape % y_Lat (0:jmax-1) )
    phy_ape % y_Lat = y_Lat

    allocate( phy_ape % z_Sigma (0:kmax-1) )
    phy_ape % z_Sigma = z_Sigma

    allocate( phy_ape % r_Sigma (0:kmax) )
    phy_ape % r_Sigma = r_Sigma

    !-----------------------------------------------------------------
    !  $ \Delta t $ 
    !  Configure $ \Delta t $
    !-----------------------------------------------------------------
    phy_ape % DelTime = DelTime

    !-----------------------------------------------------------------
    !  ɽ
    !  Configure ground condition
    !-----------------------------------------------------------------
    call Create( phy_grd = phy_ape % phy_grd, &  ! (inout)
      & imax = imax, jmax = jmax, &              ! (in)
      & y_Lat = y_Lat, &                         ! (in)
      & nmlfile = nmlfile, &                     ! (in)
      & err = err )                              ! (out)

    call Get( phy_grd = phy_ape % phy_grd, &          ! (inout)
      & xy_SurfTemp         = xy_SurfTemp, &          ! (out)
      & xy_SurfAlbedo       = xy_SurfAlbedo, &        ! (out)
      & xy_SurfHumidCoeff   = xy_SurfHumidCoeff, &    ! (out)
      & xy_SurfRoughLength  = xy_SurfRoughLength, &   ! (out)
      & xy_SurfCondition    = xy_SurfCondition, &     ! (out)
      & xy_SurfHeatCapacity = xy_SurfHeatCapacity, &  ! (out)
      & xy_GroundTempFlux   = xy_GroundTempFlux )     ! (out)

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential
    !-----------------------------------------------------------------
    call Create( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &       ! (in)
      & z_Sigma = z_Sigma, r_Sigma = r_Sigma, &        ! (in)
      & nmlfile = nmlfile, &                           ! (in)
      & err = err )                                    ! (out)

    !-----------------------------------------------------------------
    !  ο
    !  Remove negative moisture
    !-----------------------------------------------------------------
    call Create( phy_negq = phy_ape % phy_negq, &  ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &   ! (in)
      & DelTime2 = DelTime * 2.0_DP, &             ! (in)
      & nmlfile = nmlfile, &                       ! (in)
      & err = err )                                ! (out)

    !-----------------------------------------------------------------
    !   (ѱ)
    !  Moist process (cumulus)
    !-----------------------------------------------------------------
    call Create( phy_cumad = phy_ape % phy_cumad, &  ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &     ! (in)
      & DelTime2 = DelTime * 2.0_DP, &               ! (in)
      & nmlfile = nmlfile, &                         ! (in)
      & err = err )                                  ! (out)

    !-----------------------------------------------------------------
    !   (絬϶ŷ)
    !  Moist process (large scale condensation)
    !-----------------------------------------------------------------
    call Create( phy_lscond = phy_ape % phy_lscond, & ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &      ! (in)
      & DelTime2 = DelTime * 2.0_DP, &                ! (in)
      & nmlfile = nmlfile, &                          ! (in)
      & err = err )                                   ! (out)

    !-----------------------------------------------------------------
    !  
    !  Initialize implicit matrices
    !-----------------------------------------------------------------
    call Create( phy_impl = phy_ape % phy_impl, &    ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &     ! (in)
      & DelTime2 = DelTime * 2.0_DP, &               ! (in)
      & xy_SurfHeatCapacity = xy_SurfHeatCapacity, & ! (in)
      & xy_SurfCondition = xy_SurfCondition, &       ! (in)
      & nmlfile = nmlfile, &                         ! (in)
      & err = err )                                  ! (out)

    !-----------------------------------------------------------------
    !  ͥեå
    !  Radiation flux
    !-----------------------------------------------------------------
    call Create( phy_radflx = phy_ape % phy_radflx, & ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &      ! (in)
      & x_Lon = x_Lon, y_Lat = y_Lat, &               ! (in)
      & xy_SurfTemp = xy_SurfTemp, &                  ! (in)
      & xy_SurfAlbedo = xy_SurfAlbedo,                ! (in)
      & nmlfile = nmlfile, &                          ! (in)
      & err = err )                                   ! (out)

    !-----------------------------------------------------------------
    !  ľȻեå
    !  Vertical diffusion flux
    !-----------------------------------------------------------------
    call Create( phy_vdif = phy_ape % phy_vdif, & ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &  ! (in)
      & nmlfile = nmlfile, &                      ! (in)
      & err = err )                               ! (out)

    !-----------------------------------------------------------------
    !  ɽ̥եå
    !  Surface flux
    !-----------------------------------------------------------------
    call Create( phy_surfflx = phy_ape % phy_surfflx, & ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &        ! (in)
      & xy_SurfTemp = xy_SurfTemp, &                    ! (in)
      & xy_SurfHumidCoeff = xy_SurfHumidCoeff, &        ! (in)
      & xy_SurfRoughLength = xy_SurfRoughLength, &      ! (in)
      & xy_SurfCondition = xy_SurfCondition, &          ! (in)
      & nmlfile = nmlfile, &                            ! (in)
      & err = err )                                     ! (out)

    !-----------------------------------------------------------------
    !  ѲΨη׻ (ˡ)
    !  Calculate tendency (implicit)
    !-----------------------------------------------------------------
    call Create( phy_vdif = phy_ape % phy_vdif, & ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &  ! (in)
      & nmlfile = nmlfile, &                      ! (in)
      & err = err )                               ! (out)

    !-----------------------------------------------------------------
    !  ήĴ
    !  Dry convective adjustment
    !-----------------------------------------------------------------
    call Create( phy_dry = phy_ape % phy_dry, &   ! (inout)
      & imax = imax, jmax = jmax, kmax = kmax, &  ! (in)
      & DelTime2 = DelTime * 2.0_DP, &            ! (in)
      & nmlfile = nmlfile, &                      ! (in)
      & err = err )                               ! (out)

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1=trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_ape % param_i, &   ! (inout)
!!$        & param_r = phy_ape % param_r, &   ! (inout)
!!$        & param_c_ = phy_ape % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1=trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    !-----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_ape % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApeCreate

  subroutine PhysApeClose( phy_ape, err )
    !
    ! PHYAPE ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_ape*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYAPE".
    ! Note that if *phy_ape* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYAPE), intent(inout):: phy_ape
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhysApeClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_ape % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYAPE'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ɽ
    !  Configure ground condition
    !-----------------------------------------------------------------
    call Close( phy_grd = phy_ape % phy_grd, &  ! (inout)
      & err = err )                             ! (out)

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential
    !-----------------------------------------------------------------
    call Close( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & err = err )                                   ! (out)

    !-----------------------------------------------------------------
    !  ο
    !  Remove negative moisture
    !-----------------------------------------------------------------
    call Close( phy_negq = phy_ape % phy_negq, &  ! (inout)
      & err = err )                               ! (out)

    !-----------------------------------------------------------------
    !   (ѱ)
    !  Moist process (cumulus)
    !-----------------------------------------------------------------
    call Close( phy_cumad = phy_ape % phy_cumad, &  ! (inout)
      & err = err )                                 ! (out)

    !-----------------------------------------------------------------
    !   (絬϶ŷ)
    !  Moist process (large scale condensation)
    !-----------------------------------------------------------------
    call Close( phy_lscond = phy_ape % phy_lscond, & ! (inout)
      & err = err )                                  ! (out)

    !-----------------------------------------------------------------
    !  
    !  Initialize implicit matrices
    !-----------------------------------------------------------------
    call Close( phy_impl = phy_ape % phy_impl, &    ! (inout)
      & err = err )                                 ! (out)

    !-----------------------------------------------------------------
    !  ͥեå
    !  Radiation flux
    !-----------------------------------------------------------------
    call Close( phy_radflx = phy_ape % phy_radflx, & ! (inout)
      & err = err )                                  ! (out)

    !-----------------------------------------------------------------
    !  ľȻեå
    !  Vertical diffusion flux
    !-----------------------------------------------------------------
    call Close( phy_vdif = phy_ape % phy_vdif, & ! (inout)
      & err = err )                              ! (out)

    !-----------------------------------------------------------------
    !  ɽ̥եå
    !  Surface flux
    !-----------------------------------------------------------------
    call Close( phy_surfflx = phy_ape % phy_surfflx, & ! (inout)
      & err = err )                                    ! (out)

    !-----------------------------------------------------------------
    !  ѲΨη׻ (ˡ)
    !  Calculate tendency (implicit)
    !-----------------------------------------------------------------
    call Close( phy_vdif = phy_ape % phy_vdif, & ! (inout)
      & err = err )                              ! (out)

    !-----------------------------------------------------------------
    !  ήĴ
    !  Dry convective adjustment
    !-----------------------------------------------------------------
    call Close( phy_dry = phy_ape % phy_dry, &   ! (inout)
      & err = err )                              ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_ape % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApeClose

  subroutine PhysApePutLine( phy_ape, unit, indent, err )
    !
    !  *phy_ape* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_ape*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_string, only: Printf
    implicit none
    type(PHYAPE), intent(in):: phy_ape
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhysApePutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYAPE" ΰ
    !  Print the settings for "PHYAPE"
    !-----------------------------------------------------------------
    if ( phy_ape % initialized ) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYAPE:: @initialized=%y', &
        & l=(/phy_ape % initialized/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i=(/phy_ape % imax, phy_ape % jmax, phy_ape % kmax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @DelTime=%f', &
        & i=(/phy_ape % DelTime/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @x_Lon=%*f', &
        & i=(/phy_ape % x_Lon/) n=(/phy_ape % imax/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @y_Lat=%*f', &
        & i=(/phy_ape % y_Lat/) n=(/phy_ape % jmax/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @z_Simga=%*f', &
        & i=(/phy_ape % z_Sigma/) n=(/phy_ape % kmax/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @r_Simga=%*f', &
        & i=(/phy_ape % r_Sigma/) n=(/phy_ape % kmax + 1/))

      call PutLine( phy_ape % phy_grd, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_intpol, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_negq, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_cumad, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_lscond, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_impl, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_radflx, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_vdif, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_surfflx, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call PutLine( phy_ape % phy_dry, out_unit, &
        & indent_str(1:indent_len) // &
        & ' ', err )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYAPE:: @initialized=%y>', &
        & l=(/phy_ape % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApePutLine

  logical function PhysApeInitialized( phy_ape ) result(result)
    !
    ! *phy_ape* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_ape* is initialized, .true. is returned.
    ! If *phy_ape* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYAPE), intent(in):: phy_ape
  continue
    result = phy_ape % initialized
  end function PhysApeInitialized

  subroutine PhysApeNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_ape_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_ape ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_ape#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "phy_ape" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_ape#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhysApeNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_ape_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1='phy_ape_nml', c2=trim(nmlfile) )
!!$      write(STDOUT, nml = phy_ape_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1='phy_ape_nml', c2=trim(nmlfile), &
!!$        & i=(/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApeNmlRead

  subroutine PhysApePhysicsAPE( phy_ape, err )
    !--
    ! PhysApePhysicsAPE 򵭽ҤƤ.
    !++
    ! ʤ, Ϳ줿 *phy_ape*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !--
    ! Describe brief of PhysApePhysicsAPE
    !++
    ! If *phy_ape* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYAPE), intent(inout):: phy_ape
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  *phy_ape* Ф
    !  Setting values fetched from *phy_ape*
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    !-----------------------------------
    !   (٥) ɽ̵ޤǡ
    !  Data interpolated from temperature (full level) and surface pressure
    real(DP):: xyr_Temp (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP):: xyz_Press (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
    real(DP):: xyr_Press (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP):: xyz_GeoPot (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
    real(DP):: xyr_GeoPot (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! $ \phi $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)

    !-----------------------------------
    !  ο˻Ѥ
    !  Values for removal of negative moisture
    real(DP):: xyz_DNegQvap1Dt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! 漾ѲΨ (1). 
                              ! Specific humidity tendency (1)
    real(DP):: xyz_DNegQVap2Dt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! 漾ѲΨ (2). 
                              ! Specific humidity tendency (2)

    !-----------------------------------
    !   (ѱ) Ƿ׻
    !  Values calculated by moist process (cumulus)
    real(DP):: xyz_DCumulusTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ѱˤ벹ѲΨ. 
                              ! Temperature tendency by cumulus scheme
    real(DP):: xyz_DCumulusQvapDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ѱˤ漾ѲΨ. 
                              ! Specific humidity tendency by cumulus scheme
    real(DP):: xy_CumulusRain (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              ! ѱˤ߿. 
                              ! Precipitation by cumulus scheme

    !-----------------------------------
    !   (絬϶ŷ) Ƿ׻
    !  Values calculated by moist process (large scale condensation)
    real(DP):: xyz_DLscTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! 絬϶ŷˤ벹ѲΨ. 
                              ! Temperature tendency by large scale condensation
    real(DP):: xyz_DLscQvapDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! 絬϶ŷˤ漾ѲΨ. 
                              ! Specific humidity tendency by large scale condensation
    real(DP):: xy_LscRain (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              ! 絬϶ŷˤ߿. 
                              ! Precipitation tendency by large scale condensation

    !-----------------------------------
    !  
    !  Implicit matrices
    real(DP):: xyza_UVMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP):: xyza_TempMatrix  (0:phy_ape%imax-1, 0:phy_ape%jmax-1, -1:phy_ape%kmax-1, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP):: xyza_QvapMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity

    !-----------------------------------
    !  ͥեåǷ׻
    !  Values calculated by radiation flux
    real(DP):: xyr_RadLFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
    real(DP):: xya_SurfRadLMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, -1:1)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
    real(DP):: xyra_DelRadLFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
    real(DP):: xyr_RadSFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! ͥեå. 
                              ! Insolation flux

    !-----------------------------------
    !  ľȻեåǷ׻
    !  Values calculated by vertical diffusion flux
    real(DP):: xyr_UFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! ®եå. 
                              ! Zonal wind flux
    real(DP):: xyr_VFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! ®եå. 
                              ! Meridional wind flux
    real(DP):: xyr_TempFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP):: xyr_QvapFlux (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax)
                              ! 漾եå. 
                              ! Specific humidity flux

    !-----------------------------------
    !  ɽ̥եåǷ׻
    !  Values calculated by surface flux
    real(DP):: xy_SurfUVMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              !  ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
    real(DP):: xyaa_SurfTempMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:1, -1:1)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
    real(DP):: xyaa_SurfQvapMatrix (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:1, -1:1)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface

    !-----------------------------------
    !  ѲΨη׻ (ˡ)
    !  Calculate tendency (implicit)
    real(DP):: xyz_DVerdiffUDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ʬ ľȻ®. 
                              ! Zonal acceleration by vertical diffusion
    real(DP):: xyz_DVerdiffVDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ʬ ľȻ®. 
                              ! Meridional acceleration by vertical diffusion
    real(DP):: xyz_DVerdiffTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ľȻǮΨ. 
                              ! Temperature tendency by vertical diffusion
    real(DP):: xyz_DVerdiffSurfTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1)
                              ! ɽ ľȻǮΨ. 
                              ! Surface temperature tendency by vertical diffusion
    real(DP):: xyz_DVerdiffQvapDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ľȻüΨ. 
                              ! Specific humidity tendency by vertical diffusion

    !-----------------------------------
    !  ѴΨ
    !  Temperature tendency
    real(DP):: xyz_DRadLTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with long wave
    real(DP):: xyz_DRadSTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with short wave

    !-----------------------------------
    !  ήĴǷ׻
    !  Values calculated by dry convective adjustment
    real(DP):: xyz_DDryTempDt (0:phy_ape%imax-1, 0:phy_ape%jmax-1, 0:phy_ape%kmax-1)
                              ! ήĴˤ벹ѲΨ. 
                              ! Temperature tendency by dry convective adjustment

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhysApePhysicsAPE'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_ape % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYAPE'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_ape* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_ape*
    !-----------------------------------------------------------------
    imax = phy_ape % imax
    jmax = phy_ape % jmax
    kmax = phy_ape % kmax

    DelTime = phy_ape % DelTime

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ (1)
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential (1)
    !-----------------------------------------------------------------

    !-----------------------------------
    !  ٤Ⱦ $ \sigma $ ٥
    !  Interpolate temperature on half $ \sigma $ level
    call InterpolateTemp( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xyz_Temp   = xyz_Temp, &                                ! (in)
      & xyr_Temp   = xyr_Temp )                                 ! (out)

    !-----------------------------------
    !  ȥݥƥ󥷥λ
    !  Calculate pressure and geo-potential
    call InterpolateGeoPot( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xy_Ps      = xy_Ps, &                                     ! (in)
      & xyz_Temp   = xyz_Temp,   xyr_Temp   = xyr_Temp, &         ! (in)
      & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, &        ! (out)
      & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot )        ! (out)

    !-----------------------------------------------------------------
    !  ο (1)
    !  Remove negative moisture (1)
    !-----------------------------------------------------------------
    xyz_DNegQVap1Dt = 0.0_DP
    call RemoveNegQVap( phy_negq = phy_ape % phy_negq, &        ! (inout)
      & xyr_Press = xyr_Press, &                                ! (in)
      & xyz_QVap = xyz_QVap, xyz_DNegQVapDt = xyz_DNegQVap1Dt ) ! (inout)

    !-----------------------------------------------------------------
    !   (ѱ)
    !  Moist process (cumulus)
    !-----------------------------------------------------------------
    call Cumulus( phy_cumad = phy_ape % phy_cumad, &     ! (inout)
      & xyz_Press = xyz_Press,  xyr_Press = xyr_Press, & ! (in)
      & xyz_Temp  = xyz_Temp,   xyz_QVap  = xyz_QVap, &  ! (inout)
      & xy_CumulusRain = xy_CumulusRain, &               ! (out)
      & xyz_DCumulusTempDt = xyz_DCumulusTempDt, &       ! (out)
      & xyz_DCumulusQVapDt = xyz_DCumulusQVapDt )        ! (out)

    !-----------------------------------------------------------------
    !   (絬϶ŷ)
    !  Moist process (large scale condensation)
    !-----------------------------------------------------------------
    call LScaleCond( phy_lscond = phy_ape % phy_lscond, & ! (inout)
      & xyz_Press = xyz_Press,  xyr_Press = xyr_Press, &  ! (in)
      & xyz_Temp  = xyz_Temp,   xyz_QVap  = xyz_QVap, &   ! (inout)
      & xy_LscRain = xy_LscRain, &                        ! (out)
      & xyz_DLscTempDt = xyz_DLscTempDt, &                ! (out)
      & xyz_DLscQVapDt = xyz_DLscQVapDt )                 ! (out)

    !-----------------------------------------------------------------
    !  ο (2)
    !  Remove negative moisture (2)
    !-----------------------------------------------------------------
    call RemoveNegQVap( phy_negq = phy_ape % phy_negq, &        ! (inout)
      & xyr_Press = xyr_Press, &                                ! (in)
      & xyz_QVap = xyz_QVap, xyz_DNegQVapDt = xyz_DNegQVap1Dt ) ! (inout)

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ (2)
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential (2)
    !-----------------------------------------------------------------

    !-----------------------------------
    !  ɽ̵κƷ׻
    !  Recalculate surface pressure
    do k = 0, kmax - 1
      xy_Ps = xy_Ps &
        & + ( xyz_DLscQVapDt(:,:,k) &
        &     + xyz_DCumulusQVapDt(:,:,k) &
        &     + xyz_DNegQVap1Dt(:,:,k)     ) &
        &  * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
        &  * 2.0_DP * DelTime
    end do

    !-----------------------------------
    !  ٤Ⱦ $ \sigma $ ٥
    !  Interpolate temperature on half $ \sigma $ level
    call InterpolateTemp( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xyz_Temp   = xyz_Temp, &                                ! (in)
      & xyr_Temp   = xyr_Temp )                                 ! (out)

    !-----------------------------------
    !  ȥݥƥ󥷥λ
    !  Calculate pressure and geo-potential
    call InterpolateGeoPot( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xy_Ps      = xy_Ps, &                                     ! (in)
      & xyz_Temp   = xyz_Temp,   xyr_Temp   = xyr_Temp, &         ! (in)
      & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, &        ! (out)
      & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot )        ! (out)

    !-----------------------------------------------------------------
    !  
    !  Create implicit matrices
    !-----------------------------------------------------------------
    call GetMatrices( phy_impl = phy_ape % phy_impl, &              ! (inout)
      & xyr_Press = xyr_Press, &                                    ! (in)
      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &             ! (out)
      & xyr_TempFlux = xyr_TempFlux, xyr_QVapFlux = xyr_QVapFlux, & ! (out)
      & xyza_UVMatrix = xyza_UVMatrix, &                            ! (out)
      & xyza_TempMatrix = xyza_TempMatrix, &                        ! (out)
      & xyza_QVapMatrix = xyza_QVapMatrix )                         ! (out)

    !-----------------------------------------------------------------
    !  ͥեå
    !  Radiation flux
    !-----------------------------------------------------------------
    call RadiationFlux( phy_radflx = phy_ape % phy_radflx, & ! (inout)
      & xyz_Temp = xyz_Temp, &                               ! (in)
      & xyz_QVap = xyz_QVap, &                               ! (in)
      & xyr_Press = xyr_Press, &                             ! (in)
      & xyr_RadLFlux = xyr_RadLFlux, &                       ! (out)
      & xya_SurfRadLMatrix = xya_SurfRadLMatrix, &           ! (out)
      & xyra_DelRadLFlux = xyra_DelRadLFlux, &               ! (out)
      & xyr_RadSFlux = xyr_RadSFlux )                        ! (out)

    !-----------------------------------------------------------------
    !  ľȻեå
    !  Vertical diffusion flux
    !-----------------------------------------------------------------
    call VerticalDiffusion( phy_vdif = phy_ape % phy_vdif, & ! (inout)
      & xyz_U    = xyz_U,    xyz_V    = xyz_V, &             ! (in)
      & xyz_Temp = xyz_Temp, xyr_Temp = xyr_Temp, &          ! (in)
      & xyz_QVap = xyz_QVap, &                               ! (in)
      & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, &   ! (in)
      & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot, &  ! (in)
      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &      ! (inout)
      & xyr_TempFlux = xyr_TempFlux, &                       ! (inout)
      & xyr_QVapFlux = xyr_QVapFlux, &                       ! (inout)
      & xyza_UVMatrix   = xyza_UVMatrix, &                   ! (inout)
      & xyza_TempMatrix = xyza_TempMatrix, &                 ! (inout)
      & xyza_QVapMatrix = xyza_QVapMatrix )                  ! (inout)

    !-----------------------------------------------------------------
    !  ɽ̥եå
    !  Surface flux
    !-----------------------------------------------------------------
    call SurfaceFlux( phy_surfflx = phy_ape % phy_surfflx, & ! (inout)
      & xyz_U = xyz_U, xyz_V = xyz_V, &                      ! (in)
      & xyz_Temp = xyz_Temp, xyr_Temp = xyr_Temp, &          ! (in)
      & xyz_QVap = xyz_QVap, &                               ! (in)
      & xyz_Press = xyz_Press, xyr_Press = xyr_Press, &      ! (in)
      & xyz_GeoPot = xyz_GeoPot, &                           ! (in)
      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &      ! (inout)
      & xyr_TempFlux = xyr_TempFlux, &                       ! (inout)
      & xyr_QVapFlux = xyr_QVapFlux, &                       ! (inout)
      & xy_SurfUVMatrix = xy_SurfUVMatrix, &                 ! (out)
      & xyaa_SurfTempMatrix = xyaa_SurfTempMatrix, &         ! (out)
      & xyaa_SurfQVapMatrix = xyaa_SurfQVapMatrix )          ! (out)

    !-----------------------------------------------------------------
    !  ѲΨη׻ (ˡ)
    !  Calculate tendency (implicit)
    !-----------------------------------------------------------------
    call Integrate( phy_impl = phy_ape % phy_impl, &       ! (inout)
      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &    ! (in)
      & xyr_TempFlux = xyr_TempFlux, &                     ! (in)
      & xy_RadSFlux = xyr_RadSFlux(:,:,0), &               ! (in)
      & xy_RadLFlux = xyr_RadLFlux(:,:,0), &               ! (in)
      & xy_GroundTempFlux = xy_GroundTempFlux, &           ! (in)
      & xyr_QVapFlux = xyr_QVapFlux, &                     ! (in)
      & xyza_UVMatrix = xyza_UVMatrix, &                   ! (in)
      & xyza_TempMatrix = xyza_TempMatrix, &               ! (in)
      & xyza_QVapMatrix = xyza_QVapMatrix, &               ! (in)
      & xy_SurfUVMatrix = xy_SurfUVMatrix, &               ! (in)
      & xyaa_SurfTempMatrix = xyaa_SurfTempMatrix, &       ! (in)
      & xyaa_SurfQVapMatrix = xyaa_SurfQVapMatrix, &       ! (in)
      & xya_SurfRadLMatrix = xya_SurfRadLMatrix, &         ! (in)
      & xyz_DVerdiffUDt = xyz_DVerdiffUDt, &               ! (out)
      & xyz_DVerdiffVDt = xyz_DVerdiffVDt, &               ! (out)
      & xyz_DVerdiffTempDt = xyz_DVerdiffTempDt, &         ! (out)
      & xyz_DVerdiffSurfTempDt = xyz_DVerdiffSurfTempDt, & ! (out)
      & xyz_DVerdiffQVapDt = xyz_DVerdiffQVapDt )          ! (out)

    !-----------------------------------
    !  եå
    !  Flux correction
    !   ȤꤢޤƳʤ
!!$    call FluxCorrection( phy_impl = phy_ape % phy_impl, &  ! (inout)
!!$      & xyz_DVerdiffUDt = xyz_DVerdiffUDt, &               ! (in)
!!$      & xyz_DVerdiffVDt = xyz_DVerdiffVDt, &               ! (in)
!!$      & xyz_DVerdiffTempDt = xyz_DVerdiffTempDt, &         ! (in)
!!$      & xyz_DVerdiffSurfTempDt = xyz_DVerdiffSurfTempDt, & ! (in)
!!$      & xyz_DVerdiffQVapDt = xyz_DVerdiffQVapDt, &         ! (in)
!!$      & xyza_UVMatrix = xyza_UVMatrix, &                   ! (in)
!!$      & xyza_TempMatrix = xyza_TempMatrix, &               ! (in)
!!$      & xyza_QVapMatrix = xyza_QVapMatrix, &               ! (in)
!!$      & xy_SurfUVMatrix = xy_SurfUVMatrix, &               ! (in)
!!$      & xyaa_SurfTempMatrix = xyaa_SurfTempMatrix, &       ! (in)
!!$      & xyaa_SurfQVapMatrix = xyaa_SurfQVapMatrix, &       ! (in)
!!$      & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &    ! (inout)
!!$      & xyr_TempFlux = xyr_TempFlux, &                     ! (inout)
!!$      & xyr_QVapFlux = xyr_QVapFlux )                      ! (inout)

    !-----------------------------------------------------------------
    !  ͤˤ벹ѲΨ
    !  Temperature tendency with radiation
    !-----------------------------------------------------------------

    !-----------------------------------
    !  ɽ̵κƷ׻
    !  Recalculate surface pressure
    do k = 0, kmax
      xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k) &
        &     + (xyz_DVerdiffSurfTempDt(:,:) * xyra_DelRadLFlux(:,:,k,0)   &
        &        + xyz_DVerdiffTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
        &      * 2.0_DP * DelTime
    end do

    !-----------------------------------
    !  ѴΨη׻
    !  Calculate temperature tendency
    call Create( phy_radflx = phy_ape % phy_radflx, & ! (inout)
      & xyr_RadLFlux = xyr_RadLFlux, &                ! (in)
      & xyr_RadSFlux = xyr_RadSFlux, &                ! (in)
      & xyr_Press = xyr_Press, &                      ! (in)
      & xyz_DRadLTempDt = xyz_DRadLTempDt, &          ! (out)
      & xyz_DRadSTempDt = xyz_DRadSTempDt )           ! (out)

    !-----------------------------------------------------------------
    !  Ѳʬ­
    !  Add temperature tendency
    !-----------------------------------------------------------------
    xyz_Temp = xyz_Temp &
      & + ( xyz_DRadLTempDt + xyz_DRadSTempDt ) * 2.0_DP * DelTime

    xyz_Temp = xyz_Temp &
      & + ( xyz_DVerdiffTempDt ) * 2.0_DP * DelTime

    xyz_QVap = xyz_QVap &
      & + ( xyz_DVerdiffQVapDt ) * 2.0_DP * DelTime

    xyz_U = xyz_U &
      & + ( xyz_DVerdiffUDt ) * 2.0_DP * DelTime

    xyz_V = xyz_V &
      & + ( xyz_DVerdiffVDt ) * 2.0_DP * DelTime

!!$    !  ̤Ƴ. (⥸塼벽Ƥʤ??)
!!$    call physics_integrate_surftemp( & 
!!$      &  xy_SurfTemp, xyr_RadLFlux, xyra_DelRadLFlux, & !(inout)
!!$      &  xyz_DVerdiffSurfTempDt, DelTime & !(in)
!!$      &  )

    !-----------------------------------------------------------------
    !  ٤Ⱦ $ \sigma $ ٥, ȥݥƥ󥷥λ (3)
    !  Interpolate temperature on half $ \sigma $ level, and
    !  calculate pressure and geo-potential (3)
    !-----------------------------------------------------------------

    !-----------------------------------
    !  ɽ̵κƷ׻
    !  Recalculate surface pressure
    do k = 0, kmax - 1
      xy_Ps = xy_Ps &
        & +  xyz_DVerdiffQVapDt(:,:,k)  &
        &   * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
        &   * 2.0_DP * DelTime
    end do

    !-----------------------------------
    !  ٤Ⱦ $ \sigma $ ٥
    !  Interpolate temperature on half $ \sigma $ level
    call InterpolateTemp( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xyz_Temp   = xyz_Temp, &                                ! (in)
      & xyr_Temp   = xyr_Temp )                                 ! (out)

    !-----------------------------------
    !  ȥݥƥ󥷥λ
    !  Calculate pressure and geo-potential
    call InterpolateGeoPot( phy_intpol = phy_ape % phy_intpol, &  ! (inout)
      & xy_Ps      = xy_Ps, &                                     ! (in)
      & xyz_Temp   = xyz_Temp,   xyr_Temp   = xyr_Temp, &         ! (in)
      & xyz_Press  = xyz_Press,  xyr_Press  = xyr_Press, &        ! (out)
      & xyz_GeoPot = xyz_GeoPot, xyr_GeoPot = xyr_GeoPot )        ! (out)

    !-----------------------------------------------------------------
    !  ήĴ
    !  Dry convective adjustment
    !-----------------------------------------------------------------
    call DryConvectAdjust( phy_dry = phy_ape % phy_dry, & ! (inout)
      & xyz_Press = xyz_Press, xyr_Press = xyr_Press,     ! (in)
      & xyz_Temp = xyz_Temp, &                            ! (inout)
      & xyz_DDryTempDt = xyz_DDryTempDt )                 ! (out)

    !-----------------------------------------------------------------
    !  ο (3)
    !  Remove negative moisture (3)
    !-----------------------------------------------------------------
    xyz_DNegQVap2Dt = 0.0_DP
    call RemoveNegQVap( phy_negq = phy_ape % phy_negq, &        ! (inout)
      & xyr_Press = xyr_Press, &                                ! (in)
      & xyz_QVap = xyz_QVap, xyz_DNegQVapDt = xyz_DNegQVap2Dt ) ! (inout)

    !-----------------------------------
    !  ɽ̵κƷ׻
    !  Recalculate surface pressure
    do k = 0, kmax - 1
       xy_Ps = xy_Ps &
         & + xyz_DNegQVap2Dt(:,:,k) &
         &  * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
         &  * 2.0_DP * DelTime
    end do

    !----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  History data output
    !----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhysApePhysicsAPE

!!$  subroutine PhysApeSample( phy_ape, err )
!!$    !--
!!$    ! PhysApeSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_ape*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhysApeSample
!!$    !++
!!$    ! If *phy_ape* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYAPE), intent(inout):: phy_ape
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhysApeSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_ape % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYAPE'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_ape* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_ape*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_ape % param_i
!!$!!$    param_r = phy_ape % param_r
!!$!!$    param_c = phy_ape % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhysApeSample

end module phy_ape
