!= phy_ape ⥸塼Υƥȥץ
!
!= Test program for "phy_ape"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_ape_test.f90,v 1.2 2007/08/05 18:34:20 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_ape ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_ape" module.
! Confirm compilation and execution of this program.
!

program phy_ape_test
  use phy_ape, only: PHYAPE, Create, Close, &
    & PutLine, initialized
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_ape_test $Name: dcpam4-20070909 $ :: ' // &
    & 'Test program of "phy_ape" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYAPE):: phy_ape00, phy_ape01, phy_ape02, phy_ape03
  logical:: err
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_ape_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_ape = phy_ape00 & ! (inout)
!!$    & , param_i = 256, param_r = 98.7_DP &   ! (in)
    & )
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_ape00) )
  call PutLine( phy_ape = phy_ape00 ) ! (in)

  call Create( phy_ape = phy_ape00, & ! (inout)
!!$    & param_i = 256, param_r = 98.7_DP, &     ! (in)
    & err = err )                             ! (out)
  call AssertEqual( 'initialization test 2', &
    & answer = .true., check = err )
  call PutLine( phy_ape = phy_ape00 ) ! (in)

  call Create( phy_ape = phy_ape01, & ! (inout)
!!$    & param_i = 256, param_r = 98.7_DP, &     ! (in)
    & nmlfile = VAL_namelist )                ! (in)
  call AssertEqual( 'initialization test 3 (NAMELIST)', &
    & answer = .true., check = initialized(phy_ape01) )
  call PutLine( phy_ape = phy_ape01 ) ! (in)

!!$  call Create( phy_ape = phy_ape02, &             ! (inout)
!!$    & param_i = -32, param_r = 0.5_DP, param_c = 'foo', & ! (in)
!!$    & err = err )                                         ! (out)
!!$  call AssertEqual( 'initialization test 4', &
!!$    & answer = .true., check = err )

!!$  call Create( phy_ape = phy_ape02, & ! (inout)
!!$    & param_i = 256, &                        ! (in)
!!$    & err = err )                             ! (out)
!!$  call AssertEqual( 'initialization test 5', &
!!$    & answer = .true., check = err )

!!$  call Create( phy_ape = phy_ape03, &             ! (inout)
!!$    & param_i = -32, param_r = 0.5_DP, param_c = 'foo', & ! (in)
!!$    & nmlfile = VAL_namelist )                            ! (in)
!!$  call AssertEqual( 'initialization test 6 (NAMELIST)', &
!!$    & answer = .true., check = initialized(phy_ape03) )
!!$  call PutLine( phy_ape = phy_ape03 ) ! (in)

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_ape = phy_ape00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_ape00) )
  call PutLine( phy_ape = phy_ape00 ) ! (in)

  call Close( phy_ape = phy_ape02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program phy_ape_test
