!= phy_ape_test  QVap ǡץ
!
!= QVap data generation program for "phy_ape_test"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: phy_ape_test_prep_qvap01.f90,v 1.1 2007/09/26 03:21:35 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_ape_test ǻѤ netCDF ե볫ȯ
! ץǤ. 
!
! This is a program for developers that generates 
! netCDF data for "phy_ape_test"
!

program phy_ape_test_prep_qvap01
  use intavr_operate, only: INTAVROPR, Create, Close, &
    & PutLine, initialized, AvrLonLat_xy
  use spline_data, only: SPLDAT, Create, Close, &
    & PutLine, initialized, GetSpline
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: GT_HISTORY, &
    & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
    & HistoryAddAttr, HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_ape_test_prepnc00 $Name: dcpam4-20071012 $ :: ' // &
    & 'NetCDF file generation program for "phy_ape_test"'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: imax = 64         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 32         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer:: kmax = 20         ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants
  !-----------------------------------------------------------------
  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
  real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP), allocatable:: x_Lon (:) ! . Longitude
  real(DP), allocatable:: x_Lon_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in longitude
  real(DP), allocatable:: y_Lat (:) ! . Latitude
  real(DP), allocatable:: y_Lat_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in latitude
  real(DP), allocatable:: z_Sigma (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP), allocatable:: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
!!$  real(DP), allocatable:: xyr_Press (:,:,:)
!!$                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
!!$                              ! Surface pressure (half level)
  real(DP), allocatable:: xyz_QVap (:,:,:)
                              ! $ q (t-\Delta t) $ .     漾. Specific humidity

  real(DP):: QVapMax
                              ! 漾κ
                              ! Maximum value of specific humidity
  real(DP), allocatable:: x_QVapCoeff (:)
                              ! 漾η
                              ! Specific humidity coefficient
  real(DP), allocatable:: y_QVapCoeff (:)
                              ! 漾η
                              ! Specific humidity coefficient
  real(DP), allocatable:: z_QVapCoeff (:)
                              ! 漾η
                              ! Specific humidity coefficient

  real(DP):: QVapAvrLonLatSig
                              ! 漾ʿ. 
                              ! Global mean specific humidity

  !---------------------------------------------------------
  !  ǡ
  !  Data I/O
  !---------------------------------------------------------
  type(GT_HISTORY):: gthist
  character(STRING):: default_output_file = 'phy_ape_test01_qvap.nc'
  character(STRING):: output_file

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_output        ! -o, --output ץ̵ͭ. 
                              ! Existence of '-o', '--output' option
  character(STRING):: VAL_output
                              ! -o, --output ץ. 
                              ! Value of '-o', '--output' option

  integer:: i, j, k         ! DO 롼Ѻѿ
                            ! Work variables for DO loop


  type(CONST):: const_earth
  type(INTAVROPR):: intavr_opr
  type(SPLDAT):: spl_dat_qvapx, spl_dat_qvapy, spl_dat_qvapz
  real(DP):: PI  ! $ \pi $ .    ߼Ψ.         Circular constant
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_ape_test_prepnc00 [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-o', '--output'), &
    & OPT_output, VAL_output, &
    & help = 'Output filename (default: ' // trim(default_output_file) // ' )' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  if ( VAL_output == '' ) then
    output_file = default_output_file
  else
    output_file = VAL_output
  end if

  !---------------------------------------------------------
  !  ʪ
  !  Configure a physical constant
  !---------------------------------------------------------
  call Create( constant = const_earth )   ! (inout)
  call Get( constant = const_earth, &     ! (inout)
    & PI = PI, RAir = RAir, Grav = Grav ) ! (out)

  !---------------------------------------------------------
  !  ǡ
  !  Configure axes data
  !---------------------------------------------------------
  allocate( x_Lon (0:imax-1) )
  allocate( x_Lon_Weight (0:imax-1) )
  allocate( y_Lat (0:jmax-1) )
  allocate( y_Lat_Weight (0:jmax-1) )
  allocate( z_Sigma (0:kmax-1) )
  allocate( r_Sigma (0:kmax) )

  x_Lon = &
    & (/ 0, 5.625, 11.25, 16.875, 22.5, 28.125, 33.75, 39.375, 45, 50.625, &
    &    56.25, 61.875, 67.5, 73.125, 78.75, 84.375, 90, 95.625, 101.25, 106.875, &
    &    112.5, 118.125, 123.75, 129.375, 135, 140.625, 146.25, 151.875, 157.5, &
    &    163.125, 168.75, 174.375, 180, 185.625, 191.25, 196.875, 202.5, 208.125, &
    &    213.75, 219.375, 225, 230.625, 236.25, 241.875, 247.5, 253.125, 258.75, &
    &    264.375, 270, 275.625, 281.25, 286.875, 292.5, 298.125, 303.75, 309.375, &
    &    315, 320.625, 326.25, 331.875, 337.5, 343.125, 348.75, 354.375 /)

  x_Lon_Weight =  0.098174770424681

  y_Lat = &
    & (/ -85.76059, -80.26878, -74.74454, -69.21297, -63.67863, &
    &    -58.14296, -52.60653, -47.06964, -41.53246, -35.99508, &
    &    -30.45755, -24.91993, -19.38223, -13.84448, -8.306703, &
    &     -2.768903, 2.768903, 8.306703, 13.84448, 19.38223, &
    &     24.91993, 30.45755, 35.99508, 41.53246, 47.06964, &
    &     52.60653, 58.14296, 63.67863, 69.21297, 74.74454, &
    &     80.26878, 85.76059 /)

  y_Lat_Weight = &
    & (/ 0.00701861000947014, 0.0162743947309057, 0.0253920653092621, &
    &    0.0342738629130214, 0.0428358980222267, 0.0509980592623761, &
    &    0.0586840934785356, 0.0658222227763619, 0.0723457941088486, &
    &    0.0781938957870704, 0.0833119242269467, 0.0876520930044037, &
    &    0.0911738786957639, 0.0938443990808046, 0.0956387200792749, &
    &    0.0965400885147279, 0.0965400885147279, 0.0956387200792749, &
    &    0.0938443990808046, 0.0911738786957639, 0.0876520930044037, &
    &    0.0833119242269467, 0.0781938957870704, 0.0723457941088486, &
    &    0.0658222227763619, 0.0586840934785356, 0.0509980592623761, &
    &    0.0428358980222267, 0.0342738629130214, 0.0253920653092621, &
    &    0.0162743947309057, 0.00701861000947014 /)

  z_Sigma = &
    & (/ 0.9749237, 0.9249195, 0.8749149, 0.8249098, 0.774904, 0.7248973, &
    &    0.6748897, 0.6248809, 0.5748705, 0.5248582, 0.4748433, 0.4248248, &
    &    0.3748014, 0.3247708, 0.274729, 0.2246685, 0.1745732, 0.1244002, &
    &    0.07398598, 0.02074752 /)

  r_Sigma = &
    & (/ 1, 0.95, 0.9, 0.85, 0.8, 0.75, 0.7, 0.65, 0.6, 0.55, 0.5, &
    &    0.45, 0.4, 0.35, 0.3, 0.25, 0.2, 0.15, 0.1, 0.05, 0 /)


  !---------------------------------------------------------
  !  漾
  !  Configure specific humidity
  !---------------------------------------------------------
  QVapMax = 2.0e-5_DP
  allocate( xyz_QVap(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( x_QVapCoeff (0:imax-1) )
  allocate( y_QVapCoeff (0:jmax-1) )
  allocate( z_QVapCoeff (0:kmax-1) )

  call Create( spl_dat = spl_dat_qvapx, & ! (inout)
    & knots_num = 8, &
    & x_knots = &
    &   (/  0.0_DP,   45.0_DP,  90.0_DP,  135.0_DP, &
    &     180.0_DP,  225.0_DP, 270.0_DP, 315.0_DP /), &   ! (in)
    & x_value = &
    &   (/  0.5_DP,  0.8_DP, 1.0_DP, 0.8_DP, &
    &       0.5_DP -0.01_DP, 0.3_DP, -0.01_DP/) ) ! (in)
  call GetSpline( spl_dat = spl_dat_qvapx, &
    & a_Dim = x_Lon, &       ! (in)
    & a_Data = x_QVapCoeff ) ! (out)
  call PutLine(x_QVapCoeff, indent=' x_QVapCoeff=')

  call Create( spl_dat = spl_dat_qvapy, & ! (inout)
    & knots_num = 13, &
    & x_knots = &
    &   (/ -90.0_DP, -75.0_DP, -60.0_DP, -45.0_DP, -30.0_DP, -15.0_DP, &
    &        0.0_DP,  15.0_DP,  30.0_DP,  45.0_DP,  60.0_DP,  75.0_DP, &
    &       90.0_DP /), &             ! (in)
    & x_value = &
    &   (/  0.05_DP, 0.1_DP, 0.2_DP, 0.4_DP, 0.7_DP, 0.9_DP, &
    &       1.0_DP,  0.9_DP, 0.7_DP, 0.4_DP, 0.2_DP, 0.1_DP, &
    &       0.05_DP /) )   ! (in)
  call GetSpline( spl_dat = spl_dat_qvapy, &
    & a_Dim = y_Lat, &       ! (in)
    & a_Data = y_QVapCoeff ) ! (out)
  call PutLine(y_QVapCoeff, indent=' y_QVapCoeff=')

  call Create( spl_dat = spl_dat_qvapz, & ! (inout)
    & knots_num = 3, &
    & x_knots = &
    &   (/  1.0_DP, 0.5_DP, 0.0_DP /), &   ! (in)
    & x_value = &
    &   (/  1.0_DP, 0.5_DP, 0.0_DP /) )  ! (in)

  call GetSpline( spl_dat = spl_dat_qvapz , &
    & a_Dim = z_Sigma, &      ! (in)
    & a_Data = z_QVapCoeff )  ! (out)

  call PutLine(z_QVapCoeff, indent=' z_QVapCoeff=')

  do k = 0, kmax - 1
    do j = 0, jmax - 1
      do i = 0, imax - 1
        xyz_QVap(i,j,k) = &
          & QVapMax * x_QVapCoeff(i) * y_QVapCoeff(j) * z_QVapCoeff(k)
      end do
    end do
  end do
  call PutLine(xyz_QVap, indent=' xyz_QVap=')

  call Create( intavr_opr = intavr_opr, & ! (inout)
    & imax = imax, jmax = jmax, &         ! (in)
    & PI = PI )                           ! (in)
  QVapAvrLonLatSig = 0.0_DP
  do k = 0, kmax-1
    QVapAvrLonLatSig = &
      &   QVapAvrLonLatSig  &
      & + AvrLonLat_xy( xyz_QVap(:,:,k), intavr_opr )
  end do

  !----------------------------------------------------------------
  !  ǡ
  !  Output data
  !----------------------------------------------------------------
  call HistoryCreate( &
    & history = gthist, &                            ! (out)
    & file = output_file, &                          ! (in)
    & title = title, &                               ! (in)
    & source = source, institution = institution, &  ! (in)
    & dims = StoA('lon', 'lat', 'sig', 'sigm'), &        ! (in)
    & dimsizes = (/imax, jmax, kmax, kmax + 1/), &       ! (in)
    & longnames = &
    &  StoA('longitude', 'latitude', &
    &       'sigma at layer midpoints', &
    &       'sigma at layer end-points (half level)'), & ! (in)
    & units = StoA('degree_east', 'degree_north', &
    &              '1', '1') )                           ! (out)

  call HistoryPut( &
    & history = gthist, &               ! (out)
    & varname = 'lon', array = x_Lon )  ! (in)
  call HistoryPut( &
    & history = gthist, &               ! (out)
    & varname = 'lat', array = y_Lat  ) ! (in)
  call HistoryPut( &
    & history = gthist, &                ! (out)
    & varname = 'sig', array = z_Sigma ) ! (in)
  call HistoryPut( &
    & history = gthist, &                 ! (out)
    & varname = 'sigm', array = r_Sigma ) ! (in)

  call HistoryAddAttr( &
    & history = gthist, &                    ! (inout)
    & varname = 'lon', attrname = 'standard_name', & ! (in)
    & value = 'longitude' )                          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                    ! (inout)
    & varname = 'lat', attrname = 'standard_name', & ! (in)
    & value = 'latitude' )                           ! (in)

  call HistoryAddAttr( &
    & history = gthist, &                              ! (inout)
    & varname = 'sig', attrname = 'standard_name', &   ! (in)
    & value = 'atmosphere_sigma_coordinate' )          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                              ! (inout)
    & varname = 'sigm', attrname = 'standard_name', &  ! (in)
    & value = 'atmosphere_sigma_coordinate' )          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                         ! (inout)
    & varname = 'sig', attrname = 'positive', &   ! (in)
    & value = 'down' )                            ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                         ! (inout)
    & varname = 'sigm', attrname = 'positive', &  ! (in)
    & value = 'down' )                            ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                                 ! (inout)
    & varname = 'lon_weight', &                           ! (in)
    & dims = StoA('lon'), &                               ! (in)
    & longname = 'weight for integration in longitude', & ! (in)
    & units = 'radian', xtype = 'double' )                ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                             ! (inout)
    & varname = 'lon', attrname = 'gt_calc_weight', & ! (in)
    & value = 'lon_weight' )                          ! (in)
  call HistoryPut( &
    & history = gthist, &                            ! (inout)
    & varname = 'lon_weight', array = x_Lon_Weight ) ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                                ! (inout)
    & varname = 'lat_weight', &                          ! (in)
    & dims = StoA('lat'), &                              ! (in)
    & longname = 'weight for integration in latitude', & ! (in)
    & units = 'radian', xtype = 'double' )               ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                             ! (inout)
    & varname = 'lat', attrname = 'gt_calc_weight', & ! (in)
    & value = 'lat_weight' )                          ! (in)
  call HistoryPut( &
    & history = gthist, &                            ! (inout)
    & varname = 'lat_weight', array = y_Lat_Weight ) ! (in)

!!$  call HistoryAddVariable( &
!!$    & history = gthist, &                   ! (inout)
!!$    & varname = 'PressM', &                 ! (in)
!!$    & dims = StoA('lon', 'lat', 'sigm'), &  ! (in)
!!$    & longname = 'air pressure', &          ! (in)
!!$    & units = 'Pa', xtype = 'double' )      ! (in)
!!$  call HistoryAddAttr( &
!!$    & history = gthist, &                               ! (inout)
!!$    & varname = 'PressM', attrname = 'standard_name', & ! (in)
!!$    & value = 'air_pressure' )                          ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                     ! (inout)
!!$    & varname = 'PressM', array = xyr_Press ) ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                           ! (inout)
    & varname = 'QVap', &                           ! (in)
    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
    & longname = 'specific humidity', &             ! (in)
    & units = '1', xtype = 'double' )               ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                             ! (inout)
    & varname = 'QVap', attrname = 'standard_name', & ! (in)
    & value = 'specific_humidity' )                   ! (in)
  call HistoryPut( &
    & history = gthist, &                     ! (inout)
    & varname = 'QVap', array = xyz_QVap )    ! (in)

!!$  call HistoryAddVariable( &
!!$    & history = gthist, &                           ! (inout)
!!$    & varname = 'QVapAvrLonLatSig', &               ! (in)
!!$    & dims = StoA(''), &                            ! (in)
!!$    & longname = 'global mean specific humidity', & ! (in)
!!$    & units = '1', xtype = 'double' )               ! (in)
!!$  call HistoryPut( &
!!$    & history = gthist, &                     ! (inout)
!!$    & varname = 'QVapAvrLonLatSig', &         ! (in)
!!$    & array = (/ QVapAvrLonLatSig /) )        ! (in)

  call HistoryClose( history = gthist ) ! (inout)

end program phy_ape_test_prep_qvap01
