!= ήĴ
!
!= Dry convective adjustment
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_dryconv_adjust.f90,v 1.2 2007/10/12 01:01:55 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module phy_dryconv_adjust
  !
  != ήĴ
  !
  != Dry convective adjustment
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ήĴԤޤ. 
  !
  ! Dry convective adjustment is performed. 
  !
  !== Procedures List
  !
  ! Create           :: PHYDRYCONV ѿν
  ! Close            :: PHYDRYCONV ѿνλ
  ! PutLine          :: PHYDRYCONV ѿ˳ǼƤΰ
  ! initialized      :: PHYDRYCONV ѿꤵƤ뤫ݤ
  ! DryConvectAdjust :: ήĴԤ
  ! ------------     :: ------------
  ! Create           :: Constructor of "PHYDRYCONV"
  ! Close            :: Deconstructor of "PHYDRYCONV"
  ! PutLine          :: Print information of "PHYDRYCONV"
  ! initialized      :: Check initialization of "PHYDRYCONV"
  ! DryConvectAdjust :: Dry convective adjustment is performed. 
  !
  !== Usage
  !
  ! Ϥ, PHYDRYCONV ѿ, Create ǽԤޤ.
  ! DryConvectAdjust ѤƴήĴԤäƤ. 
  ! PHYDRYCONV ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYDRYCONV" by "Create".
  ! Dry convective adjustment is performed by "DryConvectAdjust".
  ! In order to terminate "PHYDRYCONV", use "Close".
  !

  use dc_types, only: DP, TOKEN
  implicit none
  private
  public:: PHYDRYCONV, Create, Close, PutLine, initialized, DryConvectAdjust

  type PHYDRYCONV
    !
    ! ޤ, Create  "PHYDRYCONV" ѿꤷƲ.
    ! ꤵ줿 "PHYDRYCONV" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYDRYCONV" variable by "Create" before usage.
    ! If you reuse "PHYDRYCONV" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

  end type PHYDRYCONV

  character(*), parameter:: version = &
    & '$Name: dcpam4-20071012 $' // &
    & '$Id: phy_dryconv_adjust.f90,v 1.2 2007/10/12 01:01:55 morikawa Exp $'

  interface Create
    module procedure PhyDryConvAdjCreate
  end interface

  interface Close
    module procedure PhyDryConvAdjClose
  end interface

  interface PutLine
    module procedure PhyDryConvAdjPutLine
  end interface

  interface initialized
    module procedure PhyDryConvAdjInitialized
  end interface

  interface NmlRead
    module procedure PhyDryConvAdjNmlRead
  end interface

  interface DryConvectAdjust
    module procedure PhyDryConvAdjDryConvectAdjust
  end interface

!!$  interface Sample
!!$    module procedure PhyDryConvAdjSample
!!$  end interface

contains

  subroutine PhyDryConvAdjCreate( phy_dryconv, &
    & imax, jmax, kmax, &
    & RAir, Cp, &
    & DelTime, &
    & nmlfile, err )
    !
    ! PHYDRYCONV ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYDRYCONV ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_dryconv* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_dryconv_adjust_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYDRYCONV".
    ! Initialize *phy_dryconv* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_dryconv* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_dryconv_adjust_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    implicit none
    type(PHYDRYCONV), intent(inout):: phy_dryconv
    integer, intent(in):: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP), intent(in):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_dryconv_adjust_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_dryconv_adjust_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyDryConvAdjCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_dryconv % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYDRYCONV'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (DelTime < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'DelTime'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYDRYCONV" 
    !  Configure the settings for "PHYDRYCONV"
    !-----------------------------------------------------------------
    phy_dryconv % imax    = imax   
    phy_dryconv % jmax    = jmax   
    phy_dryconv % kmax    = kmax   
    phy_dryconv % Cp      = Cp     
    phy_dryconv % RAir    = RAir   
    phy_dryconv % DelTime = DelTime

    !-------------------------
    !  ǥե
    !  Default values
!!$    phy_dryconv % param_r = 0.0_DP
!!$    phy_dryconv % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    phy_dryconv % param_i = param_i
!!$    if ( present(param_r) )  phy_dryconv % param_r = param_r
!!$    if ( present(param_c) )  phy_dryconv % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1 = trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_dryconv % param_i, &   ! (inout)
!!$        & param_r = phy_dryconv % param_r, &   ! (inout)
!!$        & param_c_ = phy_dryconv % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1 = trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( phy_dryconv % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_dryconv % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyDryConvAdjCreate

  subroutine PhyDryConvAdjClose( phy_dryconv, err )
    !
    ! PHYDRYCONV ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_dryconv*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYDRYCONV".
    ! Note that if *phy_dryconv* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYDRYCONV), intent(inout):: phy_dryconv
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyDryConvAdjClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_dryconv % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYDRYCONV'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYDRYCONV" ξõ
    !  Clear the settings for "PHYDRYCONV"
    !-----------------------------------------------------------------


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_dryconv % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyDryConvAdjClose

  subroutine PhyDryConvAdjPutLine( phy_dryconv, unit, indent, err )
    !
    !  *phy_dryconv* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_dryconv*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYDRYCONV), intent(in):: phy_dryconv
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyDryConvAdjPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYDRYCONV" ΰ
    !  Print the settings for "PHYDRYCONV"
    !-----------------------------------------------------------------
    if ( phy_dryconv % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYDRYCONV:: @initialized=%y', &
        & l = (/phy_dryconv % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_dryconv % imax, phy_dryconv % jmax, phy_dryconv % kmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @RAir=%f @Cp=%f', &
        & d = (/ phy_dryconv % RAir, phy_dryconv % Cp /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @DelTime=%f', &
        & d = (/ phy_dryconv % DelTime /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYDRYCONV:: @initialized=%y>', &
        & l = (/phy_dryconv % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyDryConvAdjPutLine

  logical function PhyDryConvAdjInitialized( phy_dryconv ) result(result)
    !
    ! *phy_dryconv* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_dryconv* is initialized, .true. is returned.
    ! If *phy_dryconv* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYDRYCONV), intent(in):: phy_dryconv
  continue
    result = phy_dryconv % initialized
  end function PhyDryConvAdjInitialized

  subroutine PhyDryConvAdjNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_dryconv_adjust_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_dryconv_adjust ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_dryconv_adjust#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "phy_dryconv_adjust" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_dryconv_adjust#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyDryConvAdjNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_dryconv_adjust_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'phy_dryconv_adjust_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_dryconv_adjust_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'phy_dryconv_adjust_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyDryConvAdjNmlRead

  subroutine PhyDryConvAdjDryConvectAdjust( phy_dryconv, &
    & xyz_Press, xyr_Press, &
    & xyz_Temp, &
    & xyz_DDryTempDt, &
    & err )
    !
    ! ήĴԤޤ. 
    !
    ! ʤ, Ϳ줿 *phy_dryconv*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Dry convective adjustment is performed. 
    !
    ! If *phy_dryconv* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYDRYCONV), intent(inout):: phy_dryconv
    real(DP), intent(in):: xyz_Press (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1, 0:phy_dryconv%kmax-1)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
    real(DP), intent(in):: xyr_Press (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1, 0:phy_dryconv%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(inout):: xyz_Temp (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1, 0:phy_dryconv%kmax-1)
                              ! $ T $ .     . Temperature
    real(DP), intent(out):: xyz_DDryTempDt (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1, 0:phy_dryconv%kmax-1)
                              ! ήĴˤ벹ѲΨ. 
                              ! Temperature tendency by dry convective adjustment

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    real(DP):: xyz_TempB (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1, 0:phy_dryconv%kmax-1)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
    logical:: xy_Adjust (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1)
                              ! Ĵᤵ줿ݤ. 
                              ! Whether it was adjusted this time or not?
    logical:: xy_AdjustB (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1)
                              ! Ĵᤵ줿ݤ. 
                              ! Whether it was adjusted last time or not?
    real(DP):: xyz_DPressDz (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1, 0:phy_dryconv%kmax-1)
                              ! $ \DD{p}{z} $
                              ! 
    real(DP):: xyz_DDPressDDPress (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1, 0:phy_dryconv%kmax-1)
                              ! $ \DD{p_{k}}{p_{k-1}} $
                              ! 
    real(DP):: xyz_DPFact (0:phy_dryconv%imax-1, 0:phy_dryconv%jmax-1, 0:phy_dryconv%kmax-1)
                              ! $ (R / C_p)
                              ! \frac{p_{k-1} - p_{k}}{2 p_{k-1/2}} $ . 
                              !
                              ! ե. 
                              ! Factor
    real(DP):: TempSat
                              ! ˰². 
                              ! Saturated temperature
    real(DP):: DelTemp
                              ! Ĵˤ벹٤Ѳ. 
                              ! Temperature variation by adjustment
    logical:: Adjust
                              ! ΰˤư٤ǤĴᤵ줿ݤ?. 
                              ! Whether it was adjusted even once in global 
                              ! this time or not?


    integer, parameter :: IterationMax = 10
                              ! ƥ졼. 
                              ! Number of iteration
    
    real(DP):: TempSatMax(IterationMax)
                              ! ԰εƸ. 
                              ! Admissible error of unstability

    data TempSatMax  / 0.01  , 0.02  , 0.02  , 0.05  , 0.05  , &
         &             0.10  , 0.10  , 0.20  , 0.20  , 0.40  /


    integer:: i, j, k         ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: Iteration

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyDryConvAdjDryConvectAdjust'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_dryconv % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYDRYCONV'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_dryconv* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_dryconv*
    !-----------------------------------------------------------------
    imax    = phy_dryconv % imax   
    jmax    = phy_dryconv % jmax   
    kmax    = phy_dryconv % kmax   
    Cp      = phy_dryconv % Cp     
    RAir    = phy_dryconv % RAir   
    DelTime = phy_dryconv % DelTime

    !-----------------------------------------------------------------
    !  Ĵ "QVap" ¸
    !  Store "QVap" before adjustment
    !-----------------------------------------------------------------
    xyz_TempB  = xyz_Temp
    
    !-----------------------------------------------------------------
    !  ѿ
    !  Initialize a variable
    !-----------------------------------------------------------------
    xyz_DDryTempDt = 0.0_DP
    
    !-----------------------------------------------------------------
    !  եη׻
    !  Calculate factor
    !-----------------------------------------------------------------
    do k = 0, kmax-1
      xyz_DPressDz(:,:,k) = xyr_Press(:,:,k) - xyr_Press(:,:,k+1)
    end do
    
    do k = 1, kmax-1

      xyz_DDPressDDPress(:,:,k) = xyz_DPressDz(:,:,k) / xyz_DPressDz(:,:,k-1)
      
      xyz_DPFact(:,:,k) = &
        &   RAir / Cp &
        &   * ( xyz_Press(:,:,k-1) - xyz_Press(:,:,k) ) &
        &   / ( xyz_DPressDz(:,:,k-1) + xyz_DPressDz(:,:,k) ) &
        &   / xyr_Press(:,:,k)

    end do
    
    !-----------------------------------------------------------------
    !  Ĵ
    !  Adjustment
    !-----------------------------------------------------------------
    xy_AdjustB = .true.
    
    !-------------------------
    !  ƥ졼
    !  iteration
    do Iteration = 1, IterationMax
      xy_Adjust = .false.
      
      do k = 1, kmax-1
        do i = 0, imax-1
          do j = 0, jmax-1
            if ( xy_AdjustB(i,j) ) then
              
              TempSat = xyz_Temp(i,j,k-1) - xyz_Temp(i,j,k) &
                & - xyz_DPFact(i,j,k) &
                &  * ( xyz_DPressDz(i,j,k-1) * xyz_Temp(i,j,k-1) &
                &     + xyz_DPressDz(i,j,k) * xyz_Temp(i,j,k) )
              
              !-------------------------
              !  ԰Ǥʤ
              !  If it is unstable
              if ( TempSat > TempSatMax(Iteration) ) then
                
                DelTemp = TempSat / ( 1.0_DP + xyz_DDPressDDPress(i,j,k) )
                xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
                xyz_Temp(i,j,k-1) = &
                  &   xyz_Temp(i,j,k-1) &
                  & - DelTemp * xyz_DDPressDDPress(i,j,k)
                
                !-------------------------
                !  Ĵᤷݤ?
                !  Whether it was adjusted or not?
                xy_Adjust(i,j) = .true.
              end if
              
            end if
          end do
        end do
      end do
      
      Adjust = .false.
      do i = 0, imax-1
        do j = 0, jmax-1
          xy_AdjustB(i,j) = xy_Adjust(i,j)
          Adjust          = Adjust .or. xy_Adjust(i,j)
        end do
      end do
      
      if ( .not. Adjust ) exit
      
    end do
    
    !-----------------------------------------------------------------
    !  ѲΨλ
    !  Calculate temperature tendency
    !-----------------------------------------------------------------
    xyz_DDryTempDt = &
      &   xyz_DDryTempDt &
      & + ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
    
    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyDryConvAdjDryConvectAdjust

!!$  subroutine PhyDryConvAdjSample( phy_dryconv, err )
!!$    !--
!!$    ! PhyDryConvAdjSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_dryconv*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyDryConvAdjSample
!!$    !++
!!$    ! If *phy_dryconv* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYDRYCONV), intent(inout):: phy_dryconv
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyDryConvAdjSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_dryconv % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYDRYCONV'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_dryconv* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_dryconv*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_dryconv % param_i
!!$!!$    param_r = phy_dryconv % param_r
!!$!!$    param_c = phy_dryconv % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyDryConvAdjSample

end module phy_dryconv_adjust
