!= ٤Ⱦҥ٥, ȥݥƥ󥷥λ
!
!= Interpolate temperature on half sigma level, and calculate pressure and geo-potential
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_interpolate.f90,v 1.2 2007/10/12 01:01:55 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module phy_interpolate
  !
  != ٤Ⱦҥ٥, ȥݥƥ󥷥λ
  !
  != Interpolate temperature on half sigma level, and calculate pressure and geo-potential
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Υ⥸塼Ǥ, 
  ! ٤Ⱦ $ \sigma $ ٥֤
  ! ȥݥƥ󥷥λФΤΥ֥롼󶡤ޤ.
  !
  ! This module provides subroutines that
  ! interpolate temperature on half $ \sigma $ level, or
  ! calculate pressure and geo-potential. 
  !
  !== Procedures List
  !
  ! Create           :: PHYINTPOL ѿν
  ! Close            :: PHYINTPOL ѿνλ
  ! PutLine          :: PHYINTPOL ѿ˳ǼƤΰ
  ! initialized      :: PHYINTPOL ѿꤵƤ뤫ݤ
  ! InterpolateTemp  :: ٤Ⱦ $ \sigma $ ٥
  ! InterpolateGeoPot:: ȥݥƥ󥷥λ
  ! ---------------  :: ---------------
  ! Create           :: Constructor of "PHYINTPOL"
  ! Close            :: Deconstructor of "PHYINTPOL"
  ! PutLine          :: Print information of "PHYINTPOL"
  ! initialized      :: Check initialization of "PHYINTPOL"
  ! InterpolateTemp  :: Interpolate temperature on half $ \sigma $ level
  ! InterpolateGeoPot:: Calculate pressure and geo-potential
  !
  !== Usage
  !
  ! Ϥ, PHYINTPOL ѿ, Create ǽԤޤ.
  ! ٤Ⱦ $ \sigma $ ٥֤ˤ InterpolateTemp ,
  ! ȥݥƥ󥷥λФˤ InterpolateGeoPot ѤƤ.
  ! PHYINTPOL ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYINTPOL" by "Create".
  ! Use "InterpolateTemp" in order to 
  ! interpolate temperature on half $ \sigma $ level. 
  ! And use "InterpolateGeoPot" in order to 
  ! calculate pressure and geo-potential.
  ! In order to terminate "PHYINTPOL", use "Close".
  !

  use dc_types, only: DP, TOKEN
  implicit none
  private
  public:: PHYINTPOL, Create, Close, PutLine, initialized
  public:: InterpolateTemp, InterpolateGeoPot

  type PHYINTPOL
    !
    ! ޤ, Create  "PHYINTPOL" ѿꤷƲ.
    ! ꤵ줿 "PHYINTPOL" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYINTPOL" variable by "Create" before usage.
    ! If you reuse "PHYINTPOL" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
!!$    real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), pointer:: z_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), pointer:: r_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP), pointer:: z_DelSigma (:) =>null()
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
    real(DP), pointer:: r_DelSigma (:) =>null()
                              ! $ \Delta \sigma $ (Ⱦ). 
                              ! $ \Delta \sigma $ (Half)
    real(DP), pointer:: z_TempInpolM (:) =>null()
                              ! Ѥη. 
                              ! Coefficient for interpolation
    real(DP), pointer:: z_TempInpol (:) =>null()
                              ! Ѥη. 
                              ! Coefficient for interpolation
  end type PHYINTPOL

  character(*), parameter:: version = &
    & '$Name: dcpam4-20071012 $' // &
    & '$Id: phy_interpolate.f90,v 1.2 2007/10/12 01:01:55 morikawa Exp $'

  interface Create
    module procedure PhyIntpolCreate
  end interface

  interface Close
    module procedure PhyIntpolClose
  end interface

  interface PutLine
    module procedure PhyIntpolPutLine
  end interface

  interface initialized
    module procedure PhyIntpolInitialized
  end interface

  interface NmlRead
    module procedure PhyIntpolNmlRead
  end interface

  interface InterpolateTemp
    module procedure PhyIntpolInterpolateTemp
  end interface

  interface InterpolateGeoPot
    module procedure PhyIntpolInterpolateGeoPot
  end interface

!!$  interface Sample
!!$    module procedure PhyIntpolSample
!!$  end interface

contains

  subroutine PhyIntpolCreate( phy_intpol, &
    & imax, jmax, kmax, &
    & z_Sigma, r_Sigma, &
!!$    & Cp, &
    & RAir, Grav, &
    & nmlfile, err )
    !
    ! PHYINTPOL ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYINTPOL ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_intpol* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_interpolate_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYINTPOL".
    ! Initialize *phy_intpol* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_intpol* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_interpolate_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    implicit none
    type(PHYINTPOL), intent(inout):: phy_intpol
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), intent(in):: r_Sigma (0:kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
!!$    real(DP), intent(in):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_interpolate_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_interpolate_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyIntpolCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_intpol % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYINTPOL'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    phy_intpol % imax = imax
    phy_intpol % jmax = jmax
    phy_intpol % kmax = kmax

    !-----------------------------------------------------------------
    !  ʪ
    !  Configure physical constants
    !-----------------------------------------------------------------
!!$    phy_intpol % Cp = Cp
    phy_intpol % RAir = RAir
    phy_intpol % Grav = Grav

    !-----------------------------------------------------------------
    !  ľʻ
    !  Configure values of vertical grid point
    !-----------------------------------------------------------------
    allocate( phy_intpol % z_Sigma(0:kmax-1) )
    allocate( phy_intpol % r_Sigma(0:kmax) )
    allocate( phy_intpol % z_DelSigma(0:kmax-1) )
    allocate( phy_intpol % r_DelSigma(0:kmax) )

    phy_intpol % r_Sigma = r_Sigma
    phy_intpol % z_Sigma = z_Sigma

    do k = 0, kmax - 1
      phy_intpol % z_DelSigma(k) = r_Sigma(k) - r_Sigma(k+1)
    end do

    do k = 1, kmax - 1
      phy_intpol % r_DelSigma(k) = z_Sigma(k-1) - z_Sigma(k)
    end do
    phy_intpol % r_DelSigma(0)    = r_Sigma(0)      - z_Sigma(0)
    phy_intpol % r_DelSigma(kmax) = z_Sigma(kmax-1) - r_Sigma(kmax)

    !-----------------------------------------------------------------
    !  Ѥηη׻
    !  Calculate coefficient for interpolation
    !-----------------------------------------------------------------
    allocate( phy_intpol % z_TempInpolM(0:kmax-1) )
    allocate( phy_intpol % z_TempInpol(0:kmax-1) )

    phy_intpol % z_TempInpolM = 0.0_DP
    phy_intpol % z_TempInpol = 0.0_DP

    do k = 1, kmax - 1
      phy_intpol % z_TempInpolM(k) = &
        &   ( log( r_Sigma( k ) ) - log( z_Sigma( k ) ) )   &
        &     / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k ) ) )
      phy_intpol % z_TempInpol(k) = &
        &   ( log( z_Sigma( k-1 ) ) - log( r_Sigma( k ) ) )   &
        &     / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k ) ) )
    end  do

    !-----------------------------------------------------------------
    !  "PHYINTPOL" 
    !  Configure the settings for "PHYINTPOL"
    !-----------------------------------------------------------------

    !-------------------------
    !  ǥե
    !  Default values
!!$    phy_intpol % param_r = 0.0_DP
!!$    phy_intpol % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    phy_intpol % param_i = param_i
!!$    if ( present(param_r) )  phy_intpol % param_r = param_r
!!$    if ( present(param_c) )  phy_intpol % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1=trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_intpol % param_i, &   ! (inout)
!!$        & param_r = phy_intpol % param_r, &   ! (inout)
!!$        & param_c_ = phy_intpol % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1=trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( phy_intpol % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_intpol % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyIntpolCreate

  subroutine PhyIntpolClose( phy_intpol, err )
    !
    ! PHYINTPOL ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_intpol*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYINTPOL".
    ! Note that if *phy_intpol* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYINTPOL), intent(inout):: phy_intpol
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyIntpolClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_intpol % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYINTPOL'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYINTPOL" ξõ
    !  Clear the settings for "PHYINTPOL"
    !-----------------------------------------------------------------
    deallocate( phy_intpol % z_Sigma )
    deallocate( phy_intpol % r_Sigma )
    deallocate( phy_intpol % z_DelSigma )
    deallocate( phy_intpol % r_DelSigma )
    deallocate( phy_intpol % z_TempInpolM )
    deallocate( phy_intpol % z_TempInpol )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_intpol % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyIntpolClose

  subroutine PhyIntpolPutLine( phy_intpol, unit, indent, err )
    !
    !  *phy_intpol* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_intpol*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYINTPOL), intent(in):: phy_intpol
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyIntpolPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYINTPOL" ΰ
    !  Print the settings for "PHYINTPOL"
    !-----------------------------------------------------------------
    if ( phy_intpol % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYINTPOL:: @initialized=%y', &
        & l = (/phy_intpol % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_intpol % imax, phy_intpol % jmax, phy_intpol % kmax/) )

!!$      call Printf( out_unit, &
!!$        & indent_str(1:indent_len) // &
!!$        & ' @Cp=%f', &
!!$        & d = (/phy_intpol % Cp/) )
!!$
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @RAir=%f @Grav=%f', &
        & d = (/phy_intpol % RAir, phy_intpol % Grav/) )

      call PutLine( phy_intpol % z_Sigma, unit = out_unit, &
        & lbounds = lbound(phy_intpol % z_Sigma), &
        & ubounds = ubound(phy_intpol % z_Sigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @z_Sigma=' )

      call PutLine( phy_intpol % r_Sigma, unit = out_unit, &
        & lbounds = lbound(phy_intpol % r_Sigma), &
        & ubounds = ubound(phy_intpol % r_Sigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @r_Sigma=' )

      call PutLine( phy_intpol % z_DelSigma, unit = out_unit, &
        & lbounds = lbound(phy_intpol % z_DelSigma), &
        & ubounds = ubound(phy_intpol % z_DelSigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @z_DelSigma=' )

      call PutLine( phy_intpol % r_DelSigma, unit = out_unit, &
        & lbounds = lbound(phy_intpol % r_DelSigma), &
        & ubounds = ubound(phy_intpol % r_DelSigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @r_DelSigma=' )

      call PutLine( phy_intpol % z_TempInpolM, unit = out_unit, &
        & lbounds = lbound(phy_intpol % z_TempInpolM), &
        & ubounds = ubound(phy_intpol % z_TempInpolM), &
        & indent = indent_str(1:indent_len) // &
        & ' @z_TempInpolM=' )

      call PutLine( phy_intpol % z_TempInpol, unit = out_unit, &
        & lbounds = lbound(phy_intpol % z_TempInpol), &
        & ubounds = ubound(phy_intpol % z_TempInpol), &
        & indent = indent_str(1:indent_len) // &
        & ' @z_TempInpol=' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYINTPOL:: @initialized=%y>', &
        & l = (/phy_intpol % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyIntpolPutLine

  logical function PhyIntpolInitialized( phy_intpol ) result(result)
    !
    ! *phy_intpol* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_intpol* is initialized, .true. is returned.
    ! If *phy_intpol* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYINTPOL), intent(in):: phy_intpol
  continue
    result = phy_intpol % initialized
  end function PhyIntpolInitialized

  subroutine PhyIntpolNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_interpolate_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_interpolate ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_interpolate#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "phy_interpolate" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_interpolate#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyIntpolNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_interpolate_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1='phy_interpolate_nml', c2=trim(nmlfile) )
!!$      write(STDOUT, nml = phy_interpolate_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1='phy_interpolate_nml', c2=trim(nmlfile), &
!!$        & i=(/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyIntpolNmlRead

  subroutine PhyIntpolInterpolateTemp( phy_intpol, &
    & xyz_Temp, &
    & xyr_Temp, &
    & err )
    !
    !  ( $ \sigma $ ٥) *xyz_Temp* 
    !  (Ⱦ $ \sigma $ ٥) *xyr_Temp* 򻻽Фޤ.
    !
    ! ʤ, Ϳ줿 *phy_intpol*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate *xyr_Temp* that is temperature on half $ \sigma $ level 
    ! from *xyz_Temp* that is temperature on full $ \sigma $ level 
    ! 
    ! If *phy_intpol* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYINTPOL), intent(inout):: phy_intpol
    real(DP), intent(in):: xyz_Temp (0:phy_intpol%imax-1, 0:phy_intpol%jmax-1, 0:phy_intpol%kmax-1)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(out):: xyr_Temp (0:phy_intpol%imax-1, 0:phy_intpol%jmax-1, 0:phy_intpol%kmax)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: z_TempInpolM  (0:phy_intpol%kmax-1)
                              ! Ѥη. 
                              ! Coefficient for interpolation
    real(DP):: z_TempInpol (0:phy_intpol%kmax-1)
                              ! Ѥη. 
                              ! Coefficient for interpolation

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyIntpolInterpolateTemp'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_intpol % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYINTPOL'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_intpol* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_intpol*
    !-----------------------------------------------------------------
    kmax = phy_intpol % kmax
    z_TempInpolM = phy_intpol % z_TempInpolM
    z_TempInpol  = phy_intpol % z_TempInpol

    !-----------------------------------------------------------------
    !  ٤
    !  Interpolate temperature
    !-----------------------------------------------------------------
    do k = 1, kmax - 1
      xyr_Temp(:,:,k) =   z_TempInpolM(k) * xyz_Temp(:,:,k-1)  &
        &               + z_TempInpol(k) * xyz_Temp(:,:,k)
    end do

    xyr_Temp(:,:,kmax) = xyz_Temp(:,:,kmax-1)
    xyr_Temp(:,:,0)    = xyz_Temp(:,:,0)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyIntpolInterpolateTemp

  subroutine PhyIntpolInterpolateGeoPot( phy_intpol, &
    & xy_Ps, &
    & xyz_Temp,   xyr_Temp, &
    & xyz_Press,  xyr_Press, &
    & xyz_GeoPot, xyr_GeoPot, &
    & err )
    !
    ! ɽ̵ *xy_Ps*, Ȳ *xyz_Temp*, *xyr_Temp* , 
    !  *xyz_Press*, *xyzr_Press* 
    ! ݥƥ󥷥 *xyz_GeoPot*, *xyzr_GeoPot* 򻻽Фޤ.
    !
    ! ʤ, Ϳ줿 *phy_intpol*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate pressure *xyz_Press*, *xyzr_Press* and
    ! geo-potential *xyz_GeoPot*, *xyzr_GeoPot* from
    ! surface pressure *xy_Ps*, and temperature *xyz_Temp*, *xyr_Temp*.
    ! 
    ! If *phy_intpol* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYINTPOL), intent(inout):: phy_intpol
    real(DP), intent(in):: xy_Ps (0:phy_intpol%imax-1, 0:phy_intpol%jmax-1)
                              ! $ P_s $ .   ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_Temp (0:phy_intpol%imax-1, 0:phy_intpol%jmax-1, 0:phy_intpol%kmax-1)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(in):: xyr_Temp (0:phy_intpol%imax-1, 0:phy_intpol%jmax-1, 0:phy_intpol%kmax)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP), intent(out):: xyz_Press (0:phy_intpol%imax-1, 0:phy_intpol%jmax-1, 0:phy_intpol%kmax-1)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
    real(DP), intent(out):: xyr_Press (0:phy_intpol%imax-1, 0:phy_intpol%jmax-1, 0:phy_intpol%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xyz_GeoPot (0:phy_intpol%imax-1, 0:phy_intpol%jmax-1, 0:phy_intpol%kmax-1)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
    real(DP), intent(out):: xyr_GeoPot (0:phy_intpol%imax-1, 0:phy_intpol%jmax-1, 0:phy_intpol%kmax)
                              ! $ \phi $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
!!$    real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration

    real(DP):: z_Sigma (0:phy_intpol%kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP):: r_Sigma (0:phy_intpol%kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP):: z_DelSigma (0:phy_intpol%kmax-1)
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
    real(DP):: r_DelSigma (0:phy_intpol%kmax)
                              ! $ \Delta \sigma $ (Ⱦ). 
                              ! $ \Delta \sigma $ (Half)

!!$    real(DP):: z_PhiA(0:phy_intpol%kmax-1)
!!$    real(DP):: z_PhiB(0:phy_intpol%kmax-1)
!!$    real(DP):: z_PhiC(0:phy_intpol%kmax-1)

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyIntpolInterpolateGeoPot'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_intpol % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYINTPOL'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_intpol* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_intpol*
    !-----------------------------------------------------------------
    kmax = phy_intpol % kmax
!!$    Cp = phy_intpol % Cp
    RAir = phy_intpol % RAir
    Grav = phy_intpol % Grav

    z_Sigma = phy_intpol % z_Sigma
    r_Sigma = phy_intpol % r_Sigma
    z_DelSigma = phy_intpol % z_DelSigma
    r_DelSigma = phy_intpol % r_DelSigma

    !----------------------------------------------------------------
    !  η׻
    !  Calculate pressure
    !----------------------------------------------------------------
    do k = 0, kmax - 1
      xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
    end do

    do k = 0, kmax
      xyr_Press(:,:,k) = xy_Ps * r_Sigma(k)
    end do

    !----------------------------------------------------------------
    !  ݥƥ󥷥η׻
    !  Calculate geo-potential
    !----------------------------------------------------------------
    xyz_GeoPot(:,:,0) = &
      &   RAir / Grav * xyz_Temp(:,:,0) &
      &   * ( 1.0_DP - z_Sigma(0) )

    do k = 1, kmax - 1
      xyz_GeoPot(:,:,k) = &
        &   xyz_GeoPot(:,:,k-1) &
        & + RAir / Grav * xyr_Temp(:,:,k)  &
        &   * r_DelSigma(k) / r_Sigma(k)
    end do

    xyr_GeoPot = 0.0_DP
    do k = 1, kmax
      xyr_GeoPot(:,:,k) = &
        &   xyr_GeoPot(:,:,k-1) &
        & + RAir / Grav * xyz_Temp(:,:,k-1)  &
        &   * z_DelSigma(k-1) / z_Sigma(k-1)
    end do

!!$    !-----------------------------------
!!$    !  AFES Ǥλˡ (ͤޤǤ)
!!$    !  Calculation of AFES (for reference)
!!$    do k = 0, kmax - 1
!!$      z_PhiA(k) = ( r_Sigma(k) / z_Sigma(k) )**( RAir / Cp ) - 1.0_DP
!!$      z_PhiB(k) = 1.0_DP - ( r_Sigma(k+1) / z_Sigma(k) )**( RAir / Cp )
!!$      z_PhiC(k) =   ( r_Sigma(k) / z_Sigma(k) )**( RAir / Cp ) &
!!$        &         - ( r_Sigma(k+1) / z_Sigma(k) )**( RAir / Cp )
!!$    end do
!!$    z_PhiB(kmax-1) = 0.0_DP
!!$
!!$    xyz_GeoPot(:,:,0) = Cp / Grav * z_PhiA(0) * xyz_Temp(:,:,0)
!!$    xyr_GeoPot(:,:,0) = 0.0_DP
!!$
!!$    do k = 1, kmax - 1
!!$      xyz_GeoPot(:,:,k) =   &
!!$        &   xyz_GeoPot(:,:,k-1) &
!!$        & + Cp / Grav &
!!$        &    * (   z_PhiA(k) * xyz_Temp(:,:,k) &
!!$        &        + z_PhiB(k-1) * xyz_Temp(:,:,k-1) )
!!$    end do
!!$
!!$    do k = 1, kmax
!!$      xyr_GeoPot(:,:,k) = &
!!$        &   xyr_GeoPot(:,:,k-1) &
!!$        & + Cp / Grav * z_PhiC(k-1) * xyz_Temp(:,:,k-1)
!!$    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyIntpolInterpolateGeoPot

!!$  subroutine PhyIntpolSample( phy_intpol, err )
!!$    !--
!!$    ! PhyIntpolSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_intpol*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyIntpolSample
!!$    !++
!!$    ! If *phy_intpol* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYINTPOL), intent(inout):: phy_intpol
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyIntpolSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_intpol % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYINTPOL'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_intpol* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_intpol*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_intpol % param_i
!!$!!$    param_r = phy_intpol % param_r
!!$!!$    param_c = phy_intpol % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyIntpolSample

end module phy_interpolate
