#!/bin/sh
#
#= Compile and Execute test program of "spline_data"
#
# Authors::   Yasuhiro MORIKAWA
# Version::   $Id: spline_data_test.sh,v 1.1 2007/09/21 13:36:44 morikawa Exp $
# Tag Name::  $Name: dcpam4-20071012 $
# Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
# License::   See COPYRIGHT[link:../../../COPYRIGHT]
#
######################################################################
#
#== Settings

test -n "$TEST_BASE" || TEST_BASE="spline_data"
TEST_OBJ="${TEST_BASE}.f90 ${TEST_BASE}_test.f90"
TEST_EXEC="${TEST_BASE}_test"
TEST_NML00="${TEST_BASE}_test00.nml"

#test -n "$LINKF" || LINKF=gt4frt
test -n "$MAKE" || MAKE=make

# End Settings
######################################################################

set -e

case `echo "testing\c"; echo 1,2,3`,`echo -n testing; echo 1,2,3` in
  *c*,-n*) ECHO_N= ECHO_C='
' ECHO_T='      ' ;;
  *c*,*  ) ECHO_N=-n ECHO_C= ECHO_T= ;;
  *)       ECHO_N= ECHO_C='\c' ECHO_T= ;;
esac

echo ""
echo "****** ${TEST_BASE} Test ******"
echo " in \"`pwd`\""

echo " Compiling and Linking ... "
if [ -n "${LINKF}" ]; then
    echo "   ${LINKF} ${TEST_OBJ} -o ${TEST_EXEC}"
    ${LINKF} ${TEST_OBJ} -o ${TEST_EXEC}
else
    ${MAKE} ${TEST_EXEC}
fi
echo " done . "

if [ ! "$CROSS_COMPILING" = "yes" ] && [ ! "$CROSS_COMPILING" = "maybe" ] ; then
    echo "./${TEST_EXEC} --namelist=${TEST_NML00}"
    ./${TEST_EXEC} --namelist=${TEST_NML00}
else
    echo ""
    echo "   WARNING: Cross compile mode will be used."
    echo "            Submit ./${TEST_EXEC}  ."
    echo ""
    exit 1
fi

echo "  *** Test program \"${TEST_EXEC}\" becomes successful ***"
exit 0
