!= 絬϶ŷ
!
!= Large scale condensation
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: lscond.F90,v 1.4 2009-04-15 22:41:16 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module lscond
  !
  != 絬϶ŷ
  !
  != Large scale condensation
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 絬϶ŷˤäƲ٤漾Ĵᤷޤ. 
  !
  ! ˰漾η׻ˤϥǥեȤǤ
  ! Tetens (1930) Ѥޤ (saturate_t1930 ). 
  ! ޤ, Config.mk  CPPFLAGS  -DLIB_SATURATE_NHA1992 ꤹ
  ! Nakajima et al. (1992) Ѥޤ (saturate_tnha1992 ). 
  !
  ! Adjust temperature and specific humidity by 
  ! a large scale condensation process.
  ! 
  ! By default, Tetens (1930) is used for calculation of 
  ! saturation specific humidity (See "saturate_t1930"). 
  ! If "-DLIB_SATURATE_NHA1992" is specified to "CPPFLAGS" in Config.mk, 
  ! Nakajima et al. (1992) is used (See "saturate_nha1992"). 
  !
  !== Procedures List
  ! 
  ! LScaleCond    :: ٤漾Ĵ
  ! ------------  :: ------------
  ! LScaleCond    :: Adjust temperature and specific humidity
  !
  !== NAMELIST
  !
  ! NAMELIST#lscond_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: LScaleCond

  ! ѿ
  ! Public variables
  !
  logical, save, public:: lscond_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), save:: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
  integer, save:: ItrtMax
                              ! ƥ졼. 
                              ! Number of iteration

  ! Nakajima et al. (1992) Ѥ˰漾η׻Ѥ
  ! Values for calculation of saturation specific humidity with Nakajima et al. (1992) 
  ! 
  real(DP), parameter:: LatHeatNha92 = 43655_DP
                              ! $ l $ [J mol-1].
                              ! ζŷǮ. Latent heat of condensation of water vapor
  real(DP), parameter:: P0Nha92 = 1.4e+11_DP
                              ! $ p_0^{*} $ [Pa].
                              ! ˰¶. constant for water vapor saturation curve

  character(*), parameter:: saturate_scheme = &
#ifdef LIB_SATURATE_NHA1992
    & 'Nakajima et al. (1992)'
#elif LIB_SATURATE_T1930
    & 'Tetens (1930)'
#else
    & 'Tetens (1930)'
#endif

  character(*), parameter:: module_name = 'lscond'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: lscond.F90,v 1.4 2009-04-15 22:41:16 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface LScaleCond
    module procedure LScaleCond
  end interface

contains

  subroutine LScaleCond( &
    & xyz_Temp, xyz_QVap, xy_Rain, &  ! (inout)
    & xyz_DTempDt, xyz_DQVapDt, &     ! (inout)
    & xyz_Press, xyr_Press &          ! (in)
    & )
    !
    ! 絬϶ŷ륹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! Adjust temperature and specific humidity by 
    ! large scale condensation scheme. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRUniv, &
                              ! $ R^{*} $ [J K-1 mol-1]. 
                              ! ׵.  Universal gas constant
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & GasRWet, &
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ŷʬε. 
                              ! Gas constant of condensible elements
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & EpsV
                              ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(inout):: xy_Rain (0:imax-1, 1:jmax)
                              ! ߿. 
                              ! Precipitation
    real(DP), intent(inout):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP), intent(inout):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)

    ! ѿ
    ! Work variables
    !
    real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
                              ! ߿. 
                              ! Precipitation
    real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency

    real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
                              !
    real(DP):: QVapSat
                              ! ˰漾. 
                              ! Saturation specific humidity. 
    real(DP):: DQVapSatDTemp
                              ! $ \DD{q_{\rm{sat}}}{T} $
    real(DP):: DelQVap
                              ! Ĵˤ漾Ѳ. 
                              ! Specific humidity variation by adjustment
    real(DP):: DelTemp
                              ! Ĵˤ벹Ѳ. 
                              ! Temperature variation by adjustment


    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: itr             ! ƥ졼˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in iteration direction

    ! ˰漾׻Τʸؿ (CalcQVapSatSF, CalcDQVapSatDTempSF)
    ! Declaration of statement function for 
    !   calculation of saturation specific humidity 
    !   ("CalcQVapSatSF", "CalcDQVapSatDTempSF")
    !
#ifdef LIB_SATURATE_NHA1992
#include "../saturate/saturate_nha1992_sf.f90"
    EpsVSF     = EpsV
    GasRUnivSF = GasRUniv
#elif LIB_SATURATE_T1930
#include "../saturate/saturate_t1930_sf.f90"
    EpsVSF    = EpsV
    LatHeatSF = LatentHeat
    GasRWetSF = GasRWet
#else
#include "../saturate/saturate_t1930_sf.f90"
    EpsVSF    = EpsV
    LatHeatSF = LatentHeat
    GasRWetSF = GasRWet
#endif

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. lscond_inited ) call LSCondInit

    ! Ĵ "QVap", "Temp" ¸
    ! Store "QVap", "Temp" before adjustment
    !
    xyz_QVapB  = xyz_QVap
    xyz_TempB  = xyz_Temp

    ! Ĵ
    ! Adjustment
    !
    do k = kmax, 1, -1
      do i = 0, imax-1
        do j = 1, jmax
          
          ! ˰漾׻
          ! Calculate saturation specific humidity 
          ! 
          ! CalcQVapSatSF ʸؿ. (¹ʸľ)
          ! "CalcQVapSatSF" is statement function and 
          !   is declared just before executable statement. 
          ! 
          QVapSat = &
            & CalcQVapSatSF( xyz_Temp(i,j,k), xyz_Press(i,j,k) )

          ! ˰¤Ƥ, ٤漾Ѳ׻
          ! Calculate tendency of temperature and humidity 
          ! if moist is saturation. 
          !
          if ( ( xyz_QVap(i,j,k) / QVapSat ) >= CrtlRH ) then
            
            do itr = 1, ItrtMax
              
              ! ˰漾׻
              ! Calculate saturation specific humidity
              ! 
              ! CalcQVapSatSF, CalcDQVapSatDTempSF ʸؿ. (¹ʸľ)
              ! "CalcQVapSatSF", "CalcDQVapSatDTempSF" is statement function and 
              !   is declared just before executable statement. 
              ! 
              QVapSat = &
                & CalcQVapSatSF( xyz_Temp(i,j,k), xyz_Press(i,j,k) )

              DQVapSatDTemp = &
                & CalcDQVapSatDTempSF( xyz_Temp(i,j,k), QVapSat )

              ! ٤漾Ѳʬ˥塼ȥˡǵ
              ! Calculate variation of temperature and specific humidity 
              ! with Newton method
              !
              DelTemp = &
                & LatentHeat / CpDry * ( xyz_QVap(i,j,k) - QVapSat ) &
                &    / ( 1.0_DP + LatentHeat / CpDry * DQVapSatDTemp )
              DelQVap = DQVapSatDTemp * DelTemp 
              
              ! ٤漾Ĵ
              ! Adjust temperature and specific humidity
              !
              xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
              xyz_QVap(i,j,k) = QVapSat + DelQVap
              
            end do
            
          end if
        end do
      end do
    end do
    
    ! 漾ѲΨ, ѲΨ, ߿̤λ
    ! Calculate specific humidity tendency, temperature tendency, 
    ! precipitation
    !
    xy_RainLsc     = 0.
    xyz_DTempDtLsc = 0.
    xyz_DQvapDtLsc = 0.

    xyz_DQVapDtLsc = xyz_DQVapDtLsc & 
      & + ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )

    xyz_DTempDtLsc = xyz_DTempDtLsc &
      & + ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )

    do k = kmax, 1, -1
      xy_RainLsc = xy_RainLsc &
        & + ( xyz_Temp(:,:,k) - xyz_TempB(:,:,k) ) &
        &     * CpDry / ( 2.0_DP * DelTime ) &
        &     * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav &
        &     / LatentHeat
    end do
    
    xy_Rain     = xy_Rain     + xy_RainLsc
    xyz_DTempDt = xyz_DTempDt + xyz_DTempDtLsc
    xyz_DQVapDt = xyz_DQVapDt + xyz_DQVapDtLsc

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc * LatentHeat )
    call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
    call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine LScaleCond

  !-------------------------------------------------------------------

  subroutine LSCondInit
    !
    ! lscond ⥸塼νԤޤ. 
    ! NAMELIST#lscond_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "lscond" module is initialized. 
    ! "NAMELIST#lscond_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /lscond_nml/ &
      & CrtlRH, ItrtMax
          !
          ! ǥեͤˤĤƤϽ³ "lscond#LSCondInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "lscond#LSCondInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( lscond_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    CrtlRH  = 1.0_DP
    ItrtMax = 3

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = lscond_nml, &   ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = lscond_nml )
    end if

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'RainLsc', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'precipitation by large scale condensation', 'W m-2' )
    call HistoryAutoAddVariable( 'DTempDtLsc', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'large-scale condensation heating', 'K s-1' )
    call HistoryAutoAddVariable( 'DQVapDtLsc', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'large-scale condensation moistening', 'kg kg-1 s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  CrtlRH  = %f', d = (/ CrtlRH /) )
    call MessageNotify( 'M', module_name, '  ItrtMax = %d', i = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '' )
    call MessageNotify( 'M', module_name, '  Scheme of saturation = %c', &
      & c1 = saturate_scheme )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    lscond_inited = .true.
  end subroutine LSCondInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module lscond
