!= 
!
!= Time control
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: timeset.f90,v 1.9 2009-03-17 02:41:03 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20090405 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module timeset
  !
  != 
  !
  != Time control
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! δԤޤ. 
  !
  ! Information of time is controlled. 
  !
  !== Variables List
  !
  ! TimeB                         :: ƥå $ t - \Delta t $ λ
  ! TimeN                         :: ƥå $ t $ λ
  ! TimeA                         :: ƥå $ t + \Delta t $ λ
  ! DelTime                       :: $ \Delta t $ [s] (¿ο)
  ! StartTime                     :: ׻ϻ
  ! EndTime                       :: ׻λ
  ! StartDate                     :: ׻
  ! StartDateValid                :: ׻ͭ
  ! ------------                  :: ------------
  ! TimeB                         :: Time of step $ t - \Delta t $
  ! TimeN                         :: Time of step $ t $
  ! TimeA                         :: Time of step $ t + \Delta t $
  ! DelTime                       :: $ \Delta t $ [s] (numerical value of float type)
  ! StartTime                     :: Start time of calculation
  ! EndTime                       :: End time of calculation
  ! StartDate                     :: Start date of calculation
  ! StartDateValid                :: Validation of start date of calculation
  !
  !== Procedures List
  !
  ! TimesetInit           :: timeset ⥸塼ν
  ! TimesetDelTimeHalf    :: t ŪȾʬ
  ! TimesetProgress       :: οʹ
  ! TimesetClockStart     :: ׻ַ¬
  ! TimesetClockStop      :: ׻ַװ
  ! TimesetClose          :: timeset ⥸塼νλ
  ! ------------          :: ------------
  ! TimesetInit           :: Initialize "timeset" module
  ! TimesetDelTimeHalf    :: Reduce delta t to half temporarily
  ! TimesetProgress       :: Progress time
  ! TimesetClockStart     :: Start measurement of computation time
  ! TimesetClockStop      :: Pause measurement of computation time
  ! TimesetClose          :: Terminate "timeset" module
  !
  !== NAMELIST
  !
  ! NAMELIST#timeset_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &  ! ټ¿. Double precision. 
    &                 TOKEN  ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! դӻμ갷
  ! Date and time handler
  !
  use dc_date_types, only: &
    & DC_DIFFTIME, &          ! κɽǡ. 
                              ! Data type for difference about date and time
    & DC_DATETIME             ! ɽǡ. 
                              ! Data type for date and time

  ! CPU ַ¬
  ! CPU time monitor
  !
  use dc_clock, only: CLOCK

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: TimesetInit, TimesetClose, TimesetProgress, TimesetDelTimeHalf
  public:: TimesetClockStart, TimesetClockStop

  ! ѿ
  ! Public variables
  !
  logical, save, public:: timeset_inited = .false.
                              ! ե饰. 
                              ! Initialization flag
  type(DC_DIFFTIME), save, public:: TimeB
                              ! ƥå $ t - \Delta t $ λ. 
                              ! Time of step $ t - \Delta t $. 
  type(DC_DIFFTIME), save, public:: TimeN
                              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
  type(DC_DIFFTIME), save, public:: TimeA
                              ! ƥå $ t + \Delta t $ λ. 
                              ! Time of step $ t + \Delta t $. 
  real(DP), save, public:: DelTime
                              ! $ \Delta t $ [s]
  type(DC_DIFFTIME), save, public:: StartTime
                              ! ׻ϻ. 
                              ! Start time of calculation
  type(DC_DIFFTIME), save, public:: EndTime
                              ! ׻λ. 
                              ! End time of calculation
  type(DC_DATETIME), save, public:: StartDate
                              ! ׻. 
                              ! Start date of calculation
  logical, save, public:: StartDateValid
                              ! ׻ͭ. 
                              ! NAMELIST#timeset_nml  Date ˻꤬
                              ! Ԥ줿ˤ .true. ˤʤޤ. 
                              ! 
                              ! Validation of start date of calculation
                              ! If "Date" of "NAMELIST#timeset_nml" is 
                              ! specified explicitly, 
                              ! this value becomes ".true.". 


  ! ѿ
  ! Private variables
  !
  real(DP), save:: StartTimeValue
                              ! ׻ϻ. 
                              ! Start time of calculation
  character(TOKEN), save:: StartTimeUnit
                              ! ׻ϻñ. 
                              ! Unit of start time of calculation
  real(DP), save:: EndTimeValue
                              ! ׻λ. 
                              ! End time of calculation
  character(TOKEN), save:: EndTimeUnit
                              ! ׻ϻñ. 
                              ! Unit of end time of calculation
  real(DP), save:: DelTimeValue
                              ! $ \Delta t $ .  ñ̤ DelTimeUnit ˤƻ.
                              ! Unit is specified by "DelTimeUnit". 
  character(TOKEN), save:: DelTimeUnit
                              ! $ \Delta t $ ñ. 
                              ! Unit of $ \Delta t $ 

  logical, save:: flag_half
                              ! TimesetDelTimeHalf ˤä $ \Delta t $ 
                              ! ȾʬˤʤäƤ뤳Ȥ򼨤ե饰. 
                              ! 
                              ! Flag that shows $ \Delta t $ is reduced to 
                              ! half by "TimesetDelTimeHalf"
  real(DP), save:: DelTimeSave
                              ! $ \Delta t $ [s] Υǥե. 
                              ! ("TimesetDelTimeHalf" ǻѤ)
                              ! 
                              ! Default value of $ \Delta t $ [s]. 
                              ! (for "TimesetDelTimeHalf")

  type(DC_DIFFTIME), save:: PredictIntTime
                              ! λͽ¬ɽֳִ. 
                              ! Interval time of predicted end time output
  type(DC_DIFFTIME), save:: PredictPrevTime
                              ! νλͽ¬ɽ. 
                              ! Time when predicted end time is output previously
  real(DP), save:: PredictIntValue
                              ! λͽ¬ɽֳ. 
                              ! Interval of predicted end time output
  character(TOKEN), save:: PredictIntUnit
                              ! λͽ¬ɽֳ (ñ). 
                              ! Unit for interval of predicted end time output

  type(DC_DIFFTIME), save:: DCdiffDelTime
                              ! $ \Delta t $ 

  logical, save:: CpuTimeMoniter
                              ! CPU ַ¬Υ󥪥
                              ! On/off of CPU time monitoring

  integer, parameter:: clkmax = 64
                              ! CPU ַ¬Ԥץκ. 
                              ! Maximum number of processes monitored CPU time
  integer, save:: clk_proc_num = 0
                              ! CPU ַ¬ԤäƤץο. 
                              ! Number of processes monitored CPU time
  type(CLOCK), save:: clocks(1:clkmax)
                              ! CPU ַ¬ѹ¤
                              ! Derived type for monitoring CPU time
  character(TOKEN), save:: clocks_name(1:clkmax) = ''
                              ! CPU ַ¬ԤäƤץ̾
                              ! Names of processes monitored CPU time

  integer, save:: Date(8)
                              ! ׻. (ǯʬ, ॾʬ)
                              ! Start date of calculation. 
                              ! (year, month, day, hour, minute, second, 
                              ! and hour, minute of time zone)
  character(TOKEN), save:: Calendar
                              ! ˡ. Calendar

  character(*), parameter:: module_name = 'timeset'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20090405 $' // &
    & '$Id: timeset.f90,v 1.9 2009-03-17 02:41:03 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface TimesetInit
    module procedure TimesetInit
  end interface

  interface TimesetClose
    module procedure TimesetClose
  end interface

  interface TimesetProgress
    module procedure TimesetProgress
  end interface

  interface TimesetClockStart
    module procedure TimesetClockStart
  end interface

  interface TimesetClockStop
    module procedure TimesetClockStop
  end interface

contains

  !-------------------------------------------------------------------

  subroutine TimesetInit
    !
    ! timeset ⥸塼νԤޤ. 
    ! NAMELIST#timeset_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "timeset" module is initialized. 
    ! NAMELIST#timeset_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDateTimeCreate, DCDiffTimeCreate, &
      & EvalSec, EvalByUnit, mod, toChar, toCharCal, &
      & operator(*), operator(==), operator(<), operator(>), &
      & operator(/), operator(+), operator(-)

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockCreate, DCClockStart

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    real, parameter:: date_zero(8) = 0.0
                              ! NAMELIST ˤ Date ͭĴ٤뤿ѿ
                              ! Variable for check of validation of "Date" by NAMELIST

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /timeset_nml/ &
      & StartTimeValue,  StartTimeUnit, &
      & EndTimeValue,    EndTimeUnit, &
      & DelTimeValue,    DelTimeUnit, &
      & PredictIntValue, PredictIntUnit, &
      & CpuTimeMoniter, &
      & Date, Calendar
          !
          ! ǥեͤˤĤƤϽ³ "timeset#TimesetInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "timeset#TimesetInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( timeset_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    StartTimeValue = 0.0_DP
    StartTimeUnit = 'day'

    EndTimeValue = 10.0_DP
    EndTimeUnit = 'day'

    DelTime = 180.0_DP
    DelTimeValue = 30.0_DP
    DelTimeUnit = 'min'
    DelTimeSave = DelTime
    flag_half = .false.

    PredictIntValue = 1.0_DP
    PredictIntUnit = 'day'
    call DCDiffTimeCreate( PredictIntTime, &  ! (out)
      & PredictIntValue, PredictIntUnit )     ! (in)
    call DCDiffTimeCreate( PredictPrevTime, & ! (out)
      & StartTimeValue, StartTimeUnit )       ! (in)

    CpuTimeMoniter = .true.

    Date = 0.0
    Calendar = ''
    StartDateValid = .false.

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = timeset_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = timeset_nml )
    end if

    ! DC_DIFFTIME ѿ
    ! Configure DC_DIFFTIME type variables
    !
    call DCDiffTimeCreate( StartTime, &       ! (out)
      & StartTimeValue, StartTimeUnit )       ! (in)
    call DCDiffTimeCreate( EndTime, &         ! (out)
      & EndTimeValue, EndTimeUnit )           ! (in)
    call DCDiffTimeCreate( DCdiffDelTime, &    ! (out)
      & DelTimeValue, DelTimeUnit )            ! (in)
    call DCDiffTimeCreate( PredictIntTime, & ! (out)
      & PredictIntValue, PredictIntUnit )    ! (in)
    PredictPrevTime = StartTime - DCdiffDelTime

    ! Υå
    ! Check validation of time
    !
    call TimeValidCheck( &
      & StartTime, EndTime, DCdiffDelTime, PredictIntTime & ! (in)
      & )

    ! $ \Delta t $ [s] 
    ! Calculate $ \Delta t $ [s] 
    !
    DelTime = EvalSec( DCdiffDelTime )
    DelTimeSave = DelTime

    ! ƥॹƥåפλ
    ! Configure time on each time step
    !
    call DCDiffTimeCreate( TimeN, &       ! (out)
      & StartTimeValue, StartTimeUnit )   ! (in)
    TimeB = TimeN - DCdiffDelTime
    TimeA = TimeN + DCdiffDelTime


    ! CPU ַ¬ (ǥ)
    ! Start CPU time monitoring (for entire model)
    !
    if ( CpuTimeMoniter ) then
      call DCClockCreate( clocks(clk_proc_num + 1), 'total' ) ! (in)
      call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
      clocks_name(clk_proc_num + 1) = 'total'
      clk_proc_num = clk_proc_num + 1
    end if

    ! ׻
    ! Start date of calculation
    !
    if ( any( date_zero(1:8) /= Date(1:8) ) ) then
      call DCDateTimeCreate( StartDate, &                              ! (out)
        & year = Date(1), mon = Date(2), day = Date(3), &              ! (in)
        & hour = Date(4), min = Date(5), sec = real( Date(6), DP ) , & ! (in)
        & zone_hour = Date(7), zone_min = Date(8), &                   ! (in)
        & caltype_str = Calendar )                                     ! (in)
      StartDateValid = .true.
    else
      StartDateValid = .false.
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  StartTime  = %f [%c]', &
      & d = (/ StartTimeValue /), c1 = trim(StartTimeUnit) )
    if ( StartDateValid ) then
      call MessageNotify( 'M', module_name, '  StartDate  = %c', &
        & c1 = trim(toChar(StartDate)) )
      call MessageNotify( 'M', module_name, '  Calendar   = %c', &
        & c1 = trim(toCharCal(StartDate)) )
    end if
    call MessageNotify( 'M', module_name, '  EndTime    = %f [%c]', &
      & d = (/ EndTimeValue /), c1 = trim(EndTimeUnit) )
    call MessageNotify( 'M', module_name, '  DelTime    = %f [%c]', &
      & d = (/ DelTimeValue /), c1 = trim(DelTimeUnit) )
    call MessageNotify( 'M', module_name, '             = %f [%c]', &
      & d = (/ DelTime /), c1 = 'sec' )
    call MessageNotify( 'M', module_name, '  PredictInt = %f [%c]', &
      & d = (/ PredictIntValue /), c1 = trim(PredictIntUnit) )
    call MessageNotify( 'M', module_name, '  CpuTimeMoniter = %b', &
      & l = (/ CpuTimeMoniter /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    timeset_inited = .true.
  end subroutine TimesetInit

  !-------------------------------------------------------------------

  subroutine TimesetDelTimeHalf
    ! 
    ! ׻νϥ顼ˡѤ뤿, 
    ! Ū t Ⱦʬˤޤ. 
    ! TimesetProgress ƤФ줿ʳ t ϸޤ. 
    ! 
    ! Delta t is reduced to half temporarily 
    ! in order to use Euler method at initial step. 
    ! Delta t is returned to default, when "TimesetProgress" is called. 
    !
    
    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !
    if ( flag_half ) return
    DelTime = DelTime / 2.0_DP
    flag_half = .true.

  end subroutine TimesetDelTimeHalf

  !-------------------------------------------------------------------

  subroutine TimesetProgress
    !
    ! timeset ⥸塼λʤޤ. 
    ! ޤ, TimesetProgress#PredictIntStep ꤵ줿ͤ˱, 
    ! ߤޤǤη׻֤ȷ׻λͽ¬ɽޤ. 
    !
    ! Progress time configured in "timeset" module. 
    ! And, computation time until now and 
    ! predicted end of computation time are printed 
    ! according to configured "TimesetProgress#PredictIntStep"
    !

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockPredict, DCClockStop, DCClockClose, &
      & operator(+), operator(-)

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: operator(==), operator(+), operator(/), &
      & operator(-), operator(>=), toChar

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    type(CLOCK):: clock_tmp

    ! ¹ʸ ; Executable statement
    !

    ! t 򸵤᤹. 
    ! Delta t is returned to default
    !
    if ( flag_half ) then
      DelTime = DelTimeSave
      flag_half = .false.
    end if

    ! λͽ¬ɽ
    ! Print predicted end time
    !
    if ( TimeA - PredictPrevTime >= PredictIntTime ) then
      PredictPrevTime = PredictPrevTime + PredictIntTime
      if ( CpuTimeMoniter ) then
        clock_tmp = clocks(1)
        call DCClockStop( clock_tmp ) ! (in)
        call DCClockPredict( &
          & clock_tmp, &
          & real( ( TimeA - StartTime ) / ( ( EndTime + DelTimeSave ) - StartTime ) ) ) ! (in)
        call DCClockClose( clock_tmp ) ! (in)
      else
        call MessageNotify( 'M', module_name, &
          & ' Current/Total = [ %c / %c ]', &
          & c1 = trim(toChar(TimeA - StartTime)), &
          & c2 = trim(toChar(EndTime - StartTime)) )
      end if
    end if

    ! οʹ
    ! Progress time
    !
    TimeB = TimeB + DCdiffDelTime
    TimeN = TimeN + DCdiffDelTime
    TimeA = TimeA + DCdiffDelTime
  end subroutine TimesetProgress

  !-------------------------------------------------------------------

  subroutine TimesetClose
    !
    ! ׻֤פɽޤ. 
    !
    ! Total computation time is printed. 

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockStop, DCClockResult, DCClockSetName, &
      & operator(+), operator(-)

    ! ʸ ; Declaration statements
    !
    implicit none
    integer:: i               ! clocks, clocks_name  DO 롼Ѻѿ
                              ! Work variables for DO loop for "clocks", "clocks_name"

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    if ( .not. CpuTimeMoniter ) return

    ! CPU ַ¬λ (ǥ)
    ! Stop CPU time monitoring (for entire model)
    !
    call DCClockStop( clocks(1) ) ! (in)

    ! ֤¾פ CPU ֤򻻽
    ! Calculate CPU time of "Others"
    !
    clocks(clk_proc_num + 1) = clocks(1)
    do i = 2, clk_proc_num
      clocks(clk_proc_num + 1) = clocks(clk_proc_num + 1) - clocks(i)
    end do
    call DCClockSetName( clocks(clk_proc_num + 1), 'others' )

    ! CPU ֤פɽ
    ! Print total CPU time
    !
    call DCClockResult( &
      & clocks(2:clk_proc_num + 1), total_auto = .true. ) ! (in)

  end subroutine TimesetClose

  !-------------------------------------------------------------------

  subroutine TimesetClockStart( name & ! (in)
    & )
    !
    ! ץñ (˥⥸塼) Ȥλַ¬򳫻Ϥޤ. 
    !
    ! Start measurement of computation time by program unit
    ! (expected modules). 

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockCreate, DCClockStart

    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), intent(in):: name
                              ! ⥸塼̾. 
                              ! Name of module

    ! ѿ
    ! Work variables
    !
    integer:: i               ! clocks, clocks_name  DO 롼Ѻѿ
                              ! Work variables for DO loop for "clocks", "clocks_name"

    ! ¹ʸ ; Executable statement
    !

    if ( .not. CpuTimeMoniter ) return

    do i = 1, clk_proc_num
      if ( trim(clocks_name(i)) == trim(name) ) then
        call DCClockStart( clocks(i) ) ! (in)
        return
      end if
    end do

    call DCClockCreate( clocks(clk_proc_num + 1), name ) ! (in)
    call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
    clocks_name(clk_proc_num + 1) = name
    clk_proc_num = clk_proc_num + 1

  end subroutine TimesetClockStart

  !-------------------------------------------------------------------

  subroutine TimesetClockStop( name & ! (in)
    & )
    !
    ! ץñ (˥⥸塼) Ȥλַ¬ߤޤ.
    !
    ! Pause measurement of computation time by program unit
    ! (expected modules). 

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockStop

    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), intent(in):: name
                              ! ⥸塼̾. 
                              ! Name of module

    ! ѿ
    ! Work variables
    !
    integer:: i               ! clocks, clocks_name  DO 롼Ѻѿ
                              ! Work variables for DO loop for "clocks", "clocks_name"

    ! ¹ʸ ; Executable statement
    !

    if ( .not. CpuTimeMoniter ) return

    do i = 1, clk_proc_num
      if ( trim(clocks_name(i)) == trim(name) ) then
        call DCClockStop( clocks(i) ) ! (in)
        return
      end if
    end do

    call MessageNotify( 'W', module_name, ' name "%c" is not found in "TimesetClockStop"', c1 = trim(name) )

  end subroutine TimesetClockStop

  !-------------------------------------------------------------------

  subroutine TimeValidCheck( &
    & dcdiff_start, dcdiff_end, dcdiff_delt, dcdiff_predict & ! (in)
    & )
    !
    ! ˤĤƤͭåޤ. 
    !
    ! Check validation about infomation time
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit, mod, toChar, &
      & operator(*), operator(==), operator(<), operator(>), &
      & operator(/), operator(+), operator(-)

    implicit none
    type(DC_DIFFTIME), intent(in):: dcdiff_start
                              ! ׻ϻ. 
                              ! Start time of calculation
    type(DC_DIFFTIME), intent(in):: dcdiff_end
                              ! ׻λ. 
                              ! End time of calculation
    type(DC_DIFFTIME), intent(in):: dcdiff_delt
                              ! $ \Delta t $ [s]
    type(DC_DIFFTIME), intent(in):: dcdiff_predict
                              ! λͽ¬ɽֳ. 
                              ! Interval of predicted end time output

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    if ( .not. 0.0_DP < EvalSec( dcdiff_end - dcdiff_start )  ) then
      call MessageNotify( 'E', module_name, &
        & 'StartTime=<%f[%c]> is later than EndTime=<%f[%c]>', &
        & d = (/ StartTimeValue, EndTimeValue /), &
        & c1 = trim(StartTimeUnit), c2 = trim(EndTimeUnit) )
    end if

    if ( dcdiff_delt > ( dcdiff_end - dcdiff_start ) ) then
      call MessageNotify( 'E', module_name, &
        & 'DelTime=<%f[%c]> is larger than ' // &
        & 'EndTime=<%f[%c]> - StartTime=<%f[%c]>.', &
        & d = (/ DelTimeValue, EndTimeValue, StartTimeValue /), &
        & c1 = trim(DelTimeUnit), &
        & c2 = trim(EndTimeUnit), c3 = trim(StartTimeUnit) )
    end if

    if ( .not. EvalSec( dcdiff_delt ) > 0.0_DP ) then
      call MessageNotify( 'E', module_name, &
        & 'DelTime=<%f[%c]> must be more than 0.', &
        & d = (/ DelTimeValue /), &
        & c1 = trim(DelTimeUnit) )
    end if

    if ( .not. EvalSec( dcdiff_predict ) > 0.0_DP ) then
      call MessageNotify( 'E', module_name, &
        & 'PredictInt=<%f[%c]> must be more than 0.', &
        & d = (/ PredictIntValue /), &
        & c1 = trim(PredictIntUnit) )
    end if

  end subroutine TimeValidCheck

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

  end subroutine InitCheck

end module timeset
