# -*- coding: euc-jp -*-
require "gphys_const_v1.1"
require "gphys_methods_v1.4"
require "numru/ggraph"
include NumRu


dir  = ARGV[0]
vname = ARGV[1]
iyrs = ARGV[2].to_i
iyre = ARGV[3].to_i
imon = ARGV[4].to_i

title = MonNames[imon-1]

gphys = GPhys::NetCDF_IO.open(dir+'/'+vname+".nc", vname)


#< DCLΥץ >
DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.uzfact(0.75)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

#< GGraph ˤ  >
GGraph.set_fig 'itr'=>10, 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[0,360,-90,90]
GGraph.set_map 'coast_world'=>true, 'grid'=>false
GGraph.set_axes('xlabelint'=>90)
GGraph.set_axes('ylabelint'=>30)

gphysout = dcpam_clim_mon_mean( iyrs, iyre, imon, gphys )


# ٥ѥۤ˻
# ѥ1¿ޡޤ

if vname == 'SurfTemp'
  levels = [210,220,230,240,250,260,270,280,290,300]
  patterns = [20999,30999,40999,45999,50999,55999,60999,70999,80999,85999,90999]
elsif vname == 'Rain'
  levels = [0,1e-5,2e-5,4e-5,8e-5,12e-5,16e-5,20e-5,24e-5,28e-5,32e-5]
  patterns = [1,20999,30999,35999,40999,50999,60999,65999,70999,75999,80999,85999]
elsif vname == 'SoilMoist'
  levels = [0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150]
  patterns = [15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'SurfSnow'
  levels = [0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150]
  patterns = [15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
#elsif vname == 'OLR'
elsif vname == 'OLRA'
  levels = [100,120,140,160,180,200,220,240,260,280,300]
  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,70999,80999,90999]
end

if vname == 'Rain'
  gphysout= gphysout / 2.5e6
end

GGraph.tone( gphysout, true, 'lev'=>levels, 'pat'=>patterns, 'map_axes'=>true, 'annotate'=>false )
GGraph.color_bar

DCL::uxmttl('T', ' ', 1.0)
DCL::uxmttl('T', title, -1.0)



DCL.grcls

