!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 3  (xyz ) ֳָ߳ʻ ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/06/07 () : 

module xyz_bc_module
  != 3  (xyz ) ֳָ߳ʻ ͭºʬǥ ⥸塼
  !
  !== 
  !
  ! xyz_bc_module , 3  (xyz ) ֳָ߳ʻҤѤͭºʬˡ
  ! ŤͥǥΤ,  Fortran 90 ץ
  ! .
  !
  ! Υ⥸塼 xyz_module β̥⥸塼Ǥ. ⥸塼
  ! Ȥ data_type, xyz_base_module, x_bc_module, y_bc_module, 
  ! z_bc_module ⥸塼ѤƤ. 
  !
  !
  !== ³̿̾ˡ
  !
  ! ꤹץ
  !
  !   Boundary[򼨤ʸ][...]_(μ)
  !
  ! Τ褦̿̾Ƥ. 򼨤ʸμ x_bc_module,
  ! y_bc_module, z_bc_module ξƱǤ.
  ! 
  !
  use dc_types, only : DP
  use gridset,  only : imin, imax, jmin, jmax, kmin, kmax,    &
    &                  xmg, ymg, zmg, nx, ny, nz 
#ifdef LIB_MPI
  use mpi_wrapper, only : myrank, nprocs, &
    &                     MPIWrapperISend, MPIWrapperIRecv, MPIWrapperWait
#else
!  use mpi_wrapper, only : myrank, nprocs
#endif

  implicit none

  private

  public :: BoundaryXSym_xyz, BoundaryXAsym_xyz, BoundaryXCyc_xyz 
  public :: BoundaryXSym_xqz, BoundaryXAsym_xqz, BoundaryXCyc_xqz 
  public :: BoundaryXSym_xyr, BoundaryXAsym_xyr, BoundaryXCyc_xyr 
  public :: BoundaryXSym_pyz, BoundaryXAsym_pyz, BoundaryXCyc_pyz 

  public :: BoundaryYSym_xyz, BoundaryYAsym_xyz, BoundaryYCyc_xyz 
  public :: BoundaryYSym_xqz, BoundaryYAsym_xqz, BoundaryYCyc_xqz 
  public :: BoundaryYSym_xyr, BoundaryYAsym_xyr, BoundaryYCyc_xyr 
  public :: BoundaryYSym_pyz, BoundaryYAsym_pyz, BoundaryYCyc_pyz 

  public :: BoundaryZSym_xyz, BoundaryZAsym_xyz, BoundaryZCyc_xyz 
  public :: BoundaryZSym_xqz, BoundaryZAsym_xqz, BoundaryZCyc_xqz 
  public :: BoundaryZSym_xyr, BoundaryZAsym_xyr, BoundaryZCyc_xyr 
  public :: BoundaryZSym_pyz, BoundaryZAsym_pyz, BoundaryZCyc_pyz 

  interface BoundaryXSym_xyz
    module procedure BoundaryXSym_xaa
  end interface

  interface BoundaryXSym_xqz
    module procedure BoundaryXSym_xaa
  end interface
  
  interface BoundaryXSym_xyr
    module procedure BoundaryXSym_xaa
  end interface

  interface BoundaryXAsym_xyz
    module procedure BoundaryXAsym_xaa
  end interface

  interface BoundaryXAsym_xqz
    module procedure BoundaryXAsym_xaa
  end interface

  interface BoundaryXAsym_xyr
    module procedure BoundaryXAsym_xaa
  end interface

#ifdef LIB_MPI
  interface BoundaryXCyc_xyz
    module procedure MPIBoundaryXCyc_aaa
  end interface

  interface BoundaryXCyc_xqz
    module procedure MPIBoundaryXCyc_aaa
  end interface

  interface BoundaryXCyc_xyr
    module procedure MPIBoundaryXCyc_aaa
  end interface

  interface BoundaryXCyc_pyz
    module procedure MPIBoundaryXCyc_aaa
  end interface
#else
  interface BoundaryXCyc_xyz
    module procedure BoundaryXCyc_aaa
  end interface

  interface BoundaryXCyc_xqz
    module procedure BoundaryXCyc_aaa
  end interface

  interface BoundaryXCyc_xyr
    module procedure BoundaryXCyc_aaa
  end interface

  interface BoundaryXCyc_pyz
    module procedure BoundaryXCyc_aaa
  end interface
#endif

  interface BoundaryYSym_xyz
    module procedure BoundaryYSym_aya
  end interface

  interface BoundaryYSym_pyz
    module procedure BoundaryYSym_aya
  end interface

  interface BoundaryYSym_xyr
    module procedure BoundaryYSym_aya
  end interface

  interface BoundaryYAsym_xyz
    module procedure BoundaryYAsym_aya
  end interface

  interface BoundaryYAsym_pyz
    module procedure BoundaryYAsym_aya
  end interface

  interface BoundaryYAsym_xyr
    module procedure BoundaryYAsym_aya
  end interface

  interface BoundaryYCyc_xyz
    module procedure BoundaryYCyc_aaa
  end interface

  interface BoundaryYCyc_pyz
    module procedure BoundaryYCyc_aaa
  end interface

  interface BoundaryYCyc_xyr
    module procedure BoundaryYCyc_aaa
  end interface

  interface BoundaryYCyc_xqz
    module procedure BoundaryYCyc_aaa
  end interface

  interface BoundaryZSym_xyz
    module procedure BoundaryZSym_aaz
  end interface

  interface BoundaryZSym_pyz
    module procedure BoundaryZSym_aaz
  end interface

  interface BoundaryZSym_xqz
    module procedure BoundaryZSym_aaz
  end interface

  interface BoundaryZAsym_xyz
    module procedure BoundaryZAsym_aaz
  end interface

  interface BoundaryZAsym_pyz
    module procedure BoundaryZAsym_aaz
  end interface

  interface BoundaryZAsym_xqz
    module procedure BoundaryZAsym_aaz
  end interface

  interface BoundaryZCyc_xyz
    module procedure BoundaryZCyc_aaa
  end interface

  interface BoundaryZCyc_pyz
    module procedure BoundaryZCyc_aaa
  end interface

  interface BoundaryZCyc_xqz
    module procedure BoundaryZCyc_aaa
  end interface

  interface BoundaryZCyc_xyr
    module procedure BoundaryZCyc_aaa
  end interface

  integer :: ix, jy, kz
  
contains
  
!--------------------------------------------------------------------
  subroutine BoundaryXSym_xaa(xaa_Var)
    real(DP),intent(inout) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax) 

    ! x ˼ŬѤ
    
    do ix = 1, xmg
      xaa_Var(1-ix,:,:)  = xaa_Var(ix,:,:)
      xaa_Var(nx+ix,:,:) = xaa_Var(nx+1-ix,:,:)
    end do
    
  end subroutine BoundaryXSym_xaa
!--------------------------------------------------------------------
  subroutine BoundaryXSym_pyz(pyz_Var)
    real(DP),intent(inout) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
    
    ! x оζŬѤ

    do ix = 1, xmg-1
      pyz_Var(-ix,:,:)   = pyz_Var(ix,:,:)      
    end do
    
    do ix = 1, xmg
      pyz_Var(nx+ix,:,:) = pyz_Var(nx+1-ix,:,:)
    end do
    
    
  end subroutine BoundaryXSym_pyz
!--------------------------------------------------------------------
  subroutine BoundaryXAsym_xaa(xaa_Var)
    real(DP),intent(inout) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax) 

    ! x ȿоζŬѤ

    do ix = 1, xmg
      xaa_Var(1-ix,:,:)  = - xaa_Var(ix,:,:)
      xaa_Var(nx+ix,:,:) = - xaa_Var(nx+1-ix,:,:)
    end do
        
  end subroutine BoundaryXAsym_xaa
!--------------------------------------------------------------------
  subroutine BoundaryXAsym_pyz(pyz_Var)
    real(DP),intent(inout) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
    
    ! x ȿоζŬѤ
    pyz_Var(0,:,:) = 0.0d0
    pyz_Var(nx,:,:) = 0.0d0
          
    do ix = 1, xmg-1
      pyz_Var(-ix,:,:) = - pyz_Var(ix,:,:)
    end do
    
    do ix = 1, xmg
      pyz_Var(nx+ix,:,:) = - pyz_Var(nx-ix,:,:)
    end do
    
  end subroutine BoundaryXAsym_pyz
!--------------------------------------------------------------------
   subroutine BoundaryXCyc_aaa(aaa_Var)
      real(DP),intent(inout) :: aaa_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! x ˼ŬѤ

      do ix = 1, xmg
        aaa_Var(1-ix,:,:)  = aaa_Var(nx+1-ix,:,:)
        aaa_Var(nx+ix,:,:) = aaa_Var(ix,:,:)
      end do
 
   end subroutine BoundaryXCyc_aaa


!--------------------------------------------------------------------
    subroutine BoundaryYSym_aya(aya_Var)
      real(DP),intent(inout) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! y оζŬѤ

      if (ymg == 0) return 

      do jy = 1, ymg
        aya_Var(:,1-jy,:)  = aya_Var(:,jy,:)
        aya_Var(:,ny+jy,:) = aya_Var(:,ny+1-jy,:)
      end do

    end subroutine BoundaryYsym_aya
!--------------------------------------------------------------------
    subroutine BoundaryYSym_xqz(xqz_Var)
      real(DP),intent(inout) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! y оζŬѤ

      if (ymg == 0) return 

      do jy = 1, ymg-1
        xqz_Var(:,-jy,:)   = xqz_Var(:,jy,:)      
      end do

      do jy = 1, ymg
        xqz_Var(:,ny+jy,:) = xqz_Var(:,ny+1-jy,:)
      end do

    end subroutine BoundaryYsym_xqz
!--------------------------------------------------------------------
    subroutine BoundaryYASym_aya(aya_Var)
      real(DP),intent(inout) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! y ȿоζŬѤ

      if (ymg == 0) return 

      do jy = 1, ymg
        aya_Var(:,1-jy,:)  = - aya_Var(:,jy,:)
        aya_Var(:,ny+jy,:) = - aya_Var(:,ny+1-jy,:)
      end do

    end subroutine BoundaryYAsym_aya
!--------------------------------------------------------------------
    subroutine BoundaryYASym_xqz(xqz_Var)
      real(DP),intent(inout) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) 

      ! y ȿоζŬѤ

      if (ymg == 0) return 

      xqz_Var(:,0,:) = 0.0d0
      xqz_Var(:,ny,:) = 0.0d0
          
      do jy = 1, ymg-1
        xqz_Var(:,-jy,:) = - xqz_Var(:,jy,:)
      end do

      do jy = 1, ymg
        xqz_Var(:,ny+jy,:) = - xqz_Var(:,ny-jy,:)
      end do

    end subroutine BoundaryYAsym_xqz
!--------------------------------------------------------------------
    subroutine BoundaryYCyc_aaa(aaa_Var)
      real(DP),intent(inout) :: aaa_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! y ˼ŬѤ

      if (ymg == 0) return 

      do jy = 1, ymg
        aaa_Var(:,1-jy,:)  = aaa_Var(:,ny+1-jy,:)
        aaa_Var(:,ny+jy,:) = aaa_Var(:,jy,:)
      end do

    end subroutine BoundaryYCyc_aaa
!--------------------------------------------------------------------
    subroutine BoundaryZSym_aaz(aaz_Var)
      real(DP),intent(inout) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z оζŬѤ

      do kz = 1, zmg
        aaz_Var(:,:,1-kz)  = aaz_Var(:,:,kz)
        aaz_Var(:,:,nz+kz) = aaz_Var(:,:,nz+1-kz)
      end do


    end subroutine BoundaryZSym_aaz
!--------------------------------------------------------------------
    subroutine BoundaryZSym_xyr(xyr_Var)
      real(DP),intent(inout) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z оζŬѤ

      do kz = 1, zmg-1
        xyr_Var(:,:,-kz)   = xyr_Var(:,:,kz)      
      end do

      do kz = 1, zmg
        xyr_Var(:,:,nz+kz) = xyr_Var(:,:,nz+1-kz)
      end do

    end subroutine BoundaryZSym_xyr
!--------------------------------------------------------------------
    subroutine BoundaryZAsym_aaz(aaz_Var)
      real(DP),intent(inout) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z ȿоζŬѤ

      do kz = 1, zmg
        aaz_Var(:,:,1-kz)  = - aaz_Var(:,:,kz)
        aaz_Var(:,:,nz+kz) = - aaz_Var(:,:,nz+1-kz)
      end do

    end subroutine BoundaryZAsym_aaz
!--------------------------------------------------------------------
    subroutine BoundaryZAsym_xyr(xyr_Var)
      real(DP),intent(inout) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z ȿоζŬѤ

      xyr_Var(:,:,0) = 0.0d0
      xyr_Var(:,:,nz) = 0.0d0
          
      do kz = 1, zmg-1
        xyr_Var(:,:,-kz) = - xyr_Var(:,:,kz)
      end do

      do kz = 1, zmg
        xyr_Var(:,:,nz+kz) = - xyr_Var(:,:,nz-kz)
      end do

    end subroutine BoundaryZAsym_xyr
!--------------------------------------------------------------------
    subroutine BoundaryZCyc_aaa(aaa_Var)
      real(DP),intent(inout) :: aaa_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z ˼ŬѤ

      do kz = 1, zmg
        aaa_Var(:,:,1-kz)  = aaa_Var(:,:,nz+1-kz)
        aaa_Var(:,:,nz+kz) = aaa_Var(:,:,kz)
      end do

    end subroutine BoundaryZCyc_aaa
!--------------------------------------------------------------------

#ifdef LIB_MPI
  subroutine MPIBoundaryXCyc_aaa(aaa_Var)
    
    implicit none
    
    !ѿ
    real(8), intent(inout)  :: aaa_Var(imin:imax, jmin:jmax, kmin:kmax)
    integer            :: idest_a, idep_a, idest_b, idep_b
    integer, parameter :: nvars = 1
    real(8)            :: sbuf_a( Xmg, ny, nz )
    real(8)            :: rbuf_a( Xmg, ny, nz )
    real(8)            :: sbuf_b( Xmg, ny, nz )
    real(8)            :: rbuf_b( Xmg, ny, nz )
    integer            :: ireqs_a, ireqr_a, ireqs_b, ireqr_b
    integer            :: i, j, k
    
    !-------------------------------
    ! α¦, Ρɴ֤̿.
    ! ʬ(sbuf_a)Ѱդ
    do k = 1, nz
      do j = 1, ny
        do i = 1, Xmg
          sbuf_a( i, j, k ) = aaa_var( nx + 1 - i , j, k ) 
        end do
      end do
    end do

    idest_a = mod(( myrank+1 )       , nprocs)   !
    idep_a  = mod(( myrank-1 )+nprocs, nprocs)   !

    call MPIWrapperISend( idest_a, xmg, ny, nz, sbuf_a, ireqs_a ) !
    call MPIWrapperIRecv( idep_a , xmg, ny, nz, rbuf_a, ireqr_a ) !
    
    !-------------------------------
    ! κ¦, Ρɴ֤̿.
    ! ʬ(sbuf_b)Ѱդ
    do k = 1, nz
      do j = 1, ny
        do i = 1, Xmg
          sbuf_b( i, j, k ) = aaa_var( i, j, k ) 
        end do
      end do
    end do
    
    idest_b = mod(( myrank-1 )+nprocs, nprocs)    !
    idep_b  = mod(( myrank+1 )       , nprocs)    !

    call MPIWrapperISend( idest_b, xmg, ny, nz, sbuf_b, ireqs_b ) !
    call MPIWrapperIRecv( idep_b , xmg, ny, nz, rbuf_b, ireqr_b ) !

    !-------------------------------
    ! α¦, Ρɴ֤̿.
    ! ʬ(rbuf_a).
    call MPIWrapperWait( ireqs_a )
    call MPIWrapperWait( ireqr_a )
    
    do k = 1, nz
      do j = 1, ny
        do i = 1, Xmg
          aaa_var( 1-i , j, k ) = rbuf_a( i, j, k ) 
        end do
      end do
    end do
    
    !-------------------------------
    ! κ¦, Ρɴ֤̿.
    ! ʬ(rbuf_b).
    call MPIWrapperWait( ireqs_b )
    call MPIWrapperWait( ireqr_b )
    
    do k = 1, nz
      do j = 1, ny
        do i = 1, Xmg
          aaa_var(nx + i , j, k ) = rbuf_b( i, j, k ) 
        end do
      end do
    end do
    
  end subroutine MPIBoundaryXCyc_aaa
#endif

end module xyz_bc_module
