!= Module DynFunc
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: dynfunc.f90,v 1.8 2006/11/22 15:38:22 sugiyama Exp $ 
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǥϳز׻뤿ɬפȤʤؿ«ͤ⥸塼
!Ūˤϰʲι׻뤿δؿǼ.  
!  * ή
!  * Ϲ
!  * Ϲ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * ʡؿζΥˤ, 2 ٤ΥۤѤƤ뤿, Ϲη׻ץˤ differentiate_center4 ⥸塼ꤹ뤳ȤϤǤʤΤ.
!
!== Future Plans
!

module DynFunc
  !
  !۳Ѥϳزγƹη׻⥸塼. 
  !Ūˤϰʲι׻뤿δؿǼ.  
  !  * ή
  !  * Ϲ
  !  * Ϲ
  !

  !⥸塼ɤ߹
  use gridset, only:  DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 SpcNum              !
  use damping,  only: DampSound           !Ȥθ그
  use basicset, only: xz_PotTempBasicZ,  &!ܾβ
    &                 xz_EffMolWtBasicZ, &!ܾʬ̸
    &                 CpDry,             &!ʬǮ
    &                 Grav                !ϲ®
  use average,  only: xz_avr_pz, xz_avr_xr, &
    &                 pz_avr_xz, pz_avr_pr, &
    &                 pr_avr_xr, pr_avr_pz, &
    &                 xr_avr_pr, xr_avr_xz
  use storeset, only: StoreAdv
  use storeset2, only: Store2Adv

  !ۤηػ
  implicit none

  !°λ
  private

  !ή׻Τδؿ public ˤ
  public xz_AdvScalar
  public xz_AdvScalar2
  public xza_AdvScalar
  public pz_AdvVelX
  public xr_AdvVelZ

  !Ϲ׻Τδؿ public ˤ
  public xr_Buoy

  !Ϥη׻Τδؿ public ˤ
  public pz_GradPi


contains


!!!------------------------------------------------------------------------!!!
  function xz_AdvScalar(xz_Var, pz_VelX, xr_VelZ)
    !
    ! x, z ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use differentiate_center4, only: pz_dx_xz, xr_dz_xz
!    use differentiate_center2, only: pz_dx_xz, xr_dz_xz

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ʿ®
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ľ®
    real(8), intent(in) :: xz_Var(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !顼
    real(8)             :: xz_AdvScalar(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !顼̤οʿή
    
    xz_AdvScalar =                               &
      & - xz_avr_pz(pz_VelX * pz_dx_xz(xz_Var))  &
      & - xz_avr_xr(xr_VelZ * xr_dz_xz(xz_Var))    

    call StoreAdv( xz_AdvScalar )   

  end function xz_AdvScalar



!!!------------------------------------------------------------------------!!!
  function xz_AdvScalar2(xz_Var, pz_VelX, xr_VelZ)
    !
    ! x, z ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use differentiate_center4, only: pz_dx_xz, xr_dz_xz
!    use differentiate_center2, only: pz_dx_xz, xr_dz_xz

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ʿ®
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ľ®
    real(8), intent(in) :: xz_Var(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !顼
    real(8)             :: xz_AdvScalar2(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !顼̤οʿή
    
    xz_AdvScalar2 =                               &
      & - xz_avr_pz(pz_VelX * pz_dx_xz(xz_Var))  &
      & - xz_avr_xr(xr_VelZ * xr_dz_xz(xz_Var))    

  end function xz_AdvScalar2



  function xza_AdvScalar(xza_Var, pz_VelX, xr_VelZ)
    !
    ! x, z ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use differentiate_center4, only: pz_dx_xz, xr_dz_xz
!    use differentiate_center2, only: pz_dx_xz, xr_dz_xz

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ʿ®
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ľ®
    real(8), intent(in) :: xza_Var(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                        !顼
    real(8)             :: xza_AdvScalar(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                        !顼̤οʿή
    integer             :: s

    do s = 1, SpcNum
      xza_AdvScalar(:,:,s) =                               &
        & - xz_avr_pz(pz_VelX * pz_dx_xz(xza_Var(:,:,s)))  &
        & - xz_avr_xr(xr_VelZ * xr_dz_xz(xza_Var(:,:,s)))    
    end do

    call Store2Adv( xza_AdvScalar )   
    
  end function xza_AdvScalar
  

!!!------------------------------------------------------------------------!!!
  function pz_AdvVelX(pz_VelX, xr_VelZ)
    !
    ! z ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use differentiate_center4, only: xz_dx_pz, pr_dz_pz
!    use differentiate_center2, only: xz_dx_pz, pr_dz_pz

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ʿ®
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ľ®
    real(8)             :: pz_AdvVelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !顼̤οʿή
    
!    pz_AdvVelX = 0.0d0  !
    pz_AdvVelX =                                                 &
      & - pz_VelX * pz_avr_xz( xz_dx_pz( pz_VelX ) )             &
      & - pz_avr_pr( pr_avr_xr( xr_VelZ ) * pr_dz_pz( pz_VelX ) )
    
  end function pz_AdvVelX


!!!------------------------------------------------------------------------!!!
  function xr_AdvVelZ(xr_VelZ, pz_VelX)
    !
    ! x ȾʻҤ줿ˤή׻
    !
    
    !⥸塼ɤ߹
    use differentiate_center4, only: pr_dx_xr, xz_dz_xr
!    use differentiate_center2, only: pr_dx_xr, xz_dz_xr
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ʿ®
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !ľ®
    real(8)             :: xr_AdvVelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                        !顼̤οʿή
  
!    xr_AdvVelZ = 0.0d0  !
    xr_AdvVelZ =                                                 &
      & - xr_avr_pr( pr_avr_pz( pz_VelX ) * pr_dx_xr( xr_VelZ ) ) &
      & - xr_VelZ * xr_avr_xz( xz_dz_xr( xr_VelZ ) )
    
  end function xr_AdvVelZ
  

!!!------------------------------------------------------------------------!!!
  function xr_Buoy(xz_PotTemp)
    !
    ! ľαư˸Ϲ׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !̾
    real(8)              :: xr_Buoy(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !Ϲ

!    !
!    xr_Buoy = 0.0d0

    !Ϲη׻
    xr_Buoy = Grav * xr_avr_xz(xz_PotTemp / xz_PotTempBasicZ)

  end function xr_Buoy


!!!------------------------------------------------------------------------!!!
  function pz_GradPi(xz_Exner, pz_VelX, xr_VelZ)
    !
    ! z ȾʻҤ줿ǤΰϷϹη׻. 
    ! ȸޤ᤿꼰Ƥ뤳Ȥ.
    !
    
    !⥸塼ɤ߹
    use differentiate_center2,  only: pz_dx_xz, xz_dx_pz, xz_dz_xr
        
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ʡؿξ
    real(8), intent(in)  :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ʿ®
    real(8), intent(in)  :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ľ®
    real(8)              :: pz_GradPi(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !Ϸ
    real(8)              :: xz_DivVel(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !®٤μ«

    !®٤μ«
    xz_DivVel =  xz_dx_pz( pz_VelX ) + xz_dz_xr( xr_VelZ )
    
    !Ϸ
!    pz_GradPi = 0.0d0
    pz_GradPi =  &
      & pz_avr_xz( CpDry * xz_PotTempBasicZ / xz_EffMolWtBasicZ )    &
      &   * ( pz_dx_xz( xz_Exner ) - pz_dx_xz( DampSound * xz_DivVel ) )  
    
  end function pz_GradPi
  
end module DynFunc
