!= Module GridSet
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: gridset.f90,v 1.7 2011-10-15 15:34:34 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20120828 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ʻ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module gridset
  !
  !Ϳ줿 NAMELIST ե뤫, ʻ, 
  !ݴɤ뤿ѿȷ⥸塼
  !

  !⥸塼ɤ߹
  use dc_types,    only: DP, STRING
  use dc_iounit,   only: FileOpen
  use dc_message,  only: MessageNotify
  use mpi_wrapper, only: myrank
  use namelist_util, only: namelist_filename
  
  !ۤηػ
  implicit none
  
  !save °
  private
  
  !ѿ
  integer, public, save :: NX = 10 ! x ʻ
  integer, public, save :: NY = 10 ! y ʻ
  integer, public, save :: NZ = 10 ! z ʻ
  integer, public, save :: NCMAX = 3  ! ǿ
  integer, public, save :: Xmg = 4 ! x ʻ
  integer, public, save :: Ymg = 4 ! y ʻ
  integer, public, save :: Zmg = 4 ! z ʻ
  integer, public, save :: imin    ! x β 
  integer, public, save :: imax    ! x ξ
  integer, public, save :: jmin    ! y β 
  integer, public, save :: jmax    ! y β 
  integer, public, save :: kmin    ! z β 
  integer, public, save :: kmax    ! z β 

  public gridset_init

contains

  subroutine gridset_init
    !
    !ե뤫ɤ߹߳ʻ׻
    !

    !ۤηػ
    implicit none

    !ѿ
    integer            :: unit                !եֹ

    !-----------------------------------------------------------------
    ! ե뤫ɤ߹
    !
    NAMELIST /gridset_nml/ NX, NY, NZ, NCMAX, Xmg, Ymg, Zmg
    
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=gridset_nml)
    close(unit)
    
    if ( NX < xmg ) then
      call MessageNotify( "E", "gridset_init", "NX < Xmg" )
    end if
    
    if ( NY < ymg ) then
      call MessageNotify( "E", "gridset_init", "NY < Ymg" )
    end if
    
    if ( NZ < zmg ) then
      call MessageNotify( "E", "gridset_init", "NZ < Zmg" )
    end if

    !-----------------------------------------------------------------
    ! ξ¡¤
    !
    imin = 1  - xmg
    imax = nx + xmg    
    jmin = 1  - ymg
    jmax = ny + ymg    
    kmin = 1  - zmg
    kmax = nz + zmg    
    
    !-----------------------------------------------------------------    
    !"myrank == 0" ˳׻Ρɤ, ɤ߹
    !
    if (myrank == 0) then 
      call MessageNotify( "M", "gridset_init", "NX = %d",   i=(/NX/) )
      call MessageNotify( "M", "gridset_init", "NY = %d",   i=(/NY/) )
      call MessageNotify( "M", "gridset_init", "NZ = %d",   i=(/NZ/) )
      call MessageNotify( "M", "gridset_init", "NCMAX = %d",   i=(/NCMAX/) )
      call MessageNotify( "M", "gridset_init", "xmg  = %d", i=(/Xmg/) )
      call MessageNotify( "M", "gridset_init", "ymg  = %d", i=(/Ymg/) )
      call MessageNotify( "M", "gridset_init", "zmg  = %d", i=(/Zmg/) )
      call MessageNotify( "M", "gridset_init", "imin = %d", i=(/imin/) )
      call MessageNotify( "M", "gridset_init", "imax = %d", i=(/imax/) )
      call MessageNotify( "M", "gridset_init", "jmin = %d", i=(/jmin/) )
      call MessageNotify( "M", "gridset_init", "jmax = %d", i=(/jmax/) )
      call MessageNotify( "M", "gridset_init", "kmin = %d", i=(/kmin/) )
      call MessageNotify( "M", "gridset_init", "kmax = %d", i=(/kmax/) )
    end if
  end subroutine gridset_init
  
end module gridset
