!= Program ArareInitData
!
! Authors::   SUGIYAMA Ko-ichiro (̰ϯ), ODAKA Masatsugu ()
! Version::   $Id: arare_init-data.f90,v 1.20 2012-01-12 11:53:08 sugiyama Exp $
! Tag Name::  $Name: arare5-20120828 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ϳإǥ deepconv/arare. 
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * ϤϽవ̷.
!
!== Future Plans
!
!

program ArareInitData
  !
  !ϳإǥ deepconv/arare. 
  !

  !----- ⥸塼ɤ߹ ------

  !-----   , ʸ   ----
  use dc_types,       only : STRING, DP
  use dc_string,      only : StoA
  use gtool_history,  only : HistoryPut

  !-----   å   -----
  use dc_message,     only: MessageNotify

  !  ޥɥ饤
  use argset,        only : argset_init  

  !  MPI ν
  !  Initialize MPI wrapper
  !
  use mpi_wrapper,   only : MPIWrapperInit, MPIWrapperFinalize, myrank

  !-----    ⥸塼   -----
  !  ϥե̾⥸塼
  use fileset,    only : fileset_init

  !  ʻ⥸塼 
  use gridset, only : gridset_init, &
    &                       imin, imax, jmin, jmax, kmin, kmax, &
    &                       nx, ny, nz,  ncmax

  !  ܾ⥸塼
  use basicset,      only : basicset_init

  use axesset,       only : axesset_init

  use constants0,    only : Pi

  use constants,     only : constants_init, molwtdry, &
    &                       Grav, TempSfc, PressSfc, &
    &                       pressbasis, gasrdry, cpdry, cvdry

  !  롼⥸塼
  use composition,      only: composition_init, molwtwet, SpcWetMolFr, &
    &                       GasNum, CondNum, IdxCC, IdxCG, SpcWetID

  ! ط׻
  use ChemCalc, only: ChemCalc_init, xyz_SvapPress

  !  Ŭѥ⥸塼
  use setmargin

  use axesset, only:  z_Z,          &!顼ʻǤι
    &                 z_dz,         &!Z γʻֳ
    &                 xyz_X,        &
    &                 xyz_Y,        &
    &                 xyz_Z

  use namelist_util, only: NmlutilInit, namelist_filename

  use eccm,     only: ECCM_Dry,      &!
    &                 ECCM_Wet              

  use initialdata_disturb, only: &
    &  initialdata_disturb_random,  &
    &  initialdata_disturb_gaussXZ, initialdata_disturb_gaussXY, &
    &  initialdata_disturb_gaussYZ, initialdata_disturb_gaussXYZ, &
    &  initialdata_disturb_dryreg,  initialdata_disturb_moist, &
    &  initialdata_disturb_rectangle
  use initialdata_yamasaki1983, only: initialdata_yamasaki1983_basic
  use initialdata_takemi2007, only: initialdata_takemi2007_init, &
    &  initialdata_takemi2007_basic, initialdata_takemi2007_wind
  use initialdata_toon2002, only: initialdata_toon2002_basic

  !-----    ϥ⥸塼   -----
  !  ꥹȥեϥ⥸塼
  use RestartFileIO, only : ReStartFileIO_Init, ReStartFileIO_Finalize, rstat
  use Arare4FileIO,  only : Arare4FileIO_Init, Arare4FileIO_Var_Get, Arare4FileIO_BZ_Get, &
    &                       Arare4FileIO_MMC_Var_Get, Arare4FileIO_MMC_BZ_Get

  !ۤηػ
  implicit none

  !ѿ
  real(DP), allocatable :: pyz_VelX(:,:,:)
  real(DP), allocatable :: xqz_VelY(:,:,:)
  real(DP), allocatable :: xyr_VelZ(:,:,:)
  real(DP), allocatable :: xyz_Exner(:,:,:)
  real(DP), allocatable :: xyz_PTemp(:,:,:)
  real(DP), allocatable :: xyz_Km(:,:,:)
  real(DP), allocatable :: xyz_Kh(:,:,:)
  real(DP), allocatable :: xyz_CDens(:,:,:)
  real(DP), allocatable :: xyzf_QMix(:,:,:,:)
  real(DP), allocatable :: xyz_DensBZ(:,:,:)
  real(DP), allocatable :: xyz_PressBZ(:,:,:)
  real(DP), allocatable :: xyz_ExnerBZ(:,:,:)
  real(DP), allocatable :: xyz_TempBZ(:,:,:)
  real(DP), allocatable :: xyz_PTempBZ(:,:,:)
  real(DP), allocatable :: xyz_VelSoundBZ(:,:,:)
  real(DP), allocatable :: xyzf_QMixBZ(:,:,:,:)
  real(DP), allocatable :: xyz_EffMolWtBZ(:,:,:)
  real(DP), allocatable :: z_TempBZ(:)
  real(DP), allocatable :: z_PressBZ(:)
  real(DP), allocatable :: xyzf_MolFr(:,:,:,:)
  real(DP), allocatable :: zf_MolFr(:,:)
  real(DP), allocatable :: xyzf_QMixDivMolWt(:,:,:,:)
  real(DP), allocatable :: xyzf_HumBZ(:,:,:,:)
  real(DP)              :: Time
  integer               :: i, j, k, s

  !ѿ
  ! Moist 
  real(DP)   :: Humidity = 0.0d0 !м
  ! Gauss 
  real(DP)   :: PTempMax = 0.0d0 !
  real(DP)   :: ExnerMax = 0.0d0 !
  real(DP)   :: QMixMax = 0.0d0  !
  real(DP)   :: Xc = 0.0d0       !濴(X)
  real(DP)   :: Yc = 0.0d0       !濴(Y)
  real(DP)   :: Zc = 0.0d0       !濴(ľ)
  real(DP)   :: Xr = 0.0d0       !Ⱦ(X)
  real(DP)   :: Yr = 0.0d0       !Ⱦ(Y)
  real(DP)   :: Zr = 0.0d0       !Ⱦ(ľ)
  ! Therma-Random 
  real(DP)   :: Zpos = 0.0d0     ! Z ɸ [m] 
  ! Rectangle 
  real(DP)   :: XposMin = 0.0d0    ! X ɸ [m] 
  real(DP)   :: YposMin = 0.0d0    ! Y ɸ [m] 
  real(DP)   :: ZposMin = 0.0d0    ! Z ɸ [m] 
  real(DP)   :: XposMax = 0.0d0    ! X ɸ [m] 
  real(DP)   :: YposMax = 0.0d0    ! Y ɸ [m] 
  real(DP)   :: ZposMax = 0.0d0    ! Z ɸ [m] 

  real(DP)   :: TempTr = 100.0d0     !ή̤β [k]
  real(DP)   :: Dhight = 10.0d3       !ŤߴؿΥѥ᡼ [m]

  integer               :: IDBasic                = 0
  integer, parameter    :: IDBasicArare4          = 1
  integer, parameter    :: IDBasicArare4mmc       = 2
  integer, parameter    :: IDBasicYamasaki1983    = 3
  integer, parameter    :: IDBasicTakemi2007      = 4
  integer, parameter    :: IDBasicIsoThermal      = 5
  integer, parameter    :: IDBasicDry             = 6
  integer, parameter    :: IDBasicMoist           = 7
  integer, parameter    :: IDBasicToon2002        = 8
  integer               :: IDDisturbPTemp         = 0
  integer, parameter    :: IDDisturbPTempGaussXY  = 1
  integer, parameter    :: IDDisturbPTempGaussXZ  = 2
  integer, parameter    :: IDDisturbPTempGaussYZ  = 3
  integer, parameter    :: IDDisturbPTempGaussXYZ = 4
  integer, parameter    :: IDDisturbPTempRandom   = 5
  integer, parameter    :: IDDisturbPTempRectangle= 6
  integer, parameter    :: IDDisturbPTempCosXZ  = 7
  integer, parameter    :: IDDisturbPTempCosYZ  = 8
  integer               :: IDDisturbExner         = 0
  integer, parameter    :: IDDisturbExnerGaussXY  = 1
  integer, parameter    :: IDDisturbExnerGaussXZ  = 2
  integer, parameter    :: IDDisturbExnerGaussYZ  = 3
  integer, parameter    :: IDDisturbExnerGaussXYZ = 4
  integer               :: IDDisturbQMix          = 0
  integer, parameter    :: IDDisturbQMixGaussXY   = 1
  integer, parameter    :: IDDisturbQMixGaussXZ   = 2
  integer, parameter    :: IDDisturbQMixGaussYZ   = 3
  integer, parameter    :: IDDisturbQMixGaussXYZ  = 4
  integer, parameter    :: IDDisturbQMixDryreg    = 5
  integer, parameter    :: IDDisturbQMixMoist     = 6
  integer               :: IDDisturbWind          = 0
  integer, parameter    :: IDDisturbWindTakemi2007= 1
  integer               :: IDDisturb              = 0
  integer, parameter    :: IDDisturbArare4        = 1
  integer, parameter    :: IDDisturbArare4mmc     = 2
  

  !------------------------------------------
  ! ³ ; Initialize procedure 
  !
  call MainInit

  Time = 0.0d0
  call MessageNotify( "M", "main", "Making Initial data...." )

  !---------------------------------------------------------------  
  ! ܾ. 
  !
  select case(IDBasic)
    
  case (IDBasicArare4)
    ! deepconv/arare4 Υҥȥ꡼ե뤫ͤɤ߹
    !
    call MessageNotify( "M", "main", "Making Initial data using arare4 files ...." )
    call Arare4fileio_BZ_Get( &
      & xyz_PressBZ,   & ! (out)
      & xyz_ExnerBZ,   & ! (out)
      & xyz_TempBZ,    & ! (out)
      & xyz_PTempBZ,   & ! (out)
      & xyz_DensBZ,    & ! (out)
      & xyz_VelSoundBZ,& ! (out)
      & xyzf_QMixBZ,   & ! (out)
      & xyz_EffMolWtBZ & ! (out)
      & )

  case (IDBasicArare4mmc)
    ! deepconv/arare4 ǤΥҥȥ꡼ե뤫ͤɤ߹
    !    
    call MessageNotify( "M", "main", "Making Initial data using arare4 files ...." )

    call Arare4fileio_MMC_BZ_Get( &
      & xyz_PressBZ,   & ! (out)
      & xyz_ExnerBZ,   & ! (out)
      & xyz_TempBZ,    & ! (out)
      & xyz_PTempBZ,   & ! (out)
      & xyz_DensBZ,    & ! (out)
      & xyz_VelSoundBZ,& ! (out)
      & xyzf_QMixBZ,   & ! (out)
      & xyz_EffMolWtBZ & ! (out)
      & )
    
  case(IDBasicIsoThermal) 
    ! /Ϲθʤ
    !  
    call MessageNotify( "M", "main", "Making Initial data (basic) named IsoThermal..." )
    
    z_TempBZ = TempSfc
    z_PressBZ = PressSfc
    zf_MolFr = 0.0d0
    
    ! Ĥδܾͤ
    call DetermineBZ            

  case(IDBasicDry) 
    ! ǮŪʽ
    !
    call MessageNotify( "M", "main", "Making Initial data (basic) named DRY..." )
    call eccm_dry( SpcWetMolFr(1:ncmax), Humidity, z_TempBZ, z_PressBZ, zf_MolFr )
    if (minval(z_TempBZ(1:nz)) < TempTr) then 
      call initialdata_basic_strat( z_TempBZ, z_PressBZ ) !(inout)
    end if
    
    ! Ĥδܾͤ
    call DetermineBZ            
    
! ǥХåѤǤʤ
!   
!  case(IDBasicMoist) 
!    ! ǮŪʽ
!    !
!    call MessageNotify( "M", "main", "Making Initial data (basic) named MOIST..." )
!    call eccm_wet( SpcWetMolFr(1:ncmax), Humidity, z_TempBZ, z_PressBZ, zf_MolFr )
!    call initialdata_basic_strat( z_TempBZ, z_PressBZ ) !(inout)
!
!    ! Ĥδܾͤ
!    call DetermineBZ            

  case(IDBasicToon2002) 
    ! 
    !
    call MessageNotify( "M", "main", "Making Initial data (basic) named Toon et al. 2002..." )
    call initialdata_toon2002_basic( z_TempBZ, z_PressBZ ) !(out)
!    call initialdata_basic_strat( z_TempBZ, z_PressBZ ) !(inout)

    ! Ĥδܾͤ
    call DetermineBZ            
    
  case(IDBasicTakemi2007)
    ! Takemi(2007)δܾѤ
    !
    call MessageNotify( "M", "main", "Making Initial data named Takemi2007..." )
    call initialdata_takemi2007_basic( z_TempBZ, z_PressBZ, zf_MolFr )

    ! Ĥδܾͤ
    call DetermineBZ            

  case(IDBasicYamasaki1983) 
    ! Yamasaki(1983)β٤м٤δ¬ͤѤ 
    !
    call MessageNotify( "M", "main", "Making Initial data named Yamasaki1983..." )
    call initialdata_yamasaki1983_basic( z_TempBZ, z_PressBZ, zf_MolFr )
    
    ! Ĥδܾͤ
    call DetermineBZ            

  end select

  !---------------------------------------------------------
  ! ͤ
  ! 

  ! : ͤ
  !    
  select case(IDDisturbPTemp)

  case(IDDisturbPTempCosXZ)
    ! : cos ʬۤͿ (XZ)
    call MessageNotify( "M", "main", "Making Initial data (disturb) named CosXZ..." )

    xyz_PTemp = 0.0d0

    where ( sqrt( ( (xyz_X - Xc)/Xr)**2 + ((xyz_Z - Zc)/Zr)**2 ) .le. 1.0d0 )
      xyz_PTemp = PTempMax * (     &
      &          cos( Pi * sqrt( ((xyz_X - Xc)/Xr)**2 + ((xyz_Z - Zc)/Zr)**2 ) ) &
      &          + 1.0d0 ) * 0.5d0
    end where

    call SetMargin_xyz( xyz_PTemp )

  case(IDDisturbPTempCosYZ)
    ! : cos ʬۤͿ (YZ)
    call MessageNotify( "M", "main", "Making Initial data (disturb) named CosYZ..." )

    xyz_PTemp = 0.0d0

    where ( sqrt( ( (xyz_Y - Yc)/Yr)**2 + ((xyz_Z - Zc)/Zr)**2 ) .le. 1.0d0 )
      xyz_PTemp = PTempMax * (     &
      &          cos( Pi * sqrt( ((xyz_Y - Yc)/Yr)**2 + ((xyz_Z - Zc)/Zr)**2 ) ) &
      &          + 1.0d0 ) * 0.5d0
    end where
      
    call SetMargin_xyz( xyz_PTemp )

  case(IDDisturbPTempGaussXY)
    ! : ʬۤͿ (XY)
    !          
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussXY..." )
    call initialdata_disturb_gaussXY(PTempMax, Xc, Xr, Yc, Yr, xyz_PTemp)
    call SetMargin_xyz( xyz_PTemp )

  case(IDDisturbPTempGaussXZ)
    ! : ʬۤͿ (XZ)
    !                
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussXZ..." )
    call initialdata_disturb_gaussXZ(PTempMax, Xc, Xr, Zc, Zr, xyz_PTemp)
    call SetMargin_xyz( xyz_PTemp )

  case(IDDisturbPTempGaussYZ)
    ! : ʬۤͿ (YZ)
    !                
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussYZ..." )
    call initialdata_disturb_gaussYZ(PTempMax, Yc, Yr, Zc, Zr, xyz_PTemp)
    call SetMargin_xyz( xyz_PTemp )

  case(IDDisturbPTempGaussXYZ)
    ! : ʬۤͿ (XYZ)
    !                   
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussXYZ..." )
    call initialdata_disturb_gaussXYZ(PTempMax, Xc, Xr, Yc, Yr, Zc, Zr, xyz_PTemp)
    call SetMargin_xyz( xyz_PTemp )

  case(IDDisturbPTempRandom)
    ! : ꤵ줿٤˥ʬۤͿ. 
    !                      
    call MessageNotify( "M", "main", "Making Initial data (disturb) named random..." )
    call initialdata_disturb_random(PTempMax, Zpos, xyz_PTemp)
    call SetMargin_xyz( xyz_PTemp )

  case(IDDisturbPTempRectangle)
    ! : ʾͿ
    !                      
    call MessageNotify( "M", "main", "Making Initial data (disturb) named Rectangle..." )
    call initialdata_disturb_rectangle(PTempMax, XposMin, XposMax, YposMin, YposMax, ZposMin, ZposMax, xyz_PTemp)
    call SetMargin_xyz( xyz_PTemp )
    
  end select

  
  ! ʡؿ: ͤ    
  !                
  select case(IDDisturbExner)

  case(IDDisturbExnerGaussXY)
    ! ʡؿ: ʬۤͿ (XY)
    !                         
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussXY..." )
    call initialdata_disturb_gaussXY(ExnerMax, Xc, Xr, Yc, Yr, xyz_Exner)
    call SetMargin_xyz( xyz_Exner )

  case(IDDisturbExnerGaussXZ)
    ! ʡؿ: ʬۤͿ (XZ)
    !                            
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussXZ..." )
    call initialdata_disturb_gaussXZ(ExnerMax, Xc, Xr, Zc, Zr, xyz_Exner)
    call SetMargin_xyz( xyz_Exner )

  case(IDDisturbExnerGaussYZ)
    ! ʡؿ: ʬۤͿ (YZ)
    !                            
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussYZ..." )
    call initialdata_disturb_gaussYZ(ExnerMax, Yc, Yr, Zc, Zr, xyz_Exner)
    call SetMargin_xyz( xyz_Exner )

  case(IDDisturbExnerGaussXYZ)      
    ! ʡؿ: ʬۤͿ (XYZ)
    !                      
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussXYZ..." )
    call initialdata_disturb_gaussXYZ(ExnerMax, Xc, Xr, Yc, Yr, Zc, Zr, xyz_Exner)
    call SetMargin_xyz( xyz_Exner )

  end select


  ! : ͤ
  !                    
  select case(IDDisturbQMix)

  case(IDDisturbQMixGaussXY)
    ! : ʬۤͿ (XY)
    !                               
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussXY..." )
    call initialdata_disturb_gaussXY(QMixMax, Xc, Xr, Yc, Yr, xyzf_QMix(:,:,:,1))
    call SetMargin_xyzf( xyzf_QMix )
    
  case(IDDisturbQMixGaussXZ)
    ! : ʬۤͿ (XZ)
    !                                      
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussXZ..." )
    call initialdata_disturb_gaussXZ(QMixMax, Xc, Xr, Zc, Zr, xyzf_QMix(:,:,:,1))
    call SetMargin_xyzf( xyzf_QMix )

  case(IDDisturbQMixGaussYZ)
    ! : ʬۤͿ (YZ)
    !                                      
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussYZ..." )
    call initialdata_disturb_gaussYZ(QMixMax, Yc, Yr, Zc, Zr, xyzf_QMix(:,:,:,1))
    call SetMargin_xyzf( xyzf_QMix )

  case(IDDisturbQMixGaussXYZ)
    ! : ʬۤͿ (XYZ)
    !                                      
    call MessageNotify( "M", "main", "Making Initial data (disturb) named GaussXYZ..." )
    call initialdata_disturb_gaussXYZ(QMixMax, Xc, Xr, Yc, Yr, Zc, Zr, xyzf_QMix(:,:,:,1))
    call SetMargin_xyzf( xyzf_QMix )

  case(IDDisturbQMixDryreg)
    ! : ΰ
    !                            
    call MessageNotify( "M", "main", "Making Initial data (disturb) named Dryreg..." )
    call initialdata_disturb_Dryreg(XposMin, XposMax, YposMin, YposMax, ZposMin, ZposMax, xyzf_QMix)
    call SetMargin_xyzf( xyzf_QMix )

  case(IDDisturbQMixMoist)
    ! : ǮŪʬۤͿ 
    !                                  
    call MessageNotify( "M", "main", "Making Initial data (disturb) named MOIST..." )
    call initialdata_disturb_moist(Humidity, xyzf_QMix)
    call SetMargin_xyzf( xyzf_QMix )
    
  end select

  ! : ®پͤ
  !                    
  select case(IDDisturbWind)  
  case (IDDisturbWindTakemi2007)  
    ! Takemi (2007) ®ʬ
    !
    call MessageNotify( "M", "main", "Making Initial data (disturb) named Wind takemi2007..." )
    call initialdata_takemi2007_wind( pyz_VelX ) 
    call SetMargin_pyz( pyz_VelX )   

  end select

  ! 礷ƾͿ
  !
  select case(IDDisturb)  
  case (IDDisturbArare4)    
    call MessageNotify( "M", "main", "Making Initial data using arare4 files ...." )
    call Arare4fileio_Var_Get( &
      & pyz_VelX,     & ! (out)
      & xqz_VelY,     & ! (out)
      & xyr_VelZ,     & ! (out)
      & xyz_PTemp,    & ! (out)
      & xyz_Exner,    & ! (out)
      & xyzf_QMix,    & ! (out)
      & xyz_Km,       & ! (out)
      & xyz_Kh,       & ! (out)
      & xyz_CDens   )   ! (out)

  case (IDDisturbArare4mmc)    
    call MessageNotify( "M", "main", "Making Initial data using arare4 files ...." )
    call Arare4fileio_MMC_Var_Get( &
      & pyz_VelX,     & ! (out)
      & xqz_VelY,     & ! (out)
      & xyr_VelZ,     & ! (out)
      & xyz_PTemp,    & ! (out)
      & xyz_Exner,    & ! (out)
      & xyzf_QMix,    & ! (out)
      & xyz_Km,       & ! (out)
      & xyz_Kh,       & ! (out)
      & xyz_CDens   )   ! (out)
  end select

  !------------------------------------------------
  ! ե
  !
  call MessageNotify( "M", "main", "Output variables into netCDF file..." )

  ! ꥹȥե. ܾȾ. 
  !
  call ReStartFileIO_Init

  call HistoryPut( 't',     Time,      rstat)
  call HistoryPut( 'VelX',  pyz_VelX,  rstat)
  call HistoryPut( 'VelY',  xqz_VelY,  rstat)
  call HistoryPut( 'VelZ',  xyr_VelZ,  rstat)
  call HistoryPut( 'Exner', xyz_Exner, rstat)
  call HistoryPut( 'PTemp', xyz_PTemp, rstat)
  call HistoryPut( 'Km',    xyz_Km,    rstat)
  call HistoryPut( 'Kh',    xyz_Kh,    rstat)
  call HistoryPut( 'QMix',  xyzf_QMix, rstat)    
  call HistoryPut( 'CDens', xyz_CDens, rstat)    

  ! ܾΥե
  !
  call HistoryPut( 'DensBZ',     xyz_DensBZ    , rstat)
  call HistoryPut( 'ExnerBZ',    xyz_ExnerBZ   , rstat)
  call HistoryPut( 'PTempBZ',    xyz_PTempBZ   , rstat)
  call HistoryPut( 'VelSoundBZ', xyz_VelSoundBZ, rstat)
  call HistoryPut( 'TempBZ',     xyz_TempBZ    , rstat)
  call HistoryPut( 'PressBZ',    xyz_PressBZ   , rstat)
  call HistoryPut( 'QMixBZ',     xyzf_QMixBZ   , rstat)
  call HistoryPut( 'EffMolWtBZ', xyz_EffMolWtBZ, rstat)
  call HistoryPut( 'HumBZ',      xyzf_HumBZ    , rstat)
  
  call ReStartFileIO_Finalize

  !----------------------------------------------------
  ! MPI END
  !
  call MPIWrapperFinalize
  
contains

  subroutine ArareAlloc
    !
    !Ȥ, , ͤȤƥ.
    !

    !ۤηػ
    implicit none

    !
    allocate( pyz_VelX(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xqz_VelY(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyr_VelZ(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_Exner(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_PTemp(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_Km(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_Kh(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_CDens(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyzf_QMix(imin:imax, jmin:jmax, kmin:kmax, ncmax) )

    allocate( xyz_DensBZ(imin:imax,jmin:jmax,kmin:kmax))
    allocate( xyz_PressBZ(imin:imax,jmin:jmax,kmin:kmax))
    allocate( xyz_ExnerBZ(imin:imax,jmin:jmax,kmin:kmax))
    allocate( xyz_TempBZ(imin:imax,jmin:jmax,kmin:kmax))
    allocate( xyz_PTempBZ(imin:imax,jmin:jmax,kmin:kmax))
    allocate( xyz_VelSoundBZ(imin:imax,jmin:jmax,kmin:kmax))
    allocate( xyzf_QMixBZ(imin:imax,jmin:jmax,kmin:kmax,ncmax))
    allocate( xyz_EffMolWtBZ(imin:imax,jmin:jmax,kmin:kmax))
    allocate( z_TempBZ(kmin:kmax))
    allocate( z_PressBZ(kmin:kmax))
    allocate( xyzf_MolFr(imin:imax, jmin:jmax, kmin:kmax, ncmax))
    allocate( zf_MolFr(kmin:kmax, ncmax))
    allocate( xyzf_QMixDivMolWt(imin:imax,jmin:jmax,kmin:kmax, ncmax))
    allocate( xyzf_HumBZ(imin:imax,jmin:jmax,kmin:kmax, ncmax))

    pyz_VelX = 0.0d0
    xqz_VelY = 0.0d0
    xyr_VelZ = 0.0d0
    xyz_PTemp = 0.0d0
    xyz_Exner = 0.0d0
    xyz_Km = 0.0d0
    xyz_Kh = 0.0d0
    xyz_CDens = 0.0d0
    xyzf_QMix = 0.0d0

    xyz_DensBZ = 0.0d0
    xyz_PressBZ = 0.0d0
    xyz_ExnerBZ = 0.0d0
    xyz_TempBZ = 0.0d0
    xyz_PTempBZ = 0.0d0
    xyz_VelSoundBZ = 0.0d0
    xyzf_QMixBZ = 0.0d0
    xyz_EffMolWtBZ  = 0.0d0
    z_TempBZ  = 0.0d0
    z_PressBZ = 0.0d0
    xyzf_MolFr = 0.0d0
    zf_MolFr = 0.0d0 
    xyzf_QMixDivMolWt = 0.0d0
    xyzf_HumBZ = 0.0d0

  end subroutine ArareAlloc
    

  subroutine DetermineBZ

    !---------------------------------------------------------------
    ! ١
    !

    ! 3 ˳Ǽ
    do k = 1, nz
      do j = 1, ny
        do i = 1, nx
          xyz_TempBZ(i,j,k)  = z_TempBZ(k)  
          xyz_PressBZ(i,j,k) = z_PressBZ(k)
        end do
      end do
    end do
    
    !Τͤ
    !
    call SetMargin_xyz( xyz_TempBZ )
    call SetMargin_xyz( xyz_PressBZ)

    !---------------------------------------------------------------
    ! 
    !
    !ʿˤϰ
    do k = 1, nz
      do j = 1, ny
        do i = 1, nx
          xyzf_MolFr(i,j,k,:) = zf_MolFr(k,:)
        end do
      end do
    end do

    !Τͤ
    ! 
    call SetMargin_xyzf( xyzf_MolFr )

    !Υ򺮹Ѵ
    do s = 1, ncmax
      xyzf_QMixBZ(:,:,:,s) = xyzf_MolFr(:,:,:,s) * MolWtWet(s) / MolWtDry
    end do
    
    !  !ͤʤꤹʤ褦˺ͤͿ
    !  where (xyzf_QMixBZ <= 1.0d-20 )
    !    xyzf_QMixBZ = 1.0d-20
    !  end where
    
    !Τͤ
    !
    call SetMargin_xyzf( xyzf_QMixBZ )
    
    !---------------------------------------------------------------
    ! ʬ̤θ
    !
    do s = 1, ncmax
      xyzf_QMixDivMolWt(:,:,:,s) = xyzf_QMixBZ(:,:,:,s) / MolWtWet(s)
    end do
    
    xyz_EffMolWtBZ = &
      & (1.0d0 + sum(xyzf_QMixBZ,4) ) &
      & / ( MolWtDry * ((1.0d0 / MolWtDry) + sum(xyzf_QMixDivMolWt,4)) )
    
    !Τͤ  
    !
    call SetMargin_xyz( xyz_EffMolWtBZ )
    
    !---------------------------------------------------------------    
    ! 
    !
    xyz_PTempBZ = &
      & xyz_TempBZ * (PressBasis / xyz_PressBZ) ** (GasRDry / CpDry) 

    !Τͤ  
    !
    call SetMargin_xyz( xyz_PTempBZ )
    
    !---------------------------------------------------------------    
    ! ʡؿ
    !
    xyz_ExnerBZ = xyz_TempBZ / xyz_PTempBZ    
    
    !Τͤ
    !
    call SetMargin_xyz( xyz_ExnerBZ )

    !---------------------------------------------------------------    
    ! ̩
    !    
    xyz_DensBZ = &
      & PressBasis * (xyz_ExnerBZ ** (CvDry / GasRDry)) &
      &  / (GasRDry * xyz_PTempBZ / xyz_EffMolWtBZ)
    
    !Τͤ
    !
    call SetMargin_xyz( xyz_DensBZ )
    
    !---------------------------------------------------------------    
    ! ®
    !
    xyz_VelSoundBZ = &
      & sqrt ( &
      &   CpDry * GasRDry * xyz_ExnerBZ * xyz_PTempBZ &
      &   / (CvDry * xyz_EffMolWtBZ) &
      & )
    
    !Τͤ
    !
    call SetMargin_xyz( xyz_VelSoundBZ )

    !---------------------------------------------------------------    
    ! 
    !
    if (CondNum >= 1) then 
      do s = 1, CondNum
        xyzf_HumBZ(:,:,:,IdxCG(s)) = &
          & xyz_PressBZ * xyzf_MolFr(:,:,:,IdxCG(s)) &
          & / xyz_SvapPress(SpcWetID(IdxCC(s)), xyz_TempBZ) &
          & * 100.0d0
      end do
    end if

    !----------------------------------------------------------
    ! BasicSet ⥸塼ͤ
    !
    call BasicSet_Init(                           &
      & xyz_PressBZ, xyz_ExnerBZ, xyz_TempBZ,     &
      & xyz_PTempBZ, xyz_DensBZ,  xyz_VelSoundBZ, &
      & xyzf_QMixBZ, xyz_EffMolWtBZ )
    
  end subroutine DetermineBZ


  subroutine Initialdata_init

    use dc_iounit,     only : FileOpen    

    implicit none

    integer                       :: unit     !ֹ

    character(STRING) :: FlagBasic        = ""
    character(STRING) :: FlagDisturbPTemp = ""
    character(STRING) :: FlagDisturbExner = ""
    character(STRING) :: FlagDisturbQMix  = ""
    character(STRING) :: FlagDisturbWind  = ""
    character(STRING) :: FlagDisturb      = ""

    NAMELIST /initialdata_nml/ &
      & FlagBasic,        & 
      & FlagDisturb,      &
      & FlagDisturbPTemp, &    
      & FlagDisturbExner, &    
      & FlagDisturbQMix,  &    
      & FlagDisturbWind  

    NAMELIST /initialdata_basic_nml/ &
      & Humidity, TempTr, DHight

    NAMELIST /initialdata_disturb_gauss_nml/ &
      & PTempMax, ExnerMax, QMixMax, Xc, Xr, Yc, Yr, Zc, Zr

    NAMELIST /initialdata_disturb_cos_nml/ &
      & PTempMax, ExnerMax, QMixMax, Xc, Xr, Yc, Yr, Zc, Zr

    NAMELIST /initialdata_disturb_random_nml/ &
      & PTempMax, ExnerMax, QMixMax, Zpos

    NAMELIST /initialdata_disturb_rectangle_nml/ &
      & QMixMax, PTempMax, XposMin, YposMin, ZposMin, XposMax, YposMax, ZposMax

!    NAMELIST /initialdata_disturb_dryreg_nml/ &
!      & XposMin, YposMin, ZposMin, XposMax, YposMax, ZposMax

    NAMELIST /initialdata_disturb_moist_nml/ &
      & Humidity

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=initialdata_nml)
    close(unit)
    
    if (FlagBasic == "Arare4") then 
      IDBasic = IDBasicArare4
    elseif(FlagBasic == "Arare4mmc") then 
      IDBasic = IDBasicArare4mmc
    elseif(FlagBasic == "Yamasaki1983") then 
      IDBasic = IDBasicYamasaki1983
    elseif(FlagBasic == "Takemi2007") then 
      IDBasic = IDBasicTakemi2007
    elseif(FlagBasic == "IsoThermal") then 
      IDBasic = IDBasicIsoThermal
    elseif(FlagBasic == "Dry"       ) then 
      IDBasic = IDBasicDry
    elseif(FlagBasic == "Moist"     ) then 
      IDBasic = IDBasicMoist
    elseif(FlagBasic == "Toon2002"  ) then 
      IDBasic = IDBasicToon2002
    end if

    if(FlagDisturbPTemp == "GaussXY" ) then     
      IDDisturbPTemp = IDDisturbPTempGaussXY
    elseif(FlagDisturbPTemp == "GaussXZ" ) then     
      IDDisturbPTemp = IDDisturbPTempGaussXZ
    elseif(FlagDisturbPTemp == "GaussYZ" ) then     
      IDDisturbPTemp = IDDisturbPTempGaussYZ
    elseif(FlagDisturbPTemp == "GaussXYZ") then     
      IDDisturbPTemp = IDDisturbPTempGaussXYZ
    elseif(FlagDisturbPTemp == "Random"  ) then     
      IDDisturbPTemp = IDDisturbPTempRandom
    elseif(FlagDisturbPTemp == "Rectangle"  ) then     
      IDDisturbPTemp = IDDisturbPTempRectangle
    elseif(FlagDisturbPTemp == "CosXZ"  ) then     
      IDDisturbPTemp = IDDisturbPTempCosXZ
    elseif(FlagDisturbPTemp == "CosYZ"  ) then     
      IDDisturbPTemp = IDDisturbPTempCosYZ
    end if

    if(FlagDisturbExner == "GaussXY" ) then     
      IDDisturbExner = IDDisturbExnerGaussXY 
    elseif(FlagDisturbExner == "GaussXZ" ) then     
      IDDisturbExner = IDDisturbExnerGaussXZ 
    elseif(FlagDisturbExner == "GaussYZ" ) then     
      IDDisturbExner = IDDisturbExnerGaussYZ 
    elseif(FlagDisturbExner == "GaussXYZ") then    
      IDDisturbExner = IDDisturbExnerGaussXYZ  
    end if

    if(FlagDisturbQMix == "GaussXY"  ) then     
      IDDisturbQMix = IDDisturbQMixGaussXY
    elseif(FlagDisturbQMix == "GaussXZ"  ) then 
      IDDisturbQMix = IDDisturbQMixGaussXZ   
    elseif(FlagDisturbQMix == "GaussYZ"  ) then 
      IDDisturbQMix = IDDisturbQMixGaussYZ   
    elseif(FlagDisturbQMix == "GaussXYZ" ) then 
      IDDisturbQMix = IDDisturbQMixGaussXYZ    
    elseif(FlagDisturbQMix == "Dryreg" ) then
      IDDisturbQMix = IDDisturbQMixDryreg
    elseif(FlagDisturbQMix == "Moist"    ) then    
      IDDisturbQMix = IDDisturbQMixMoist
    end if

    if (FlagDisturbWind == "Takemi2007") then
      IDDisturbWind = IDDisturbWindTakemi2007
    end if

    if(FlagDisturb == "Arare4"        ) then    
      IDDisturb = IDDisturbArare4
    elseif(FlagDisturb == "Arare4mmc" ) then    
      IDDisturb = IDDisturbArare4mmc
    end if

    !----------------------------------------------------
    ! ⥸塼ν
    !
    !   Yamasaki, ץ, ɬפʤ. 
    !
    select case (IDDisturbPTemp)
    case (IDDisturbPTempCosXZ)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_disturb_cos_nml)
      close(unit)

    case (IDDisturbPTempCosYZ)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_disturb_cos_nml)
      close(unit)

    case (IDDisturbPTempGaussXY:IDDisturbPTempGaussXYZ)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_disturb_gauss_nml)
      close(unit)

    case (IDDisturbPTempRandom)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_disturb_random_nml)
      close(unit)

    case (IDDisturbPTempRectangle)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_disturb_rectangle_nml)
      close(unit)
    end select

    select case (IDDisturbExner)
    case (IDDisturbExnerGaussXY:IDDisturbExnerGaussXYZ)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_disturb_gauss_nml)
      close(unit)
    end select

    select case (IDDisturbQMix)
    case (IDDisturbQMixGaussXY:IDDisturbQMixGaussXYZ)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_disturb_gauss_nml)
      close(unit)

    case(IDDisturbQMixDryreg)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_disturb_rectangle_nml)
      close(unit)

    case(IDDisturbQMixMoist)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_disturb_moist_nml)
      close(unit)
    end select

    select case (IDBasic)
    case (IDBasicDry, IDBasicMoist)
      call FileOpen(unit, file=namelist_filename, mode='r')
      read(unit, NML=initialdata_basic_nml)
      close(unit)
    end select

    if (FlagBasic == "Takemi2007" .OR. FlagDisturbWind == "Takemi2007") then 
      call initialdata_takemi2007_init
    end if

    if (     FlagBasic == "Arare4"        &
      & .OR. FlagDisturb == "Arare4"      &
      & .OR. FlagBasic   == "Arare4mmc"   &
      & .OR. FlagDisturb == "Arare4mmc") then 
      call arare4fileio_init
    end if

    if (myrank == 0) then 
      call MessageNotify( "M", "main", "FlagBasic        = %c", c1=trim(FlagBasic))
      call MessageNotify( "M", "main", "IDBasic          = %d", i=(/IDBasic/))
      call MessageNotify( "M", "main", "FlagDisturbPTemp = %c", c1=trim(FlagDisturbPTemp))
      call MessageNotify( "M", "main", "IDDisturbPTemp   = %d", i=(/IDDisturbPTemp/))
      call MessageNotify( "M", "main", "FlagDisturbExner = %c", c1=trim(FlagDisturbExner))
      call MessageNotify( "M", "main", "IDDisturbExner   = %d", i=(/IDDisturbExner/))
      call MessageNotify( "M", "main", "FlagDisturbQMix  = %c", c1=trim(FlagDisturbQMix))
      call MessageNotify( "M", "main", "IDDisturbQMix    = %d", i=(/IDDisturbQMix/))
      call MessageNotify( "M", "main", "FlagDisturb      = %c", c1=trim(FlagDisturb))
      call MessageNotify( "M", "main", "IDDisturb        = %d", i=(/IDDisturb/))
    end if

  end subroutine Initialdata_init


!!!--------------------------------------------------------------
  subroutine initialdata_basic_strat(z_TempBZ, z_PressBZ)
    !
    implicit none
    
    real(DP), intent(inout) :: z_TempBZ(kmin:kmax)
    real(DP), intent(inout) :: z_PressBZ(kmin:kmax)
    real(DP)                :: HeightTr
    real(DP)                :: z_DTempDZ(kmin:kmax)
    real(DP)                :: DTempDZ
    real(DP)                :: Weight
    integer                 :: k    
    
    do k = 1, kmax
      z_DTempDZ(k) = (z_TempBZ(k) - z_TempBZ(k-1)) / z_dz(k-1)
    end do

    ! ή
    !
    HeightTr =  minval(z_z(1:nz), 1, z_TempBZ(1:nz) < TempTr)
    
    ! ή̤ΰ
    !   ̤絤Ȥ. 絤絤ؤܤ 
    !   tanh ѤƤʤ餫ˤĤʤ
    do k = 2, kmax
      
      !ŤߤĤδؿѰ. tanh Ѥ
      Weight = ( tanh( (z_Z(k) - HeightTr ) / Dhight ) + 1.0d0 ) * 5.0d-1
      
      !ͤȤƲ٤׻. ̤Ǥ TempTr 絤˶Ť
      z_TempBZ(k) = z_TempBZ(k) * ( 1.0d0 - Weight ) + TempTr * Weight
      
      !ٸΨǮٸΨ꾮ʤʤ褦
      DTempDZ = max( z_DTempDZ(k), (z_TempBZ(k) - z_TempBZ(k-1)) / z_dz(k-1) )
      
      !ܾβ٤
      z_TempBZ(k) = z_TempBZ(k-1) + DTempDZ * z_dz(k-1) 
      
      !Ϥſ尵ʿդ׻
      z_PressBZ(k) =                                          &
        &  z_PressBZ(k-1) * ( ( z_TempBZ(k-1) / z_TempBZ(k) ) &
        &    ** (Grav / ( DTempDZ * GasRDry ) ) )
    end do
    
  end subroutine initialdata_basic_strat


  subroutine MainInit

    implicit none

    character(STRING)     :: cfgfile = ""    

    ! MPI
    !
    call MPIWrapperInit
    
    !NAMELIST ե̾ɤ߹
    !
    call argset_init(cfgfile) !(out)
    
    ! NAMELIST ե̾Υ⥸塼ؤϿ
    ! Loading NAMELIST file.
    !
    call NmlutilInit( cfgfile ) !(in)
    
    !ʻν
    !  NAMELIST , ʻ׻
    !
    call gridset_init
    
    ! ط׻롼ν
    ! Initialization of chemical routines.
    !
    call chemcalc_init
    
    ! ξν
    ! Initialization of axis variables.
    !
    call axesset_init
    
    ! ξν
    ! Initialization of constant variables.
    !
    call constants_init
    
    ! ͭѿν
    ! Initialization of common variables for moist process.
    !
    call composition_init
    
    ! I/O ե̾ν
    ! Initialization of output file name. 
    !
    call fileset_init
    
    ! nml Ф (֥롼)
    !
    call InitialData_init

    !ѿν. ȤꤢͤꤵƤ. 
    !
    call ArareAlloc  
    
  end subroutine MainInit

end program ArareInitData
