! gtool_frame.f90 - gtool4 graphic objects - frame
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool_frame 

    use gtool_figure
    implicit none
    private
    public:: GT_FRAME, Init, Put, Display, Dispose

    type GT_FRAME
	integer:: n_figures
	type(GT_FIGURE), pointer:: figs(:)
    end type

    interface Init; module procedure init_frame; end interface
    interface Display; module procedure display_frame; end interface
    interface Dispose; module procedure dispose_frame; end interface

    interface Put
	module procedure put_figure
    end interface

contains

    subroutine init_frame(frame)
	type(GT_FRAME), intent(out):: frame
    continue
	nullify(frame%figs)
	frame%n_figures = 0
    end subroutine

    subroutine dispose_frame(frame)
	type(GT_FRAME), intent(inout):: frame
    continue
	if (associated(frame%figs)) deallocate(frame%figs)
	frame%n_figures = 0
    end subroutine

    subroutine display_frame(dev, frame)
	type(GT_DEVICE), intent(inout):: dev
	type(GT_FRAME), intent(in):: frame
	integer:: i
    continue
	do, i = 1, frame%n_figures
	    call Display(dev, frame%figs(i))
	enddo
    end subroutine

    subroutine put_figure(frame, figure)
	type(GT_FRAME), intent(inout):: frame
	type(GT_FIGURE), intent(in):: figure
	type(GT_FIGURE), pointer:: buffer(:)
    continue
	allocate(buffer(frame%n_figures + 1))
	buffer(1: size(buffer) - 1) = frame%figs(:)
	buffer(size(buffer)) = figure
	deallocate(frame%figs)
	frame%figs => buffer
    end subroutine

end module
