!-------------------------------------------------
!  UMpack Module
!-------------------------------------------------
module umpack
  use dcl_common
  contains
!ȉ̂Q͌Ȃ
!UMQCNT(XCNT, YCNT, ROT)				DclGetMapContactPoint
!UMQCWD(XCNTR, YCNTR, R)				DclGetCircleWindow

!-------------------------------------------------
    subroutine DclSetMapContactPoint(lon, lat, rot)  !eʂ́uړ_vw肷D
      real, intent(in), optional :: lon, lat, rot 

      call prcopn('DclSetMapContactPoint')
      call glrget('rundef', rundef)

      x0   = rundef
      y0   = rundef
      rot0 = rundef

      if(present(lon))  x0   = lon
      if(present(lat))  y0   = lat
      if(present(rot))  rot0 = rot
      
      call umscnt(x0, y0, rot0) 
      call prccls('DclSetMapContactPoint')
    end subroutine
!-------------------------------------------------
    subroutine DclSetCircleWindow(lon, lat, r)  !~`̃EBhEݒ肷D
      real,intent(in), optional :: lon, lat, r  

      call prcopn('DclSetCircleWindow')
      call glrget('rundef', rundef)

      x0 = rundef
      y0 = rundef
      r0 = rundef

      if(present(lon)) x0 = lon
      if(present(lat)) y0 = lat
      if(present(r))   r0 = r
      
      call umscwd(x0, y0, r0) 
      call prccls('DclSetCircleWindow')
    end subroutine
!-------------------------------------------------
    subroutine DclSetMapPoint(lon, lat)        !n}Ɋ܂߂_w肷D
      real, intent(in), dimension(:) :: lon, lat  !_̌oxCܓx

      call prcopn('DclSetMapPoint')
      nx = size(lon)
      ny = size(lat)

      if(nx.ne.ny) call msgdmp('M', 'DclSetMapPoint', 'Length of x and y don''t match.')

      n = min(nx, ny)
      call umspnt(n, lon, lat)
      call prccls('DclSetMapPoint')
    end subroutine
!-------------------------------------------------
    subroutine DclFitMapParm()         !n}e̕ϊ֐̃p^K؂Ɍ߂D
      call prcopn('DclFitMapParm')
      call umpfit() 
      call prccls('DclFitMapParm')
    end subroutine
!-------------------------------------------------
    subroutine DclDrawGlobe()          !n}̋Eijƈܓx,ox`D
      call sgoopn('DclDrawGlobe', ' ')
      call umpglb() 
      call sgocls('DclDrawGlobe')
    end subroutine
!-------------------------------------------------
    subroutine DclDrawGrid()           !ܓxEox`D
      call sgoopn('DclDrawGrid', ' ')
      call umpgrd()  
      call sgocls('DclDrawGrid')
    end subroutine
!-------------------------------------------------
    subroutine DclDrawLimb()           !n}̋Eij`D
      call sgoopn('DclDrawLimb', ' ')
      call umplim()
      call sgocls('DclDrawLimb')
    end subroutine
!-------------------------------------------------
    subroutine DclDrawMap(file_name)        !en}`D
      character(len=*), intent(in) :: file_name        !n}t@C
      call sgoopn('DclDrawMap', ' ')
      call umpmap(file_name)
      call sgocls('DclDrawMap')
    end subroutine
!-------------------------------------------------
end module
