! gtool_partial.f90 - gtool4 file interface
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool_partial 

    use netcdf
    use gtool_variable
    implicit none

    private
    public:: Slice, Count, Size
    public:: GtoolVariableSliceName

    interface Slice
	module procedure GtoolVariableSliceName
	module procedure slice_ord
    end interface

    interface Count
	module procedure count_limited, count_all
    end interface

    interface Size
	module procedure size_all
    end interface

contains

    logical function GtoolVariableSliceName(var, dimname, &
	& start, stride, count) result(result)
	type(GT_VARIABLE), intent(in)::		var
	character(len = *), intent(in)::	dimname
	integer, intent(in)::			start
	integer, intent(in), optional::		stride, count
    continue
	result = Slice(var%nclimit, dimname, start, stride, count)
    end function

    logical function slice_ord(var, dimord, start, stride, count) &
	& result(result)
	type(GT_VARIABLE), intent(in)::		var
	integer, intent(in)::			dimord
	integer, intent(in)::			start
	integer, intent(in), optional::		stride, count
    continue
	result = Slice(var%nclimit, dimord, start, stride, count)
    end function

    function count_limited(var, ndims) result(result)
	type(GT_VARIABLE), intent(in):: var
	integer, intent(in):: ndims
	integer:: result(ndims)
    continue
	result(:) = Count(var%nclimit, ndims)
    end function

    function count_all(var) result(result)
	type(GT_VARIABLE), intent(in):: var
	integer:: result(NC_SLICE_DIMS)
    continue
	result(:) = Count(var%nclimit, NC_SLICE_DIMS)
    end function

    integer function size_all(var) result(result)
	type(GT_VARIABLE), intent(in):: var
    continue
	result = Size(var%nclimit)
    end function

end module
