type(VSTRING) function ANVarToString(var) result(result)
    use dc_string, only: VSTRING, sprintf, len, vchar
    use an_types, only: AN_VARIABLE
    type(AN_VARIABLE), intent(in):: var
    type(VSTRING):: fmt, buf
    if (associated(var%allcount)) then
        call sprintf(buf, "AN_VARIABLE(file=%d,var=%d,dim=%d,allcount=%*d,&
            &dimids=%*d,start=%*d,count=%*d,stride=%*d,growable=%d,&
            &attrid=%d)", &
            & i=(/var%fileid, var%varid, var%dimid, var%allcount, &
            & var%dimids, var%start, var%count, var%stride, &
            & var%growable, var%attrid/), &
            & n=(/size(var%allcount), size(var%dimids), size(var%start), &
            & size(var%count), size(var%stride) /))
    else
        call sprintf(buf, "AN_VARIABLE(file=%d,var=%d,dim=%d,with-no-dims)",&
            & i=(/var%fileid, var%varid, var%dimid/))
    endif
    result = buf
end function
