subroutine GTDevOpen(dev, ws_id, err)
    use gtgraph_types, only: GT_DEVICE
    use gtgraph_com, only: gtdev_wsn_default
    use netcdf_f77, only: NF_EINVAL
    use dc_error, only: StoreError
    use sysdep, only: AbortProgram
    use dcl, only: DclOpenGraphics, DclSelectDevice
implicit none
    type(GT_DEVICE), intent(out):: dev
    integer, intent(in), optional:: ws_id
    logical, intent(out), optional:: err
    integer, save:: opened_wsn = 0
    integer:: wsn
continue
    wsn = gtdev_wsn_default
    if (present(ws_id)) wsn = ws_id
    if (opened_wsn /= 0) then
        call StoreError(NF_EINVAL, 'GTDevOpen', err=err, cause_i=wsn)
        return
    else
        if (present(err)) err = .FALSE.
    endif
    if (wsn == 0) then
        !-- R\[ˑR[hBI --!
        wsn = DclSelectDevice()
        gtdev_wsn_default = wsn
    endif
    call DclOpenGraphics(wsn)
    dev%ws_id = wsn
    opened_wsn = wsn
end subroutine

subroutine GTDevClose(dev)
    use gtgraph_types, only: GT_DEVICE
    use dcl, only: DclCloseGraphics
implicit none
    type(GT_DEVICE), intent(inout):: dev
continue
    call DclCloseGraphics()
    dev%ws_id = 0
end subroutine
