! Copyright (C) GFD Dennou Club, 2001.  All rights reserved


subroutine anvargetdouble(var, start, count, stride, imap, value, iostat)
    use an_types, only: an_variable
    use an_vartable, only: an_variable_entry, vtable_lookup
    use netcdf_f77, only: nf_noerr, nf_einval, nf_get_varm_double
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(an_variable), intent(in):: var
    integer, intent(in):: start(:)
    integer, intent(in):: count(:)
    integer, intent(in):: stride(:)
    integer, intent(in):: imap(:)
    double precision, intent(out):: value(*)
    integer, intent(out):: iostat
    integer:: ndims, ipos, i
    type(an_variable_entry), pointer:: ent
    integer, allocatable:: istart(:), istride(:), iimap(:)
continue
    call beginsub('anvargetdouble', &
        & fmt='var=%d, start=%*d, count=%*d, stride=%*d, imap=%*d', &
        & i=(/var%id, start(:), count(:), stride(:), imap(:)/), &
        & n=(/size(start), size(count), size(stride), size(imap)/))
    iostat = vtable_lookup(var, ent)
    if (iostat /= nf_noerr) goto 999
    ! --- ndims check ---
    ndims = 0
    if (associated(ent%dimids)) ndims = size(ent%dimids)
    if (min(size(start), size(count), size(stride), size(imap)) < ndims) then
        iostat = nf_einval
        goto 999
    endif
    ! --- negative stride hack ---
    allocate(istart(ndims + 1), istride(ndims + 1), iimap(ndims + 1))
    istart(1:ndims) = start(1:ndims)
    istride(1:ndims) = stride(1:ndims)
    iimap(1:ndims) = imap(1:ndims)
    ipos = 1
    do, i = 1, ndims
        if (stride(i) > 0) cycle
        ipos = ipos + (count(i) - 1) * imap(i)
        istart(i) = start(i) + (count(i) - 1) * stride(i)
        istride(i) = -stride(i)
        iimap(i) = -imap(i)
        call message('dim %d negate: stride->%d start->%d map->%d', &
            & i=(/i, istride(i), istart(i), iimap(i)/))
    enddo
    ! --- do read ---
    iostat = nf_get_varm_double(ent%fileid, ent%varid, istart, count, istride, &
        & iimap, value(ipos))
    deallocate(istart, istride, iimap)
999 continue
    call endsub('anvargetdouble', 'iostat=%d', i=(/iostat/))
    return
end subroutine
