! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTAxisLoadByName(Axis, varname)
    use gtgraph_types, only: GT_AXIS
    use dc_string, only: VSTRING
    use gtgraph_generic, only: Load
    use gtdata_generic, only: Open, Close
    use gtdata_types, only: GT_VARIABLE
    implicit none
    type(GT_AXIS), intent(out):: axis
    type(VSTRING), intent(in):: varname
    type(GT_VARIABLE):: tmpvar
    call Open(tmpvar, varname)
    call Load(axis, tmpvar)
    call Close(tmpvar)
end subroutine

subroutine GTAxisLoad(Axis, var)
    use gtgraph_types, only: GT_Axis
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr, Open, attr_true, Close
    use gtgraph_generic, only: Open
    use dc_string
    use dc_error
    implicit none
    type(GT_Axis), intent(out):: Axis
    type(GT_VARIABLE), intent(in):: var
    type(GT_VARIABLE):: datavar
    type(VSTRING):: varname
continue
    call get_attr(var, "gt_structure_link_data", varname)
    if (varname == "") then
        call StoreError(GT_EBADLINK, "GTContLoad(data variable)")
        return
    endif
    call Open(datavar, varname)
    call Open(axis, datavar, 0)
    call Close(datavar)
    axis%vertical = attr_true(var, "gt_axis_vertical", default=.false.)
end subroutine

