module gtdata_internal

    use gt_vartable
    implicit none

    interface dimrange
        module procedure dimrange_direct
    end interface

contains

    subroutine dimrange_direct(vid, dimlo, dimhi)
        use an_types, only: an_variable
        use an_generic, only: an_inquire => inquire
        use dc_error, only: storeerror, nf_einval, gt_efake
        integer, intent(in):: vid
        integer, intent(out):: dimlo, dimhi
        integer:: class, cid
        call VarTableLookup(vid, class, cid)
        select case(class)
            case(VTB_CLASS_MEMORY)
                call storeerror(gt_efake, 'gtdata::dimrange')
            case(VTB_CLASS_NETCDF)
                dimlo = 1
                call an_inquire(an_variable(cid), dimlen=dimhi)
            case default
                call storeerror(nf_einval, 'gtdata::dimrange')
        end select
    end subroutine

    integer function ndims(vid) result(result)
        use an_types, only: an_variable
        use an_generic, only: an_inquire => inquire
        use dc_error, only: storeerror, nf_einval
        integer, intent(in):: vid
        integer:: class, cid
        call VarTableLookup(vid, class, cid)
        select case(class)
            case(VTB_CLASS_MEMORY)
                result = 1
            case(VTB_CLASS_NETCDF)
                call an_inquire(an_variable(cid), ndims=result)
            case default
                call storeerror(nf_einval, 'gtdata::ndims')
        end select
    end function

    subroutine query_growable(vid, result)
        use an_types, only: an_variable
        use an_generic, only: inquire 
        use dc_error, only: storeerror, nf_einval
        integer, intent(in):: vid
        logical, intent(out):: result
        integer:: class, cid
        call vartablelookup(vid, class, cid)
        select case(class)
            case(vtb_class_memory)
                result = .false.
            case(vtb_class_netcdf)
                call inquire(an_variable(cid), growable=result)
            case default
                call storeerror(nf_einval, 'gtdata::ndims')
        end select
    end subroutine

end module
