! gtfig.f90 - Definitions of Gtool Figure Subroutines
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

! GTFigPutCont, GTFigPutLine ͂ꂼ
! gtcontlib.f90, gtlinelib.f90 ɂB

subroutine GTFigOpen(fig)
    use gtgraph_types, only: GT_FIGURE
    use dc_string
    use dc_trace, only: beginsub, endsub
    implicit none
    type(GT_FIGURE), intent(out):: fig
    call beginsub('gtfigopen')
    nullify(fig%h_axis)
    nullify(fig%v_axis)
    nullify(fig%contours)
    nullify(fig%line)
    fig%animate = .FALSE.
    fig%title = 'untitled'
    call endsub('gtfigopen')
end subroutine

subroutine GtFigOption(fig, optname, value, err)
    use gtgraph_types, only: GT_FIGURE
    use gtgraph_generic, only: Option
    use dc_string, only: assignment(=)
    use dc_string, only: stoi, stod, toUpper, get_array
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(GT_FIGURE), intent(inout):: fig
    character(len = *), intent(in):: optname
    character(len = *), intent(in):: value
    character(len = len(optname)):: uc_name
    logical, intent(out):: err
continue
    call beginsub('gtfigoption', '<%c>=<%c>', c1=optname, c2=value)
    err = .FALSE.
    uc_name = optname
    call toUpper(uc_name)
    select case(uc_name)
    case("TITLE")
        fig%title = value
    case("-ANIMATE")
        fig%animate = .TRUE.
        call message('figure animation enabled')
    case("-NEXT")
        if (fig%animate) then
            call internal_next_slice
        else
            call message('figure animation disabled, so -next ignored')
            err = .TRUE.
        endif
    case default
        err = .TRUE.
    end select
    call endsub('gtfigoption')
    return
contains

    subroutine internal_next_slice
        integer:: i
        logical:: alleof
        alleof = .TRUE.
        if (associated(fig%contours)) then
            do, i = 1, size(fig%contours)
                call Option(fig%contours(i), optname, value, err)
                if (.not. err) alleof = .FALSE.
            enddo
        endif
        if (associated(fig%line)) then
            do, i = 1, size(fig%line)
                call Option(fig%line(i), optname, value, err)
                if (.not. err) alleof = .FALSE.
            enddo
        endif
        err = alleof
    end subroutine

end subroutine

    ! ̂Ƃ뎝̂ axis BȂƂ axis ȊO
    ! ϐ reopen T{Ă̂ŁAŕƂȂƂɂȂ邩B
subroutine GTFigClose(fig)
    use gtgraph_types, only: GT_FIGURE
    use gtgraph_generic, only: Close
    use dc_trace, only: beginsub, endsub
    implicit none
    type(GT_FIGURE), intent(out):: fig
    call beginsub('gtfigclose')
    if (associated(fig%h_axis)) then
        call Close(fig%h_axis)
        deallocate(fig%h_axis)
    endif
    if (associated(fig%v_axis)) then
        call Close(fig%v_axis)
        deallocate(fig%v_axis)
    endif
    if (associated(fig%contours)) then
        deallocate(fig%contours)
    endif
    if (associated(fig%line)) then
        deallocate(fig%line)
    endif
    call endsub('gtfigclose')
end subroutine

subroutine GTFigBindAxis(fig, axis, vertical)
    use gtgraph_types, only: GT_FIGURE, GT_AXIS
    use dc_trace, only: beginsub, endsub
    implicit none
    type(GT_FIGURE), intent(inout):: fig
    type(GT_AXIS), pointer:: axis
    logical, intent(in), optional:: vertical
continue
    if (present(vertical)) axis%vertical = vertical
    call beginsub('gtfigbindaxis')
    !
    ! ͏cɂȂ邩ǂ͍ŏ猈肵Ă邪A
    ! ͂Ŏ̗x
    !
    if (axis%vertical) then
        if (.not. associated(fig%v_axis)) allocate(fig%v_axis)
        fig%v_axis => axis
    else
        if (.not. associated(fig%h_axis)) allocate(fig%h_axis)
        fig%h_axis => axis
    endif
    call endsub('gtfigbindaxis', 'vertical=%y', L=(/axis%vertical/))
end subroutine

subroutine GTFigDraw(fig, parent)
    use gtgraph_types, only: GT_FRAME, GT_FIGURE
    use gtgraph_generic, only: Draw, Option
    use dc_error
    use dcl, only: DclNewFig, DclSetViewport
    use dc_trace, only: beginsub, endsub
    implicit none
    type(GT_FRAME), intent(in):: parent
    type(GT_FIGURE), intent(out):: fig
    integer:: i
    logical:: err
    call beginsub('gtfigdraw')
    if (.not. associated(fig%h_axis)) then
        call StoreError(GT_EFIGNOHAXIS, 'GTFigDraw')
        goto 999
    else if (.not. associated(fig%v_axis)) then
        call StoreError(GT_EFIGNOVAXIS, 'GTFigDraw')
        goto 999
    endif
    if (.not. parent%first_figure) then 
        call DclNewFig
    endif
    call DclSetViewport(0.25, 0.8, 0.15, 0.52)
    fig%h_axis%drawn = .FALSE.
    fig%v_axis%drawn = .FALSE.
    ! call Draw(fig%h_axis, fig%v_axis, parent=fig)
    if (associated(fig%contours)) then
        do, i = 1, size(fig%contours)
            call Draw(fig%contours(i), parent=fig)
        enddo        
    endif
    if (associated(fig%line)) then
        do, i = 1, size(fig%line)
            call Draw(fig%line(i), parent=fig)
        enddo        
    endif
999 continue
    call endsub('gtfigdraw')

end subroutine
