! gtvargetattr.f90 - l^̓
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

! ̌^ɉĂ낢날邪Aǂ\ł͓mgĂB

! XJŎ󂯎̂ԊȒPB߉\ȒlƂAĉ͎ĂB

subroutine GTVarGetAttrR(var, attrname, value, default)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: get_attr, an_variable
    use gt_mem, only: get_attr, mem_variable
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use dc_error
    use dc_string, only: VSTRING, assignment(=), stod
    use netcdf_f77, only: NF_FILL_REAL
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: attrname
    real, intent(out):: value
    real, intent(in), optional:: default
    integer:: stat
    real:: buffer(1)
    type(VSTRING):: cbuffer
    integer:: class, cid
    logical:: err
continue
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        call get_attr(an_variable(cid), attrname, value=buffer, &
            & stat=stat, default=default)
        if (stat >= 1) then
            value = buffer(1)
            return
        endif
    else if (class == vtb_class_memory) then
        call get_attr(mem_variable(cid), attrname, cbuffer, err)
        if (.not. err) then
            value = stod(cbuffer)
            return
        endif
    else
        call StoreError(GT_EBADVAR, "GTVarGetAttrR")
    endif
    if (present(default)) then
        value = default
    else
        value = NF_FILL_REAL
    endif
end subroutine

subroutine GTVarGetAttrD(var, attrname, value, default)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use gt_mem, only: get_attr, mem_variable
    use dc_string, only: VSTRING, assignment(=), stod
    use dc_error
    use netcdf_f77, only: NF_FILL_REAL
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: attrname
    double precision, intent(out):: value
    double precision, intent(in), optional:: default
    integer:: stat
    double precision:: buffer(1)
    type(VSTRING):: cbuffer
    integer:: class, cid
    logical:: err
continue
    call var_class(var, class, cid)
    select case(class)
    case (vtb_class_netcdf)
        call get_attr(an_variable(cid), attrname, value=buffer, &
            & stat=stat, default=default)
        value = buffer(1)
        if (stat >= 1) return
    case (vtb_class_memory)
        call get_attr(mem_variable(cid), attrname, cbuffer, err)
        if (.not. err) then
            value = stod(cbuffer)
            return
        endif
    case default
        call StoreError(GT_ENOTVAR, "GTVarGetAttrR")
    end select
    value = NF_FILL_REAL
    if (present(default)) value = default
end subroutine

subroutine GTVarGetAttrI(var, attrname, value, default)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use gt_mem, only: get_attr, mem_variable
    use netcdf_f77, only: NF_FILL_INT
    use dc_string, only: VSTRING, assignment(=), stoi
    use dc_error
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: attrname
    integer, intent(out):: value
    integer, intent(in), optional:: default
    integer:: stat, buffer(1), class, cid
    type(VSTRING):: cbuffer
    logical:: err
continue
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        call get_attr(an_variable(cid), attrname, buffer, stat, default)
        value = buffer(1)
        if (stat >= 1) return
    else if (class == vtb_class_memory) then
        call get_attr(mem_variable(cid), attrname, cbuffer, err)
        if (.not. err) then
            value = stoi(cbuffer)
            return
        endif
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrI")
    endif
    value = NF_FILL_INT
    if (present(default)) value = default
end subroutine

! |C^zgĎ󂯎ꍇ͉߉\Ȑ̂tB

subroutine GTVarGetAttrRP(var, name, value)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use gt_mem, only: get_attr, mem_variable
    use dc_string, only: VSTRING, assignment(=), get_array
    use dc_error
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    real, pointer:: value(:)
    integer:: stat, class, cid
    type(VSTRING):: cbuffer
    logical:: err
continue
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        allocate(value(1))
        call get_attr(an_variable(cid), name, value(1:0), stat)
        deallocate(value)
        if (stat < 1) return
        allocate(value(stat))
        call get_attr(an_variable(cid), name, value, stat)
        if (stat < 1) deallocate(value)
    else if (class == vtb_class_memory) then
        call get_attr(mem_variable(cid), name, cbuffer, err)
        if (err) then
            nullify(value)
            return
        endif
        call get_array(value, cbuffer)
        cbuffer = ""
    else
        nullify(value)
        call StoreError(GT_ENOTVAR, "GTVarGetAttrRP")
    endif
end subroutine

subroutine GTVarGetAttrDP(var, name, value)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use gt_mem, only: get_attr, mem_variable
    use dc_error
    use dc_string, only: VSTRING, get_array, assignment(=)
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    double precision, pointer:: value(:)
    integer:: stat, class, cid
    type(VSTRING):: cbuffer
    logical:: err
continue
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        allocate(value(1))
        call get_attr(an_variable(cid), name, value(1:0), stat)
        deallocate(value)
        if (stat < 1) return
        allocate(value(stat))
        call get_attr(an_variable(cid), name, value, stat)
        if (stat < 1) deallocate(value)
    else if (class == vtb_class_memory) then
        call get_attr(mem_variable(cid), name, cbuffer, err)
        if (err) then
            nullify(value)
            return
        endif
        call get_array(value, cbuffer)
        cbuffer = ""
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrRP")
    endif
end subroutine

subroutine GTVarGetAttrIP(var, name, value)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use gt_mem, only: get_attr, mem_variable
    use dc_error
    use dc_string, only: VSTRING, get_array, assignment(=)
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    integer, pointer:: value(:)
    integer:: stat, class, cid
    type(VSTRING):: cbuffer
    logical:: err
continue
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        allocate(value(1))
        call get_attr(an_variable(cid), name, value(1:0), stat)
        deallocate(value)
        if (stat < 1) return
        allocate(value(stat))
        call get_attr(an_variable(cid), name, value, stat)
        if (stat < 1) deallocate(value)
    else if (class == vtb_class_memory) then
        call get_attr(mem_variable(cid), name, cbuffer, err)
        if (err) then
            nullify(value)
            return
        endif
        call get_array(value, cbuffer)
        cbuffer = ""
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrIP")
    endif
end subroutine

! integer z, real zƂĎ󂯎
! ꍇ͑܂Ăꍇɂ͐؂̂ĂA
! Ȃꍇ default l (|C^ƈႢK{) 𖄂߂B

subroutine GTVarGetAttrRA(var, name, value, default)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use dc_error
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    real, intent(out):: value(:)
    real, intent(in):: default
    real, pointer:: ptr(:)
    integer:: n, class, cid, stat
continue
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        call get_attr(an_variable(cid), name, value, stat, default)
    else if (class == vtb_class_memory) then
        call get_attr(var, name, ptr)
        if (.not. associated(ptr)) then
            value(:) = default
        else
            n = min(size(ptr), size(value))
            value(1:n) = ptr(1:n)
            if (n < size(ptr)) value(n+1: ) = default
            deallocate(ptr)
        endif
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrRA")
    endif
end subroutine

subroutine GTVarGetAttrDA(var, name, value, default)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use dc_error
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    double precision, intent(out):: value(:)
    double precision, intent(in):: default
    double precision, pointer:: ptr(:)
    integer:: n, stat, class, cid
continue
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        call get_attr(an_variable(cid), name, value, stat, default)
    else if (class == vtb_class_memory) then
        call get_attr(var, name, ptr)
        if (.not. associated(ptr)) then
            value(:) = default
        else
            n = min(size(ptr), size(value))
            value(1:n) = ptr(1:n)
            if (n < size(ptr)) value(n+1: ) = default
            deallocate(ptr)
        endif
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrRA")
    endif
end subroutine

subroutine GTVarGetAttrIA(var, name, value, stat, default)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use dc_error
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    integer, intent(out):: value(:)
    integer, intent(in):: default
    integer, pointer:: ptr(:)
    integer:: n, stat, class, cid
continue
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        call get_attr(an_variable(cid), name, value, stat, default)
    else if (class == vtb_class_memory) then
        call get_attr(var, name, ptr)
        if (.not. associated(ptr)) then
            value(:) = default
        else
            n = min(size(ptr), size(value))
            value(1:n) = ptr(1:n)
            if (n < size(ptr)) value(n+1: ) = default
            deallocate(ptr)
        endif
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrIA")
    endif
end subroutine
