! Copyright (C) GFD Dennou Club, 2000.  All rights reserved
! dv (@mĂ) Tu[`

type(DC_DATETIME) function DCDateTime(mon, day, sec) result(result)
    use dc_date_types, only: DC_DATETIME, caltype, cyclic_mdays, &
        & CAL_NOLEAP, CAL_JULIAN, CAL_CYCLIC
    implicit none
    integer, intent(in):: mon, day
    double precision, intent(in):: sec
    integer:: iday, month, year, century
    integer, parameter:: four_years = 365 * 4 + 1
continue
    iday = day + floor(sec / 86400.0_8)     
    result%sec = modulo(sec, 86400.0_8)
    if (caltype == CAL_CYCLIC) then
        result%day = iday + mon * cyclic_mdays
	return
    endif
    month = modulo(mon - 3, 12) + 3
    year = (mon - month) / 12
    iday = iday + (month * 306 - 914) / 10
    if (caltype == CAL_NOLEAP) then
        result%day = iday + year * 365 + month + 90
    else
	iday = iday + (year * four_years - modulo(year * four_years, 4)) / 4
	if (caltype == CAL_JULIAN .or. iday < 640116) then
	    result%day = iday + 91
        else
            century = (year - modulo(year, 100)) / 100 + 1
	    result%day = iday - (century * 3 - modulo(century * 3, 4)) / 4 + 93
        endif
    endif
end function
