! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTVarGetReal2(var, value, err)
    use gtdata_types, only: gt_variable
    use gtdata_generic, only: get_slice, gtvargetreal, inquire
    use gt_map, only: map_set_rank
    use dc_error, only: storeerror, dc_noerr
    implicit none
    type(gt_variable), intent(inout):: var
    real, pointer:: value(:, :)
    logical, intent(out), optional:: err
    integer:: stat, n(2)
continue
    call map_set_rank(var, 2, stat)
    if (stat /= dc_noerr) goto 999
    call get_slice(var, dimord=1, count=n(1), count_compact=.false.)
    call get_slice(var, dimord=2, count=n(2), count_compact=.false.)
    allocate(value(n(1), n(2)))
    call gtvargetreal(var, value, product(n), err)
999 continue
    call storeerror(stat, 'gtvargetreal2')
end subroutine
