! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTVarSlice(var, dimord, start, count, stride)
    use gtdata_types, only: gt_variable
    use gtdata_internal, only: query_growable
    use gt_map, only: maptablookup, gt_dimmap, gtvar_dump
    use dc_error, only: nf_enotvar, StoreError
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(gt_variable), intent(in):: var
    integer, intent(in):: dimord
    integer, intent(in), optional:: start
    integer, intent(in), optional:: count
    integer, intent(in), optional:: stride
    type(gt_dimmap), pointer:: map(:)
    integer:: vid, maxindex, maxcount
    logical:: growable_dimension

    call beginsub('gtvarslice', 'var%%mapid=%d dimord=%d', &
        & i=(/var%mapid, dimord/))
    call gtvar_dump(var)
    call maptablookup(var, vid=vid, map=map)
    call query_growable(vid, growable_dimension)

    if (vid <= 0) then
        call StoreError(nf_enotvar, "GTVarSlice")
    endif
    if (.not. associated(map)) goto 999
    if (dimord <= 0 .or. dimord > size(map)) goto 999

    call message('map(dimord): originally start=%d count=%d stride=%d', &
        & i=(/map(dimord)%start, map(dimord)%count, map(dimord)%stride/))
    if (.not. growable_dimension) then
        maxindex = map(dimord)%allcount
        call message('maxindex=%d', i=(/maxindex/))
    endif

    if (present(start)) then
        if (start < 0) then
            map(dimord)%start = max(1, maxindex + 1 + start)
        else if (growable_dimension) then
            map(dimord)%start = max(1, start)
        else
            map(dimord)%start = min(maxindex, max(1, start))
        endif
        call message('start=%d (%d specified)', i=(/map(dimord)%start, start/))
    endif

    if (present(stride)) then
        map(dimord)%stride = stride
        if (stride == 0) map(dimord)%stride = 1
        call message('stride=%d (%d specified)', &
            & i=(/map(dimord)%stride, stride/))
    endif

    if (present(count)) then
        map(dimord)%count = abs(count)
        if (count == 0) map(dimord)%count = 1
        call message('count=%d (%d specified)', &
            & i=(/map(dimord)%count, count/))
    endif

    if (.not. growable_dimension) then
        maxcount = 1 + (maxindex - map(dimord)%start) / map(dimord)%stride
        map(dimord)%count = max(1, min(maxcount, map(dimord)%count))
        call message('count=%d ', i=(/map(dimord)%count/))
    endif

    call endsub('gtvarslice')
    return
999 continue
    call endsub('gtvarslice', 'err skipped')
end subroutine
