! dc_url.f90 - ϐ URL ̕
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

module dc_url

    implicit none

    public:: UrlSplit, IORangeParse, UrlResolve, url_chop_iorange

    interface UrlMerge
        module procedure url_merge_v_vvv
        module procedure url_merge_cccc
        module procedure url_merge_cc
    end interface

    interface UrlSplit
        module procedure url_split_v
        module procedure url_split_c
    end interface

    interface operator(.OnTheSameFile.)
        module procedure UrlOnTheSameFile
    end interface

    character, public, parameter:: GT_ATMARK = "@"
    character, public, parameter:: GT_COLON = ":"
    character, public, parameter:: GT_COMMA = ","
    character, public, parameter:: GT_QUESTION = '?'
    character, public, parameter:: GT_EQUAL = "="
    character, public, parameter:: GT_CIRCUMFLEX = "^"
    character, public, parameter:: GT_PLUS = "+"

contains

    ! ANUrlMerge - ϐ URL ̍
    ! 󕶎̐͂ȂƂ݂ȂB

        type(VSTRING) function &
    url_merge_v_vvv(file, var, attr, iorange) result(result)
        use dc_string
        type(VSTRING), intent(in):: file
        type(VSTRING), intent(in), optional:: var
        type(VSTRING), intent(in), optional:: attr
        type(VSTRING), intent(in), optional:: iorange
        result = file // GT_ATMARK
        if (present(var)) result = result // var
        if (present(attr)) then
            if (attr /= "") result = result // GT_COLON // attr
        endif
        if (present(iorange)) then
            if (extract(iorange, 1, 1) == GT_COMMA) then
                result = result // iorange
            else if (iorange /= "") then
                result = result // GT_COMMA // iorange
            endif
        endif
    end function

    function url_merge_cccc(file, var, attr, iorange) result(result)
        use dc_types, only: string
        character(len = string):: result
        character(len = *), intent(in):: file
        character(len = *), intent(in):: var
        character(len = *), intent(in):: attr
        character(len = *), intent(in):: iorange
    continue
        if (file /= "") then
            result = trim(file) // gt_atmark
        else
            result = gt_atmark
        endif
        if (var /= "") result = trim(result) // var
        if (attr /= "") then
            result = trim(result) // gt_colon // attr
        endif
        if (iorange /= "") then
            if (iorange(1:1) == gt_comma) then
                result = trim(result) // iorange
            else
                result = trim(result) // gt_comma // iorange
            endif
        endif
    end function

    function url_merge_cc(file, var) result(result)
        use dc_types, only: string
        character(len = string):: result
        character(len = *), intent(in):: file
        character(len = *), intent(in):: var
    continue
        result = url_merge_cccc(file, var, "", "")
    end function

    ! url_chop_iorange - ϐ URL  iorange 
    subroutine url_chop_iorange(fullname, iorange, remainder)
        use dc_types, only: string
        character(len = *), intent(in):: fullname
        character(len = *), intent(out):: iorange, remainder
        character(string):: file, var, attr
        call urlsplit(fullname, file=file, var=var, attr=attr, iorange=iorange)
        remainder = url_merge_cccc(file=file, var=var, attr=attr, iorange="")
    end subroutine

    ! UrlSplit - ϐ URL ̕
    ! Ȃɂ͋󕶎񂪑B

    subroutine url_split_c(fullname, file, var, attr, iorange)
        use dc_types, only: string
        character(len = *), intent(in):: fullname
        character(len = *), intent(out), optional:: file, var, attr, iorange
        character(len = string):: varpart
        integer:: atmark, colon, comma
        character(len = *), parameter:: VARNAME_SET &
            = "0123456789eEdD+-=^,.:_" &
            // "ABCDEFGHIJKLMNOPQRSTUVWXYZ" &
            // "abcdefghijklmnopqrstuvwxyz"
    continue
        ! ܂ URL ƕϐw (? ܂ @ ȍ~) 𕪗B
        ! URL  @ ܂݂邽߁AŌ @ ȍ~ɑ΂ĕϐ
        ! ƂċȂiT^Iɂ '/'j܂܂Ă
        ! Y @  URL ̈ꕔƂ݂ȂB
        atmark = index(fullname, GT_QUESTION)
        if (atmark == 0) then
            atmark = index(fullname, GT_ATMARK, back=.TRUE.)
            if (atmark /= 0) then
                if (verify(trim(fullname(atmark+1: )), VARNAME_SET) /= 0) then
                    atmark = 0
                endif
            endif
        endif
        if (atmark == 0) then
            ! ϐw͂ȂB
            if (present(file)) file = fullname
            if (present(var)) var = ''
            if (present(attr)) attr = ''
            if (present(iorange)) iorange = ''
            return
        endif
        varpart = fullname(atmark+1: )
        ! ϐw肪B
        if (present(file)) file = fullname(1: atmark - 1)
        ! ͈͎wTB
        comma = index(varpart, GT_COMMA)
        if (comma /= 0) then
            ! ͈͎w肪݂B
            if (present(var)) var = varpart(1: comma - 1)
            if (present(attr)) attr = ''
            if (present(iorange)) iorange = varpart(comma + 1: )
            return
        endif
        if (present(iorange)) iorange = ''
        ! ͈͎w肪Ȃ̂ŁǍB
        colon = index(varpart, GT_COLON)
        if (colon == 0) then
            if (present(var)) var = varpart
            if (present(attr)) attr = ''
            varpart = ''
            return
        endif
        if (present(var)) var = varpart(1: colon - 1)
        if (present(attr)) attr = varpart(colon + 1: )
        varpart = ''
    end subroutine

    subroutine url_split_v(fullname, file, var, attr, iorange)
        use dc_string
        type(VSTRING), intent(in):: fullname
        type(VSTRING), intent(out), optional::        file, var, attr, iorange
        type(VSTRING):: varpart
        integer:: atmark, colon, comma
        character(len = *), parameter:: VARNAME_SET &
            = "0123456789eEdD+-=^,.:_" &
            // "ABCDEFGHIJKLMNOPQRSTUVWXYZ" &
            // "abcdefghijklmnopqrstuvwxyz"
    continue
        ! ܂ URL ƕϐw (? ܂ @ ȍ~) 𕪗B
        ! URL  @ ܂݂邽߁AŌ @ ȍ~ɑ΂ĕϐ
        ! ƂċȂiT^Iɂ '/'j܂܂Ă
        ! Y @  URL ̈ꕔƂ݂ȂB
        atmark = vindex(fullname, GT_QUESTION)
        if (atmark == 0) then
            atmark = vindex(fullname, GT_ATMARK, .TRUE.)
            if (atmark /= 0) then
                varpart = extract(fullname, atmark + 1)
                if (vverify(varpart, VARNAME_SET) /= 0) then
                    atmark = 0
                endif
            endif
        endif
        if (atmark == 0) then
            ! ϐw͂ȂB
            if (present(file)) file = fullname
            if (present(var)) var = ''
            if (present(attr)) attr = ''
            if (present(iorange)) iorange = ''
            return
        endif
        varpart = extract(fullname, atmark + 1)
        ! ϐw肪B
        if (present(file)) file = extract(fullname, 1, atmark - 1)
        ! ͈͎wTB
        comma = vindex(varpart, GT_COMMA)
        if (comma /= 0) then
            ! ͈͎w肪݂B
            if (present(var)) var = extract(varpart, 1, comma - 1)
            if (present(attr)) attr = ''
            if (present(iorange)) iorange = extract(varpart, comma + 1)
            return
        endif
        if (present(iorange)) iorange = ''
        ! ͈͎w肪Ȃ̂ŁǍB
        colon = vindex(varpart, GT_COLON)
        if (colon == 0) then
            if (present(var)) var = varpart
            if (present(attr)) attr = ''
            varpart = ''
            return
        endif
        if (present(var)) var = extract(varpart, 1, colon - 1)
        if (present(attr)) attr = extract(varpart, colon + 1)
        varpart = ''
    end subroutine

    !
    ! --- o͔͈͎w蕶̉ ---
    !
    ! o͔͈͎wQ iorange ͂Bŏ͈͎̔w肪͂A
    !  dimname, (, , Ԋu)  range(1:3),
    ! c remainder Ɋi[BG[͋󕶎񂪊i[B
    ! Pڂ '^' ƂȂĂꍇ͏ range ̑Svf
    ! YwƂ݂ȂB
    !
    ! Ƃ "lon=-4.245:+84.2e0,^lat=1:13:2" ͂
    ! x:  
    !   dimname="lon", range=(/"-4.245", "+84.2e0", ""/), remainder="^lat=1:13:2"
    ! x:
    !   dimname="lat", range=(/"^1", "^13", "^2"/), remainder=""
    !
    subroutine IORangeParse(iorange, dimname, range, remainder)
        use dc_string
        implicit none
        type(VSTRING), intent(in):: iorange
        type(VSTRING), intent(out):: dimname
        type(VSTRING), intent(out):: range(3)
        type(VSTRING), intent(out):: remainder
        type(VSTRING):: word
        integer:: comma, equal, colon, i
        logical:: hat_all
    continue
        ! iorange ɐsR}ΏÔ word ɓ
        comma = vindex(iorange, GT_COMMA)
        if (comma == 1) then
            comma = vverify(iorange, GT_COMMA)
            word = extract(iorange, comma)
        else
            word = iorange
        endif
        if (len(word) == 0) goto 900
        ! word R}ȉ remainder ɓ
        comma = vindex(word, GT_COMMA)
        if (comma == 0) then
            remainder = ""
        else
            remainder = extract(word, comma + 1)
            word = extract(word, 1, comma - 1)
        endif
        ! ŏ '=' ܂ł
        equal = vindex(word, GT_EQUAL)
        dimname = extract(word, 1, equal - 1)
        word = extract(word, equal + 1)
        ! ̐擪 '^' ΑS̐l '^' ŝƓ
        hat_all = (vindex(dimname, GT_CIRCUMFLEX) == 1)
        if (hat_all) dimname = extract(dimname, 2)
        !  = ȂȂ΃G[
        if (len(dimname) == 0) goto 900
        ! Rŋ؂
        do, i = 1, 3
            colon = vindex(word, GT_COLON)
            if (colon > 0) then
                range(i) = extract(word, 1, colon - 1)
                word = extract(word, colon + 1)
            else
                range(i) = word
                if (i > 1) word = ""
            endif
            if (hat_all .and. vindex(dimname, GT_CIRCUMFLEX) /= 1) then
                range(i) = GT_CIRCUMFLEX // range(1)
            endif
        enddo
        return
    ! --- ͂ł镶cĂȂꍇ ---    
    900 continue
        dimname = "";  remainder = ""
        range(:) = (/(var_str(""), i = 1, 3)/)
    end subroutine

    !
    ! === t@CɍڂĂ邩ǂ ===
    !

    logical function UrlOnTheSameFile(url_a, url_b) result(result)
        use dc_string
        type(VSTRING), intent(in):: url_a
        type(VSTRING), intent(in):: url_b
        type(VSTRING):: filepart_a
        type(VSTRING):: filepart_b
        call UrlSplit(url_a, file=filepart_a)
        call UrlSplit(url_b, file=filepart_b)
        result = (filepart_a == filepart_b)
    end function

    !
    ! === ΃N ===
    !

    type(VSTRING) function UrlResolve(relative, base) result(result)
        use dc_string, only: StrHead, extract, vscan, VSTRING, &
            & operator(==), operator(//)
        use dc_trace, only: beginsub, endsub, message
        implicit none
        type(VSTRING), intent(in):: relative
        type(VSTRING), intent(in):: base
        integer, parameter:: FILE = 1, VAR = 2, ATTR = 3, IOR = 4
        type(VSTRING):: rel(FILE:IOR), bas(FILE:IOR)
        character(3), parameter:: PATHDELIM = "/:" // achar(94)
        integer:: idir_r, idir_b
        call beginsub('urlresolve', 'rel=<%s> base=<%s>', s=(/relative, base/))
        call UrlSplit(relative, file=rel(FILE), var=rel(VAR), &
            & attr=rel(ATTR), iorange=rel(IOR))
        call message('rel -> file=<%s> var=<%s> attr=<%s> ior=<%s>', s=rel)
        call UrlSplit(base, file=bas(FILE), var=bas(VAR), &
            & attr=bas(ATTR), iorange=bas(IOR))
        call message('base -> file=<%s> var=<%s> attr=<%s> ior=<%s>', s=bas)
        if (rel(FILE) == "") then
            rel(FILE) = bas(FILE)
            if (rel(VAR) == "") rel(VAR) = bas(VAR)
            result = UrlMerge(file=rel(FILE), var=rel(VAR), &
                    & attr=rel(ATTR), iorange=rel(IOR))
            call endsub('urlresolve', '1 result=%s', s=(/result/))
            return
        endif
        ! --- ΃pX̃t@C ---
        if (StrHead(rel(FILE), "file:") &
            & .OR. StrHead(rel(FILE), "http:") &
            & .OR. StrHead(rel(FILE), "ftp:") &
            & .OR. StrHead(rel(FILE), "news:") &
            & .OR. StrHead(rel(FILE), "www") &
            & .OR. StrHead(rel(FILE), "/") &
            & .OR. StrHead(rel(FILE), achar(94)) &
            & .OR. extract(rel(FILE), 2, 1) == ":" &
            ) then
            result = relative
            call endsub('urlresolve', '2 result=%s', s=(/result/))
            return
        endif
        idir_b = vscan(bas(FILE), PATHDELIM, back=.TRUE.) 
        if (idir_b == 0) then
            result = relative
            call endsub('urlresolve', '3 result=%s', s=(/result/))
            return
        endif
        idir_r = vscan(rel(FILE), PATHDELIM, back=.TRUE.)
        result = extract(base, 1, idir_b) // extract(relative, idir_r + 1)
        call endsub('urlresolve', '4 result=%s', s=(/result/))
    end function

end module
