! gtdata_variable.f90 - gtool ϐ̎葱̐錾
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

module gtdata_generic

    implicit none
    !
    ! {J
    !

    interface open

        ! 
        ! open(var, url, [writable], [err])  url Ŏʂ
        ! ϐJ var Ɋi[Bwritable ^Ɏw肷
        ! ݉ŊJƂBftHg writable=.FALSE. łB
        ! G[ꍇ err ^ƂȂBerr ^Ȃ΃vO͒~B
        !
        subroutine GTVarOpen(var, url, writable, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(out):: var
            character(*), intent(in):: url
            logical, intent(in), optional:: writable
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarOpenV(var, url, writable, err)
            use dc_string, only: VSTRING    
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(out):: var
            type(VSTRING), intent(in):: url
            logical, intent(in), optional:: writable
            logical, intent(out), optional:: err
        end subroutine
        
        !
        ! open(dimvar, var, dimord, [count_compact], [err]) 
        ! ɊJꂽϐ var  ord Ԗڂ̎ɂϐ
        ! J dimvar Ɋi[B ord ݂͌̓o͔͈͂
        ! PɂȂĂ (RpNgĂj΂
        ! ł邪Acount_compact ɐ^w肷
        ! ׂĂ̎̂Ȃ̏ɂȂB
        !
        ! ord == 0 ̏ꍇ͕ϐ̂ēxJB͎QƃJE^
        ! iłB
        !
        subroutine GTVarOpenByDimOrd(var, source_var, dimord, &
            count_compact, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(out):: var
            type(GT_VARIABLE), intent(in):: source_var
            integer, intent(in):: dimord
            logical, intent(in), optional:: count_compact
            logical, intent(out), optional:: err
        end subroutine

    end interface

    interface create
        !
        ! ]ϐ create
        !
        ! create(var, url, [dims], [xtype], [overwrite], [err]) 
        ! ꏊ url Ɏ dims ϐ쐬AJ
        ! ̂ var Ɋi[B^ xtype ȗ "float" 
        ! ݂ȂBϐƂs邪
        ! overwrite ^łΑsB
        ! dims ̏ȗ 0 ϐ̐ݒӖB
        !
        subroutine GTVarCreate(var, url, dims, xtype, long_name, overwrite, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            character(len = *), intent(in):: url
            type(GT_VARIABLE), intent(in), optional:: dims(:)
            character(len = *), intent(in), optional:: xtype
            character(len = *), intent(in), optional:: long_name
            logical, intent(in), optional:: overwrite
            logical, intent(out), optional:: err
        end subroutine
        !
        ! Ɨϐ create
        !
        !  length ̎gƂϐ쐬B
        !  length = 0 ̕ϐ͉ϒłB
        !
        subroutine GTVarCreateD(var, url, length, xtype, long_name, overwrite, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            character(len = *), intent(in):: url
            integer, intent(in):: length
            character(len = *), intent(in), optional:: xtype
            character(len = *), intent(in), optional:: long_name
            logical, intent(in), optional:: overwrite
            logical, intent(out), optional:: err
        end subroutine
    end interface

    interface close
        subroutine GTVarClose(var, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            logical, intent(out), optional:: err
        end subroutine
    end interface

    !
    ! --- ֌W ---
    !

    interface attr_rewind
        subroutine GTVarAttrRewind(var)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
        end subroutine
    end interface

    interface attr_next
        subroutine GTVarAttrNext(var, name, end)
            use gtdata_types, only: GT_VARIABLE
            use dc_string, only: VSTRING    
            type(GT_VARIABLE), intent(inout):: var
            type(VSTRING), intent(out):: name
            logical, intent(out), optional:: end
        end subroutine
    end interface

    ! _^ǂݎ͊֐C^[tFCX
    interface attr_true
        logical function GTVarAttrTrue(var, name, default)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            logical, intent(in), optional:: default
        end function
    end interface

    interface get_attr

        ! Ƃēǂݎꍇ͌̒͐mɎ󂯎B
        ! ݂Ȃꍇ default lgB

        subroutine GTVarGetAttrSC(var, name, value, default)
            use dc_string, only: VSTRING    
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            type(VSTRING), intent(out):: value
            character(len = *), intent(in), optional:: default
        end subroutine

        ! character ^Ŏ󂯎ꍇ͒ʏ̕^ƓlA
        ! 󂯑ϐ̒ɍ킹Đ؂̂āE󔒖߂sB
        ! ݂Ȃꍇ default lgB

        subroutine GTVarGetAttrCC(var, name, value, default)
            use dc_string, only: VSTRING    
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            character(len = *), intent(out):: value
            character(len = *), intent(in), optional:: default
        end subroutine

        ! XJŎ󂯎̂ԊȒPB߉\ȒlƂAĉ͎ĂB

        subroutine GTVarGetAttrR(var, name, value, default)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            real, intent(out):: value
            real, intent(in), optional:: default
        end subroutine

        subroutine GTVarGetAttrD(var, name, value, default)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            double precision, intent(out):: value
            double precision, intent(in), optional:: default
        end subroutine

        subroutine GTVarGetAttrI(var, name, value, default)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            integer, intent(out):: value
            integer, intent(in), optional:: default
        end subroutine

        ! |C^zgĎ󂯎ꍇ͉߉\Ȑ̂tB

        subroutine GTVarGetAttrRP(var, name, value)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            real, pointer:: value(:)
        end subroutine

        subroutine GTVarGetAttrDP(var, name, value)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            double precision, pointer:: value(:)
        end subroutine

        subroutine GTVarGetAttrIP(var, name, value)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            integer, pointer:: value(:)
        end subroutine

        ! integer z, real zƂĎ󂯎
        ! ꍇ͑܂Ăꍇɂ͐؂̂ĂA
        ! Ȃꍇ default l (|C^ƈႢK{) 𖄂߂B

        subroutine GTVarGetAttrRA(var, name, value, default)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            real, intent(out):: value(:)
            real, intent(in):: default
        end subroutine

        subroutine GTVarGetAttrDA(var, name, value, default)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            double precision, intent(out):: value(:)
            double precision, intent(in):: default
        end subroutine

        subroutine GTVarGetAttrIA(var, name, value, default)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len = *), intent(in):: name
            integer, intent(out):: value(:)
            integer, intent(in):: default
        end subroutine

    end interface

    interface put_attr

        subroutine GTVarPutAttrString(var, name, value, err)
            use dc_string, only: VSTRING    
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            character(len = *), intent(in):: name
            type(VSTRING), intent(in):: value
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutAttrChar(var, name, value, xtype, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            character(len = *), intent(in):: name
            character(len = *), intent(in):: value
            character(len = *), intent(in), optional:: xtype
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutAttrReal(var, name, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            character(len = *), intent(in):: name
            real, intent(in):: value(:)
            real, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutAttrDouble(var, name, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            character(len = *), intent(in):: name
            double precision, intent(in):: value(:)
            real, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutAttrInt(var, name, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            character(len = *), intent(in):: name
            integer, intent(in):: value(:)
            real, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutAttrLogical(var, name, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            character(len = *), intent(in):: name
            logical, intent(in):: value
            real, intent(out), optional:: err
        end subroutine

    end interface

    interface del_attr
        subroutine GTVarDelAttr(var, name, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            character(len = *), intent(in):: name
            logical, intent(out), optional:: err
        end subroutine
    end interface

    interface copy_attr
        subroutine GTVarCopyAttr(to, attrname, from, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: to
            character(len = *), intent(in):: attrname
            type(GT_VARIABLE), intent(in):: from
            logical, intent(out), optional:: err
        end subroutine
    end interface

    !
    ! --- ֌W ---
    !

    ! ݂̓o͔͈͂̑傫 inquire(var, size=) Ŏ擾ł

    interface slice

        ! ܂w
        ! compatible w肷Ƃ܂Ɏw
        subroutine GTVarSliceAuto(var, compatible)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            type(GT_VARIABLE), intent(in), optional:: compatible
        end subroutine

        ! w肵w
        subroutine GTVarSlice(var, dimord, start, count, stride)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            integer, intent(in):: dimord
            integer, intent(in), optional:: start
            integer, intent(in), optional:: count
            integer, intent(in), optional:: stride
        end subroutine
    end interface

    interface get_slice

        ! Ԃw肵Ď擾
        subroutine GTVarGetSlice(var, dimord, start, count, stride, count_compact)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            integer, intent(in):: dimord
            integer, intent(out), optional:: start
            integer, intent(out), optional:: count
            integer, intent(out), optional:: stride
            logical, intent(in), optional:: count_compact
        end subroutine

        ! SɂĈꊇ擾
        ! 炩 inquire(var, alldims) ĔzmۂB
        subroutine GTVarGetSliceAll(var, start, count, stride)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            integer, intent(out), optional:: start(:), count(:), stride(:)
        end subroutine

    end interface

    interface dimname_to_dimord
        integer function gtdim_name2ord(var, name)
            use gtdata_types, only: gt_variable
            type(gt_variable), intent(in):: var
            character(len = *), intent(in):: name
        end function
    end interface

    ! limit: ԕϊ@\̃ZbgAbv
    !
    interface limit

        subroutine GTVarLimitBinary(var1, var2, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var1, var2
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarLimit(var, string, err)
            use gtdata_types, only: gt_variable
            type(gt_variable), intent(in):: var
            character(len = *), intent(in):: string
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarLimitTriplet(var, dimord, start, count, stride, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            integer, intent(in):: dimord
            integer, intent(in), optional:: start, count, stride
            logical, intent(out), optional:: err
        end subroutine

    end interface

    ! Iԕϊ@\

    ! ϐnh var  dimord Ԗڂ̈ʒuɎ
    ! dimvar ǉBdimord Ԗڈȍ~͈̎ɂB
    !  dimord  var ̗L傫 (L + 1)
    ! ^ꂽ̂Ƃ݂ȂB
    interface add_dim
        subroutine gtvaradddim(var, dimord, dimvar, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            type(GT_VARIABLE), intent(in):: dimvar
            integer, intent(in):: dimord
            logical, intent(out):: err
        end subroutine
    end interface

    ! ϐnh玟uvBۂɂ́A
    ! Ή\̏ʂLfNg邾Ȃ̂ŁA
    ! o͂Ɏx͂ȂB
    interface del_dim
        subroutine gtvardeldim(var, dimord, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            integer, intent(in):: dimord
            logical, intent(out):: err
        end subroutine
    end interface

    !
    ! --- ₢킹 ---
    !

    interface inquire

        subroutine GTVarInquire(var, xtype, name, url, &
            & rank, alldims, allcount, size, growable)
            use gtdata_types, only: gt_variable
            type(gt_variable), intent(in):: var
            ! O^̖O
            character(len=*), intent(out), optional:: xtype
            ! name ͕ϐ̍ŏ̒PʂԂB
            ! t@C܂܂Ȃ߃vOł̈Ӑ͕ۏ؂ȂB
            character(len=*), intent(out), optional:: name
            ! url ̓t@ĈϐԂBvO
            ! ӂłB
            character(len=*), intent(out), optional:: url
            ! RpNg(k)𐔂Ȃ, ̐
            integer, intent(out), optional:: rank
            ! kގ܂ޑSBdimord ɂ͊{Iɂg
            integer, intent(out), optional:: alldims
            ! ϐϐłꍇAԂBG[̓[B
            integer, intent(out), optional:: allcount
            ! ϐ̓o͗̈̑傫B
            integer, intent(out), optional:: size
            ! ϐϐłꍇAg\ۂԂB
            ! łȂꍇ͕sB
            logical, intent(out), optional:: growable
        end subroutine

        subroutine GTVarInquire2(var, allcount)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            ! alldims Kv
            integer, intent(out), optional:: allcount(:)
        end subroutine

        subroutine GTVarInquireD(var, dimord, url, allcount)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            integer, intent(in):: dimord
            character(len=*), intent(out), optional:: url
            integer, intent(out), optional:: allcount
        end subroutine

        subroutine GTVarInquireV(var, xtype, name, url)
            use gtdata_types, only: GT_VARIABLE
            use dc_string, only: VSTRING
            type(GT_VARIABLE), intent(in):: var
            type(vstring), intent(out), optional:: xtype
            type(vstring), intent(out), optional:: name
            type(vstring), intent(out), optional:: url
        end subroutine

        subroutine GTVarInquireAV(var, attrname, xtype)
            use gtdata_types, only: GT_VARIABLE
            use dc_string, only: VSTRING
            type(GT_VARIABLE), intent(in):: var
            character(len=*), intent(in):: attrname
            type(VSTRING), intent(out), optional:: xtype
        end subroutine

        subroutine GTVarInquireA(var, attrname, xtype)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            character(len=*), intent(in):: attrname
            character(len=*), intent(out), optional:: xtype
        end subroutine
    end interface

    ! ȂߗpCe[^
    interface slice_next
        subroutine GTVarSliceNext(var, dimord, err, stat)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in out):: var
            integer, intent(in), optional:: dimord
            logical, intent(out), optional:: err
            integer, intent(out), optional:: stat
        end subroutine
    end interface

    ! l
    interface operator(.equivalent.)
	logical function gtvarequivalent(var1, var2)
	    use gtdata_types, only: gt_variable
	    type(gt_variable), intent(in):: var1, var2
	end function
    end interface

    !
    ! === o ===
    !
    ! ---  ---
    !
    ! get(var, value, nvalue, [err])
    ! 1zɌ݂̓o͔͈͂擾B
    ! nvalue ͗p҂z񒷂i[Ȃ΂ȂȂB
    ! ʖ GTVarGetReal pƑzɓ
    ! 邱Ƃł邪Ao͔͈͂Ƃ̊֌WɒӂKvB
    !
    ! get(var, value, [err])  1`3 ̃|C^ƂB
    ! o͔͈͂|C^Ɍ肵AzmۂA
    ! lĕԂBʏ͂p邱ƂɂȂ낤B
    !

    interface get

        subroutine GTVarGetReal(var, value, nvalue, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            real, intent(out):: value(*)
            integer, intent(in):: nvalue
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarGetReal1(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            real, pointer:: value(:)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarGetReal2(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            real, pointer:: value(:, :)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarGetReal3(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            real, pointer:: value(:, :, :)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarGetDouble(var, value, nvalue, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            double precision, intent(out):: value(*)
            integer, intent(in):: nvalue
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarGetDouble1(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            double precision, pointer:: value(:)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarGetDouble2(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            double precision, pointer:: value(:, :)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarGetDouble3(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            double precision, pointer:: value(:, :, :)
            logical, intent(out), optional:: err
        end subroutine

    end interface

    !
    ! ---  ---
    !
    ! 󎚂Ƃ͕̂ϐɂĂ݂Γ͂t@CɂĂ݂Ώo͂B
    !  put  get cĂ悤Ȃ̂ł܂Ƃɂ₵̂A
    !  dc_string ̎葱p put_line ɂĂB

    interface put_line
        subroutine GTVarPutLine(var, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            logical, intent(out), optional:: err
        end subroutine
    end interface

    !
    ! --- o ---
    !

    interface put

        subroutine GTVarPutReal(var, value, nvalue, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            real, intent(in):: value(*)
            integer, intent(in):: nvalue
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutReal1(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            real, intent(in):: value(:)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutReal2(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            real, intent(in):: value(:, :)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutReal3(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            real, intent(in):: value(:, :, :)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutDouble(var, value, nvalue, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            double precision, intent(in):: value(*)
            integer, intent(in):: nvalue
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutDouble1(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            double precision, intent(in):: value(:)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutDouble2(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            double precision, intent(in):: value(:, :)
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarPutDouble3(var, value, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout):: var
            double precision, intent(in):: value(:, :, :)
            logical, intent(out), optional:: err
        end subroutine

    end interface

    !
    ! === ϐƃt@C̊֌W ===
    !

    interface GTVarSearch
        
        subroutine GTVarSearchInit(urlBase)
            character(len = *), intent(in):: urlBase
        end subroutine

        subroutine GTVarSearchNext(url, end)
            character(len = *), intent(out):: url
            logical, intent(out):: end
        end subroutine

    end interface        

    !
    ! === Ŝ߂̒Eo ===
    !
    ! SysDepAbort ĂяôŁAStoreError Ăł͂ȂȂ
    !

    interface
        subroutine GTVarSync(var, stat)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(inout), optional:: var
            integer, intent(out), optional:: stat
        end subroutine
    end interface


    !
    ! === [eBeB ===
    !
    ! gtdata wŏꂽCuB

    ! Create(var, url, copyfrom, [copyvalue], [overwrite], [err])
    ! ͕ϐ copyfrom ƓAϐ쐬B
    ! KvȂΎϐB
    ! copyvalue ^Ɏw肷ƒlB
    !
    interface Create
        subroutine GTVarCreateCopyC(var, url, copyfrom, copyvalue, &
            & overwrite, err)
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(out):: var
            character(len = *), intent(in):: url
            type(GT_VARIABLE), intent(inout):: copyfrom
            logical, intent(in), optional:: copyvalue
            logical, intent(in), optional:: overwrite
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTVarCreateCopyV(var, url, copyfrom, copyvalue, &
            & overwrite, err)
            use gtdata_types, only: GT_VARIABLE
            use dc_string, only: VSTRING
            type(GT_VARIABLE), intent(out):: var
            type(VSTRING), intent(in):: url
            type(GT_VARIABLE), intent(inout):: copyfrom
            logical, intent(in), optional:: copyvalue
            logical, intent(in), optional:: overwrite
            logical, intent(out), optional:: err
        end subroutine
    end interface

    !
    ! --- \̊֌W ---
    !

    interface add_member
        subroutine GTVarAddMember(var, url, link_name)
            use gtdata_types, only: GT_VARIABLE
            use dc_string, only: VSTRING
            type(GT_VARIABLE), intent(inout):: var
            type(VSTRING), intent(in):: url
            character(len = *), intent(in), optional:: link_name
        end subroutine
    end interface

    ! ӂȕϐ̎쐬
    interface 
        type(VSTRING) function GTDataTmpNam(file, base)
            use dc_string, only: VSTRING
            type(VSTRING), intent(in), optional:: file, base
        end function
    end interface


end module
