! gtgraph_types.f90 - gtgraph w̌^錾
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module gtgraph_types

    use dc_string, only: VSTRING
    use dc_types, only: STRING
    use gtdata_types, only: GT_VARIABLE
    implicit none

    type GT_AXIS
        type(GT_VARIABLE):: var
        real:: lower
        real:: upper
        logical:: vertical
        logical:: drawn
        type(VSTRING):: saved
        type(VSTRING):: title
        type(VSTRING):: units
        integer:: index
    end type

    type GT_CONTOURS
        type(GT_VARIABLE):: var
        type(GT_AXIS), pointer:: h_axis
        type(GT_AXIS), pointer:: v_axis
        ! ^ɂƂ݂̂ʂ킯s
        logical:: shade
        ! ^ɂƂ̂ݓl
        logical:: contours
        ! --- ǂ̃xɓl܂͂ʂ킯Eu ---
        ! mۂĂ size(levels) {̐蓮ݒ
        real, pointer, dimension(:):: levels
        ! Ɏw肷΂̊ԊupĎݒ
        ! Ɏw肷΍őŏ int(abs(interval)) {̐ݒ
        ! l 0.0 ͎蓮Ȃꍇ -12.0 Ɠ
        real:: interval
        ! ݒsƂɂ̒l܂ނ悤ɂ
        real:: base
        ! 蓮Eݒ̂Ȃꍇłx
        real, pointer, dimension(:):: skiplevels
        ! --- lǂ̂悤ɕ` ---
        ! icycle {̓l̂1{ major line (x̑) ɂ
        integer:: icycle
        ! --- ʂ킯ǂ̂悤ɂ邩 ---
        ! ЂƂłtȂΑ傫
        ! size(levels) + 1 ɂȂ΂ȂȂ
        integer, pointer, dimension(:):: tones
        ! --- -next bZ[W󂯕t邩
        logical:: animate
        ! --- łȂΒn}`悷
        character(STRING):: map
    end type

    type GT_LINE
        type(GT_VARIABLE):: var
        type(GT_AXIS), pointer:: h_axis
        type(GT_AXIS), pointer:: v_axis
        integer:: index
        integer:: type
        integer:: mark
    end type

    type GT_FIGURE
        type(GT_AXIS), pointer:: h_axis
        type(GT_AXIS), pointer:: v_axis
        type(GT_CONTOURS), pointer:: contours(:)
        type(GT_LINE), pointer:: line(:)
        type(VSTRING):: title
        logical:: animate
    end type

    type GT_FRAME
        type(GT_FIGURE), pointer:: figs(:)
        type(VSTRING):: title
        logical:: first_figure
    end type

    type GT_DEVICE
        integer:: ws_id
    end type

    ! 𕹓ۂ邽߂̌^
    type GT_OBJECT
        type(GT_AXIS), pointer:: axis
        type(GT_CONTOURS), pointer:: cont
        type(GT_LINE), pointer:: line
        type(GT_FIGURE), pointer:: fig
        type(GT_FRAME), pointer:: frame
        type(GT_OBJECT), pointer:: next
    end type

end module
