! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine GTVarDelAttr(var, name, err)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: del_attr, an_variable
    use gt_mem, only: del_attr, mem_variable
    use dc_error, only: GT_EBADVAR, StoreError
    implicit none
    type(GT_VARIABLE), intent(inout):: var
    character(len = *), intent(in):: name
    logical, intent(out), optional:: err
    integer:: class, cid
continue
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        call del_attr(an_variable(cid), name, err)
    else if (class == vtb_class_memory) then
        call del_attr(mem_variable(cid), name, err)
    else
        call StoreError(GT_EBADVAR, 'GTVarDelAttr', err)
    endif
end subroutine
