#!/bin/sh

set -e

test ! -f diffusion_1.nc || rm -f diffusion_1.nc

./diffusion 2> xdifs.log

ncdump diffusion_1.nc > xdifs.cdl

diff xdifs.cdl - <<EOF
netcdf diffusion_1 {
dimensions:
	x = 30 ;
	t = UNLIMITED ; // (201 currently)
variables:
	float x(x) ;
		x:long_name = "X-coordinate" ;
		x:units = "m" ;
	float t(t) ;
		t:long_name = "time" ;
		t:units = "s" ;
	double temp(t, x) ;
		temp:long_name = "temperature" ;
		temp:units = "K" ;

// global attributes:
		:title = "Diffusion equation" ;
		:source = "Sample program of gtool_history/gtool4" ;
		:institution = "GFD_Dennou Club davis project" ;
data:

 x = 0, 0.03448276, 0.06896552, 0.1034483, 0.137931, 0.1724138, 0.2068965, 
    0.2413793, 0.2758621, 0.3103448, 0.3448276, 0.3793103, 0.4137931, 
    0.4482759, 0.4827586, 0.5172414, 0.5517241, 0.5862069, 0.6206896, 
    0.6551724, 0.6896552, 0.7241379, 0.7586207, 0.7931035, 0.8275862, 
    0.862069, 0.8965517, 0.9310345, 0.9655172, 1 ;

 t = 0, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 
    0.055, 0.06, 0.06500001, 0.07000001, 0.075, 0.08000001, 0.08500001, 0.09, 
    0.09500001, 0.1, 0.105, 0.11, 0.115, 0.12, 0.125, 0.13, 0.135, 0.14, 
    0.145, 0.15, 0.155, 0.16, 0.165, 0.17, 0.175, 0.18, 0.185, 0.19, 0.195, 
    0.2, 0.205, 0.21, 0.215, 0.22, 0.225, 0.23, 0.235, 0.24, 0.245, 0.25, 
    0.255, 0.26, 0.265, 0.27, 0.275, 0.28, 0.285, 0.29, 0.295, 0.3, 0.305, 
    0.31, 0.315, 0.32, 0.325, 0.33, 0.335, 0.34, 0.345, 0.35, 0.355, 0.36, 
    0.365, 0.37, 0.375, 0.38, 0.385, 0.39, 0.395, 0.4, 0.405, 0.41, 0.415, 
    0.42, 0.425, 0.43, 0.435, 0.44, 0.445, 0.45, 0.455, 0.46, 0.465, 0.47, 
    0.475, 0.48, 0.485, 0.49, 0.495, 0.5000001, 0.5050001, 0.5100001, 0.515, 
    0.52, 0.525, 0.53, 0.535, 0.54, 0.545, 0.55, 0.5550001, 0.5600001, 
    0.5650001, 0.5700001, 0.575, 0.58, 0.585, 0.59, 0.595, 0.6, 0.605, 0.61, 
    0.6150001, 0.6200001, 0.6250001, 0.6300001, 0.6350001, 0.64, 0.645, 0.65, 
    0.655, 0.66, 0.665, 0.6700001, 0.6750001, 0.6800001, 0.6850001, 
    0.6900001, 0.6950001, 0.7, 0.705, 0.71, 0.715, 0.72, 0.725, 0.7300001, 
    0.7350001, 0.7400001, 0.7450001, 0.7500001, 0.7550001, 0.7600001, 0.765, 
    0.77, 0.775, 0.78, 0.785, 0.7900001, 0.7950001, 0.8000001, 0.8050001, 
    0.8100001, 0.8150001, 0.8200001, 0.825, 0.83, 0.835, 0.84, 0.8450001, 
    0.8500001, 0.8550001, 0.8600001, 0.8650001, 0.8700001, 0.8750001, 
    0.8800001, 0.8850001, 0.89, 0.895, 0.9, 0.9050001, 0.9100001, 0.9150001, 
    0.9200001, 0.9250001, 0.9300001, 0.9350001, 0.9400001, 0.9450001, 0.95, 
    0.955, 0.96, 0.9650001, 0.9700001, 0.9750001, 0.9800001, 0.9850001, 
    0.9900001, 0.9950001, 1 ;

 temp =
  1.38879542122922e-11, 3.87761921792298e-10, 8.53515772443671e-09, 
    1.48107636541387e-07, 2.02610925813017e-06, 2.18508219965393e-05, 
    0.000185777111465519, 0.00124519148341671, 0.00657960142498993, 
    0.0274083277581443, 0.0900088060584303, 0.233027390329919, 
    0.475607233183334, 0.7652607498358, 0.970710965959007, 0.970710978428593, 
    0.765260779327025, 0.475607263731179, 0.233027411283928, 
    0.0900088164645698, 0.0274083316310539, 0.00657960252375561, 
    0.00124519172334947, 0.000185777152035358, 2.18508273296861e-05, 
    2.02610980469832e-06, 1.48107680300394e-07, 8.53516046546642e-09, 
    3.87762056282641e-10, 1.3887959385959e-11,
  1.38879542122922e-11, 3.65652803304914e-09, 6.37994081686141e-08, 
    8.79117131244473e-07, 9.57270169742353e-06, 8.24455383413045e-05, 
    0.000562329870840121, 0.00304282721921932, 0.013094961825656, 
    0.0449733504254865, 0.123824621477433, 0.274892901864046, 
    0.495401714103502, 0.729853260017675, 0.884319150575599, 
    0.884319159715862, 0.729853282795609, 0.495401740172831, 
    0.274892922416884, 0.123824633571729, 0.0449733558790919, 
    0.01309496372981, 0.00304282773645923, 0.000562329980425044, 
    8.24455564787248e-05, 9.57270404531686e-06, 8.79117369186678e-07, 
    6.37994270616544e-08, 3.65652920921168e-09, 1.3887959385959e-11,
  1.38879542122922e-11, 2.74148802823779e-08, 3.81350447073812e-07, 
    4.19192852080182e-06, 3.65600786790004e-05, 0.000253593881752569, 
    0.00140358769024328, 0.00622670086118007, 0.0222729021341878, 
    0.0647254485819403, 0.154191875571281, 0.304092647112635, 
    0.501264633935877, 0.696219290092252, 0.819366243870438, 
    0.819366251058381, 0.696219308519577, 0.501264656301489, 
    0.30409266642834, 0.154191888429984, 0.0647254553354118, 
    0.0222729049476888, 0.00622670179019846, 0.00140358793279346, 
    0.00025359393170417, 3.65600867791556e-05, 4.19192955386835e-06, 
    3.81350550627083e-07, 2.74148884160871e-08, 1.3887959385959e-11,
  1.38879542122922e-11, 1.64722676388975e-07, 1.83486870110861e-06, 
    1.62003882421629e-05, 0.000114211989996733, 0.000645903585587122, 
    0.00294813446702166, 0.0109460096674176, 0.0333767708903037, 
    0.0844947864359644, 0.179604518851777, 0.323970194230901, 
    0.500332246339227, 0.66602414958306, 0.767582949983851, 
    0.767582955852894, 0.666024164940274, 0.500332265766303, 
    0.323970212113923, 0.1796045318584, 0.084494794099928, 
    0.0333767745681374, 0.0109460111002011, 0.00294813491724403, 
    0.000645903698927895, 0.000114212012723711, 1.620039185608e-05, 
    1.83486915539829e-06, 1.64722721228563e-07, 1.3887959385959e-11,
  1.38879542122922e-11, 7.97759069030865e-07, 7.17327355806215e-06, 
    5.13735677456432e-05, 0.000296574437425152, 0.00139041539619404, 
    0.0053431530347465, 0.0170150385733559, 0.045439761995868, 
    0.102993304396321, 0.20031664400594, 0.337424671384827, 
    0.495845448495167, 0.639056178355724, 0.724877474536669, 
    0.724877479459623, 0.639056191434539, 0.495845465561591, 
    0.337424687866598, 0.2003166568165, 0.102993312630705, 
    0.0454397664058258, 0.0170150405370161, 0.00534315375647711, 
    0.00139041561309043, 0.00029657449021819, 5.13735780679795e-05, 
    7.17327516880149e-06, 7.97759267191356e-07, 1.3887959385959e-11,
  1.38879542122922e-11, 3.14321119190376e-06, 2.30785942952683e-05, 
    0.000135894314384247, 0.000653427614495616, 0.00259258151609969, 
    0.00858905490507635, 0.0240596072906222, 0.0576884310491322, 
    0.119716505041682, 0.217046106132168, 0.346386683139348, 
    0.489449623275195, 0.614923920167427, 0.688789619579727, 
    0.688789623792016, 0.614923931493492, 0.489449638418983, 
    0.346386698323221, 0.21704611856219, 0.119716513592177, 
    0.0576884360385931, 0.0240596097607191, 0.00858905593675557, 
    0.00259258187627342, 0.000653427718435186, 0.000135894338902288, 
    2.3078598975245e-05, 3.14321190072937e-06, 1.3887959385959e-11,
  1.38879542122922e-11, 1.02043257085521e-05, 6.21347781437795e-05, 
    0.000306078066134924, 0.00125121911027076, 0.00429868445428686, 
    0.0125729053420384, 0.0316951608225122, 0.069630316428729, 
    0.134560798002029, 0.230506722244772, 0.352156937152017, 
    0.482053598384858, 0.593222503734666, 0.657729093041408, 
    0.657729096702505, 0.59322251367474, 0.482053611940149, 0.35215695116104, 
    0.230506734201448, 0.13456080668645, 0.0696303218562122, 
    0.0316951637471471, 0.0125729066962042, 0.00429868498908219, 
    0.00125121928856005, 0.000306078115707813, 6.21347894957935e-05, 
    1.02043277891878e-05, 1.3887959385959e-11,
  1.38879542122922e-11, 2.77501688011133e-05, 0.000142876179931624, 
    0.000600931738795396, 0.00213524652694597, 0.00649653528119519, 
    0.017134504138929, 0.0396059857600714, 0.0809818516216319, 
    0.147602792361162, 0.241315377063109, 0.35562456802247, 
    0.474178576603325, 0.573600998760394, 0.630604072286948, 
    0.630604075509372, 0.573601007580357, 0.474178588829212, 
    0.355624580977686, 0.241315388506814, 0.147602801052023, 
    0.0809818573662099, 0.0396059890767718, 0.0171345058089318, 
    0.00649653601062503, 0.00213524680102081, 0.000600931826421654, 
    0.000142876203456902, 2.77501739054586e-05, 1.3887959385959e-11,
  1.38879542122922e-11, 6.44917183593852e-05, 0.00028707806267707, 
    0.00105349876957816, 0.00332398914500951, 0.00913587940973721, 
    0.0221104965293633, 0.0475552797699653, 0.0915974061911218, 
    0.158994829273328, 0.249976250470249, 0.357409513930388, 
    0.466133744070075, 0.555763661681136, 0.606634279906968, 
    0.606634282773099, 0.555763669579525, 0.466133755170454, 
    0.35740952594333, 0.249976261391974, 0.158994837882848, 
    0.0915974121536896, 0.0475552834151518, 0.0221104984962915, 
    0.00913588034320121, 0.00332398953215951, 0.00105349890865159, 
    0.000287078105410809, 6.4491729063358e-05, 1.3887959385959e-11,
  1.38879542122922e-11, 0.000130970518067614, 0.000515760424709039, 
    0.00168596009994764, 0.00481314788028497, 0.0121478062177214, 
    0.0273542016713649, 0.0553754630070921, 0.101418308976733, 
    0.168911901025489, 0.256894250522063, 0.357952365448967, 
    0.458104585210601, 0.539465375394089, 0.585243184972815, 
    0.585243187544594, 0.53946538252285, 0.458104595348276, 
    0.357952376619319, 0.256894260930362, 0.168911909494248, 
    0.101418315077885, 0.0553754669210298, 0.0273542039094291, 
    0.0121478073560321, 0.00481314839284381, 0.00168596030282643, 
    0.000515760494485101, 0.000130970537739085, 1.3887959385959e-11,
  1.38879542122922e-11, 0.000237701582667448, 0.000846025250551553, 
    0.00250887364335913, 0.00658238934676148, 0.0154578718569681, 
    0.0327428530708769, 0.062953539762053, 0.110438348198634, 
    0.177527424005702, 0.262392610187641, 0.35757143651104, 
    0.450202788638802, 0.524502731227619, 0.565993616068668, 
    0.565993618393792, 0.524502737705417, 0.45020279794547, 
    0.357571446926708, 0.262392620100807, 0.177527432294459, 
    0.110438354375641, 0.0629535438910097, 0.0327428555511996, 
    0.0154578731945965, 0.00658238999222852, 0.00250887392048869, 
    0.000846025355228334, 0.000237701615136049, 1.3887959385959e-11,
  1.38879542122922e-11, 0.000393548183904401, 0.00128945292174735, 
    0.00352255930316426, 0.00860161649997522, 0.0189940662561818, 
    0.0381781125227246, 0.0702173083551257, 0.118681943080893, 
    0.185002278829064, 0.266729496105428, 0.356500223552913, 
    0.442494430504116, 0.510706521686608, 0.548546699012048, 
    0.548546701127942, 0.510706527607746, 0.442494439087579, 
    0.356500233290945, 0.266729505546832, 0.185002286912894, 
    0.118681949284686, 0.070217312652037, 0.0381781152157949, 
    0.0189940677832593, 0.0086016172816102, 0.00352255966266334, 
    0.00128945306857699, 0.000393548233083497, 1.3887959385959e-11,
  1.38879542122922e-11, 0.000604789132282719, 0.00185174624376711, 
    0.00471928168679499, 0.0108358981939704, 0.0226909327919137, 
    0.0435837032121945, 0.0771242057893067, 0.126190265773381, 
    0.191480872867655, 0.270111792318235, 0.354912196596968, 
    0.435017050412506, 0.497935131207955, 0.532634904462112, 
    0.532634906398644, 0.497935136648496, 0.435017058361957, 
    0.354912205724771, 0.270111801313511, 0.19148088073179, 
    0.126190271965886, 0.0771242102136465, 0.04358370608938, 
    0.0226909344958326, 0.0108358991115559, 0.00471928213437472, 
    0.0018517464389622, 0.000604789201844061, 1.3887959385959e-11,
  1.38879542122922e-11, 0.000874820788214615, 0.00253319946962566, 
    0.00608552034934117, 0.0132489031337282, 0.0264913009140294, 
    0.0489020748763761, 0.0836527030376625, 0.133012688208099, 
    0.197090474521718, 0.272706060831023, 0.352937717518701, 
    0.427790011960447, 0.48606933223484, 0.51804364982129, 0.518043651602634, 
    0.486069337256941, 0.427790019350398, 0.352937726095279, 
    0.272706069406382, 0.197090482158578, 0.13301269436001, 
    0.0836527075549372, 0.0489020779107814, 0.0264913027806537, 
    0.0132489041843294, 0.00608552088843055, 0.0025331997181195, 
    0.000874820881354406, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00120430690624821, 0.00332960220777345, 
    0.00760397196369146, 0.0158051290799697, 0.0303466033104208, 
    0.0540909838521506, 0.0897959379975687, 0.139201523928872, 
    0.201942119686492, 0.274647118531786, 0.350675695569993, 
    0.420821075940145, 0.475008077996766, 0.504598449286456, 
    0.504598450932428, 0.47500808265181, 0.420821082833393, 
    0.350675703647082, 0.274647126713019, 0.20194212709357, 
    0.139201530017839, 0.0897959425786617, 0.0540909870190506, 
    0.0303466053249593, 0.0158051302586179, 0.00760397259567617, 
    0.00332960251313634, 0.0012043070255491, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00159158255358212, 0.00423328806550137, 
    0.00925518613945389, 0.0184712325729765, 0.0342164256269526, 
    0.0591204053288583, 0.0955570539800952, 0.144808895868952, 
    0.206132151415093, 0.2760446832387, 0.348201811235141, 0.414110577490577, 
    0.46466519419095, 0.492155698167568, 0.492155699694592, 
    0.464665198521844, 0.414110583940465, 0.348201818858217, 
    0.276044691050608, 0.206132158593437, 0.144808901878124, 
    0.0955570586005812, 0.0591204086058585, 0.0342164277745672, 
    0.0184712338732446, 0.00925518686396613, 0.00423328842996966, 
    0.00159158270095606, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00203315928766654, 0.00523415909283225, 
    0.0110188256215616, 0.0212167388777373, 0.0380676956240267, 
    0.0639698928885219, 0.100945843032618, 0.149884925590758, 
    0.209743942288228, 0.276988535981239, 0.345574374978676, 
    0.407654157247906, 0.4549667342577, 0.480595941252328, 0.480595942674152, 
    0.454966738300603, 0.407654163300082, 0.34557438218783, 0.27698854344733, 
    0.209743949241349, 0.149884931507624, 0.10094584767211, 
    0.0639698962555512, 0.0380676978902387, 0.0212167402922093, 
    0.0110188264367807, 0.00523415951741085, 0.00203315946435792, 
    1.3887959385959e-11,
  1.38879542122922e-11, 0.00252423625809854, 0.00632059100978807, 
    0.0128745959724237, 0.024014343819053, 0.041873742471067, 
    0.0686264062302603, 0.105976340489139, 0.154476758148658, 
    0.212849577585502, 0.27755252966274, 0.342838577974138, 
    0.401444547095107, 0.445848876665314, 0.469818859716784, 
    0.469818861045018, 0.445848880450953, 0.401444552788893, 
    0.342838584804825, 0.277552536805086, 0.212849584318581, 
    0.154476763964134, 0.105976345130697, 0.0686264096694667, 
    0.0418737448420161, 0.0240143453396959, 0.0128745968753644, 
    0.00632059149439443, 0.00252423646472777, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00305916211988656, 0.00748018298720821, 
    0.0148029009610996, 0.0268399571379792, 0.0456133606541205, 
    0.0730825587202349, 0.110665119016748, 0.158628103324131, 
    0.21551139850705, 0.277797721642677, 0.340029604520215, 
    0.395472757335874, 0.437256233482036, 0.459739481848322, 
    0.45973948309285, 0.437256237036713, 0.395472762705351, 
    0.340029611003888, 0.277797728481874, 0.215511405026373, 
    0.158628109031827, 0.110665123646349, 0.0730825622158277, 
    0.0456133631167181, 0.026839958756432, 0.0148029019478745, 
    0.00748018353083475, 0.00305916235651758, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00363182376048953, 0.00870034668756638, 
    0.016785280284384, 0.0296725913497864, 0.0492699424633062, 
    0.0773352277717932, 0.115030087553165, 0.162379094253403, 
    0.217783371886004, 0.277774829512893, 0.337174943372337, 
    0.389728862980735, 0.429140487254654, 0.450285275914133, 
    0.45028527708343, 0.429140490601036, 0.389728868055608, 
    0.337174949536988, 0.277774836068085, 0.217783378198545, 
    0.16237909984905, 0.115030092159255, 0.0773352313098621, 
    0.0492699450053154, 0.0296725930575815, 0.0167852813504355, 
    0.00870034728844517, 0.00363182402670883, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00423595579907525, 0.00996874744388849, 
    0.0188046801208859, 0.0324941633450596, 0.052830708987947, 
    0.0813844640601389, 0.119089656555614, 0.165766335866584, 
    0.219712281179592, 0.277526169445019, 0.334296118531586, 
    0.384202527488925, 0.421459282456715, 0.441393892285947, 
    0.44139389338733, 0.421459285614463, 0.38420253229522, 0.334296124402208, 
    0.277526175733954, 0.219712287292713, 0.165766341347576, 
    0.119089661128709, 0.0813844676284674, 0.0528307115980123, 
    0.0324941651337885, 0.0188046812611855, 0.00996874809964812, 
    0.00423595609407365, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00486537531263332, 0.011273618319622, 
    0.0208455982381179, 0.0352892532457134, 0.0562860457428335, 
    0.0852326437080793, 0.122862166968822, 0.168823062388402, 
    0.221338751280456, 0.277087192996188, 0.331409999748659, 
    0.378883347694041, 0.414175320025712, 0.433011388855284, 
    0.433011389895106, 0.414175323011972, 0.378883352254672, 
    0.331410005347632, 0.277087199035292, 0.221338757201696, 
    0.168823067753434, 0.122862171501183, 0.0852326472959626, 
    0.0562860484104765, 0.0352892551071497, 0.020845599447333, 
    0.0112736190274306, 0.00486537563528499, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00551415121959861, 0.012603969764011, 
    0.0228941377256475, 0.038044847711473, 0.0596289391258657, 
    0.0888838139954602, 0.126365509154115, 0.17157935319503, 
    0.222698123917507, 0.276487713461196, 0.328529802162017, 
    0.373761078967017, 0.407255612222855, 0.425090821914475, 
    0.425090822898284, 0.407255615052661, 0.373761083302248, 
    0.328529807509442, 0.276487719265664, 0.222698129654424, 
    0.171579358443809, 0.126365513639461, 0.0888838175935355, 
    0.0596289418414599, 0.0380448496376602, 0.0228941389982802, 
    0.0126039705207025, 0.00551415156853373, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0061767193719295, 0.0139497167678999, 
    0.0249379957591249, 0.040750084750833, 0.0628545037460165, 
    0.092343192117096, 0.129616877937762, 0.174062375001064, 
    0.223821203293538, 0.275752889316393, 0.325665855602456, 
    0.368825778033409, 0.400670866302282, 0.417591116240746, 
    0.417591117173413, 0.400670868988878, 0.368825782161237, 
    0.32566586071644, 0.275752894900269, 0.223821208853598, 
    0.174062380134081, 0.129616882371034, 0.0923431957171854, 
    0.0628545065007483, 0.0407500867341461, 0.0249379970896241, 
    0.0139497175700831, 0.00617671974559899, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00684795432376162, 0.0153017427529956, 
    0.0269664079757853, 0.0433960096626828, 0.0659595891891991, 
    0.0956167837245243, 0.132632624731, 0.176296630905698, 0.224734890019368, 
    0.274904017620428, 0.322826200505349, 0.364067890006818, 
    0.394394971439497, 0.410476151142856, 0.410476152028676, 
    0.394394973994604, 0.364067893943286, 0.322826205402243, 0.2749040229967, 
    0.224734895409872, 0.176296635924045, 0.132632629108161, 
    0.0956167873194944, 0.0659595919750222, 0.0433960116958692, 
    0.0269664093586359, 0.0153017435971457, 0.00684795472049312, 
    1.3887959385959e-11,
  1.38879542122922e-11, 0.00752320760805649, 0.0166519165188752, 
    0.0289700638690396, 0.045975347485972, 0.0689424544643058, 
    0.0987110947356692, 0.135428178337848, 0.178304204376848, 
    0.225462720258309, 0.273959177315375, 0.32001705288325, 
    0.359478297061703, 0.388404569433157, 0.403714015078515, 
    0.403714015921295, 0.388404571867191, 0.359478300821168, 
    0.320017057577864, 0.273959182496053, 0.225462725486335, 
    0.178304209282068, 0.135428182655716, 0.0987110983193047, 
    0.0689424572738915, 0.045975349562176, 0.0289700652988328, 
    0.0166519174014093, 0.00752320802610189, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00819832094880402, 0.0179930754563141, 
    0.0309410047775149, 0.0484822943471931, 0.0718024993711786, 
    0.101632915316825, 0.138018013774838, 0.180104991454552, 
    0.226025324553565, 0.272933753742825, 0.317243169231578, 
    0.355048341173443, 0.382678693480208, 0.397276393185296, 
    0.397276393988421, 0.382678695802463, 0.355048344768794, 
    0.317243173737352, 0.272933758739023, 0.226025329625941, 
    0.180104996248531, 0.138018018030942, 0.101632918883718, 
    0.0718025021978652, 0.0484822964599683, 0.0309410062490013, 
    0.0179930763736532, 0.00819832138637885, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00886962130296643, 0.0193189855383272, 
    0.0328725128681322, 0.0509123284292549, 0.0745400432141598, 
    0.104389159464725, 0.140415654119309, 0.181716917496939, 
    0.226440818982345, 0.27184086842171, 0.314508134669827, 
    0.350769829281788, 0.377198462760075, 0.391138060459731, 
    0.391138061226223, 0.377198464978873, 0.350769832724635, 
    0.314508138998991, 0.271840873243717, 0.226440823905622, 
    0.181716922181808, 0.140415658311776, 0.104389163010175, 
    0.0745400460519032, 0.0509123305725679, 0.0328725143762616, 
    0.0193189864869444, 0.00886962175828191, 1.3887959385959e-11,
  1.38879542122922e-11, 0.00953390324837911, 0.0206242861912647, 
    0.0347589971730599, 0.0532620401819673, 0.0771561426742196, 
    0.106986747226347, 0.142633694489227, 0.183156136900341, 
    0.226725139212608, 0.270691733026647, 0.311814591648818, 
    0.346635026847879, 0.371946822926593, 0.385276459627252, 
    0.385276460359819, 0.371946825049409, 0.346635030148709, 
    0.311814595812527, 0.270691737683998, 0.22672514399305, 
    0.183156141478406, 0.142633698616678, 0.106986750746277, 
    0.0771561455175455, 0.0532620423501936, 0.0347589987130091, 
    0.0206242871677234, 0.0095339037196678, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0101884030017224, 0.0219044262019673, 
    0.0365958808913937, 0.0555289808192777, 0.0796524419275639, 
    0.109432519470609, 0.144683840311711, 0.184437215409168, 
    0.22689232644829, 0.26949594231276, 0.309164422453779, 0.34263664387807, 
    0.366908324631265, 0.37967134739468, 0.379671348095757, 
    0.366908326664837, 0.342636647046386, 0.309164426462224, 
    0.269495946814295, 0.226892331091872, 0.18443721988285, 
    0.144683844373182, 0.10943252296149, 0.0796524447715225, 
    0.0555289830071929, 0.0365958824585857, 0.0219044272029498, 
    0.0101884034872582, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0108307673363377, 0.0231555952119174, 
    0.0383794928121711, 0.0577115278155635, 0.0820310492690798, 
    0.111733177403859, 0.146576954230531, 0.185573295435063, 
    0.22695477273078, 0.26826171767323, 0.306558895520226, 0.33876781631329, 
    0.362068933680647, 0.374304496322569, 0.374304496994354, 
    0.362068935631065, 0.33876781935772, 0.306558899382741, 
    0.268261722027152, 0.226954777243188, 0.185573299806854, 
    0.146576958225404, 0.111733180862642, 0.0820310521092028, 
    0.0577115300183308, 0.0383794944022861, 0.0231555962342457, 
    0.010830767834451, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0114590198334501, 0.0243746540981277, 
    0.0401069646851121, 0.0598087659830797, 0.0842944355029192, 
    0.113895240797601, 0.148323107647369, 0.186576245216517, 
    0.22692343187451, 0.266996110540049, 0.303998783288375, 0.33502208476696, 
    0.357415867662925, 0.369159442231416, 0.369159442875895, 
    0.35741586953571, 0.335022087695362, 0.303998787013521, 
    0.266996114753978, 0.226923436261144, 0.186576249488943, 
    0.14832311157531, 0.113895244221663, 0.0842944383351809, 
    0.0598087681962348, 0.0401069662940931, 0.0243746551387779, 
    0.0114590203425391, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0120715262412772, 0.0255590665567388, 
    0.0417761356207982, 0.0618203826809112, 0.0864453502144289, 
    0.115925020293047, 0.149931634073254, 0.18745679290676, 0.22680800125734, 
    0.265705172980926, 0.301484457531292, 0.331393372003577, 
    0.352937454815142, 0.364221269125026, 0.364221269744001, 
    0.352937456615312, 0.331393374823124, 0.30148446112694, 
    0.265705177061945, 0.226808005523327, 0.187456797082355, 
    0.149931637934169, 0.115925023680138, 0.0864453530352084, 
    0.0618203849003454, 0.0417761372448513, 0.0255590676128507, 
    0.0120715267598157, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0126669601980296, 0.0267068334585917, 
    0.0433854640565682, 0.0637465757458184, 0.0884867527468147, 
    0.117828600224163, 0.151411182349465, 0.188224646770882, 
    0.226617078845198, 0.264394101352546, 0.29901596677782, 
    0.327875960096969, 0.348623011673115, 0.359476425207279, 
    0.359476425802388, 0.34862301340524, 0.327875962814219, 
    0.299015970251216, 0.264394105307246, 0.226617082995396, 
    0.188224650852164, 0.15141118614346, 0.117828603572363, 
    0.0884867555528625, 0.0637465779677605, 0.0433854656921597, 
    0.0267068345274733, 0.0126669607245722, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0132442701783864, 0.0278164309799446, 
    0.0449339474405349, 0.0655879728105888, 0.0904217552884453, 
    0.119611829241612, 0.152769768429633, 0.188888602705409, 
    0.226358299108069, 0.263067357726632, 0.296593099424063, 
    0.324464467906582, 0.344462736647863, 0.354912564815631, 
    0.354912565388369, 0.344462738316117, 0.324464470527546, 
    0.296593102781887, 0.263067361561151, 0.22635830314708, 
    0.188888606694866, 0.152769772156975, 0.119611832549294, 
    0.0904217580768518, 0.0655879750315869, 0.0449339490843853, 
    0.0278164320590742, 0.0132442707115714, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0138026482219518, 0.0288867530933797, 
    0.0464210495186777, 0.0673455607709958, 0.0922535759544683, 
    0.121280316664548, 0.154014824882447, 0.189456640260976, 
    0.226038450902281, 0.261728772887743, 0.294215435356545, 
    0.321153829283478, 0.340447617166078, 0.350518412070471, 
    0.350518412622201, 0.340447618774282, 0.321153831813678, 
    0.294215438604969, 0.261728776607801, 0.226038454834466, 
    0.189456644161052, 0.154014828543542, 0.121280319930342, 
    0.0922535787226349, 0.0673455629878985, 0.0464210511677536, 
    0.0288867541804047, 0.0138026487605022, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0143415007785053, 0.0299170586983953, 
    0.0478466349317727, 0.0690206242660876, 0.0939855001335725, 
    0.122839432987257, 0.155153247606046, 0.189936008295314, 
    0.225663579901901, 0.260381633986965, 0.291882388306493, 
    0.317939272265202, 0.336569348405639, 0.346283642812484, 
    0.346283643344456, 0.336569349957295, 0.317939274709716, 
    0.291882391451226, 0.2603816375979, 0.225663583731384, 0.1899360121084, 
    0.155153251201408, 0.122839436210022, 0.093985502879185, 
    0.0690206264760257, 0.0478466365832774, 0.0299170597911292, 
    0.0143415013212288, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0148604218408112, 0.0309069234536079, 
    0.0492109107156812, 0.0706146921408765, 0.0956208486861285, 
    0.124294313349426, 0.156191439485729, 0.190333301307877, 
    0.225239077760775, 0.259028759361219, 0.289593240693985, 
    0.314816299406017, 0.332820261980659, 0.342198782013645, 
    0.342198782527005, 0.332820263478984, 0.314816301769526, 
    0.289593243740313, 0.259028762868016, 0.225239081491464, 
    0.190333305036305, 0.156191443015967, 0.124294316528226, 
    0.0956208514071327, 0.0706146943412444, 0.049210912367044, 
    0.0309069245500255, 0.0148604223865988, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0153591684181761, 0.0318561962212894, 
    0.0505143742328968, 0.0721294909620956, 0.0971629518345023, 
    0.12564986307331, 0.157135350893493, 0.190654527427758, 0.22476975984953, 
    0.25767256257414, 0.287347172358549, 0.311780669313442, 
    0.329193263192596, 0.338255114338946, 0.338255114834748, 
    0.329193264640554, 0.311780671600268, 0.287347175311379, 
    0.257672565981456, 0.224769763485122, 0.190654531073798, 
    0.15713535435929, 0.125649866207386, 0.0971629545290819, 
    0.0721294931505344, 0.0505143758817618, 0.0318561973195215, 
    0.015359168966, 1.3887959385959e-11,
  1.38879542122922e-11, 0.015837638321673, 0.0327649599338959, 
    0.0517577670319659, 0.0735669047532976, 0.0986151277933679, 
    0.126910764595062, 0.157990517044754, 0.190905168942227, 
    0.224259933133859, 0.256315107368196, 0.285143284292638, 
    0.308828379407872, 0.325681775680503, 0.33444460593101, 
    0.334444606410224, 0.325681777080823, 0.308828381622008, 
    0.285143287156525, 0.256315110680391, 0.224259936677855, 
    0.190905172508081, 0.157990520446855, 0.126910767683819, 
    0.0986151304599238, 0.0735669069276778, 0.0517577686761806, 
    0.0327649610322225, 0.0158376388705837, 1.3887959385959e-11,
  1.38879542122922e-11, 0.016295850176367, 0.033633496628419, 
    0.0529420341241206, 0.0749289402046684, 0.0999806653551644, 
    0.128081485289374, 0.158762092304943, 0.19109023617209, 
    0.223713455526789, 0.254958154924824, 0.282980618273032, 
    0.305955649886706, 0.322279692481262, 0.33075983580971, 
    0.330759836273231, 0.322279693836467, 0.305955652031853, 
    0.282980621052212, 0.254958158145977, 0.223713458982504, 
    0.191090239659894, 0.15876209564414, 0.128081488332356, 
    0.0999806679922958, 0.0749289423630738, 0.0529420357617239, 
    0.0336334977252621, 0.0162958507254901, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0167339255402038, 0.0344622563578124, 
    0.0540682881759339, 0.0762176966943962, 0.101262809782167, 
    0.129166285816693, 0.159454881589099, 0.191214315421423, 
    0.22313378785316, 0.25360320459142, 0.280858173112036, 0.303158908850491, 
    0.318981332658626, 0.327193935539069, 0.327193935987722, 
    0.318981333971048, 0.303158910930079, 0.280858175810455, 
    0.253603207725356, 0.223133791223735, 0.191214318833245, 
    0.159454884866227, 0.129166288813574, 0.101262812388655, 
    0.0762176988351087, 0.0540682898051448, 0.0344622574517289, 
    0.0167339260887369, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0171520729881688, 0.0352518296719136, 
    0.0551377781371936, 0.0774353405326977, 0.102464751467322, 
    0.130169228721581, 0.160073369027279, 0.191281611656174, 
    0.222524039400548, 0.252251529041629, 0.278774918112667, 
    0.300434778534106, 0.315781402782702, 0.323740536026744, 
    0.323740536461294, 0.315781404054502, 0.300434780551319, 
    0.278774920734002, 0.252251532091937, 0.222524042688961, 
    0.191281614994013, 0.160073372243202, 0.130169231672146, 
    0.102464754042111, 0.0774353426541821, 0.0551377797563996, 
    0.0352518307615877, 0.0171520735353774, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0175505740098952, 0.0360029233573202, 
    0.0561518618505747, 0.0785840829065188, 0.103589616916538, 
    0.131094187085536, 0.160621744084316, 0.191295986498023, 
    0.22188700789311, 0.250904204677893, 0.276729804203135, 
    0.297780062577554, 0.312674962644594, 0.320393720496452, 
    0.320393720917609, 0.312674963877777, 0.297780064535354, 
    0.27672980675082, 0.250904207647941, 0.221887011102183, 
    0.191295989763813, 0.160621747239921, 0.13109418998967, 
    0.103589619458726, 0.07858408500741, 0.0561518634583206, 
    0.0360029244415558, 0.0175505745551094, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0179297705660025, 0.0367163391323423, 
    0.0571119822209424, 0.0796661610631653, 0.10464046167913, 
    0.131944853094201, 0.161103925327788, 0.19126099205777, 
    0.221225214608113, 0.249562137956512, 0.274721773138877, 
    0.295191734267078, 0.3096573946773, 0.317147982818495, 0.317147983226916, 
    0.309657395873728, 0.295191736168223, 0.274721775616119, 
    0.249562140849467, 0.221225217740525, 0.191260995253378, 
    0.161103928423982, 0.131944855951881, 0.104640464187951, 
    0.0796661631422542, 0.0571119838159198, 0.0367163402100555, 
    0.0179297711086126, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0182900541507811, 0.0373929550061315, 
    0.0580196465552152, 0.0806838223249424, 0.105620264913993, 
    0.132724746421241, 0.161523582036582, 0.191179901075776, 
    0.220540935256096, 0.248226088209281, 0.272749765090743, 
    0.292666925676435, 0.306724376627011, 0.313998190503789, 
    0.313998190900085, 0.306724377788415, 0.292666927523495, 
    0.272749767500543, 0.248226091028121, 0.22054093831439, 
    0.191179904203007, 0.161523585074284, 0.132724749232521, 
    0.105620267388806, 0.0806838243811648, 0.0580196481362519, 
    0.0373929560763434, 0.0182900546902345, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0186318562146737, 0.0380337090280545, 
    0.0588764087170732, 0.08163931057497, 0.106531925329189, 
    0.133437222362843, 0.161884153836125, 0.191055733785796, 
    0.219836227161363, 0.246896687448073, 0.270812724881935, 
    0.290202917639476, 0.303871857080738, 0.31093955176718, 
    0.310939552151919, 0.303871858208733, 0.29020291943485, 
    0.270812727227104, 0.246896690195603, 0.219836230147955, 
    0.191055736846393, 0.161884156816263, 0.133437225127849, 
    0.106531927769469, 0.0816393126073944, 0.0588764102831236, 
    0.0380337100898843, 0.0186318567504709, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0189556398080612, 0.0386395851725519, 
    0.0596838537734539, 0.0825348548970817, 0.107378258274196, 
    0.134085479680327, 0.16218886853719, 0.190891281872349, 
    0.219112953207757, 0.245574457565797, 0.26890960709097, 
    0.287797130487788, 0.30109603350881, 0.30796758615001, 0.307967586523723, 
    0.301096034604899, 0.287797132233717, 0.268909609374142, 
    0.245574460244659, 0.219112956124941, 0.190891284867994, 
    0.162188871460698, 0.134085482399249, 0.10737826067952, 
    0.0825348569048992, 0.0596838553235898, 0.0386395862252098, 
    0.0189556403397524, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0192618923172077, 0.039211601124894, 
    0.0604435848410059, 0.0833726600907084, 0.108161993798462, 
    0.134672568125619, 0.162440758344154, 0.190689129850346, 
    0.218372802953104, 0.24425982528634, 0.267039380201231, 
    0.285447115490637, 0.298393332525587, 0.30507809826276, 0.30507809862594, 
    0.298393333591174, 0.285447117189219, 0.267039382424881, 
    0.244259827899029, 0.218372805803066, 0.190689132782664, 
    0.162440761211967, 0.134672570798702, 0.108161996168503, 
    0.0833726620732223, 0.0604435863744074, 0.0392116021676749, 
    0.0192618928443892, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0195511191731863, 0.0397507977535147, 
    0.0611572118700931, 0.0841548988153014, 0.108885775518692, 
    0.135201395637002, 0.162642674586709, 0.190451674158654, 
    0.217617311263007, 0.242953135165126, 0.265201029947701, 
    0.283150546938446, 0.295760392110197, 0.30226715426854, 
    0.302267154621648, 0.295760393146596, 0.283150548591645, 
    0.265201032114151, 0.242953137713997, 0.217617314047827, 
    0.190451677029218, 0.162642677399762, 0.135201398264539, 
    0.108885777853206, 0.0841549007719185, 0.0611572133860405, 
    0.0397507987857921, 0.0195511196954975, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0198238384247148, 0.0402582300743902, 
    0.0618263421312994, 0.0848837051486633, 0.109552160161282, 
    0.135674735201613, 0.162797301116856, 0.190181140226166, 
    0.216847874769189, 0.241654660899009, 0.26339356198692, 
    0.280905214815182, 0.293194045562043, 0.299531060779096, 
    0.299531061122564, 0.293194046570483, 0.280905216424839, 
    0.263393564098356, 0.241654663386289, 0.216847877490847, 
    0.190181143036491, 0.162797303876083, 0.135674737783944, 
    0.109552162460107, 0.0848837070788848, 0.0618263436291651, 
    0.0402582310956101, 0.0198238389418349, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0200805760757579, 0.0407349595318274, 
    0.0624525721945807, 0.0855611693698932, 0.110163617666533, 
    0.136095231387619, 0.162907166500998, 0.189879597739473, 
    0.216065766418462, 0.240364615168001, 0.261616003996064, 
    0.278709018009276, 0.290691306994238, 0.296866345878333, 
    0.296866346212565, 0.290691307975869, 0.278709019577119, 
    0.261616006054544, 0.240364617595794, 0.216065769078848, 
    0.189879600491027, 0.162907169207327, 0.13609523392512, 
    0.110163619929575, 0.0855611712733068, 0.0624525736738224, 
    0.0407349605415029, 0.0200805765874029, 1.3887959385959e-11,
  1.38879542122922e-11, 0.020321862098277, 0.0411820474378045, 
    0.0630374812142514, 0.0861893338009279, 0.110722531758224, 
    0.136465406553419, 0.162974655125309, 0.189548974315042, 
    0.21527214834452, 0.239083158200607, 0.259867407290337, 
    0.276559958016811, 0.288249358192643, 0.294269742025437, 
    0.294269742350811, 0.288249359148545, 0.276559959544464, 
    0.259867409297801, 0.239083160570909, 0.215272150945438, 
    0.189548977009243, 0.162974657779664, 0.136465409046502, 
    0.110722533985452, 0.0861893356772007, 0.0630374826744048, 
    0.0411820484355108, 0.0203218626041971, 1.3887959385959e-11,
  1.38879542122922e-11, 0.020548227039501, 0.041600549428525, 
    0.0635826253539076, 0.0867701895611903, 0.111231200896511, 
    0.136787666744227, 0.163002017321616, 0.189191067755489, 
    0.214468083265427, 0.237810405228419, 0.258146848034046, 
    0.274456133094665, 0.285865536689409, 0.291738170621462, 
    0.291738170938334, 0.285865537620596, 0.274456134583657, 
    0.258146849992324, 0.237810407543121, 0.214468085808597, 
    0.189191070393708, 0.163002019924911, 0.136787669193333, 
    0.111231203087954, 0.0867701914100617, 0.0635826267945802, 
    0.0416005504138942, 0.0205482275394778, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0207601991514628, 0.0419915108120464, 
    0.0640895332043002, 0.087305674107954, 0.111691839544284, 
    0.137064307288255, 0.162991378610683, 0.188807557048901, 
    0.213654544584234, 0.236546432973294, 0.25645342810922, 0.27239573282505, 
    0.283537324918317, 0.289268728050587, 0.289268728359289, 
    0.283537325825741, 0.272395734276819, 0.25645343002004, 
    0.236546435234191, 0.213654547071301, 0.188807559632466, 
    0.162991381163827, 0.13706430969385, 0.111691841700023, 
    0.0873056759292293, 0.0640895346251653, 0.0419915117847631, 
    0.0207601996453068, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0209583019782733, 0.0423559626947396, 
    0.0645597020641787, 0.0877976694509787, 0.112106579687436, 
    0.137297518105811, 0.16294474815031, 0.188400012251844, 
    0.212832425348053, 0.235291285291383, 0.254786275695963, 
    0.270377033056339, 0.281262340335212, 0.286858673030849, 
    0.286858673331695, 0.281262341219771, 0.270377034472241, 
    0.254786277560959, 0.235291287500177, 0.212832427780592, 
    0.18840001478204, 0.162944750654202, 0.137297520468386, 
    0.112106581807598, 0.0877976712445234, 0.06455970346497, 
    0.0423559636545368, 0.0209583024658219, 1.3887959385959e-11,
  1.38879542122922e-11, 0.021143052343675, 0.0426949187869397, 
    0.0649945949693755, 0.0882480009440046, 0.112477472558312, 
    0.137489388745139, 0.162864026466858, 0.187969903380471, 
    0.212002546201667, 0.234044978081856, 0.253144545610665, 
    0.268398391188344, 0.279038326400756, 0.284505415129533, 
    0.284505415422818, 0.279038327263294, 0.268398392569661, 
    0.253144547431385, 0.234044980240168, 0.212002548581186, 
    0.187969905858542, 0.162864028922387, 0.137489391065203, 
    0.112477474643066, 0.0882480027097388, 0.0649945963498815, 
    0.0426949197335943, 0.02114305282479, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0213149586878383, 0.0430093727995398, 
    0.0653956383690293, 0.088658436568042, 0.112806490519136, 
    0.137641913158942, 0.16275101254084, 0.187518608419812, 
    0.211165662454989, 0.232807503554104, 0.251527419441357, 
    0.266458241773142, 0.276863144334866, 0.282206504316088, 
    0.282206504602091, 0.276863145176179, 0.266458243121081, 
    0.251527421219265, 0.232807505663476, 0.211165664782931, 
    0.187518610846963, 0.162751014948884, 0.137641915437021, 
    0.11280649256869, 0.0886584383059356, 0.0653956397290893, 
    0.0430093737328695, 0.0213149591624038, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0214745197081802, 0.0433002963535253, 
    0.0657642203599966, 0.0890306866322464, 0.113095529068621, 
    0.137756994235315, 0.162607410309969, 0.187047420548605, 
    0.210322470369043, 0.231578833935003, 0.249934105513733, 
    0.264555092405257, 0.274734765562815, 0.279959621440786, 
    0.279959621719769, 0.274734766383656, 0.264555093720962, 
    0.24993410725022, 0.231578835996903, 0.210322472646794, 
    0.187047422926005, 0.162607412671397, 0.13775699647195, 
    0.113095531083217, 0.0890306883423142, 0.0657642216994956, 
    0.0433002972733848, 0.0214745201761013, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0216222232642139, 0.0435686373336237, 
    0.0661016894012997, 0.0893664038277081, 0.113346408940506, 
    0.137836448096478, 0.162434834646441, 0.186557554665836, 
    0.209473612752392, 0.230358924687341, 0.24836383871648, 
    0.262687519877505, 0.272651264782265, 0.277762569540688, 
    0.277762569812898, 0.272651265583344, 0.262687521162058, 
    0.248363840412864, 0.23035892670317, 0.20947361498128, 0.186557556994617, 
    0.162434836962109, 0.137836450292221, 0.113346410920415, 
    0.0893664055100056, 0.0661016907201645, 0.0435686382399015, 
    0.0216222237254143, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0217585455111293, 0.0438153186254493, 
    0.0664093534400522, 0.089667183577862, 0.113560878267445, 
    0.137882008178154, 0.162234816859346, 0.186050153295196, 
    0.20861968394872, 0.229147717301394, 0.246815880210381, 
    0.260854166581006, 0.270610813588611, 0.275613265886135, 
    0.275613266151806, 0.270610814370602, 0.260854167835434, 
    0.246815881867917, 0.229147719272488, 0.208619686130021, 
    0.186050155576459, 0.1622348191301, 0.137882010333568, 0.113560880212967, 
    0.0896671852324817, 0.0664093547382476, 0.0438153195180649, 
    0.02175854596555, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0218839502310016, 0.044041237182832, 
    0.0666884793887981, 0.0899345646365748, 0.113740614787805, 
    0.137895329101874, 0.162008809767761, 0.185526291934943, 
    0.207761234286543, 0.227945141713744, 0.245289517042129, 
    0.259053737129926, 0.268611674603173, 0.273509734691156, 
    0.27350973495051, 0.268611675366711, 0.259053738355201, 
    0.245289518662009, 0.22794514364138, 0.207761236421485, 
    0.185526294169753, 0.162008811994433, 0.137895331217529, 
    0.113740616699262, 0.0899345662636424, 0.0666884806663236, 
    0.044041238061733, 0.0218839506785993, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0219988883342656, 0.0442472633785168, 
    0.0669402929017161, 0.0901700298914153, 0.113887228076335, 
    0.137877990351861, 0.161758192385285, 0.184986983912857, 
    0.206898774053443, 0.226751118400583, 0.24378406168074, 
    0.257284995193319, 0.266652196055, 0.271450100420045, 0.271450100673292, 
    0.266652196800689, 0.257284996390365, 0.2437840632641, 0.22675112028598, 
    0.206898776143207, 0.184986986102251, 0.161758194568696, 
    0.137877992428333, 0.113887229954071, 0.0901700314910862, 
    0.0669402941586024, 0.0442472642436764, 0.0219988887750115, 
    1.3887959385959e-11,
  1.38879542122922e-11, 0.022103797507419, 0.0444342405971885, 
    0.0671659784037803, 0.0903750073352687, 0.114002261782756, 
    0.137831499767502, 0.161484274252523, 0.184433184799199, 
    0.206032777049714, 0.225565560186772, 0.242298851491864, 
    0.255546760518104, 0.264730806772588, 0.269432581630175, 
    0.269432581877513, 0.264730807501001, 0.255546761687799, 
    0.242298853039786, 0.225565562031099, 0.206032779095436, 
    0.184433186944183, 0.161484276393482, 0.137831501805374, 
    0.114002263627134, 0.0903750089077251, 0.0671659796400864, 
    0.0444342414486032, 0.0221037979412972, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0221991019858741, 0.0446029850348845, 
    0.0673666793328274, 0.0905508711744095, 0.11408719586484, 
    0.13775729686179, 0.161188299450186, 0.183865796424486, 
    0.205163683769751, 0.224388373806746, 0.240833248163075, 
    0.253837906128682, 0.262846011546627, 0.267455485297928, 
    0.267455485539547, 0.262846012258307, 0.253837907271863, 
    0.240833249676591, 0.224388375611121, 0.205163685772525, 
    0.183865798526038, 0.161188301549489, 0.137757298861646, 
    0.114087197676239, 0.0905508727198579, 0.0673666805486379, 
    0.0446029858725719, 0.0221991024128806, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0222852124334944, 0.0447542856733743, 
    0.0675434985596435, 0.0906989430454867, 0.114143448804823, 
    0.137656755975469, 0.160871450322049, 0.1832856705436, 0.204291904253721, 
    0.223219461248796, 0.239386637091288, 0.252157355690047, 
    0.26099638682917, 0.265517201580602, 0.26551720181668, 0.260996387524635, 
    0.252157356807508, 0.239386638571384, 0.223219463014292, 
    0.204291906214605, 0.18328567260267, 0.16087145238048, 0.137656757937896, 
    0.114143450583636, 0.0906989445641546, 0.067543499755066, 
    0.0447542864973711, 0.022285212853636, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0223625259126676, 0.044888904402078, 
    0.0676974989557264, 0.0908204933176694, 0.114172379799868, 
    0.137531189276049, 0.160534850933979, 0.182693612183011, 
    0.203417820647015, 0.222058720910355, 0.237958426741821, 
    0.250504081022426, 0.259180576738371, 0.263616198972439, 
    0.263616199203148, 0.259180577418113, 0.250504082114926, 
    0.23795842818944, 0.222058722638, 0.203417822567026, 0.182693614200525, 
    0.160534852952309, 0.137531191201636, 0.1141723815465, 
    0.0908204948098035, 0.0676975001308891, 0.0448889052124382, 
    0.0223625263259608, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0224314259308138, 0.0450075762636109, 
    0.0678297040823787, 0.0909167424595257, 0.114175290918998, 
    0.137381849610268, 0.160179570292515, 0.18209038270376, 0.2025417895005, 
    0.220906048588415, 0.236548047987186, 0.248877099756587, 
    0.257397289341254, 0.261751019817539, 0.26175102004304, 
    0.257397290005742, 0.24887710082485, 0.236548049403229, 
    0.220906050279199, 0.202541791380621, 0.182090384680618, 
    0.160179572271504, 0.137381851499603, 0.114175292633864, 
    0.0909167439253896, 0.0678297052374284, 0.0450075770604038, 
    0.0224314263372839, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0224922825510316, 0.045111009802145, 
    0.067941098978298, 0.0909888624531062, 0.114153429220268, 
    0.137209933218027, 0.159806625344066, 0.18147670260914, 
    0.201664143840714, 0.21976133832623, 0.235154953432488, 0.2472754731199, 
    0.25564529318991, 0.259920276146488, 0.259920276366937, 
    0.255645293839592, 0.247275474164617, 0.235154954817818, 
    0.219761339981102, 0.201664145681897, 0.181476704546216, 
    0.159806627284459, 0.137209935071698, 0.114153430903793, 
    0.0909888638929782, 0.0679411001133982, 0.0451110105854542, 
    0.0224922829507118, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0225454525561775, 0.0451998874965078, 
    0.068032631025912, 0.0910379782402396, 0.114107988823237, 
    0.137016582315345, 0.159416983773621, 0.180853254122796, 0.2007851950357, 
    0.218624483134784, 0.233778616733236, 0.24569830384412, 
    0.253923414089098, 0.25812264580717, 0.258122646022713, 0.2539234147244, 
    0.245698304865952, 0.233778618088681, 0.218624484754657, 
    0.200785196838862, 0.180853256020944, 0.159416985676152, 
    0.137016584133936, 0.114107990475852, 0.0910379796544111, 
    0.0680326321412407, 0.0451998882664291, 0.0225454529491081, 
    1.3887959385959e-11,
  1.38879542122922e-11, 0.0225912796570718, 0.0452748662623333, 
    0.0681052108794104, 0.0910651691882595, 0.114040112932788, 
    0.136802887553376, 0.159011566619967, 0.180220683560086, 
    0.199905234479137, 0.217495375605226, 0.23241853191048, 
    0.244144734186641, 0.252230532075514, 0.256356868863331, 
    0.25635686907411, 0.252230532696843, 0.244144735186221, 
    0.232418533236833, 0.21749537719098, 0.199905236245167, 
    0.180220685420135, 0.159011568485358, 0.136802889337471, 
    0.114040114554931, 0.0910651705770331, 0.0681052119751587, 
    0.0452748670189738, 0.0225912800432996, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0226300947367583, 0.0453365780096927, 
    0.0681597134397954, 0.0910714705643091, 0.113950895811269, 
    0.136569890360118, 0.15859125072269, 0.179579603513001, 
    0.199024535112804, 0.216373908426442, 0.231074212667379, 
    0.242613944057672, 0.250565578591034, 0.254621744237345, 
    0.254621744443495, 0.250565579198782, 0.242613945035606, 
    0.231074213965402, 0.216373909978924, 0.199024536842563, 
    0.179579605335761, 0.15859125255165, 0.136569892110297, 
    0.113950897403381, 0.0910714719279971, 0.068159714516166, 
    0.0453365787531695, 0.0226300951163358, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0226622161238252, 0.0453856302444773, 
    0.0681969788643429, 0.0910578750090507, 0.113841384696696, 
    0.13631858517098, 0.158156871014686, 0.17893059486673, 0.198143352805052, 
    0.215259974820163, 0.229745191710656, 0.241105149246427, 
    0.248927533834022, 0.252916126576037, 0.252916126777686, 
    0.248927534428561, 0.241105150203295, 0.229745192981082, 
    0.21525997634019, 0.198143354499374, 0.178930596652991, 
    0.158156872807911, 0.136318586887819, 0.113841386259223, 
    0.0910578763479739, 0.0681969799215486, 0.0453856309749163, 
    0.0226622164968101, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0226879498887448, 0.0454226067034284, 
    0.0682178135996838, 0.0910253340020678, 0.1137125816654, 
    0.136049921554059, 0.157709222672595, 0.178274208663943, 
    0.197261927600909, 0.214153468904461, 0.228431020079784, 
    0.239617599739981, 0.247315424274373, 0.251238923320654, 
    0.251238923517926, 0.247315424856062, 0.239617600676341, 
    0.228431021323316, 0.214153470392821, 0.1972619292606, 0.178274210414472, 
    0.157709224430771, 0.136049923238131, 0.11371258319879, 
    0.0910253353165541, 0.0682178146379464, 0.0454226074209633, 
    0.022687950255199, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0227075901580211, 0.0454480680141284, 
    0.0682229914292954, 0.0909747593125175, 0.113565445438065, 
    0.135764806235556, 0.157249063136328, 0.177610967831132, 
    0.196380484857625, 0.213054285995143, 0.227131266486255, 
    0.23815057812897, 0.245728320319414, 0.249589091963991, 
    0.249589092157004, 0.245728320888595, 0.238150579045357, 
    0.227131267703571, 0.213054287452597, 0.196380486483469, 
    0.177610969546679, 0.157249064860127, 0.135764807887427, 
    0.113565446942768, 0.0909747606029007, 0.0682229924488441, 
    0.0454480687188998, 0.0227075905180108, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0227214194416661, 0.0454625523725089, 
    0.0682132545275776, 0.0909070244296935, 0.113400893128575, 
    0.135464105030463, 0.156777114007785, 0.176941368779814, 
    0.195499236277888, 0.211962322853328, 0.225845516664855, 
    0.23670339809477, 0.244165334118994, 0.247965637479403, 
    0.247965637668271, 0.244165334675996, 0.236703398991698, 
    0.225845517856608, 0.211962324280612, 0.195499237870644, 
    0.176941370461111, 0.156777115697869, 0.135464106650695, 
    0.113400894605041, 0.090907025696312, 0.0682132555286483, 
    0.0454625530646634, 0.0227214197952609, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0227297089701603, 0.045466576231517, 
    0.0681893145138955, 0.0908229659691147, 0.113219801935488, 
    0.135148644683349, 0.156294062837916, 0.176265882893999, 
    0.194618380851519, 0.210877477886492, 0.224573372738486, 
    0.235275402973212, 0.242625617499256, 0.246367609907961, 
    0.246367610092792, 0.242625618044396, 0.235275403851175, 
    0.224573373905305, 0.210877479284317, 0.194618382411926, 
    0.17626588454176, 0.156294064494933, 0.1351486462725, 0.113219803384167, 
    0.090822967212311, 0.0681893154967298, 0.0454665769112064, 
    0.0227297093174328, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0227327190376137, 0.0454606349955302, 
    0.0681518535010166, 0.0907233850505834, 0.113023010776291, 
    0.134819214623768, 0.155800564810387, 0.175584957914138, 
    0.193738105715219, 0.209799651309325, 0.22331445259775, 
    0.233865964390265, 0.241108360015545, 0.244794102091361, 
    0.244794102272259, 0.241108360549127, 0.23386596524974, 
    0.223314453740242, 0.209799652678377, 0.193738107243992, 
    0.175584959529058, 0.155800566434974, 0.134819216182388, 
    0.113023012197632, 0.0907233862707029, 0.0681518544658607, 
    0.0454606356629107, 0.0227327193786394, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0227306993483299, 0.0454452037159354, 
    0.068101525133287, 0.0906090486453678, 0.112811321864863, 
    0.134476568640549, 0.155297244329384, 0.174899019226674, 
    0.192858586938858, 0.208728745269942, 0.222068389296251, 
    0.232474480965483, 0.239612787115816, 0.243244247539386, 
    0.243244247716453, 0.239612787638133, 0.232474481806929, 
    0.222068390415003, 0.208728746610888, 0.192858588436694, 
    0.174899020809434, 0.155297245922167, 0.134476570169183, 
    0.112811323259316, 0.0906090498427581, 0.068101526080391, 
    0.0454452043711672, 0.0227306996831865, 1.3887959385959e-11,
  1.38879542122922e-11, 0.022723889364401, 0.0454207377840093, 
    0.0680389556106826, 0.0904806908902825, 0.112585502232833, 
    0.134121426479014, 0.154784696518376, 0.174208471067393, 
    0.191979990245828, 0.207664663946315, 0.220834830462318, 
    0.231100377079282, 0.238138158406684, 0.241717218421824, 
    0.241717218595156, 0.238138158918017, 0.231100377903141, 
    0.220834831557896, 0.207664665259801, 0.191979991713403, 
    0.174208472618657, 0.15478469807997, 0.1341214279782, 0.112585503600844, 
    0.0904806920652924, 0.0680389565402996, 0.0454207384272556, 
    0.0227238896931682, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0227125186523307, 0.0453876736178633, 
    0.0679647446955605, 0.0903390143669684, 0.112346285195665, 
    0.133754475364883, 0.154263488636047, 0.173513697645887, 
    0.191102471674133, 0.20660731361714, 0.219613437727659, 
    0.229743101700442, 0.236683766014962, 0.240212223675647, 
    0.240212223845337, 0.236683766515583, 0.229743102507141, 
    0.219613438800609, 0.20660731490379, 0.191102473112104, 
    0.173513699166303, 0.154263490167054, 0.133754476835153, 
    0.112346286537678, 0.0903390155199476, 0.0679647456079463, 
    0.04538767424929, 0.0227125189750898, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0226968072270087, 0.0453464293407622, 
    0.06787946669953, 0.0901846913451286, 0.112094371764512, 
    0.133376371458475, 0.153734161415075, 0.172815064197738, 
    0.19022617818414, 0.205556602710844, 0.218403886173279, 
    0.228402127270458, 0.235248933038183, 0.238728507219156, 
    0.238728507385293, 0.235248933528353, 0.22840212806041, 
    0.218403887224131, 0.205556603971264, 0.190226179593148, 
    0.17281506568794, 0.153734162916088, 0.133376372900353, 
    0.112094373080968, 0.090184692476427, 0.067879467594942, 
    0.0453464299605375, 0.0226968075438423, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0226769658916345, 0.0452974054485969, 
    0.0677836714483786, 0.0900183649888659, 0.11183043200497, 
    0.13298774124256, 0.153197230328931, 0.172112917970329, 
    0.189351248218261, 0.204512441835944, 0.21720586379286, 
    0.227076948641607, 0.233833012078152, 0.23726534626552, 
    0.237265346428192, 0.233833012558124, 0.227076949415209, 
    0.217205864822127, 0.204512443070722, 0.18935124959893, 
    0.172112919430935, 0.153197231800532, 0.132987742656564, 
    0.111830433296307, 0.0900183660988329, 0.0677836723270756, 
    0.0452974060568905, 0.0226769662026266, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0226531965724387, 0.0452409854647023, 
    0.0676778852234326, 0.0898406505255977, 0.111555106343976, 
    0.132589182847072, 0.152653186791425, 0.17140758914762, 
    0.188477812217248, 0.203474743795572, 0.216019070973663, 
    0.225767082065801, 0.232435383852076, 0.235822049728829, 
    0.235822049888119, 0.232435384322095, 0.225767082823439, 
    0.21601907198184, 0.20347474500528, 0.188477813570183, 0.171407590579236, 
    0.152653188234184, 0.132589184233714, 0.111555107610629, 
    0.0898406516145817, 0.067677886085674, 0.0452409860616852, 
    0.0226531968776739, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0226256926472537, 0.0451775365805651, 
    0.0675626116781129, 0.0896521363773069, 0.111269006826179, 
    0.132181267313707, 0.152102499293346, 0.170699391718705, 
    0.18760599309725, 0.202443423588605, 0.214843219994909, 
    0.224472064231527, 0.231055455876298, 0.234397956716384, 
    0.234397956872373, 0.231055456336599, 0.224472064973573, 
    0.214843220982478, 0.202443424773796, 0.187605994423043, 
    0.170699393121921, 0.152102500707822, 0.13218126867349, 
    0.111269008068578, 0.0896521374456552, 0.0675626125241583, 
    0.0451775371664093, 0.0226256929468174, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0225946392671745, 0.0451074102812732, 
    0.0674383327287762, 0.0894533852541257, 0.110972718321153, 
    0.131764539803241, 0.151545614480171, 0.169988624294464, 
    0.186735906691377, 0.201418398399518, 0.213678034543531, 
    0.223191451346288, 0.229692661218045, 0.232992435101491, 
    0.232992435254256, 0.229692661668857, 0.223191452073103, 
    0.213678035510958, 0.201418399560732, 0.186735907990603, 
    0.169988625669859, 0.151545615866914, 0.131764541136663, 
    0.110972719539724, 0.0894533863021838, 0.0674383335588854, 
    0.0451074108561511, 0.0225946395611526, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0225602136707044, 0.045030942954818, 
    0.0673055094192123, 0.0892449352104474, 0.110666799682877, 
    0.131339520748318, 0.150982958174516, 0.169275570876275, 
    0.18586766215904, 0.200399587578821, 0.21252324924708, 0.221924818262204, 
    0.228346457310989, 0.231604880171496, 0.231604880321114, 
    0.228346457752532, 0.221924818974137, 0.212523250194817, 
    0.200399588716582, 0.185867663432261, 0.169275572224413, 
    0.150982959534065, 0.131339522055867, 0.110666800878041, 
    0.0892449362385586, 0.0673055102336442, 0.0450309435189023, 
    0.0225602139591831, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0225225854899153, 0.0449484564845935, 
    0.0671645827584052, 0.0890273006639309, 0.110351784862929, 
    0.130906706954234, 0.150414936346678, 0.168560501580296, 
    0.185001362366054, 0.199386912615661, 0.211378609223541, 
    0.220671757642505, 0.22701632483073, 0.230234713346279, 
    0.230234713492823, 0.227016325263217, 0.220671758339895, 
    0.211378610152027, 0.199386913730478, 0.185001363613816, 
    0.16856050290173, 0.150414937679562, 0.130906708236391, 
    0.110351786035105, 0.089027301672436, 0.0671645835574181, 
    0.0449484570380569, 0.0225225857729808, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0224819170482733, 0.0448602588246228, 
    0.0670159745313752, 0.0888009733778998, 0.110028183978863, 
    0.130466572650178, 0.149841936036406, 0.167843673320582, 
    0.184137104238113, 0.198380297104003, 0.21024386964775, 0.21943187916685, 
    0.225701766626638, 0.228881380962749, 0.228881381106289, 
    0.225701767050277, 0.219431879850025, 0.210243870557412, 
    0.198380298196372, 0.184137105460951, 0.167843674615852, 
    0.149841937343145, 0.130466573907419, 0.110028185128462, 
    0.088800974367137, 0.067015975315226, 0.0448602593676375, 
    0.0224819173260121, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0224383636498761, 0.0447666445572133, 
    0.0668600880830838, 0.088566423407753, 0.10969648433922, 
    0.130019570493237, 0.149264326228755, 0.167125330453937, 
    0.183274979090026, 0.19737966670356, 0.209118795334065, 
    0.218204808773484, 0.224402306706729, 0.227544353121306, 
    0.227544353261911, 0.224402307121721, 0.218204809442762, 
    0.209118796225318, 0.197379667773962, 0.183274980288459, 
    0.167125331723571, 0.149264327509857, 0.130019571726029, 
    0.10969648546665, 0.0885664243780576, 0.066860088852028, 
    0.0447666450899511, 0.0224383639223742, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0223920738599349, 0.0446678954328805, 
    0.0666973090755343, 0.0883241000120962, 0.109357151426657, 
    0.129566132527343, 0.148682458686686, 0.166405705389181, 
    0.182415072932791, 0.196384949096539, 0.208003160334911, 
    0.216990187936397, 0.223117489272531, 0.226223122590502, 
    0.226223122728238, 0.22311748967907, 0.216990188592088, 
    0.208003161208156, 0.196384950145445, 0.182415074107328, 
    0.166405706633698, 0.148682459942652, 0.129566133736144, 
    0.10935715253232, 0.0883241009638001, 0.0666973098298257, 
    0.0446678959555123, 0.0223920741272783, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0223431897764097, 0.0445642808924994, 
    0.0665280062183198, 0.0880744325293758, 0.109010629840632, 
    0.129106671099262, 0.148096668742893, 0.16568501916327, 
    0.181557466760435, 0.195396073941082, 0.206896747554805, 
    0.215787672975741, 0.221846877801076, 0.224917203766455, 
    0.224917203901387, 0.221846878199352, 0.215787673618145, 
    0.206896748410434, 0.19539607496895, 0.181557467911571, 
    0.165685020383174, 0.148096669974212, 0.129106672284526, 
    0.109010630924925, 0.0880744334628078, 0.0665280069582103, 
    0.0445642814051953, 0.022343190038684, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0222918472927638, 0.0444560585717445, 
    0.0663525319729694, 0.0878178312208601, 0.10865734420109, 
    0.128641579733599, 0.147507276053128, 0.164963481986463, 
    0.180702236818296, 0.194412972822171, 0.205799348379438, 
    0.214596934399862, 0.220590054171405, 0.22362613168381, 0.223626131816, 
    0.2205900545616, 0.214596935029271, 0.205799349217833, 0.194412973829447, 
    0.180702237946515, 0.16496348318225, 0.147507277260282, 
    0.128641580895771, 0.108657345264405, 0.087817832136345, 
    0.0663525326987087, 0.0444560590746735, 0.0222918475500541, 
    1.3887959385959e-11,
  1.38879542122922e-11, 0.0222381763518588, 0.0443434747879619, 
    0.0661712232315298, 0.0875546880808496, 0.108297700014562, 
    0.128171233968697, 0.146914585313166, 0.164241293758599, 
    0.179849454854281, 0.193435579200666, 0.20471076231938, 
    0.213417656277408, 0.219346617833113, 0.222349461075279, 
    0.222349461204789, 0.219346618215407, 0.213417656894107, 
    0.204710763140911, 0.193435580187784, 0.179849455960056, 
    0.164241294930753, 0.146914586496625, 0.128171235108214, 
    0.108297701057283, 0.0875546889787088, 0.0661712239433654, 
    0.0443434752812916, 0.0222381766042496, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0221823011910532, 0.0442267650096879, 
    0.065984401969883, 0.0872853776150385, 0.10793208450406, 
    0.127695992155219, 0.146318886941389, 0.16351864455832, 
    0.178999188354481, 0.192463828361035, 0.20363079666797, 
    0.212249535638045, 0.21811618501466, 0.221086765477024, 
    0.221086765603912, 0.218116185389225, 0.212249536242309, 
    0.203630797472998, 0.192463829328418, 0.178999189438273, 
    0.163518645707316, 0.146318888101616, 0.127695993272511, 
    0.107932085526569, 0.0872853784955894, 0.0659844026680598, 
    0.0442267654935845, 0.0221823014386285, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0221243405786063, 0.0441061543090867, 
    0.0657923758763574, 0.0870102575879667, 0.107560867404141, 
    0.127216196219127, 0.145720457728842, 0.162795715106963, 
    0.178151500764373, 0.191497657358256, 0.202559266172942, 
    0.211092281900406, 0.216898387969302, 0.219837636377319, 
    0.219837636501643, 0.216898388336307, 0.211092282492503, 
    0.202559266961819, 0.191497658306319, 0.178151501826633, 
    0.162795716233263, 0.145720458866292, 0.127216197314617, 
    0.107560868406813, 0.0870102584515229, 0.0657923765611177, 
    0.044106154783715, 0.0221243408214493, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0220644080415161, 0.0439818577976272, 
    0.0655954389562305, 0.0867296697405185, 0.107184401722455, 
    0.126732172390664, 0.145119561458488, 0.162072677208674, 
    0.177306451696726, 0.190537004964317, 0.20149599272134, 
    0.209945616325971, 0.215692874256662, 0.218601682406113, 
    0.218601682527928, 0.215692874616271, 0.209945616906163, 
    0.201495993494409, 0.190537005893463, 0.177306452737895, 
    0.162072678312734, 0.145119562573606, 0.126732173464769, 
    0.107184402705659, 0.0867296705873892, 0.0655954396278139, 
    0.0439818582631502, 0.0220644082797093, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0220026120849476, 0.0438540810453541, 
    0.0653938721127552, 0.0864439404784295, 0.106803024469077, 
    0.126244231900891, 0.144516449495282, 0.16134969416822, 
    0.176464097127237, 0.189581811614637, 0.200440805037279, 
    0.20880927149764, 0.214499306058066, 0.217378528563282, 
    0.217378528682643, 0.214499306410438, 0.208809272066181, 
    0.200440805794873, 0.189581812525258, 0.176464098147745, 
    0.161349695250484, 0.144516450588503, 0.126244232954018, 
    0.106803025433176, 0.0864439413089201, 0.0653938727713986, 
    0.0438540815019333, 0.0220026123185728, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0219390564034257, 0.0437230204841438, 
    0.0651879437053637, 0.086153381532765, 0.106417057354879, 
    0.125752671647244, 0.143911361348563, 0.160626921187801, 
    0.175624489578787, 0.188632019354717, 0.199393538392095, 
    0.207682990821831, 0.213317359523905, 0.216167815483504, 
    0.216167815600463, 0.213317359869194, 0.207682991378969, 
    0.19939353913454, 0.188632020247198, 0.175624490579057, 
    0.160626922248705, 0.143911362420317, 0.125752672679795, 
    0.106417058300232, 0.0861533823471763, 0.0651879443513009, 
    0.0437230209319388, 0.0219390566325637, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0218738400839835, 0.0435888637953532, 
    0.0649779100857221, 0.0858582905933272, 0.106026807460176, 
    0.125257774829516, 0.143304525208213, 0.159904505744116, 
    0.174787678295175, 0.18768757178726, 0.198354034326463, 
    0.206566528053001, 0.21214672415137, 0.214969198735812, 
    0.214969198850422, 0.212146724489729, 0.206566528598979, 
    0.198354035054076, 0.187687572661976, 0.174787679275616, 
    0.159904506784085, 0.14330452625892, 0.125257775841885, 
    0.106026808387135, 0.0858582913919561, 0.0649779107191838, 
    0.0435888642345217, 0.0218738403087143, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0218070578014697, 0.0434517902822904, 
    0.0647640161123168, 0.0855589519159412, 0.105632567874811, 
    0.124759811557589, 0.142696158455889, 0.159182587946821, 
    0.173953709405052, 0.186748414019968, 0.197322140384037, 
    0.205459646839535, 0.210987102191045, 0.213782348156032, 
    0.213782348268342, 0.210987102522621, 0.205459647374587, 
    0.197322141097129, 0.186748414877285, 0.173953710366067, 
    0.159182588966274, 0.14269615948596, 0.124759812550164, 
    0.105632568783722, 0.08555895269908, 0.0647640167335311, 
    0.0434517907129882, 0.0218070580218723, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0217388000062261, 0.0433119712279486, 
    0.0645464956442624, 0.0852556369045552, 0.105234618310848, 
    0.1242590394322, 0.14208646815259, 0.158461300879437, 0.173122626076772, 
    0.18581449261417, 0.196297709856192, 0.204362120290001, 
    0.209838208080883, 0.212606947210395, 0.212606947320454, 
    0.209838208405819, 0.204362120814357, 0.196297710555065, 
    0.185814493454445, 0.173122627018755, 0.158461301878782, 
    0.142086469162428, 0.124259040405361, 0.105234619202052, 
    0.085255637672492, 0.0645464962534538, 0.0433119716503294, 
    0.0217388002223785, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0216691531043553, 0.0431695702384496, 
    0.0643255720150163, 0.0849486046690773, 0.104833225688974, 
    0.123755704099938, 0.141475651503742, 0.157740770923685, 
    0.172294468664763, 0.184885755534432, 0.19528060153745, 
    0.203273730558845, 0.208699767906222, 0.211442692388741, 
    0.211442692496597, 0.208699768224658, 0.20327373107273, 
    0.195280602222399, 0.184885756358016, 0.172294469588098, 
    0.157740771903322, 0.141475652493745, 0.123755705054059, 
    0.104833226562808, 0.0849486054220956, 0.0643255726124062, 
    0.0431695706526652, 0.0216691533163346, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0215981996308017, 0.0430247435726513, 
    0.0641014584866881, 0.0846381025598499, 0.104428644699687, 
    0.123250039783642, 0.140863896302914, 0.157021118068179, 
    0.171469274847993, 0.183962152099255, 0.194270679491185, 
    0.202194268450606, 0.207571518884554, 0.210289292625818, 
    0.210289292731516, 0.207571519196627, 0.202194268954237, 
    0.194270680162497, 0.183962152906488, 0.171469275753057, 0.1570211190285, 
    0.140863897273469, 0.12325004071909, 0.104428645556479, 
    0.0846381032982292, 0.0641014590724949, 0.0430247439788514, 
    0.0215981998386841, 1.3887959385959e-11,
  1.38879542122922e-11, 0.021526018415471, 0.042877640458373, 
    0.0638743586856215, 0.0843243666796476, 0.104021118340296, 
    0.122742269789292, 0.140251381355197, 0.156302456202307, 
    0.170647079761059, 0.183043632932935, 0.193267812825209, 
    0.20112353304181, 0.206453208873832, 0.209146468749267, 
    0.209146468852854, 0.206453209179674, 0.201123533535401, 
    0.193267813483167, 0.183043633724151, 0.170647080648221, 
    0.156302457143697, 0.140251382306687, 0.122742270706428, 
    0.10402111918037, 0.0843243674036626, 0.0638743592600604, 
    0.0428776408567051, 0.0215260186193314, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0214526847426161, 0.0427284033956904, 
    0.0636444670199194, 0.0840076223740577, 0.103610878428754, 
    0.122232606990447, 0.139638276881255, 0.155584893396124, 
    0.169827916118366, 0.182130149918668, 0.192271875476864, 
    0.200061331319729, 0.205344595903171, 0.208013952952975, 
    0.208013953054494, 0.205344596202913, 0.200061331803487, 
    0.19227187612174, 0.182130150694194, 0.169827916987986, 
    0.155584894318958, 0.139638277814052, 0.122232607889625, 
    0.10361087925243, 0.0840076230839789, 0.0636444675832021, 
    0.0427284037863001, 0.0214526849425285, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0213782705037147, 0.0425771684477509, 
    0.063411969079571, 0.0836880847010844, 0.103198146095267, 
    0.121721254291242, 0.13902474490296, 0.154868532166962, 
    0.169011814331847, 0.181221656152943, 0.191282746007217, 
    0.199007477837234, 0.20424544772488, 0.206891488294544, 
    0.206891488394038, 0.204245448018648, 0.199007478311364, 
    0.191282746639281, 0.181221656913097, 0.169011815184277, 
    0.154868533071608, 0.139024745817431, 0.121721255172808, 
    0.103198146902858, 0.083688085397178, 0.0634119696319062, 
    0.0425771688307814, 0.0213782706997522, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0213028443440652, 0.0424240655195513, 
    0.0631770420198282, 0.0833659588807918, 0.102783132252617, 
    0.121208405068882, 0.138410939611518, 0.154153469733492, 
    0.16819880262261, 0.180318105901246, 0.190300307404034, 
    0.197961794383009, 0.20315554138678, 0.205778828215699, 
    0.205778828313211, 0.203155541674699, 0.197961794847708, 
    0.190300308023548, 0.18031810664634, 0.168198803458195, 
    0.154153470620313, 0.138410940508021, 0.121208405933178, 
    0.102783133044429, 0.0833659595633194, 0.0631770425614212, 
    0.0424240658951439, 0.0213028445362995, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0212264718033211, 0.0422692186251173, 
    0.062939854928464, 0.0830414407257773, 0.102366038046085, 
    0.120694243596569, 0.137797007718895, 0.153439798257861, 0.1673889071269, 
    0.179419454555123, 0.189324446893149, 0.196924109666417, 
    0.202074662823863, 0.20467573608453, 0.2046757361801, 0.202074663106051, 
    0.19692411012188, 0.18932444750037, 0.179419455285462, 0.167388907945978, 
    0.153439799127209, 0.137797008597784, 0.120694244443929, 
    0.102366038822423, 0.0830414413949963, 0.0629398554595168, 
    0.0422692189934109, 0.021226471991823, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0211492154501847, 0.0421127461435114, 
    0.0627005691775287, 0.0827147170532438, 0.101947055283852, 
    0.120178945447714, 0.137183088793359, 0.152727605076523, 
    0.166582151996707, 0.178525658590583, 0.188355055757902, 
    0.195894259016375, 0.20100260646836, 0.203581984758507, 
    0.203581984852176, 0.201002606744937, 0.195894259462791, 
    0.18835505635308, 0.178525659306466, 0.166582152799609, 
    0.152727605928745, 0.137183089654977, 0.120178946278467, 
    0.101947056045011, 0.0827147177094072, 0.0627005696982401, 
    0.0421127465046429, 0.021149215635024, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0210711350114754, 0.0419547610640908, 
    0.0624593387602075, 0.0823859660794121, 0.101526366848669, 
    0.119662677882286, 0.13656931557986, 0.152016972920342, 
    0.165778559495339, 0.177636675527868, 0.187392029166316, 
    0.19487208409358, 0.199939174877374, 0.20249735616729, 0.202497356259096, 
    0.199939175148455, 0.194872084531133, 0.187392029749696, 
    0.177636676229586, 0.165778560282388, 0.152016973755776, 
    0.136569316424548, 0.119662678696753, 0.101526367594942, 
    0.0823859667227685, 0.0624593392707731, 0.0419547614181948, 
    0.0210711351927207, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0209922874957822, 0.041795371221425, 
    0.062216310613362, 0.0820553577969929, 0.101104147091632, 
    0.119145600216068, 0.135955814305992, 0.151307980124498, 
    0.16497815008825, 0.176752463892571, 0.186435266005691, 
    0.193857432615498, 0.198884178377228, 0.201421640914376, 
    0.201421641004358, 0.198884178642926, 0.193857433044369, 
    0.186435266577512, 0.17675246458041, 0.164978150859763, 
    0.151307980943477, 0.135955815134081, 0.119145601014567, 
    0.101104147823305, 0.082055358427787, 0.0622163111139741, 
    0.0417953715686339, 0.0209922876735009, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0209127273119068, 0.041634679520272, 
    0.0619716249263243, 0.0817230543364125, 0.100680562208786, 
    0.118627864173607, 0.135342704974171, 0.15060070082871, 
    0.164180942529404, 0.175872983178095, 0.185484668724314, 
    0.192850158093534, 0.197837434723775, 0.200354637896713, 
    0.200354637984909, 0.197837434984199, 0.192850158513901, 
    0.18548466928481, 0.175872983852334, 0.164180943285692, 
    0.150600701631561, 0.135342705785987, 0.118627864956448, 
    0.10068056292614, 0.0817230549548844, 0.0619716254171719, 
    0.0416346798607163, 0.0209127274861654, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0208325063822995, 0.0414727841510036, 
    0.0617254154364927, 0.0813892103114595, 0.100255770601319, 
    0.11810961422556, 0.134730101640706, 0.149895205168253, 
    0.163386953943409, 0.174998193809438, 0.184540143179986, 
    0.191850119581843, 0.196798768777907, 0.199296153941417, 
    0.199296154027862, 0.196798769033164, 0.191850119993879, 
    0.184540143729387, 0.174998194470349, 0.163386954684775, 
    0.149895205955294, 0.134730102436568, 0.118109614993048, 
    0.10025577130463, 0.0813892109178452, 0.0617254159177617, 
    0.0414727844848114, 0.0208325065531634, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0207516742516809, 0.0413097787958548, 
    0.0614778097122626, 0.0810539731500012, 0.0998299232200271, 
    0.117590987911138, 0.134118112682343, 0.149191559456209, 
    0.162596199903671, 0.174128057108276, 0.18360159849508, 
    0.190857181437247, 0.19576801219558, 0.198246003458807, 
    0.198246003543538, 0.195768012445777, 0.190857181841119, 
    0.183601599033609, 0.174128057756128, 0.162596200630412, 
    0.149191560227752, 0.134118113462564, 0.117590988663571, 
    0.0998299239095673, 0.0810539737445325, 0.0614778101841358, 
    0.0413097791231522, 0.0207516744192145, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0206702781910416, 0.0411457528263663, 
    0.0612289294238067, 0.0807174834103886, 0.0994031638947439, 
    0.117072116146307, 0.133506841050874, 0.148489826357397, 
    0.161808694506778, 0.173262535259332, 0.182668946917863, 
    0.189871213089768, 0.194745003131676, 0.197204008110994, 
    0.197204008194045, 0.194745003376915, 0.189871213485643, 
    0.182668947445739, 0.173262535894386, 0.161808695219185, 
    0.14848982711375, 0.133506841815761, 0.117072116883978, 
    0.0994031645707792, 0.0807174839932934, 0.0612289298864635, 
    0.0411457531472771, 0.0206702783553079, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0205883632972015, 0.0409807914923717, 
    0.0609788906022016, 0.0803798750841514, 0.0989756296493625, 
    0.116553123518377, 0.132896384516353, 0.147790065054368, 
    0.16102445044332, 0.172401591277988, 0.181742103689808, 
    0.188892088823303, 0.193729585957062, 0.196169996495297, 
    0.196169996576702, 0.193729586197443, 0.188892089211342, 
    0.181742104207247, 0.172401591900501, 0.161024451141679, 
    0.147790065795831, 0.132896385266207, 0.116553124241575, 
    0.0989756303121545, 0.0803798756556533, 0.0609788910558184, 
    0.0409807918070177, 0.0205883634582628, 1.3887959385959e-11,
  1.38879542122922e-11, 0.02050597258811, 0.0408149761028748, 
    0.0607278038873813, 0.0800412758855574, 0.0985474510030844, 
    0.116034128567588, 0.132286835899446, 0.147092331405848, 
    0.160243479065331, 0.171545188979123, 0.180820986918659, 
    0.187919687565983, 0.192721610988258, 0.195143803841812, 
    0.195143803921605, 0.19272161122388, 0.187919687946344, 
    0.180820987425869, 0.171545189589345, 0.160243479749922, 
    0.147092332132714, 0.132286836634563, 0.116034129276594, 
    0.0985474516528896, 0.0800412764458761, 0.0607278043321316, 
    0.0408149764113757, 0.0205059727460274, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0204231470940571, 0.0406483841991473, 
    0.0604757747653809, 0.0797018075285914, 0.0981187522584818, 
    0.115515244056249, 0.131678283293403, 0.146396678097994, 
    0.159465790450535, 0.170693292947138, 0.17990551745698, 
    0.186953892689781, 0.191720934229126, 0.194125271724479, 
    0.194125271802692, 0.191720934460084, 0.186953893062619, 
    0.179905517954167, 0.170693293545316, 0.159465791121631, 
    0.146396678810552, 0.131678284014071, 0.11551524475134, 
    0.0981187528955519, 0.0797018080779426, 0.0604757752014348, 
    0.0406483845016207, 0.0204231472488906, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0203399259449636, 0.0404810897203656, 
    0.0602229037953149, 0.0793615859918858, 0.0976896517769457, 
    0.114996577226011, 0.131070810276131, 0.145703154788799, 
    0.158691393463561, 0.169845868507141, 0.178995618785987, 
    0.185994591818971, 0.190727417124036, 0.193114247785018, 
    0.193114247861683, 0.190727417350425, 0.185994592184438, 
    0.178995619273352, 0.169845869093514, 0.15869139412143, 
    0.145703155487333, 0.131070810982634, 0.11499657790746, 
    0.097689652401528, 0.0793615865304813, 0.0602229042228397, 
    0.040481090016927, 0.0203399260967722, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0202563464539103, 0.040313163162098, 
    0.059969286826521, 0.0790207217721156, 0.097260262242066, 
    0.114478230043772, 0.130464496112817, 0.145011808245971, 
    0.157920295814279, 0.16900288169725, 0.178091216904407, 0.18504167664702, 
    0.189740926321993, 0.192110585469163, 0.192110585544312, 
    0.189740926543906, 0.185041677005263, 0.178091217382147, 
    0.169002882272054, 0.157920296459183, 0.145011808930757, 
    0.130464496805433, 0.114478230711844, 0.0972602628544031, 
    0.0790207223001633, 0.059969287245681, 0.040313163452861, 
    0.020256346602752, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0201724441970636, 0.0401446717279367, 
    0.0597150152062819, 0.0786793201263479, 0.0968306909114652, 
    0.113960299436729, 0.129859415949527, 0.144322682478587, 
    0.157152504113406, 0.168164299241992, 0.177192240222169, 
    0.184095042761562, 0.188761333451225, 0.191114143774626, 
    0.191114143848289, 0.188761333668751, 0.184095043112726, 
    0.177192240690476, 0.168164299805457, 0.157152504745604, 
    0.144322683149895, 0.12985941662853, 0.113960300091685, 
    0.0968306915117951, 0.078679320644052, 0.0597150156172383, 
    0.0401446720130127, 0.0201724443429952, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0200882530901442, 0.0399756794745629, 
    0.0594601759785226, 0.0783374813038186, 0.0964010398575882, 
    0.113442877517056, 0.129255640998189, 0.143635818862817, 
    0.156388023925528, 0.167330088526748, 0.176298619458717, 
    0.183154589477075, 0.187788514903757, 0.190124787010248, 
    0.190124787082455, 0.187788515116984, 0.183154589821302, 
    0.176298619917779, 0.167330089079101, 0.15638802454527, 
    0.143635819520915, 0.129255641663845, 0.113442878159153, 
    0.0964010404461444, 0.0783374818113794, 0.0594601763814336, 
    0.0399756797540614, 0.0200882532332218, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0200038054615863, 0.0398062474505199, 
    0.059204852073865, 0.0779953007675896, 0.0959714061979267, 
    0.112926051796668, 0.128653238713348, 0.142951256261996, 
    0.155626859819647, 0.166500217573228, 0.175410287545731, 
    0.182220219674933, 0.186822351629528, 0.189142384565851, 
    0.18914238463663, 0.186822351838541, 0.182220220012363, 
    0.175410287995734, 0.16650021811469, 0.15562686042718, 0.142951256907143, 
    0.128653239365919, 0.112926052426157, 0.0959714067749384, 
    0.0779953012652037, 0.0592048524688863, 0.0398062477245484, 
    0.0200038056018647, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0199191321225231, 0.039636433828959, 
    0.0589491224914077, 0.0776528694065192, 0.095541882315139, 
    0.1124099053925, 0.128052272961068, 0.142269031141295, 0.154869015417393, 
    0.165674655015922, 0.174527179534098, 0.181291839650498, 
    0.185862728939615, 0.188166810692284, 0.188166810761665, 0.1858627291445, 
    0.181291839981266, 0.174527179975222, 0.165674655546708, 
    0.15486901601296, 0.142269031773747, 0.128052273600812, 
    0.112409906009628, 0.095541882880831, 0.0776528698943797, 
    0.0589491228786919, 0.0396364340976231, 0.0199191322600564, 
    1.3887959385959e-11,
  1.38879542122922e-11, 0.0198342624337349, 0.0394662940346136, 
    0.0586930624725824, 0.0773102737379645, 0.095112556067504, 
    0.111894517222733, 0.127452804180331, 0.141589177677252, 
    0.154114493439015, 0.164853370079506, 0.17364923250491, 
    0.180369358966937, 0.184909536318163, 0.187197944291224, 
    0.187197944359235, 0.184909536519002, 0.180369359291176, 
    0.173649232937332, 0.164853370599829, 0.154114494022853, 
    0.14158917829726, 0.127452804807499, 0.111894517827742, 
    0.0951125566220968, 0.0773102742162608, 0.0586930628522792, 
    0.0394662942980169, 0.0198342625685759, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0197492243696861, 0.0392958808652461, 
    0.0584367436674255, 0.0769675961016132, 0.0946835109901313, 
    0.111379962194355, 0.126854889537262, 0.140911727862394, 
    0.153363295747243, 0.164036332557167, 0.172776385484349, 
    0.179452690315476, 0.183962667242616, 0.186235668714275, 
    0.186235668780943, 0.183962667439491, 0.179452690633316, 
    0.172776385908242, 0.164036333067236, 0.153363296319583, 
    0.140911728470203, 0.126854890152102, 0.111379962787482, 
    0.0946835115338414, 0.0769675965705311, 0.0584367440396819, 
    0.0392958811234904, 0.0197492245018869, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0196640445797755, 0.0391252446078034, 
    0.0581802342935903, 0.0766249148448295, 0.0942548264873303, 
    0.110866311382447, 0.126258583072522, 0.140236711605164, 
    0.152615423389143, 0.163223512789811, 0.171908579362274, 
    0.178541749381795, 0.1830220190119, 0.185279871570957, 0.185279871636309, 
    0.183022019204889, 0.178541749693365, 0.171908579777809, 
    0.163223513289828, 0.152615423950212, 0.140236712201015, 
    0.126258583675275, 0.110866311963925, 0.09425482702037, 
    0.0766249153045513, 0.0581802346585508, 0.0391252448609885, 
    0.0196640447093871, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0195787484469187, 0.0389544331495053, 
    0.0579235992884114, 0.0762823044998792, 0.093826578016524, 
    0.110353632201556, 0.125663935842147, 0.139564156825396, 
    0.15187087663605, 0.162414881646118, 0.171045756814352, 
    0.177636454718301, 0.182087492582174, 0.184330444545185, 
    0.184330444609247, 0.182087492771355, 0.177636455023725, 
    0.171045757221694, 0.162414882136283, 0.151870877186072, 
    0.139564157409523, 0.125663936433051, 0.110353632771612, 
    0.0938265785391015, 0.0762823049505841, 0.0579235996462175, 
    0.0389544333977293, 0.0195787485739913, 1.3887959385959e-11,
  1.38879542122922e-11, 0.019493360143575, 0.0387834920840848, 
    0.0576669004543185, 0.0759398359533882, 0.0933988372640774, 
    0.109841988569505, 0.125070996052154, 0.138894089545501, 
    0.151129655021675, 0.161610410503422, 0.170187862227581, 
    0.176736727622011, 0.181158992409842, 0.183387283219852, 
    0.18338728328265, 0.181158992595291, 0.176736727921411, 
    0.170187862626893, 0.16161041098393, 0.151129655560868, 
    0.138894090118136, 0.125070996631441, 0.109841989128363, 
    0.093398837776397, 0.0759398363952516, 0.0576669008051093, 
    0.0387834923274439, 0.0194933602681578, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0194079026853302, 0.0386124648133861, 
    0.0574101965978886, 0.0755975766083677, 0.0929716723133929, 
    0.109331441063973, 0.124479809187168, 0.138226533977599, 
    0.150391757378472, 0.160810071229379, 0.169334841629058, 0.1758424920178, 
    0.180236426301475, 0.182450286909164, 0.182450286970723, 
    0.180236426483266, 0.175842492311296, 0.1693348420205, 0.160810071700421, 
    0.150391757907051, 0.138226534538969, 0.124479809755068, 
    0.109331441611852, 0.092971672815655, 0.0755975770415619, 
    0.0574101969418004, 0.0386124650519748, 0.0194079028074714, 
    1.3887959385959e-11,
  1.38879542122922e-11, 0.0193223979821379, 0.0384413926445218, 
    0.0571535436628092, 0.0752555905391329, 0.092545147805612, 
    0.108822047072167, 0.123890418133355, 0.137561512606748, 
    0.149657181872348, 0.160013836164386, 0.168486642617852, 
    0.174953674346781, 0.17931970527035, 0.181519358498364, 
    0.181519358558709, 0.179319705448556, 0.174953674634491, 
    0.16848664300158, 0.160013836626151, 0.149657182390521, 
    0.137561513157075, 0.12389041869009, 0.108822047609283, 
    0.0925451482980131, 0.0752555909638269, 0.0571535439999759, 
    0.0384413928784327, 0.0193223981018849, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0192368668873215, 0.0382703148827789, 
    0.0568969948570166, 0.0749139386394202, 0.0921193250932459, 
    0.108313860933886, 0.123302863295902, 0.13689904627047, 
    0.148925926035784, 0.159221678104739, 0.167643214299839, 
    0.174070203459582, 0.178408743399313, 0.180594404290535, 
    0.18059440434969, 0.178408743574005, 0.174070203741621, 
    0.167643214676006, 0.159221678557409, 0.148925926543758, 
    0.136899046809971, 0.123302863841693, 0.10831386146045, 
    0.0921193255759787, 0.0749139390557797, 0.0568969951875695, 
    0.0382703151121029, 0.0192368670047208, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0191513292444324, 0.0380992689204574, 
    0.056640600774262, 0.0745726787640016, 0.0916942623870451, 
    0.10780693407827, 0.122717182711298, 0.136239154234719, 
    0.148197986799466, 0.158433570286478, 0.166804507225386, 
    0.173192010514312, 0.177503457709671, 0.17967533386015, 
    0.179675333918139, 0.17750345788092, 0.173192010790793, 
    0.166804507594142, 0.158433570730234, 0.148197987297442, 
    0.136239154763608, 0.122717183246359, 0.107806934594488, 
    0.0916942628602987, 0.0745726791721894, 0.0566406010983298, 
    0.0380992691452838, 0.0191513293595296, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0190658039320575, 0.0379282903218188, 
    0.0563844095103455, 0.0742318658640789, 0.0912700148964039, 
    0.107301315154515, 0.122133412154631, 0.135581854266479, 
    0.147473360522462, 0.157649486369916, 0.16597047332974, 
    0.172319028878999, 0.176603768035863, 0.178762059913075, 
    0.178762059969921, 0.176603768203736, 0.172319029150031, 
    0.165970473691232, 0.157649486804934, 0.147473361010637, 
    0.135581854784965, 0.122133412679173, 0.10730131566059, 
    0.0912700153603637, 0.0742318662642544, 0.0563844098280547, 
    0.0379282905422351, 0.0190658040448975, 1.3887959385959e-11,
  1.38879542122922e-11, 0.018980308906664, 0.0377574129043103, 
    0.0561284667742513, 0.0738915521167271, 0.0908466349635833, 
    0.10679705015682, 0.121551585242144, 0.134927162703114, 
    0.146752043021041, 0.156869400424804, 0.165141065876023, 
    0.171451194038311, 0.175709596905636, 0.177854498152742, 
    0.177854498208468, 0.175709597070201, 0.171451194304003, 
    0.165141066230394, 0.156869400851256, 0.146752043499609, 
    0.134927163211401, 0.121551585756374, 0.106797050652951, 
    0.0908466354184312, 0.0738915525090468, 0.056128467085726, 
    0.0377574131204024, 0.0189803090172907, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0188948612435667, 0.0375866688162282, 
    0.0558728159944047, 0.0735517870486496, 0.0904241721920227, 
    0.106294182543811, 0.120971733529241, 0.134275094518635, 
    0.146034029596181, 0.156093286916113, 0.164316239400705, 
    0.170588443504373, 0.1748208694255, 0.176952567152208, 0.176952567206835, 
    0.174820869586822, 0.17058844376483, 0.164316239748097, 0.15609328733417, 
    0.146034030065332, 0.134275095016924, 0.120971734033362, 
    0.106294183030193, 0.0904241726379371, 0.0735517874332671, 
    0.0558728162997663, 0.0375866690280804, 0.0188948613520231, 
    1.3887959385959e-11,
  1.38879542122922e-11, 0.0188094771760993, 0.0374160886109742, 
    0.0556174984202623, 0.0732126176544913, 0.0900026735690009, 
    0.105792753352705, 0.120393886604156, 0.133625663387018, 
    0.145319315059832, 0.155321120690424, 0.163495949661453, 
    0.169730716731484, 0.173937513171208, 0.176056188231844, 
    0.176056188285394, 0.173937513329351, 0.169730716986811, 
    0.163495950002004, 0.155321121100251, 0.145319315519751, 
    0.133625663875506, 0.120393887098366, 0.105792753829529, 
    0.0900026740061566, 0.0732126180315571, 0.0556174987196303, 
    0.0374160888186692, 0.0188094772824277, 1.3887959385959e-11,
  1.38879542122922e-11, 0.018724172133067, 0.0372457013180525, 
    0.0553625532194412, 0.0728740885099478, 0.0895821835828921, 
    0.105292801308421, 0.119818072177475, 0.132978881742704, 
    0.144607893759986, 0.154552876962864, 0.162680153587257, 
    0.168877955034582, 0.173059458083054, 0.175165285342411, 
    0.175165285394907, 0.173059458238082, 0.16887795528488, 
    0.162680153921102, 0.154552877364624, 0.144607894210855, 
    0.132978882221584, 0.119818072661968, 0.105292801775875, 
    0.0895821840114606, 0.0728740888796094, 0.0553625535129326, 
    0.0372457015216713, 0.018724172237309, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0186389607745564, 0.0370755345109497, 
    0.055108017570579, 0.0725362418798988, 0.0891627443352567, 
    0.104794362927885, 0.11924431616769, 0.132334760838399, 
    0.143899759604619, 0.153788531304612, 0.161868809230718, 
    0.168030101511277, 0.172186636365772, 0.174279784953269, 
    0.174279785004731, 0.172186636517746, 0.168030101756645, 
    0.16186880955799, 0.153788531698464, 0.143899760046616, 
    0.132334761307861, 0.119244316642658, 0.104794363386153, 
    0.0891627447554062, 0.0725362422423012, 0.0551080178583086, 
    0.037075534710572, 0.0186389608767526, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0185538570261724, 0.0369056143720337, 
    0.0548539267521121, 0.0721991178217835, 0.0887443956479915, 
    0.10429747261972, 0.118672642782973, 0.131693310800315, 0.14319490608454, 
    0.153028059630906, 0.161061875722426, 0.167187100967296, 
    0.171318982392823, 0.173399615945503, 0.17339961599595, 
    0.171318982541804, 0.167187101207832, 0.161061876043254, 
    0.153028060017006, 0.143194906517841, 0.131693311260543, 
    0.118672643248603, 0.104297473068981, 0.088744396059887, 
    0.0721991181770687, 0.0548539270341925, 0.0369056145677374, 
    0.0185538571263628, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0184688741117718, 0.0367359657546001, 
    0.0546003142271505, 0.0718627542844246, 0.0883271751657573, 
    0.10380216277954, 0.11810307459932, 0.13105454068094, 0.14249332629522, 
    0.152271438189568, 0.16025931322731, 0.166348899845205, 
    0.170456432614895, 0.17252470950974, 0.172524709559194, 
    0.170456432760942, 0.166348900081005, 0.160259313541823, 
    0.15227143856807, 0.142493326719996, 0.131054541132117, 
    0.118103075055796, 0.103802163219972, 0.0883271755695605, 
    0.0718627546327318, 0.0546003145036921, 0.0367359659464619, 
    0.0184688742099955, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0183840245847587, 0.0365666122421926, 
    0.0543472117246194, 0.0715271872025025, 0.0879111184538909, 
    0.103308463881034, 0.117535632635244, 0.130418458509472, 
    0.141795012957618, 0.151518643550001, 0.159461082902903, 
    0.165515446156238, 0.169598925472404, 0.171654999048464, 
    0.171654999096945, 0.169598925615575, 0.165515446387396, 
    0.159461083211224, 0.151518643921053, 0.141795013374037, 
    0.130418458951776, 0.117535633082745, 0.10330846431281, 
    0.0879111188497604, 0.0715271875439683, 0.0543472119957305, 
    0.0365666124302874, 0.0183840246810541, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0182993203580042, 0.0363975762053139, 
    0.0540946493168309, 0.0711924505868683, 0.0874962590920001, 
    0.102816404563028, 0.11697033642315, 0.129785071340001, 
    0.141099958438078, 0.150769652592644, 0.15866714685941, 0.16468668941512, 
    0.168746401311845, 0.17079042008261, 0.170790420130136, 
    0.168746401452197, 0.164686689641727, 0.158667147161662, 
    0.150769652956394, 0.141099958846304, 0.129785071773606, 
    0.116970336861853, 0.102816404986318, 0.0874962594800915, 
    0.0711924509216268, 0.0540946495826179, 0.0363975763897154, 
    0.018299320452409, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0182147727324513, 0.0362288788556435, 
    0.0538426554936422, 0.0708585766108798, 0.0870826287634312, 
    0.102326011712696, 0.116407204077561, 0.129154385297551, 
    0.140408154767318, 0.150024442498876, 0.15787746812152, 
    0.163862580577734, 0.167898802305805, 0.16993091016226, 0.16993091020885, 
    0.167898802443394, 0.163862580799879, 0.157877468417823, 
    0.150024442855469, 0.140408155167514, 0.129154385722628, 
    0.116407204507639, 0.102326012127666, 0.087082629143897, 
    0.0708585769390623, 0.0538426557542091, 0.036228879036424, 
    0.0182147728250025, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0181303924244612, 0.0360605402978698, 
    0.0535912572333483, 0.0705255956929326, 0.0866702573407901, 
    0.101837310545103, 0.115846252360318, 0.128526405622076, 
    0.139719593658566, 0.149282990741336, 0.157092010591877, 
    0.163043071981519, 0.167056072376484, 0.169076408781258, 
    0.169076408826931, 0.167056072511364, 0.163043072199292, 
    0.157092010882348, 0.149282991090912, 0.13971959405089, 
    0.128526406038794, 0.11584625278194, 0.101837310951917, 
    0.0866702577137799, 0.0705255960146679, 0.0535912574887974, 
    0.0360605404751, 0.018130392515195, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0180461895919567, 0.0358925795792411, 
    0.0533404800704551, 0.0701935365753555, 0.0862591729676913, 
    0.101350324679228, 0.115287496742887, 0.127901136710494, 
    0.13903426652487, 0.148545275074648, 0.15631073901614, 0.162228117288477, 
    0.166218157122567, 0.168226857295575, 0.168226857340349, 
    0.166218157254792, 0.162228117501963, 0.156310739300895, 
    0.148545275417346, 0.139034266909475, 0.127901137119016, 
    0.11528749715622, 0.101350325078046, 0.0862591733333515, 
    0.0701935368907699, 0.0533404803208865, 0.0358925797529906, 
    0.0180461896809087, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0179621738594154, 0.0357250147369361, 
    0.053090348160466, 0.0698624263998282, 0.0858494021368994, 
    0.100865076210632, 0.114730951465916, 0.127278582156852, 
    0.138352164495626, 0.147811273526532, 0.155533618949559, 
    0.161417671430662, 0.165385003749302, 0.16738219884524, 
    0.167382198889132, 0.165385003878924, 0.161417671639946, 
    0.15553361922871, 0.147811273862487, 0.138352164872666, 0.12727858255734, 
    0.114730951871122, 0.100865076601611, 0.085849402495374, 
    0.0698624267090456, 0.053090348405978, 0.035725014907273, 
    0.0179621739466204, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0178783543417628, 0.0355578628433483, 
    0.0528408843418159, 0.0695322907794745, 0.085440969765023, 
    0.100381585780908, 0.114176629596149, 0.126658744790709, 
    0.137673278432364, 0.14708096438929, 0.154760616725005, 
    0.160611690558059, 0.164556561001634, 0.166542378279708, 
    0.166542378322737, 0.164556561128705, 0.160611690763225, 
    0.154760616998663, 0.147080964718635, 0.137673278801988, 
    0.126658745183321, 0.114176629993388, 0.100381586164201, 
    0.0854409701164529, 0.0695322910826165, 0.0528408845825049, 
    0.0355578630103394, 0.0178783544272551, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0177947396672137, 0.0353911400493762, 
    0.0525921101950761, 0.0692031538677768, 0.0850338992639116, 
    0.0998998726440678, 0.113624543080816, 0.126041626713803, 
    0.136997598943808, 0.146354326211643, 0.153991699422386, 
    0.159810131988739, 0.163732779100276, 0.165707342086488, 
    0.165707342128669, 0.163732779224846, 0.159810132189867, 
    0.153991699690659, 0.146354326534509, 0.136997599306162, 
    0.126041627098694, 0.113624543470246, 0.099899873019827, 
    0.085033899608435, 0.0692031541649623, 0.0525921104310366, 
    0.035391140213087, 0.0177947397510267, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0177113379991068, 0.035224861625807, 
    0.0523440460995493, 0.0688750384244515, 0.0846282126089009, 
    0.0994199547299944, 0.113074702799622, 0.125427229335089, 
    0.136325116400264, 0.145631337790909, 0.153226834839392, 
    0.159012954161185, 0.162913609680565, 0.1648770383229, 0.164877038364251, 
    0.162913609802683, 0.159012954358355, 0.153226835102387, 
    0.145631338107423, 0.13632511675549, 0.125427229712412, 
    0.113074703181395, 0.0994199550983672, 0.0846282129466534, 
    0.0688750387157975, 0.0523440463308739, 0.0352248617863017, 
    0.0177113380812734, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0176281570567791, 0.0350590420028767, 
    0.0520967112873715, 0.0685479658784191, 0.0842239304040452, 
    0.0989418487050819, 0.112527118614419, 0.124815553404221, 
    0.135655820947348, 0.144911978165503, 0.152465991463512, 
    0.158220116588706, 0.162099005734007, 0.16405141655082, 
    0.164051416591357, 0.162099005853721, 0.158220116781996, 
    0.152465991721333, 0.14491197847579, 0.135655821295587, 
    0.124815553774123, 0.112527118988686, 0.0989418490662136, 
    0.0842239307351597, 0.06854796616404, 0.0520967115141511, 
    0.0350590421602185, 0.0176281571373316, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0175452041355193, 0.0348936948080872, 
    0.0518501238952275, 0.0682219563879958, 0.0838210719444691, 
    0.0984655700302016, 0.11198179941669, 0.124206599043533, 
    0.134989702519095, 0.144196226607752, 0.151709138445255, 
    0.157431579815832, 0.161288921552365, 0.163230427774284, 
    0.163230427814024, 0.161288921669724, 0.157431580005319, 
    0.151709138698003, 0.144196226911936, 0.134989702860485, 
    0.124206599406161, 0.111981799783598, 0.0984655703842344, 
    0.0838210722690758, 0.068221956668004, 0.0518501241175513, 
    0.0348936949623377, 0.0175452042144894, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0174624861256429, 0.0347288329023561, 
    0.0516043010137866, 0.0678970288984296, 0.0834196552759655, 
    0.0979911330161002, 0.11143875317292, 0.123600365778608, 
    0.134326750850474, 0.14348406261701, 0.150956245572543, 
    0.156647305376622, 0.160483312674203, 0.162414024379818, 
    0.162414024418775, 0.160483312789253, 0.156647305562381, 
    0.150956245820318, 0.14348406291521, 0.134326751185149, 
    0.123600366134105, 0.111438753532614, 0.0979911333631734, 
    0.0834196555941922, 0.0678970291729352, 0.0516043012317419, 
    0.0347288330535759, 0.0174624862030615, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0173800095307259, 0.0345644684145732, 
    0.0513592587349578, 0.0675732011968974, 0.0830196972519614, 
    0.0975185508763488, 0.110897986967955, 0.122996852567474, 
    0.133666955489328, 0.142775465913047, 0.150207283246203, 
    0.155867255754778, 0.159682135833758, 0.161602160079378, 
    0.161602160117569, 0.159682135946544, 0.155867255936881, 
    0.150207283489104, 0.142775466205382, 0.133666955817422, 
    0.122996852915981, 0.110897987320577, 0.0975185512165992, 
    0.0830196975639333, 0.0675732014660083, 0.0513592589486303, 
    0.0345644685628219, 0.0173800096066234, 1.3887959385959e-11,
  1.38879542122922e-11, 0.017297780485035, 0.0344006127746336, 
    0.0511150121970608, 0.0672504899650739, 0.082621213587966, 
    0.0970478357779495, 0.110359507046444, 0.122396057828504, 
    0.133010305807781, 0.142070416429724, 0.149462222456527, 
    0.155091394345501, 0.158885348912048, 0.160794789855791, 
    0.160794789893231, 0.158885349022615, 0.155091394524022, 
    0.149462222694649, 0.142070416716308, 0.133010306129421, 
    0.122396058170157, 0.110359507392133, 0.0970478361115112, 
    0.082621213893806, 0.067250490228896, 0.0511150124065344, 
    0.0344006129199693, 0.0172977805594413, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0172158047701895, 0.034237276745013, 
    0.0508715756280033, 0.0669289108293804, 0.0822242189136138, 
    0.0965789988897017, 0.109823318852436, 0.12179797946707, 
    0.132356791013113, 0.14136889430892, 0.148721034760843, 
    0.154319685419017, 0.158092910890116, 0.159991869910572, 
    0.159991869947275, 0.158092910998508, 0.154319685594025, 
    0.148721034994281, 0.141368894589867, 0.132356791328427, 
    0.121797979802005, 0.109823319191328, 0.096578999216706, 
    0.0822242192134423, 0.0669289110880174, 0.0508715758333605, 
    0.0342372768874929, 0.0172158048431338, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0171340878310878, 0.0340744704509513, 
    0.0506289623865538, 0.0666084784090143, 0.0818287268224071, 
    0.0961120504284284, 0.109289427067224, 0.121202614901013, 
    0.131706400158151, 0.140670879894712, 0.147983692262056, 
    0.153552094085674, 0.157304781804314, 0.159193357614027, 
    0.159193357650008, 0.157304781910573, 0.15355209425724, 
    0.147983692490902, 0.140670880170133, 0.131706400467265, 
    0.121202615229362, 0.109289427399453, 0.0961120507490043, 
    0.081828727116342, 0.0666084786625682, 0.0506289625878753, 
    0.0340744705906313, 0.0171340879025987, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0170526347911322, 0.0339122034093033, 
    0.0503871850017924, 0.066289206361858, 0.0814347499192592, 
    0.0956469997031562, 0.108757835645509, 0.120609961084966, 
    0.131059122151182, 0.139976353727794, 0.147250167588114, 
    0.152788586262578, 0.156520922703539, 0.158399211457536, 
    0.158399211492809, 0.156520922807707, 0.152788586430768, 
    0.147250167812458, 0.139976353997798, 0.131059122454216, 
    0.120609961406858, 0.108757835971206, 0.0956470000174299, 
    0.0814347502074164, 0.0662892066104284, 0.0503871851991574, 
    0.0339122035462385, 0.0170526348612379, 1.3887959385959e-11,
  1.38879542122922e-11, 0.016971450466781, 0.0337504845561179, 
    0.0501462552108197, 0.0659711074283587, 0.0810422998659363, 
    0.0951838551573379, 0.108228547849958, 0.120020014533602, 
    0.130414945765407, 0.139285296540121, 0.146520433872364, 
    0.152029128641659, 0.155741295608331, 0.157609391007913, 
    0.157609391042492, 0.155741295710451, 0.152029128806541, 
    0.146520434092295, 0.139285296804814, 0.130414946062482, 
    0.120020014849164, 0.108228548169252, 0.0951838554654332, 
    0.0810423001484292, 0.0659711076720435, 0.0501462554043058, 
    0.033750484690362, 0.0169714505355091, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0168905393814597, 0.0335893222729983, 
    0.0499061839948013, 0.0656541934734711, 0.0806513874244894, 
    0.0947226244092065, 0.107701566284227, 0.119432771343836, 
    0.129773859647974, 0.138597689249779, 0.145794464734754, 
    0.151273688659146, 0.154965863471761, 0.156823856863766, 
    0.156823856897665, 0.154965863571872, 0.151273688820785, 
    0.145794464950359, 0.138597689509267, 0.129773859939206, 
    0.119432771653193, 0.107701566597243, 0.0947226247112449, 
    0.0806513877014293, 0.0656541937123662, 0.0499061841844847, 
    0.0335893224046042, 0.0168905394488371, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0168099057788571, 0.0334287244123, 
    0.0496669816134201, 0.0653384755267456, 0.0802620224987649, 
    0.0942633142903408, 0.107176892924517, 0.118848227216041, 
    0.129135852328586, 0.137913512956058, 0.145072234263844, 
    0.150522234466353, 0.154194590142015, 0.156042570613752, 
    0.156042570646984, 0.154194590240156, 0.150522234624812, 
    0.145072234475209, 0.137913513210442, 0.129135852614091, 
    0.118848227519315, 0.107176893231378, 0.0942633145864413, 
    0.0802620227702609, 0.065338475760945, 0.0496669817993754, 
    0.0334287245413194, 0.0168099058449104, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0167295536356351, 0.0332686983212151, 
    0.049428657637807, 0.0650239638206446, 0.0798742141740792, 
    0.0938059308825218, 0.106654529149729, 0.118266377474308, 
    0.128500912227724, 0.137232748934723, 0.144353716999594, 
    0.14977473490174, 0.153427440326611, 0.155265494796662, 0.15526549482924, 
    0.153427440422822, 0.149774735057082, 0.144353717206801, 
    0.137232749184104, 0.128500912507614, 0.118266377771619, 
    0.106654529450557, 0.093805931172801, 0.0798742144402381, 
    0.0650239640502405, 0.0494286578201074, 0.0332686984476988, 
    0.0167295537003902, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0166494866735773, 0.0331092508647943, 
    0.0491912209820166, 0.0647106678271656, 0.0794879707551367, 
    0.093350479552956, 0.106134475770278, 0.11768721708581, 
    0.127869027664485, 0.136555378633488, 0.14363888791689, 
    0.149031159464188, 0.152664379558181, 0.154492592863235, 
    0.154492592895173, 0.152664379652498, 0.149031159616475, 
    0.143638888120022, 0.136555378877964, 0.127869027938871, 
    0.117687217377275, 0.106134476065191, 0.0933504798375284, 
    0.0794879710160635, 0.0647106680522485, 0.0491912211607339, 
    0.0331092509887921, 0.0166494867370598, 1.3887959385959e-11,
  1.38879542122922e-11, 0.016569708371201, 0.0329503884479504, 
    0.0489546799331123, 0.0643985962928446, 0.079103299802271, 
    0.0928969649879372, 0.105616733055626, 0.117110740679285, 
    0.127240186864064, 0.135881383667658, 0.142927722409781, 
    0.148291478287429, 0.151905374161726, 0.153723829139647, 
    0.153723829170956, 0.151905374254189, 0.14829147843672, 
    0.142927722608918, 0.135881383907326, 0.127240187133055, 
    0.117110740965019, 0.105616733344741, 0.0928969652669149, 
    0.0791033000580684, 0.0643985965135031, 0.0489546801083168, 
    0.032950388569511, 0.0165697084334358, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0164902219748564, 0.0327921170364912, 
    0.0487190421799213, 0.064087757272211, 0.0787202081660797, 
    0.0924453912250148, 0.10510130076059, 0.116536942562707, 
    0.126614377964889, 0.135210745815959, 0.142220196276392, 
    0.147555662115588, 0.151150391223315, 0.15295916879258, 
    0.152959168823274, 0.151150391313959, 0.147555662261943, 
    0.142220196471612, 0.135210746050914, 0.12661437822859, 
    0.116536942842822, 0.10510130104402, 0.0924453914985078, 
    0.0787202084168485, 0.064087757488532, 0.048719042351682, 
    0.0327921171556625, 0.0164902220358679, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0164110305093352, 0.0326344421772222, 
    0.0484843148405189, 0.0637781581597631, 0.0783387020205271, 
    0.0919957616837356, 0.104588178150476, 0.115965816740152, 
    0.125991589025426, 0.134543447016529, 0.141516285704484, 
    0.146823682279785, 0.150399398560127, 0.152198577795818, 
    0.152198577825908, 0.150399398648988, 0.146823682423261, 
    0.141516285895864, 0.134543447246864, 0.125991589283941, 
    0.115965817014759, 0.104588178428333, 0.0919957619518517, 
    0.0783387022663661, 0.0637781583718318, 0.0484843150089034, 
    0.0326344422940512, 0.0164110305691476, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0163321367880111, 0.0324773690171611, 
    0.0482505044884974, 0.0634698057205288, 0.0779587868945794, 
    0.0915480791950214, 0.104077364025102, 0.115397356927915, 
    0.125371808030671, 0.133879469363071, 0.140815967257632, 
    0.146095510675743, 0.149652364691803, 0.151442022898291, 
    0.151442022927789, 0.149652364778916, 0.146095510816397, 
    0.140815967445249, 0.133879469588875, 0.125371808284103, 
    0.115397357197122, 0.104077364297497, 0.0915480794578663, 
    0.0779587871355855, 0.0634698059284287, 0.048250504653572, 
    0.0324773691316937, 0.0163321368466478, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0162535434225313, 0.0323209023219029, 
    0.048017617178073, 0.0631627061192734, 0.0775804677024391, 
    0.0911023460292423, 0.103568856741744, 0.114831556569902, 
    0.124755022898345, 0.133218795101157, 0.140119217862, 0.145371119742377, 
    0.148909258813046, 0.150689471593515, 0.150689471622433, 
    0.148909258898446, 0.145371119880265, 0.140119218045927, 
    0.133218795322521, 0.124755023146793, 0.114831556833815, 
    0.103568857008783, 0.0911023462869196, 0.0775804679387073, 
    0.0631627063230864, 0.0480176173399027, 0.0323209024341842, 
    0.0162535434800155, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0161752528320806, 0.0321650464931727, 
    0.0477856584680826, 0.0628568649484144, 0.0772037487724387, 
    0.0906585639230438, 0.103062654237063, 0.114268408852328, 
    0.12414122148479, 0.132561406624687, 0.139426014793674, 
    0.144650482441297, 0.148170050767399, 0.149940892090355, 
    0.149940892118704, 0.148170050851119, 0.144650482576473, 
    0.139426014973983, 0.132561406841697, 0.124141221728352, 
    0.114268409111053, 0.103062654498851, 0.090658564175655, 
    0.077203749004062, 0.0628568651482209, 0.0477856586267311, 
    0.0321650466032469, 0.0161752528884349, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0160972672522347, 0.0320098055856029, 
    0.0475546334449181, 0.0625522872547011, 0.0768286338746541, 
    0.0902167341049816, 0.102558754048049, 0.113707906717761, 
    0.123530391590602, 0.131907286472476, 0.138736335666544, 
    0.143933572237204, 0.14743471102217, 0.149196253285056, 
    0.149196253312847, 0.147434711104244, 0.143933572369722, 
    0.138736335843307, 0.131907286685219, 0.123530391829375, 
    0.113707906971398, 0.10255875430469, 0.0902167343526263, 
    0.0768286341017238, 0.0625522874505797, 0.0475546336004481, 
    0.0320098056935134, 0.0160972673074812, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0160195887434229, 0.0318551833227674, 
    0.047324546744447, 0.0622489775647113, 0.0764551262472931, 
    0.0897768573200182, 0.102057153332041, 0.113150042878523, 
    0.122922520965999, 0.13125641732499, 0.138050158420697, 0.14322036307913, 
    0.146703210644441, 0.148455524734497, 0.148455524761742, 
    0.146703210724901, 0.143220363209042, 0.138050158593985, 
    0.131256417533549, 0.122922521200077, 0.113150043127173, 
    0.102057153583636, 0.089776857562794, 0.0764551264698987, 
    0.0622489777567392, 0.0473245468969196, 0.0318551834285567, 
    0.0160195887975835, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0159422191990165, 0.0317011831125073, 
    0.0470954025729609, 0.0619469399092194, 0.0760832286219133, 
    0.0893389338529298, 0.101557848885845, 0.112594809829502, 
    0.122317597315932, 0.130608782001193, 0.13736746131131, 
    0.142510829382485, 0.145975521278111, 0.147718676630597, 
    0.147718676657305, 0.145975521356989, 0.142510829509842, 
    0.13736746148119, 0.130608782205651, 0.122317597545407, 
    0.112594810073263, 0.101557849132493, 0.0893389340909325, 
    0.0760832288401426, 0.0619469400974723, 0.0470954027224361, 
    0.0317011832162171, 0.0159422192521125, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0158651603530586, 0.0315478080615775, 
    0.0468672047271979, 0.0616461778464842, 0.0757129432475215, 
    0.0889029635506726, 0.101060837164002, 0.112042199860373, 
    0.121715608304962, 0.129964363455535, 0.136688222898012, 
    0.14180494601188, 0.145251615121943, 0.146985679775831, 
    0.146985679802014, 0.145251615199269, 0.141804946136732, 
    0.136688223064551, 0.129964363655973, 0.121715608529925, 
    0.112042200099341, 0.101060837405801, 0.088902963783996, 
    0.0757129434614604, 0.0616461780310362, 0.0468672048737347, 
    0.0315478081632485, 0.0158651604051108, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0157884137876525, 0.0313950609896455, 
    0.0466399566134776, 0.0613466944845045, 0.0753442719136026, 
    0.0884689458437543, 0.100566114296237, 0.111492205067278, 
    0.121116541561911, 0.129323144775047, 0.136012422034698, 
    0.141102688264692, 0.144531464908551, 0.146256505559815, 
    0.146256505585483, 0.144531464984356, 0.141102688387089, 
    0.136012422197962, 0.129323144971543, 0.12111654178245, 
    0.111492205301547, 0.100566114533281, 0.0884689460724903, 
    0.0753442721233355, 0.0613466946654283, 0.0466399567571337, 
    0.0313950610893179, 0.0157884138386814, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0157119809400227, 0.0312429444426703, 
    0.0464136612659885, 0.0610484925022878, 0.0749772159721266, 
    0.0880368797666534, 0.100073676104132, 0.110944817363971, 
    0.120520384684284, 0.128685109176548, 0.135340037859781, 
    0.140404031855332, 0.143815043884299, 0.145531125936894, 
    0.145531125962057, 0.143815043958613, 0.140404031975322, 
    0.135340038019835, 0.12868510936918, 0.120520384900486, 
    0.110944817593633, 0.100073676336516, 0.0880368799908922, 
    0.0749772161777361, 0.0610484926796548, 0.0464136614068205, 
    0.0312429445403833, 0.0157119809900486, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0156358631092638, 0.0310914607056886, 
    0.0461883213642651, 0.0607515741701761, 0.0746117763585777, 
    0.0876067639773307, 0.0995835181170512, 0.110400028492465, 
    0.119927125242491, 0.128050240003966, 0.134671049786851, 
    0.13970895290019, 0.143102325790072, 0.144809513404708, 
    0.144809513429377, 0.143102325862925, 0.13970895301782, 
    0.134671049943757, 0.12805024019281, 0.119927125454442, 
    0.110400028717612, 0.0995835183448657, 0.0876067641971607, 
    0.0746117765601448, 0.0607515743440561, 0.0461883215023285, 
    0.0310914608014807, 0.0156358631583063, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0155600614627897, 0.0309406118150346, 
    0.0459639392498899, 0.060455941369269, 0.0742479536120491, 
    0.0871785967758706, 0.0990956355873521, 0.109857830033197, 
    0.119336750783865, 0.127418520725757, 0.134005437495733, 
    0.139017427903229, 0.142393284842871, 0.144091640983681, 
    0.144091641007865, 0.142393284914291, 0.139017428018545, 
    0.134005437649553, 0.127418520910888, 0.119336750991649, 
    0.109857830253916, 0.0990956358106873, 0.0871785969913785, 
    0.0742479538096534, 0.0604559415397305, 0.0459639393852391, 
    0.0309406119089435, 0.0155600615108681, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0154845770424978, 0.0307903995700184, 
    0.0457405169424555, 0.0601615956099854, 0.0738857478944445, 
    0.0867523761222917, 0.0986100235049183, 0.109318213414724, 
    0.118749248836493, 0.126789934932427, 0.13334318092392, 
    0.138329433742192, 0.141687895718202, 0.143377482197398, 
    0.143377482221106, 0.141687895788218, 0.138329433855241, 
    0.133343181074716, 0.126789935113917, 0.11874924904019, 
    0.109318213631104, 0.0986100237238623, 0.0867523763335625, 
    0.0738857480881637, 0.0601615957770957, 0.0457405170751438, 
    0.0307903996620812, 0.0154845770896309, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0154094107706595, 0.030640825544087, 
    0.0455180561548182, 0.0598685380498012, 0.0735251590088255, 
    0.0863280996535633, 0.0981266766110383, 0.108781169922995, 
    0.118164606912854, 0.126164466334141, 0.132684260258374, 
    0.13764494765541, 0.140986133533231, 0.142667011053826, 
    0.142667011077068, 0.14098613360187, 0.137644947766236, 
    0.132684260406204, 0.126164466512063, 0.118164607112547, 
    0.10878117013512, 0.0981266768256774, 0.0863280998606802, 
    0.0735251591987361, 0.0598685382136261, 0.045518056284898, 
    0.0306408256343399, 0.0154094108168661, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0153345634555506, 0.0304918910954896, 
    0.0452965583076752, 0.0595767695101985, 0.0731661864169432, 
    0.0859057646998628, 0.097645589411663, 0.108246690710185, 
    0.117582812513301, 0.125542098758432, 0.132028655927664, 
    0.136963947229161, 0.140287973830655, 0.141960202027352, 
    0.141960202050137, 0.140287973897944, 0.136963947337807, 
    0.132028656072587, 0.125542098932855, 0.117582812709067, 
    0.108246690918139, 0.097645589622082, 0.0859057649029076, 
    0.07316618660312, 0.0595767696708026, 0.0452965584351976, 
    0.0304918911839682, 0.0153345635008488, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0152600357968307, 0.0303435973774709, 
    0.0450760245434943, 0.0592862904928623, 0.0728088292559887, 
    0.0854853683001071, 0.0971667561900684, 0.107714766803139, 
    0.117003853129356, 0.124922816147988, 0.131376348594438, 
    0.13628641038558, 0.139593392563272, 0.141257030041584, 
    0.141257030063921, 0.139593392629238, 0.13628641049209, 
    0.131376348736512, 0.124922816318981, 0.117003853321272, 
    0.107714767007004, 0.0971667563963501, 0.0854853684991598, 
    0.0728088294385051, 0.0592862906503089, 0.0450760246685096, 
    0.03034359746421, 0.0152600358412383, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0151858283906849, 0.0301959453480113, 
    0.0448564557398258, 0.0589971011951573, 0.0724530863545985, 
    0.0850669072167904, 0.0966901710189483, 0.107185389111429, 
    0.116427716246859, 0.124306602558526, 0.130727319148218, 
    0.135612315371084, 0.138902366079212, 0.140557470452907, 
    0.140557470474805, 0.138902366143881, 0.1356123154755, 0.130727319287498, 
    0.124306602726156, 0.116427716435001, 0.107185389311285, 
    0.0966901712211741, 0.0850669074119294, 0.0724530865335266, 
    0.0589971013495084, 0.0448564558623834, 0.0301959454330452, 
    0.0151858284342195, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0151119417347376, 0.0300489357791357, 
    0.0446378525220229, 0.0587092015249159, 0.0720989562481464, 
    0.0846503779501586, 0.0962158277719646, 0.10665854843504, 
    0.115854389348963, 0.123693442156744, 0.130081548698484, 
    0.134941640745285, 0.138214871107807, 0.139861499034734, 
    0.139861499056201, 0.138214871171204, 0.134941640847647, 
    0.130081548835025, 0.123693442321078, 0.115854389533406, 
    0.106658548630967, 0.0962158279702143, 0.0846503781414609, 
    0.0720989564235566, 0.0587092016762324, 0.044637852642171, 
    0.0300489358624978, 0.0151119417774164, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0150383762327474, 0.0299025692658078, 
    0.0444202152753966, 0.0584225911145692, 0.0717464371933539, 
    0.0842357767517504, 0.0957437201347771, 0.106134235471712, 
    0.115283859918981, 0.123083319218349, 0.129439018568056, 
    0.13427436537038, 0.137530884746055, 0.139169091962441, 
    0.139169091983486, 0.137530884808206, 0.134274365470729, 
    0.129439018701912, 0.123083319379452, 0.115283860099797, 
    0.106134235663786, 0.0957437203291287, 0.0842357769392914, 
    0.0717464373653153, 0.0584225912629107, 0.0444202153931825, 
    0.0299025693475311, 0.0150383762745871, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0149651321990943, 0.0297568462344308, 
    0.0442035441568309, 0.0581372693346482, 0.0713955271822488, 
    0.0838230996373316, 0.0952738416155764, 0.105612440823936, 
    0.114716115443092, 0.122476218126157, 0.128799710286753, 
    0.133610468400994, 0.136850384445682, 0.138480225798949, 
    0.13848022581958, 0.13685038450661, 0.133610468499371, 0.128799710417976, 
    0.122476218284092, 0.114716115620353, 0.105612441012234, 
    0.0952738418061067, 0.0838230998211853, 0.0713955273508293, 
    0.0581372694800733, 0.0442035442723012, 0.0297568463145474, 
    0.0149651322401114, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0148922098630671, 0.0296117669509692, 
    0.0439878391058813, 0.057853235306685, 0.0710462239555016, 
    0.0834123423992509, 0.0948061855551428, 0.105093155005642, 
    0.114151143412922, 0.121872123368265, 0.128163605585308, 
    0.132949929274452, 0.136173348000738, 0.137794877480917, 
    0.137794877501142, 0.136173348060468, 0.132949929370893, 
    0.128163605713952, 0.121872123523094, 0.114151143586697, 
    0.105093155190238, 0.0948061857419269, 0.0834123425794898, 
    0.0710462241207676, 0.0578532354492509, 0.0439878392190813, 
    0.0296117670295107, 0.0148922099032779, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0148196093729609, 0.0294673315287105, 
    0.0437730998553792, 0.057570487915538, 0.0706985250151654, 
    0.0830035006182418, 0.0943407451364502, 0.104576368448572, 
    0.11358893132799, 0.12127101953628, 0.127530686389549, 0.132292727701458, 
    0.135499753535737, 0.13711302430554, 0.137113024325367, 
    0.135499753594293, 0.132292727796004, 0.127530686515662, 
    0.121271019688065, 0.113588931498348, 0.104576368629538, 
    0.0943407453195617, 0.0830035007949368, 0.0706985251771821, 
    0.0575704880553009, 0.0437730999663537, 0.0294673316057078, 
    0.0148196094123811, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0147473307999918, 0.0293235399356809, 
    0.0435593259415653, 0.0572890258211688, 0.0703524276368483, 
    0.0825965696746948, 0.093877513393837, 0.10406207150836, 
    0.113029466698039, 0.120672891323628, 0.126900934814804, 
    0.131638843657185, 0.1348295794943, 0.1364346439179, 0.136434643937337, 
    0.134829579551704, 0.131638843749871, 0.126900934938438, 
    0.120672891472428, 0.113029466865048, 0.104062071685768, 
    0.0938775135733482, 0.0825965698479157, 0.0703524277956796, 
    0.0572890259581839, 0.0435593260503579, 0.0293235400111644, 
    0.014747330838637, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0146753741420385, 0.0291803920017324, 
    0.0433465167137707, 0.0570088474698935, 0.07000792888134, 
    0.0821915447594243, 0.0934164832217621, 0.10355025447034, 
    0.112472737045248, 0.120077723523904, 0.126274333160555, 
    0.130988257372722, 0.134162804628279, 0.135759714298863, 
    0.135759714317919, 0.134162804684554, 0.130988257463586, 
    0.126274333281758, 0.120077723669779, 0.112472737208973, 
    0.103550254644259, 0.0934164833977437, 0.0821915449292395, 
    0.0700079290370484, 0.0570088476042148, 0.0433465168204244, 
    0.0291803920757318, 0.0146753741799239, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0146037393272163, 0.0290378874253129, 
    0.0431346713436677, 0.0567299511051323, 0.0696650256057194, 
    0.081788420883952, 0.0929576473831639, 0.103040907555074, 
    0.111918729906332, 0.119485501029299, 0.125650863905301, 
    0.130340949326899, 0.133499407987346, 0.135088213753498, 
    0.135088213772179, 0.133499408042515, 0.130340949415976, 
    0.125650864024121, 0.119485501172306, 0.111918730066838, 
    0.103040907725574, 0.0929576475556854, 0.0817884210504283, 
    0.0696650257583663, 0.0567299512368127, 0.0431346714482245, 
    0.0290378874978575, 0.0146037393643568, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0145324262172928, 0.0288960257799365, 
    0.0429237888341078, 0.0564523347776788, 0.069323714473965, 
    0.0813871928903271, 0.0925009985174416, 0.102534020923638, 
    0.111367432834543, 0.11889620882907, 0.125030509701637, 
    0.129696900238446, 0.132839368909027, 0.134420120899976, 
    0.134420120918289, 0.132839368963111, 0.129696900325771, 
    0.12503050981812, 0.118896208969264, 0.111367432991893, 
    0.102534021090785, 0.092500998686571, 0.0813871930535302, 
    0.0693237146236107, 0.0564523349067702, 0.0429237889366089, 
    0.0288960258510548, 0.0145324262537032, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0144614346109519, 0.0287548065203641, 
    0.0427138680275656, 0.0561759963555113, 0.0689839919670898, 
    0.0809878554605057, 0.0920465291480732, 0.10202958468265, 
    0.110818833401561, 0.118309832008066, 0.124413253371534, 
    0.129056091058486, 0.132182667009157, 0.133755414658958, 
    0.133755414676912, 0.132182667062178, 0.129056091144094, 
    0.124413253485727, 0.118309832145503, 0.110818833555817, 
    0.102029584846511, 0.0920465293138771, 0.0809878556204999, 
    0.0689839921137933, 0.0561759964820646, 0.0427138681280515, 
    0.0287548065900842, 0.0144614346466464, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0143907642469112, 0.0286142289885101, 
    0.0425049076142066, 0.0559009335331648, 0.0686458543928224, 
    0.0805904031253072, 0.0915942316898878, 0.101527588889079, 
    0.110272919199297, 0.117726355745308, 0.123799077901811, 
    0.128418502963345, 0.131529282172739, 0.133094074243427, 
    0.133094074261027, 0.131529282224717, 0.12841850304727, 
    0.123799078013759, 0.117726355880043, 0.11027291935052, 
    0.101527589049718, 0.0915942318524317, 0.0805904032821557, 
    0.0686458545366415, 0.0559009336572299, 0.0425049077127168, 
    0.0286142290568594, 0.0143907642819039, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0143204148069017, 0.0284742924190839, 
    0.0422969061395938, 0.0556271438406847, 0.0683092978948531, 
    0.0801948302729676, 0.0911440984560077, 0.101028023554816, 
    0.109729677841598, 0.117145765312618, 0.123187966439797, 
    0.127784117347662, 0.130879194545192, 0.132436079148948, 
    0.132436079166202, 0.130879194596148, 0.127784117429937, 
    0.123187966549544, 0.117145765444704, 0.109729677989847, 
    0.101028023712296, 0.0911440986153556, 0.0801948304267321, 
    0.0683092980358445, 0.0556271439623105, 0.0422969062361672, 
    0.0284742924860894, 0.0143204148412064, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0142503859185141, 0.0283349959449816, 
    0.0420898620120514, 0.0553546246521794, 0.067974318461666, 
    0.0798011311573058, 0.0906961216644727, 0.100530878651042, 
    0.109189096965866, 0.116568046073288, 0.122579902289164, 
    0.127152915817783, 0.130232384523969, 0.131781409144351, 
    0.131781409161266, 0.130232384573923, 0.12715291589844, 
    0.122579902396752, 0.116568046202777, 0.1091890971112, 0.100530878805426, 
    0.0906961218206876, 0.0798011313080471, 0.0679743185998852, 
    0.0553546247714139, 0.0420898621067261, 0.0283349960106698, 
    0.0142503859521444, 1.3887959385959e-11,
  1.38879542122922e-11, 0.014180677157918, 0.0281963386024359, 
    0.0418837735096982, 0.05508337319399, 0.0676409119349734, 
    0.0794092999055226, 0.0902502934445639, 0.100036144112388, 
    0.108651164234595, 0.115993183480805, 0.121974868905927, 
    0.126524880185441, 0.129588832750527, 0.131130044262802, 
    0.131130044279384, 0.129588832799498, 0.126524880264511, 0.1219748690114, 
    0.115993183607748, 0.108651164377072, 0.100036144263737, 
    0.0902502935977073, 0.0794093000533, 0.0676409120704751, 
    0.0550833733108801, 0.0418837736025115, 0.0281963386668326, 
    0.0141806771908871, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0141112880524604, 0.0280583193359361, 
    0.0416786387871674, 0.0548133865524936, 0.0673090740177719, 
    0.0790193305256455, 0.0898066058428375, 0.0995438098409034, 
    0.108115867336825, 0.115421163077606, 0.121372849894619, 
    0.125899992461688, 0.128948520102636, 0.130481964793253, 
    0.130481964809509, 0.128948520150645, 0.125899992539204, 
    0.121372849998018, 0.115421163202053, 0.1081158674765, 0.099543809989276, 
    0.0898066059929697, 0.0790193306705173, 0.0673090741506094, 
    0.0548133866670855, 0.0416786388781558, 0.0280583193990666, 
    0.0141112880847812, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0140422180831469, 0.0279209370029284, 
    0.0414744558820248, 0.0545446616815576, 0.0669788002820353, 
    0.0786312169136378, 0.0893650508288824, 0.0990538657098303, 
    0.107583193989519, 0.114851970493886, 0.120773829004602, 
    0.12527823485109, 0.128311427687014, 0.129837151272253, 
    0.129837151288189, 0.128311427734079, 0.125278234927082, 
    0.120773829105968, 0.114851970615885, 0.107583194126448, 
    0.0990538658552856, 0.0893650509760627, 0.0786312170556612, 
    0.066978800412261, 0.0545446617938965, 0.0414744559712243, 
    0.0279209370648177, 0.0140422181148324, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0139734666870139, 0.0277841903783064, 
    0.041271222720901, 0.0542771954096582, 0.0666500861760611, 
    0.0782449528601849, 0.0889256203008148, 0.0985663015672102, 
    0.10705313193887, 0.114285591446435, 0.120177790126543, 
    0.124659589746155, 0.12767753683227, 0.129195584476109, 
    0.129195584491732, 0.127677536878409, 0.124659589820653, 
    0.120177790225915, 0.114285591566035, 0.107053132073107, 
    0.0985663017098055, 0.0889256204451012, 0.0782449529994158, 
    0.0666500863037263, 0.0542771955197884, 0.0412712228083467, 
    0.0277841904389789, 0.0139734667180763, 1.3887959385959e-11,
  1.38879542122922e-11, 0.0139050332593926, 0.0276480781586998, 
    0.0410689371253472, 0.0540109844466805, 0.066322927031486, 
    0.0778605320571725, 0.0884883060905196, 0.0980811072393135, 
    0.106525668961535, 0.113722011737522, 0.119584717289016, 
    0.124044039721996, 0.127046829082136, 0.128557245413368, 
    0.128557245428685, 0.127046829127369, 0.124044039795029, 
    0.119584717386435, 0.113722011854771, 0.106525669093132, 
    0.0980811073791051, 0.0884883062319691, 0.0778605321936659, 
    0.0663229271566411, 0.0540109845546453, 0.0410689372110736, 
    0.0276480782181794, 0.0139050332898444, 1.3887959385959e-11 ;
}
EOF

rm -f xdifs.log xdifs.cdl diffusion_1.nc

echo okay
