#!/bin/sh
# test of gtattr

set -e

ncgen -b - <<EOF
netcdf xxa {
dimensions:
	x = 12;
variables:
	float	a(x);
data:
	a = -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0;
}
EOF

ncgen -b - <<EOF
netcdf xxb {
dimensions:
	x = 12;
variables:
	float	b(x);
data:
	b = 0.0, 0.0, 0.0, 3.0, 3.0, 3.0, 6.0, 6.0, 6.0, 9.0, 9.0, 9.0;
}
EOF

test ! -f xo.nc || rm -f xo.nc

#	sed '/^::/d' <<-EOF > fdb.scr
#:: break an_vartable@vtable_lookup_
#:: break gtvarlimitbinary_+40
#:: run -Wl,-Re xxa.nc?a + xxb.nc?b -debug output=xo.nc
#   run xxa.nc?a + xxb.nc?b -debug output=xo.nc
#:: continue 18
#EOF
# 	fdb -script=fdb.scr ../gtbinary/gtbinary 

../gtbinary/gtbinary xxa.nc?a + xxb.nc?b  output=xo.nc

ncdump xo.nc > xo.cdl

diff xo.cdl - <<EOF
netcdf xo {
dimensions:
	x = 12 ;
variables:
	float x(x) ;
	float a(x) ;
data:

 x = 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ;

 a = -1, 0, 1, 5, 6, 7, 11, 12, 13, 17, 18, 19 ;
}
EOF

rm -f xo.nc xo.cdl xxa.nc xxb.nc

echo okay
