! gtaxisdefault.f90 - 
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GTAxisOpen(this, base_var, dimno, vertical)
    use gtgraph_types, only: GT_AXIS
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Open, get, Inquire, get_attr
    use dc_trace, only: message, beginsub, endsub
    use sysdep, only: abortprogram
    use dc_string
    implicit none
    type(GT_AXIS), intent(out):: this
    type(GT_VARIABLE), intent(in):: base_var
    integer, intent(in):: dimno
    logical, intent(in), optional:: vertical
    real, pointer:: values(:)
    character(*), parameter:: sub = 'GTAxisOpen'
continue
    call beginsub(sub, 'var=%d dimno=%d', i=(/base_var%mapid, dimno/))
    call Open(this%var, base_var, dimno)
    ! c
    this%vertical = .FALSE.
    if (present(vertical)) this%vertical = vertical
    ! ̏㉺lAł͂Ƃ肠őŏƂA
    ! ؂̂悢lւ̕ϊ DclScalingPoint ɂ䂾˂B
    call get(this%var, values)
    if (.not. associated(values)) then
        call abortprogram('gtaxisopen: read error of variable')
    endif
    this%upper = maxval(values)
    this%lower = minval(values)
    deallocate(values)
    ! 擾
    call get_attr(this%var, 'long_name', this%title)
    if (this%title == '') call Inquire(this%var, name=this%title)
    ! PʂɊւĂ͂ GT_VARIABLE 
    ! C^[tFCXׂł
    call get_attr(this%var, 'units', this%units)
    if (this%units == '') then
        call get_attr(this%var, 'unit', this%units, &
            default="units missing")
    endif
    ! d`h~邽߂̃tO
    this%drawn = .FALSE.
    ! dZ[uh~邽߂̃tO
    this%saved = ""
    call endsub(sub, 'vert=%y upper=%r lower=%r', L=(/this%vertical/), &
	& r=(/this%upper, this%lower/))
end subroutine

! Tu[` Axes  Axis ̕ł邱ƂɒӁB
! ݂̂ƂKW 2 ΂ŕ`悳Ȃ΂ȂȂB

subroutine GTAxesDraw(h_axis, v_axis, parent, set_space)
    use gtgraph_types, only: GT_AXIS, GT_FIGURE
    use gtdata_generic, only: Get
    use dc_trace, only: message
    use dc_string
    use dc_error
    use dcl
    implicit none
    type(GT_AXIS), intent(inout):: h_axis, v_axis
    type(GT_FIGURE), intent(in):: parent
    logical, intent(in), optional:: set_space
    logical:: set_space_mode
    real, pointer:: value(:)
    type(VSTRING):: xtitle, ytitle, xunits, yunits
continue
    ! ͂Ȃ낤
    if (.not. associated(parent%h_axis)) return
    if (.not. associated(parent%v_axis)) return
    ! IvV
    set_space_mode = .FALSE.
    if (present(set_space)) set_space_mode = set_space
    ! `ƂƂ͋ԐݒłB
    call message("h_axis(%r %r) v_axis(%r %r)", &
	    r=(/h_axis%lower, h_axis%upper, v_axis%lower, v_axis%upper/))
    call DclSetWindow(h_axis%lower, h_axis%upper, &
        v_axis%lower, v_axis%upper)
    call DclSetTransFunction()
    if (.not. (h_axis%drawn .or. v_axis%drawn)) then
        xtitle = GTStringQuoteForDcl(h_axis%title)
        ytitle = GTStringQuoteForDcl(v_axis%title)
        xunits = GTStringQuoteForDcl(h_axis%units)
        yunits = GTStringQuoteForDcl(v_axis%units)
        call DclSetTitle( &
            & vchar(xtitle, len(xtitle)), &
            & vchar(ytitle, len(ytitle)), &
            & vchar(xunits, len(xunits)), &
            & vchar(yunits, len(yunits)))
        ! Oڐ
        call DclSetParm('AXIS:INNER', -1)
        call DclDrawScaledAxis()
    else if (.not. v_axis%drawn) then
        ytitle = GTStringQuoteForDcl(v_axis%title)
        yunits = GTStringQuoteForDcl(v_axis%units)
        call DclSetTitle("", vchar(ytitle, len(ytitle)), &
            & "", vchar(yunits, len(yunits)))
        call DclDrawScaledAxis(side="rl")
    else if (.not. h_axis%drawn) then
        xtitle = GTStringQuoteForDcl(h_axis%title)
        xunits = GTStringQuoteForDcl(h_axis%units)
        call DclSetTitle(vchar(xtitle, len(xtitle)), "", &
            & vchar(xunits, len(xunits)), "")
        call DclDrawScaledAxis(side="tb")
    endif
    if (set_space_mode) then
        call get(h_axis%var, value)
        call DclSetXGrid(value)
        deallocate(value)
        call get(v_axis%var, value)
        call DclSetYGrid(value)
        deallocate(value)
    endif
    h_axis%drawn = .TRUE.
    v_axis%drawn = .TRUE.
end subroutine

subroutine GTAxisClose(axis)
    use gtgraph_types, only: GT_AXIS
    use gtdata_generic, only: Close
    type(GT_AXIS), intent(inout):: axis
continue
    ! 肪ʓ|Ȃ̂ var 𑽏d close Ă܂B
    call Close(axis%var)
end subroutine
