! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

! o͔͈͎wSɂĈꊇ擾
! 炩 inquire(var, alldims) ĔzmۂȂ΂ȂȂB
!
subroutine GTVarGetSliceAll(var, start, count, stride)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: GTVarGetSlice
    implicit none
    type(GT_VARIABLE), intent(in):: var
    integer, intent(out), optional:: start(:), count(:), stride(:)
    integer:: nd, i
    logical:: all
    nd = HUGE(1)
    all = present(start) .and. present(count) .and. present(stride)
    if (present(start)) nd = min(nd, size(start))
    if (present(count)) nd = min(nd, size(count))
    if (present(stride)) nd = min(nd, size(stride))
    do, i = 1, nd
        if (all) then
            call GTVarGetSlice(var, i, start(i), count(i), stride(i))
            cycle
        endif
        if (present(start)) call GTVarGetSlice(var, i, start=start(i))
        if (present(count)) call GTVarGetSlice(var, i, count=count(i))
        if (present(stride)) call GTVarGetSlice(var, i, stride=stride(i))
    enddo
end subroutine

