! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTFigLoad(fig, var)
    use gtgraph_types, only: GT_FIGURE, GT_OBJECT
    use gtgraph_generic, only: Load, Bind
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr, Inquire
    use dc_string
    use dc_error
    use dc_types, only: STRING
    use dc_url, only: UrlResolve
    use dc_trace, only: beginsub, endsub
implicit none
    type(GT_FIGURE), intent(out):: fig
    type(GT_VARIABLE), intent(in):: var
    type(GT_OBJECT):: it
    type(VSTRING):: members
    character(STRING):: member, aname, baseurl
    type(STRING_LIST):: member_list
continue
    call beginsub('gtfigload', 'var.mapid=%d', i=(/var%mapid/))
    call get_attr(var, "gt_structure_member", members)
    call split(member_list, members, " ")
    do, while (len(member_list) > 0)
        member = shift(member_list)
        aname = "gt_structure_link_" // trim(member)
        call get_attr(var, trim(aname), member)
        if (member == "") exit
        call Inquire(var, url=baseurl)
        member = UrlResolve(member, base=baseurl)
        call Load(it, member)
        call Bind(fig, it)
    enddo
    call endsub('gtfigload')
end subroutine
