#!/bin/sh
# test of gtattr

set -e

ncgen -b - <<EOF
netcdf a10 {
dimensions:
	x = 12;
variables:
	float	a(x);
data:
	a = -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0;
}
EOF

test ! -f x.nc || rm -f x.nc
../gtunary/gtunary in=a10.nc?a out=x.nc?a $opt1 negate
ncdump x.nc > x.cdl

diff x.cdl - <<EOF
netcdf x {
dimensions:
	x = 12 ;
variables:
	float x(x) ;
	float a(x) ;
data:

 x = 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ;

 a = 1, -0, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10 ;
}
EOF

test ! -f x.nc || rm -f x.nc
../gtunary/gtunary in=a10.nc?a out=x.nc?a sqrt
ncdump x.nc > x.cdl

diff x.cdl - <<EOF
netcdf x {
dimensions:
	x = 12 ;
variables:
	float x(x) ;
	float a(x) ;
data:

 x = 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ;

 a = -999000, 0, 1, 1.414214, 1.732051, 2, 2.236068, 2.44949, 2.645751, 
    2.828427, 3, 3.162278 ;
}
EOF

rm -f x.nc x.cdl a10.nc

# more realistic test

ncgen -b <<EOF
netcdf xxc {
dimensions:
        x = 2 ;
        y = 3 ;
        p = 5 ;
        time = unlimited ;
variables:
        float x(x) ;
                x:units = "degrees_east" ;
                x:long_name = "longitude" ;
        float y(y) ;
                y:units = "degrees_north" ;
                y:long_name = "latitude" ;
        float p(p) ;
                p:units = "hPa" ;
                p:long_name = "pressure" ;
        float time(time) ;
                time:units = "h from 2001-07-10T12" ;
                time:long_name = "time" ;
                time:interval = 24 ;
        float z(time, p, y, x) ;
                z:units = "m" ;
                z:long_name = "geopotential height" ;
data:
        x = 120, 140 ;
        y = 30, 40, 50 ;
        p = 925, 850, 700, 500, 300 ;
        time = 0, 24, 48, 72 ;
        z =
	0, 1, 2, 3, 4, 5, 10, 11, 12, 13, 14, 15,
	20, 21, 22, 23, 24, 25, 30, 31, 32, 33, 34, 35,
	40, 41, 42, 43, 44, 45,
        100, 101, 102, 103, 104, 105, 110, 111, 112, 113, 114, 115,
        120, 121, 122, 123, 124, 125, 130, 131, 132, 133, 134, 135,
        140, 141, 142, 143, 144, 145,
        200, 201, 202, 203, 204, 205, 210, 211, 212, 213, 214, 215,
        220, 221, 222, 223, 224, 225, 230, 231, 232, 233, 234, 235,
        240, 241, 242, 243, 244, 245,
        300, 301, 302, 303, 304, 305, 310, 311, 312, 313, 314, 315,
        320, 321, 322, 323, 324, 325, 330, 331, 332, 333, 334, 335,
        340, 341, 342, 343, 344, 345 ;
}
EOF

test ! -f x.nc || rm -f x.nc
../gtunary/gtunary in=xxc.nc?z out=x.nc?a negate
ncdump x.nc > x.cdl

diff x.cdl - <<EOF
netcdf x {
dimensions:
	x = 2 ;
	y = 3 ;
	p = 5 ;
	time = UNLIMITED ; // (4 currently)
variables:
	float x(x) ;
		x:units = "degrees_east" ;
		x:long_name = "longitude" ;
	float y(y) ;
		y:units = "degrees_north" ;
		y:long_name = "latitude" ;
	float p(p) ;
		p:units = "hPa" ;
		p:long_name = "pressure" ;
	float time(time) ;
		time:units = "h from 2001-07-10T12" ;
		time:long_name = "time" ;
		time:interval = 24 ;
	float a(time, p, y, x) ;
		a:units = "m" ;
		a:long_name = "geopotential height" ;
data:

 x = 120, 140 ;

 y = 30, 40, 50 ;

 p = 925, 850, 700, 500, 300 ;

 time = 0, 24, 48, 72 ;

 a =
  -0, -1,
  -2, -3,
  -4, -5,
  -10, -11,
  -12, -13,
  -14, -15,
  -20, -21,
  -22, -23,
  -24, -25,
  -30, -31,
  -32, -33,
  -34, -35,
  -40, -41,
  -42, -43,
  -44, -45,
  -100, -101,
  -102, -103,
  -104, -105,
  -110, -111,
  -112, -113,
  -114, -115,
  -120, -121,
  -122, -123,
  -124, -125,
  -130, -131,
  -132, -133,
  -134, -135,
  -140, -141,
  -142, -143,
  -144, -145,
  -200, -201,
  -202, -203,
  -204, -205,
  -210, -211,
  -212, -213,
  -214, -215,
  -220, -221,
  -222, -223,
  -224, -225,
  -230, -231,
  -232, -233,
  -234, -235,
  -240, -241,
  -242, -243,
  -244, -245,
  -300, -301,
  -302, -303,
  -304, -305,
  -310, -311,
  -312, -313,
  -314, -315,
  -320, -321,
  -322, -323,
  -324, -325,
  -330, -331,
  -332, -333,
  -334, -335,
  -340, -341,
  -342, -343,
  -344, -345 ;
}
EOF

rm -f x.nc x.cdl xxc.nc

echo okay
