! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.


subroutine GTVarAttrRewind(var)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: attr_rewind, an_variable
    use gt_mem, only: attr_rewind, mem_variable
    implicit none
    type(GT_VARIABLE), intent(inout), target:: var
    integer:: class, cid
    call var_class(var, class, cid)
    select case(class)
    case(vtb_class_netcdf)
        call attr_rewind(an_variable(cid))
    case(vtb_class_memory)
        call attr_rewind(mem_variable(cid))
    end select
end subroutine

subroutine GTVarAttrNext(var, name, end)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: attr_next, an_variable
    use gt_mem, only: attr_next, mem_variable
    implicit none
    type(GT_VARIABLE), intent(inout), target:: var
    character(len = *), intent(out):: name
    logical, intent(out), optional:: end
    integer:: class, cid
    call var_class(var, class, cid)
    select case(class)
    case(vtb_class_netcdf)
        call attr_next(an_variable(cid), name, end)
    case(vtb_class_memory)
        call attr_next(mem_variable(cid), name, end)
    end select
end subroutine
