! Sample program for gtool_history/gtool4          2001/02/27 S.Takehiro
! 
! Solving diffusion equation 
!     du/dt = kappa d^2 u/dx^2
! for giving values of u at x=0 and 1. 
!
program diffusion

  use gtool_history                                          ! W[w
  use dc_trace, only: setdebug

  integer:: i, it
  integer, parameter              :: nx=30                   ! Obh
  integer, parameter              :: nt=200                  ! ԃXebv
  integer, parameter              :: ndisp=10                ! o͊Ԋu
  double precision, parameter     :: dx=1.0/(nx-1)           ! ObhԊu
  double precision, parameter     :: dt=0.0005               ! ԊԊu
  double precision, dimension(nx) :: x=(/(dx*(i-1),i=1,nx)/) ! Wϐ
  double precision, dimension(nx) :: temp                    ! x
  double precision, parameter     :: kappa=1.0               ! MgUW

  temp = exp(-((x-0.5)/0.1)**2)                              ! lݒ

  call setdebug
  call HistoryCreate( &                                      ! qXg[쐬
       file='diffusion_1.nc', title='Diffusion equation', &
       source='Sample program of gtool_history/gtool4', &
       institution='GFD_Dennou Club davis project',     &
       dims=(/'x','t'/), dimsizes=(/nx,0/),             &
       longnames=(/'X-coordinate','time        '/),     &
       units=(/'m','s'/),                               &
       origin=0.0, interval=real(ndisp*dt) )

  call HistoryPut('x',x)                                     ! ϐo

  call HistoryAddVariable( &                                 ! ϐ`
       varname='temp', dims=(/'x','t'/), & 
       longname='temperature', units='K', xtype='double')

  call HistoryPut('temp',temp)                               ! ϐo

  do it=1,nt
     temp(2:nx-1) = temp(2:nx-1) &                           ! Ԑϕ
          +kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

     if ( mod(nt,ndisp) .eq. 0 ) then
        call HistoryPut('temp',temp)                         ! ϐo
     endif
  enddo

  call HistoryClose
  stop
end program diffusion

