!== netcdf_f77_win.f90 - netCDF original interface module (for Windows IntelVisualFortran)
!
! Authors::   Naohito OTOBE, Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: netcdf_f77_win.f90,v 1.1.1.1 2008-09-23 09:56:35 morikawa Exp $
! Tag Name::  $Name: gtool5-20090116 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!


module netcdf_f77
  !
  ! ܥ⥸塼뷲 netCDF ꥸʥ netcdf.inc 
  ! Ѥ٤ΤǤnetcdf.inc ؤλȤϤƤޤ
  !
!
!DEC$OBJCOMMENT LIB:'netcdf.LIB'
!DEC$OBJCOMMENT LIB:'netcdfs.LIB'
!

  use dc_types, only: NF_KIND_INT1, NF_KIND_INT2

  implicit none

  !
  ! --- symbols ---
  !

  !
  ! external netCDF data type ID
  !

  integer, parameter:: NF_BYTE = 1
  integer, parameter:: NF_INT1 = NF_BYTE
  integer, parameter:: NF_CHAR = 2
  integer, parameter:: NF_SHORT = 3
  integer, parameter:: NF_INT2 = NF_SHORT
  integer, parameter:: NF_INT = 4
  integer, parameter:: NF_FLOAT = 5
  integer, parameter:: NF_REAL = NF_FLOAT
  integer, parameter:: NF_DOUBLE = 6

  !
  ! default fill values
  !

  integer, parameter:: NF_FILL_BYTE = -127
  integer, parameter:: NF_FILL_INT1 = NF_FILL_BYTE
  integer, parameter:: NF_FILL_CHAR = 0
  integer, parameter:: NF_FILL_SHORT = -32767
  integer, parameter:: NF_FILL_INT2 = NF_FILL_SHORT
  integer, parameter:: NF_FILL_INT = -2147483647
  real, parameter:: NF_FILL_FLOAT = 9.9692099683868690e+36
  real, parameter:: NF_FILL_REAL = NF_FILL_FLOAT
  double precision, parameter:: &
    & NF_FILL_DOUBLE = 9.9692099683868690e+36

  !
  ! mode flags for opening and creating a netcdf dataset:
  !

  integer, parameter:: NF_NOWRITE = 0
  integer, parameter:: NF_WRITE = 1
  integer, parameter:: NF_CLOBBER = 0
  integer, parameter:: NF_NOCLOBBER = 4
  integer, parameter:: NF_FILL = 0
  integer, parameter:: NF_NOFILL = 256
  integer, parameter:: NF_LOCK = 1024
  integer, parameter:: NF_SHARE = 2048
  integer, parameter:: NF_SIZEHINT_DEFAULT = 0
  integer, parameter:: NF_ALIGN_CHUNK = -1

  !
  ! size argument for defining an unlimited dimension:
  !

  integer, parameter:: NF_UNLIMITED = 0

  !
  ! global attribute id:
  !

  integer, parameter:: NF_GLOBAL = 0

  !
  ! implementation limits:
  !

  integer, parameter:: NF_MAX_DIMS = 100
  integer, parameter:: NF_MAX_ATTRS = 2000
  integer, parameter:: NF_MAX_VARS = 2000
  integer, parameter:: NF_MAX_NAME = 128
  integer, parameter:: NF_MAX_VAR_DIMS = NF_MAX_DIMS

  !
  ! error codes:
  !

  integer, parameter:: NF_NOERR = 0
  integer, parameter:: NF_EBADID = -33
  integer, parameter:: NF_EEXIST = -35
  integer, parameter:: NF_EINVAL = -36
  integer, parameter:: NF_EPERM = -37
  integer, parameter:: NF_ENOTINDEFINE = -38
  integer, parameter:: NF_EINDEFINE = -39
  integer, parameter:: NF_EINVALCOORDS = -40
  integer, parameter:: NF_EMAXDIMS = -41
  integer, parameter:: NF_ENAMEINUSE = -42
  integer, parameter:: NF_ENOTATT = -43
  integer, parameter:: NF_EMAXATTS = -44
  integer, parameter:: NF_EBADTYPE = -45
  integer, parameter:: NF_EBADDIM = -46
  integer, parameter:: NF_EUNLIMPOS = -47
  integer, parameter:: NF_EMAXVARS = -48
  integer, parameter:: NF_ENOTVAR = -49
  integer, parameter:: NF_EGLOBAL = -50
  integer, parameter:: NF_ENOTNC = -51
  integer, parameter:: NF_ESTS = -52
  integer, parameter:: NF_EMAXNAME = -53
  integer, parameter:: NF_EUNLIMIT = -54
  integer, parameter:: NF_ENORECVARS = -55
  integer, parameter:: NF_ECHAR = -56
  integer, parameter:: NF_EEDGE = -57
  integer, parameter:: NF_ESTRIDE = -58
  integer, parameter:: NF_EBADNAME = -59
  integer, parameter:: NF_ERANGE = -60
  integer, parameter:: NF_ENOMEM = -61

  !
  ! error handling modes:
  !

  integer, parameter:: NF_FATAL = 1
  integer, parameter:: NF_VERBOSE = 2

  !
  ! --- interfaces ---
  !

  interface

    !
    ! --- ¿ʴؿ ---
    !

    function nf_inq_libvers(ncerr)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_LIBVERS' :: NF_INQ_LIBVERS
     !
      ! netCDF 饤֥ΥС֤
      !
      character(len=80)::                nf_inq_libvers
      integer, intent(in)::        ncerr
    end function nf_inq_libvers

    logical function nf_issyserr(ncerr)
      !
      ! (ɥȤƤʤؿ)
      !
      ! 顼ɤ netCDF ǤϤʤ C 饤֥ˤȤ
      !
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_ISSYSERR' :: NF_ISSYSERR
      integer, intent(in)::        ncerr
    end function nf_issyserr

    character(len=80) function nf_strerror(ncerr)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_STRERROR' :: NF_STRERROR
      !
      ! 顼ɤ netCDF Υå֤
      !
      integer, intent(in)::        ncerr
    end function nf_strerror

    integer function nf_inq_base_pe(ncid, pe)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_BASE_PE' :: NF_INQ_BASE_PE
      !
      ! (ɥȤƤʤؿ)
      !
      ! PE 餷
      !
      integer, intent(in)::        ncid, pe
    end function nf_inq_base_pe

    integer function nf_set_base_pe(ncid, pe)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_SET_BASE_PE' :: NF_SET_BASE_PE
      !
      ! (ɥȤƤʤؿ)
      !
      ! PE 餷
      !
      integer, intent(in)::        ncid, pe
    end function nf_set_base_pe

    !
    ! --- ե롦Ĥ롦Ū ---
    !

    integer function nf_create(path, cmode, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_CREATE' :: NF_CREATE
      !
      ! ե (줿֤Ȥʤ)
      !
      character(len=*), intent(in)::        path
      integer, intent(in)::                cmode
      integer, intent(out)::                ncid
    end function nf_create

    integer function nf__create(path, cmode, initialsz, chunksizehint, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__CREATE' :: NF__CREATE
      ! (ɥȤƤʤؿ)
      character(len=*), intent(in)::        path
      integer, intent(in):: cmode, initialsz, chunksizehint
      integer, intent(out)::                ncid
    end function nf__create

    integer function nf__create_mp(path, cmode, initialsz, &
      & basepe, chunksizehint, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__CREATE_MP' :: NF__CREATE_MP
      ! (ɥȤƤʤؿ)
      character(len=*), intent(in)::        path
      integer, intent(in):: cmode, initialsz, basepe, chunksizehint
      integer, intent(out)::                ncid
    end function nf__create_mp

    integer function nf_open(path, cmode, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_OPEN' :: NF_OPEN
      !
      ! ե򳫤
      !
      character(len=*), intent(in)::        path
      integer, intent(in)::                cmode
      integer, intent(out)::                ncid
    end function nf_open

    integer function nf__open(path, cmode, initialsz, chunksizehint, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__OPEN' :: NF__OPEN
      ! (ɥȤƤʤؿ)
      character(len=*), intent(in)::        path
      integer, intent(in):: cmode, initialsz, chunksizehint
      integer, intent(out)::                ncid
    end function nf__open

    integer function nf__open_mp(path, cmode, initialsz, &
      & basepe, chunksizehint, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__OPEN_MP' :: NF__OPEN_MP
      ! (ɥȤƤʤؿ)
      character(len=*), intent(in)::        path
      integer, intent(in):: cmode, initialsz, basepe, chunksizehint
      integer, intent(out)::                ncid
    end function nf__open_mp

    integer function nf_set_fill(ncid, fillmode, old_mode)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_SET_FILL' :: NF_SET_FILL
      ! fill ⡼ɤ/
      integer, intent(in)::        ncid, fillmode
      integer, intent(out)::        old_mode
    end function nf_set_fill

    integer function nf_redef(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_REDEF' :: NF_REDEF
      ! ⡼ɤؤΰܹ
      integer, intent(in)::        ncid
    end function nf_redef

    integer function nf_enddef(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_ENDDEF' :: NF_ENDDEF
      ! ⡼ɤæ
      integer, intent(in)::        ncid
    end function nf_enddef

    integer function nf__enddef(ncid, h_minfree, v_align, &
      & v_minfree, r_align)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__ENDDEF' :: NF__ENDDEF
      !
      ! ⡼ɤæ
      !
      ! (ɥȤƤʤؿ)
      !
      integer, intent(in)::        ncid
      integer, intent(in):: h_minfree, v_align, &
        & v_minfree, r_align
    end function nf__enddef

    integer function nf_sync(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_SYNC' :: NF_SYNC
      ! Ʊ
      integer, intent(in)::        ncid
    end function nf_sync

    integer function nf_close(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_CLOSE' :: NF_CLOSE
      ! Ĥ
      integer, intent(in)::        ncid
    end function nf_close

    integer function nf_abort(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_ABORT' :: NF_ABORT
      ! Ĥݤ⡼ɤˤ˸ƤФ
      ! (桼ƤɬפΤʤؿ)
      integer, intent(in)::        ncid
    end function nf_abort

    integer function nf_delete(path)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_DELETE' :: NF_DELETE
      ! MP եκ
      !
      ! (ɥȤƤʤؿ)
      character(len=*), intent(in)::        path
    end function nf_delete

    !
    ! --- ե䤤碌 ---
    !

    integer function nf_inq(ncid, ndims, nvars, ngatts, unlimdimid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ' :: NF_INQ
      !
      ! 줿ե ncid Ф٤Ƥ䤤碌Ԥ
      !
      integer, intent(in)::        ncid
      integer, intent(out)::        ndims, nvars, ngatts
      integer, intent(out)::        unlimdimid
    end function nf_inq

    integer function nf_inq_ndims(ncid, ndims)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_NDIMS' :: NF_INQ_NDIMS
      !  ndims 䤤碌
      integer, intent(in)::        ncid
      integer, intent(out)::        ndims
    end function nf_inq_ndims

    integer function nf_inq_nvars(ncid, nvars)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_NVARS' :: NF_INQ_NVARS
      ! ѿο nvars 䤤碌
      integer, intent(in)::        ncid
      integer, intent(out)::        nvars
    end function nf_inq_nvars

    integer function nf_inq_natts(ncid, ngatts)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_NATTS' :: NF_INQ_NATTS
      ! °ο ngatts 䤤碌
      integer, intent(in)::        ncid
      integer, intent(out)::        ngatts
    end function nf_inq_natts

    integer function nf_inq_unlimdim(ncid, unlimdimid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_UNLIMDIM' :: NF_INQ_UNLIMDIM
      ! ̵¼ID unlimdimid 䤤碌롣
      ! ⤷ʤ 1 ֤
      integer, intent(in)::        ncid
      integer, intent(out)::        unlimdimid
    end function nf_inq_unlimdim

    !
    ! --- ˴ؤ롼 ---
    !

    integer function nf_def_dim(ncid, name, len, dimid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_DEF_DIM' :: NF_DEF_DIM
      ! ̾ name, Ĺ len ļ롣
      ! Ƥ줿 ID ()  dimid ֤
      integer, intent(in)::                ncid
      character(len=*), intent(in)::        name
      integer, intent(in)::                len
      integer, intent(out)::                dimid
    end function nf_def_dim

    integer function nf_inq_dimid(ncid, name, dimid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_DIMID' :: NF_INQ_DIMID
      ! ̾Ф뼡 ID 䤤碌
      integer, intent(in)::                ncid
      character(len=*), intent(in)::        name
      integer, intent(out)::                dimid
    end function nf_inq_dimid

    integer function nf_inq_dim(ncid, dimid, name, len)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_DIM' :: NF_INQ_DIM
      !  ID ̾ name Ĺ len 䤤碌롣
      ! name ˤɬפĹʤФʤʤ
      integer, intent(in)::                ncid
      integer, intent(in)::                dimid
      character(len=*), intent(out)::        name
      integer, intent(out)::                len
    end function nf_inq_dim

    integer function nf_inq_dimname(ncid, dimid, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_DIMNAME' :: NF_INQ_DIMNAME
      !  ID ̾ name 䤤碌롣
      ! name ˤɬפĹʤФʤʤ
      integer, intent(in)::                ncid
      integer, intent(in)::                dimid
      character(len=*), intent(out)::        name
    end function nf_inq_dimname

    integer function nf_inq_dimlen(ncid, dimid, len)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_DIMLEN' :: NF_INQ_DIMLEN
      !  ID Ĺ len 䤤碌
      integer, intent(in)::                ncid
      integer, intent(in)::                dimid
      integer, intent(out)::                len
    end function nf_inq_dimlen

    !
    ! --- ° ---
    !
    ! °ʸѿͷǤ롣
    ! ĹȤʸǤĹѥ᥿ͷǤ礭Ǥ롣
    ! °ѿ varid ˽°뤫°Ȥʤ롣
    ! ° varid ȤƤ NF_GLOBAL Ѥ롣

    !
    ! --- °˴ؤ䤤碌 ---
    !

    integer function nf_inq_att(ncid, varid, name, xtype, len)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATT' :: NF_INQ_ATT
      ! ѿ varid ° name η xtype Ĺ len 䤤碌
      integer, intent(in)::        ncid, varid
      character(len=*), intent(in):: name
      integer, intent(out)::        xtype
      integer, intent(out)::        len
    end function nf_inq_att

    integer function nf_inq_atttype(ncid, varid, name, xtype)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATTTYPE' :: NF_INQ_ATTTYPE
      ! ѿ varid ° name η xtype 䤤碌
      integer, intent(in)::        ncid, varid
      character(len=*), intent(in):: name
      integer, intent(out)::        xtype
    end function nf_inq_atttype

    integer function nf_inq_attlen(ncid, varid, name, len)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATTLEN' :: NF_INQ_ATTLEN
      ! ѿ varid ° name Ĺ len 䤤碌
      integer, intent(in)::        ncid, varid
      character(len=*), intent(in):: name
      integer, intent(out)::        len
    end function nf_inq_attlen

    integer function nf_inq_attid(ncid, varid, name, attnum)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATTID' :: NF_INQ_ATTID
      ! ѿ varid ° name ֹ attnum 䤤碌
      integer, intent(in)::        ncid, varid
      character(len=*), intent(in):: name
      integer, intent(out)::        attnum
    end function nf_inq_attid

    integer function nf_inq_attname(ncid, varid, attnum, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATTNAME' :: NF_INQ_ATTNAME
      ! ѿ varid ° attnum ̾ name 䤤碌
      ! name ˤɬפĹʤФʤʤ
      integer, intent(in)::        ncid, varid
      integer, intent(in)::        attnum
      character(len=*), intent(out):: name
    end function nf_inq_attname

    !
    ! --- °ɤ߽񤭰ʳ ---
    !

    integer function nf_copy_att(ncid_in, varid_in, name, &
      & ncid_out, varid_out)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_COPY_ATT' :: NF_COPY_ATT
      integer, intent(in)::                ncid_in, varid_in
      character(len=*), intent(in)::        name
      integer, intent(in)::                ncid_out, varid_out
    end function nf_copy_att

    integer function nf_rename_att(ncid, varid, curname, newname)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_RENAME_ATT' :: NF_RENAME_ATT
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        curname
      character(len=*), intent(in)::        newname
    end function nf_rename_att

    integer function nf_del_att(ncid, varid, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_DEL_ATT' :: NF_DEL_ATT
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
    end function nf_del_att

    !
    ! --- ° ---
    !

    integer function nf_put_att_text(ncid, varid, name, len, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_TEXT' :: NF_PUT_ATT_TEXT
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      integer, intent(in)::                len
      character(len=*), intent(in)::        text
    end function nf_put_att_text

    integer function nf_put_att_int1(ncid, varid, name, &
      & xtype, len, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_INT1' :: NF_PUT_ATT_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      integer, intent(in)::                xtype, len
      integer(NF_KIND_INT1), intent(in):: i1vals(*)
    end function nf_put_att_int1

    integer function nf_put_att_int2(ncid, varid, name, &
      & xtype, len, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_INT2' :: NF_PUT_ATT_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      integer, intent(in)::                xtype, len
      integer(NF_KIND_INT2), intent(in):: i2vals(*)
    end function nf_put_att_int2

    integer function nf_put_att_int(ncid, varid, name, &
      & xtype, len, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_INT' :: NF_PUT_ATT_INT
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      integer, intent(in)::                xtype, len
      integer, intent(in)::                ivals(*)
    end function nf_put_att_int

    integer function nf_put_att_real(ncid, varid, name, &
      & xtype, len, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_REAL' :: NF_PUT_ATT_REAL
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      integer, intent(in)::                xtype, len
      real, intent(in)::                        rvals(*)
    end function nf_put_att_real

    integer function nf_put_att_double(ncid, varid, name, &
      & xtype, len, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_DOUBLE' :: NF_PUT_ATT_DOUBLE
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      integer, intent(in)::                xtype, len
      double precision, intent(in)::        dvals(*)
    end function nf_put_att_double

    !
    ! --- °ɤ߼ ---
    !

    integer function nf_get_att_text(ncid, varid, name, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_TEXT' :: NF_GET_ATT_TEXT
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      character(len=*), intent(out)::        text
    end function nf_get_att_text

    integer function nf_get_att_int1(ncid, varid, name, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_INT1' :: NF_GET_ATT_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      integer(NF_KIND_INT1), intent(in):: i1vals(*)
    end function nf_get_att_int1

    integer function nf_get_att_int2(ncid, varid, name, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_INT2' :: NF_GET_ATT_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      integer(NF_KIND_INT2), intent(in):: i2vals(*)
    end function nf_get_att_int2

    integer function nf_get_att_int(ncid, varid, name, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_INT' :: NF_GET_ATT_INT
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      integer, intent(in)::                ivals(*)
    end function nf_get_att_int

    integer function nf_get_att_real(ncid, varid, name, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_REAL' :: NF_GET_ATT_REAL
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      real, intent(in)::                        rvals(*)
    end function nf_get_att_real

    integer function nf_get_att_double(ncid, varid, name, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_DOUBLE' :: NF_GET_ATT_DOUBLE
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
      double precision, intent(in)::        dvals(*)
    end function nf_get_att_double

    !
    ! --- ѿ ---
    !
    ! ѿϼˤäƤޤǤ롣
    ! ٤ƤȤʤƤϤʤ櫓ǤϤʤ
    !

    integer function nf_def_var(ncid, name, xtype, ndims, dimids, varid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_DEF_VAR' :: NF_DEF_VAR
      ! ̾ name ѿ롣
      ! ǡ xtype,  ndims Ȥ
      ! Ƽ ID  dimids Ϳ롣
      ! ѿ ID  varid ֤롣
      integer, intent(in)::                ncid
      character(len=*), intent(in)::        name
      integer, intent(in)::                xtype, ndims
      integer, intent(in)::                dimids(*)
      integer, intent(out)::                varid
    end function nf_def_var

    !
    ! --- ѿ˴ؤ䤤碌 ---
    !

    integer function nf_inq_varid(ncid, name, varid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARID' :: NF_INQ_VARID
      ! ѿ̾ name  ID varid Τ
      integer, intent(in)::                ncid
      character(len=*), intent(in)::        name
      integer, intent(out)::                varid
    end function nf_inq_varid

    integer function nf_inq_var(ncid, varid, &
      & name, xtype, ndims, dimids, natts)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VAR' :: NF_INQ_VAR
      ! ѿ varid 鲿Ǥ䤤碌 (ʲδؿ)
      ! dimids ɬפ礭ʤФʤʤ
      integer, intent(in)::                ncid, varid
      character(len=*), intent(out)::        name
      integer, intent(out)::                xtype, ndims, natts 
      integer, intent(out)::                dimids(*)
    end function nf_inq_var

    integer function nf_inq_varname(ncid, varid, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARNAME' :: NF_INQ_VARNAME
       ! ѿ varid ѿ̾ name Τ롣
      ! name ˤɬפĹʤФʤʤ
      integer, intent(in)::                ncid, varid
      character(len=*), intent(out)::        name
    end function nf_inq_varname

    integer function nf_inq_vartype(ncid, varid, xtype)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARTYPE' :: NF_INQ_VARTYPE
      ! ѿ varid 鷿 xtype Τ
      integer, intent(in)::                ncid, varid
      integer, intent(out)::                xtype
    end function nf_inq_vartype

    integer function nf_inq_varndims(ncid, varid, ndims)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARNDIMS' :: NF_INQ_VARNDIMS
      ! ѿ varid 鼡 ndims Τ
      integer, intent(in)::                ncid, varid
      integer, intent(out)::                ndims
    end function nf_inq_varndims

    integer function nf_inq_vardimid(ncid, varid, dimids)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARDIMID' :: NF_INQ_VARDIMID
      ! ѿ varid 鼡ID  dimids 
      integer, intent(in)::                ncid, varid
      integer, intent(out)::                dimids(*)
    end function nf_inq_vardimid

    integer function nf_inq_varnatts(ncid, varid, natts)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARNATTS' :: NF_INQ_VARNATTS
      ! ѿ varid ° natts Τ
      integer, intent(in)::                ncid, varid
      integer, intent(out)::                natts
    end function nf_inq_varnatts

    !
    ! --- ѿ˴ؤɤ߽񤭰ʳ ---
    !

    integer function nf_rename_var(ncid, varid, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_RENAME_VAR' :: NF_RENAME_VAR
      ! ѿ varid  name ˲̾
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        name
    end function nf_rename_var

    integer function nf_copy_var(ncid, varid, ncid_out)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_COPY_VAR' :: NF_COPY_VAR
      ! ѿ varid ̤ netCDF ǡå ncid_out ˥ԡ
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                ncid_out
    end function nf_copy_var

    !
    ! --- ѿν񤭹 ---
    !

    !
    ! ѿñǽ񤭹
    !

    integer function nf_put_var1_text(ncid, varid, index, chval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_TEXT' :: NF_PUT_VAR1_TEXT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      character(*), intent(in)::                chval
    end function nf_put_var1_text

    integer function nf_put_var1_int1(ncid, varid, index, i1val)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_INT1' :: NF_PUT_VAR1_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      integer(NF_KIND_INT1), intent(in):: i1val
    end function nf_put_var1_int1

    integer function nf_put_var1_int2(ncid, varid, index, i2val)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_INT2' :: NF_PUT_VAR1_INT2
       use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      integer(NF_KIND_INT2), intent(in):: i2val
    end function nf_put_var1_int2

    integer function nf_put_var1_int(ncid, varid, index, ival)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_INT' :: NF_PUT_VAR1_INT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      integer, intent(in)::                 ival
    end function nf_put_var1_int

    integer function nf_put_var1_real(ncid, varid, index, rval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_REAL' :: NF_PUT_VAR1_REAL
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      real, intent(in)::                         rval
    end function nf_put_var1_real

    integer function nf_put_var1_double(ncid, varid, index, dval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_DOUBLE' :: NF_PUT_VAR1_DOUBLE
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      double precision, intent(in)::         dval
    end function nf_put_var1_double

    !
    ! ѿν񤭹
    !

    integer function nf_put_var_text(ncid, varid, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_TEXT' :: NF_PUT_VAR_TEXT
      integer, intent(in)::                ncid, varid
      character(len=*), intent(in)::        text
    end function nf_put_var_text

    integer function nf_put_var_int1(ncid, varid, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_INT1' :: NF_PUT_VAR_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      integer(NF_KIND_INT1), intent(in):: i1vals(*)
    end function nf_put_var_int1

    integer function nf_put_var_int2(ncid, varid, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_INT2' :: NF_PUT_VAR_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer(NF_KIND_INT2), intent(in):: i2vals(*)
    end function nf_put_var_int2

    integer function nf_put_var_int(ncid, varid, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_INT' :: NF_PUT_VAR_INT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                 ivals(*)
    end function nf_put_var_int

    integer function nf_put_var_real(ncid, varid, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_REAL' :: NF_PUT_VAR_REAL
      integer, intent(in)::                ncid, varid
      real, intent(in)::                         rvals(*)
    end function nf_put_var_real

    integer function nf_put_var_double(ncid, varid, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_DOUBLE' :: NF_PUT_VAR_DOUBLE
      integer, intent(in)::                ncid, varid
      double precision, intent(in)::         dvals(*)
    end function nf_put_var_double

    !
    ! ѿʬ񤭹
    !

    integer function nf_put_vara_text(ncid, varid, &
      & start, count, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_TEXT' :: NF_PUT_VARA_TEXT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      character(len=*), intent(in)::        text
    end function nf_put_vara_text

    integer function nf_put_vara_int1(ncid, varid, &
      & start, count, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_INT1' :: NF_PUT_VARA_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer(NF_KIND_INT1), intent(in):: i1vals(*)
    end function nf_put_vara_int1

    integer function nf_put_vara_int2(ncid, varid, &
      & start, count, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_INT2' :: NF_PUT_VARA_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer(NF_KIND_INT2), intent(in):: i2vals(*)
    end function nf_put_vara_int2

    integer function nf_put_vara_int(ncid, varid, &
      & start, count, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_INT' :: NF_PUT_VARA_INT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                 ivals(*)
    end function nf_put_vara_int

    integer function nf_put_vara_real(ncid, varid, &
      & start, count, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_REAL' :: NF_PUT_VARA_REAL
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      real, intent(in)::                         rvals(*)
    end function nf_put_vara_real

    integer function nf_put_vara_double(ncid, varid, &
      start, count, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_DOUBLE' :: NF_PUT_VARA_DOUBLE
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      double precision, intent(in)::         dvals(*)
    end function nf_put_vara_double

    !
    ! ѿɸ񤭹
    !
    ! ƼȤɸֳܴ stride(i) Ȥ˽񤭹
    !

    integer function nf_put_vars_text(ncid, varid, &
      & start, count, stride, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_TEXT' :: NF_PUT_VARS_TEXT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      character(len=*), intent(in)::        text
    end function nf_put_vars_text

    integer function nf_put_vars_int1(ncid, varid, &
      & start, count, stride, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_INT1' :: NF_PUT_VARS_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      integer(NF_KIND_INT1), intent(in):: i1vals(*)
    end function nf_put_vars_int1

    integer function nf_put_vars_int2(ncid, varid, &
      & start, count, stride, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_INT2' :: NF_PUT_VARS_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      integer(NF_KIND_INT2), intent(in):: i2vals(*)
    end function nf_put_vars_int2

    integer function nf_put_vars_int(ncid, varid, &
      & start, count, stride, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_INT' :: NF_PUT_VARS_INT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      integer, intent(in)::                 ivals(*)
    end function nf_put_vars_int

    integer function nf_put_vars_real(ncid, varid, &
      & start, count, stride, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_REAL' :: NF_PUT_VARS_REAL
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      real, intent(in)::                         rvals(*)
    end function nf_put_vars_real

    integer function nf_put_vars_double(ncid, varid, &
      & start, count, stride, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_DOUBLE' :: NF_PUT_VARS_DOUBLE
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      double precision, intent(in)::         dvals(*)
    end function nf_put_vars_double

    !
    ! ѿμ񤭹
    !
    ! ɸ񤭹ߵǽ˲ä¤ؤ뵡ǽդ
    !

    integer function nf_put_varm_text(ncid, varid, &
      & start, count, stride, imap, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_TEXT' :: NF_PUT_VARM_TEXT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      character(len=*), intent(in)::        text
    end function nf_put_varm_text

    integer function nf_put_varm_int1(ncid, varid, &
      & start, count, stride, imap, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_INT1' :: NF_PUT_VARM_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      integer(NF_KIND_INT1), intent(in):: i1vals(*)
    end function nf_put_varm_int1

    integer function nf_put_varm_int2(ncid, varid, &
      & start, count, stride, imap, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_INT2' :: NF_PUT_VARM_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      integer(NF_KIND_INT2), intent(in):: i2vals(*)
    end function nf_put_varm_int2

    integer function nf_put_varm_int(ncid, varid, &
      & start, count, stride, imap, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_INT' :: NF_PUT_VARM_INT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      integer, intent(in)::                 ivals(*)
    end function nf_put_varm_int

    integer function nf_put_varm_real(ncid, varid, &
      & start, count, stride, imap, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_REAL' :: NF_PUT_VARM_REAL
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      real, intent(in)::                         rvals(*)
    end function nf_put_varm_real

    integer function nf_put_varm_double(ncid, varid, &
      & start, count, stride, imap, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_DOUBLE' :: NF_PUT_VARM_DOUBLE
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      double precision, intent(in)::         dvals(*)
    end function nf_put_varm_double


    !
    ! --- ѿɤ߼ ---
    !

    !
    ! ѿñɤ߼
    !

    integer function nf_get_var1_text(ncid, varid, index, chval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_TEXT' :: NF_GET_VAR1_TEXT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      character, intent(out)::                chval
    end function nf_get_var1_text

    integer function nf_get_var1_int1(ncid, varid, index, i1val)
      use dc_types, only: NF_KIND_INT1
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_INT1' :: NF_GET_VAR1_INT1
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      integer(NF_KIND_INT1), intent(out):: i1val
    end function nf_get_var1_int1

    integer function nf_get_var1_int2(ncid, varid, index, i2val)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_INT2' :: NF_GET_VAR1_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      integer(NF_KIND_INT2), intent(out):: i2val
    end function nf_get_var1_int2

    integer function nf_get_var1_int(ncid, varid, index, ival)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_INT' :: NF_GET_VAR1_INT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      integer, intent(out)::                 ival
    end function nf_get_var1_int

    integer function nf_get_var1_real(ncid, varid, index, rval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_REAL' :: NF_GET_VAR1_REAL
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      real, intent(out)::                 rval
    end function nf_get_var1_real

    integer function nf_get_var1_double(ncid, varid, index, dval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_DOUBLE' :: NF_GET_VAR1_DOUBLE
       integer, intent(in)::                ncid, varid
      integer, intent(in)::                index(*)
      double precision, intent(out)::         dval
    end function nf_get_var1_double

    !
    ! ѿɤ߼
    !

    integer function nf_get_var_text(ncid, varid, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_TEXT' :: NF_GET_VAR_TEXT
      integer, intent(in)::                ncid, varid
      character(len=*), intent(out)::        text
    end function nf_get_var_text

    integer function nf_get_var_int1(ncid, varid, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_INT1' :: NF_GET_VAR_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      integer(NF_KIND_INT1), intent(out):: i1vals(*)
    end function nf_get_var_int1

    integer function nf_get_var_int2(ncid, varid, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_INT2' :: NF_GET_VAR_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer(NF_KIND_INT2), intent(out):: i2vals(*)
    end function nf_get_var_int2

    integer function nf_get_var_int(ncid, varid, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_INT' :: NF_GET_VAR_INT
      integer, intent(in)::                ncid, varid
      integer, intent(out)::                 ivals(*)
    end function nf_get_var_int

    integer function nf_get_var_real(ncid, varid, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_REAL' :: NF_GET_VAR_REAL
      integer, intent(in)::                ncid, varid
      real, intent(out)::                 rvals(*)
    end function nf_get_var_real

    integer function nf_get_var_double(ncid, varid, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_DOUBLE' :: NF_GET_VAR_DOUBLE
      integer, intent(in)::                ncid, varid
      double precision, intent(out)::         dvals(*)
    end function nf_get_var_double

    !
    ! ѿʬɤ߼
    !

    integer function nf_get_vara_text(ncid, varid, &
      & start, count, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_TEXT' :: NF_GET_VARA_TEXT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      character(len=*), intent(out)::        text
    end function nf_get_vara_text

    integer function nf_get_vara_int1(ncid, varid, &
      & start, count, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_INT1' :: NF_GET_VARA_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer(NF_KIND_INT1), intent(out):: i1vals(*)
    end function nf_get_vara_int1

    integer function nf_get_vara_int2(ncid, varid, &
      & start, count, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_INT2' :: NF_GET_VARA_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer(NF_KIND_INT2), intent(out):: i2vals(*)
    end function nf_get_vara_int2

    integer function nf_get_vara_int(ncid, varid, &
      & start, count, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_INT' :: NF_GET_VARA_INT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(out)::                 ivals(*)
    end function nf_get_vara_int

    integer function nf_get_vara_real(ncid, varid, &
      & start, count, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_REAL' :: NF_GET_VARA_REAL
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      real, intent(out)::                 rvals(*)
    end function nf_get_vara_real

    integer function nf_get_vara_double(ncid, varid, &
      start, count, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_DOUBLE' :: NF_GET_VARA_DOUBLE
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      double precision, intent(out)::         dvals(*)
    end function nf_get_vara_double

    !
    ! ѿɸɤ߼
    !

    integer function nf_get_vars_text(ncid, varid, &
      & start, count, stride, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_TEXT' :: NF_GET_VARS_TEXT
       integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      character(len=*), intent(out)::        text
    end function nf_get_vars_text

    integer function nf_get_vars_int1(ncid, varid, &
      & start, count, stride, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_INT1' :: NF_GET_VARS_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      integer(NF_KIND_INT1), intent(out):: i1vals(*)
    end function nf_get_vars_int1

    integer function nf_get_vars_int2(ncid, varid, &
      & start, count, stride, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_INT2' :: NF_GET_VARS_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      integer(NF_KIND_INT2), intent(out):: i2vals(*)
    end function nf_get_vars_int2

    integer function nf_get_vars_int(ncid, varid, &
      & start, count, stride, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_INT2' :: NF_GET_VARS_INT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      integer, intent(out)::                 ivals(*)
    end function nf_get_vars_int

    integer function nf_get_vars_real(ncid, varid, &
      & start, count, stride, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_REAL' :: NF_GET_VARS_REAL
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      real, intent(out)::                 rvals(*)
    end function nf_get_vars_real

    integer function nf_get_vars_double(ncid, varid, &
      & start, count, stride, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_DOUBLE' :: NF_GET_VARS_DOUBLE
       integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*)
      double precision, intent(out)::         dvals(*)
    end function nf_get_vars_double

    !
    ! ѿμɤ߼
    !

    integer function nf_get_varm_text(ncid, varid, &
      & start, count, stride, imap, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_TEXT' :: NF_GET_VARM_TEXT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      character(len=*), intent(out)::        text
    end function nf_get_varm_text

    integer function nf_get_varm_int1(ncid, varid, &
      & start, count, stride, imap, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_INT1' :: NF_GET_VARM_INT1
      use dc_types, only: NF_KIND_INT1
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      integer(NF_KIND_INT1), intent(out):: i1vals(*)
    end function nf_get_varm_int1

    integer function nf_get_varm_int2(ncid, varid, &
      & start, count, stride, imap, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_INT2' :: NF_GET_VARM_INT2
      use dc_types, only: NF_KIND_INT2
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      integer(NF_KIND_INT2), intent(out):: i2vals(*)
    end function nf_get_varm_int2

    integer function nf_get_varm_int(ncid, varid, &
      & start, count, stride, imap, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_INT1' :: NF_GET_VARM_INT
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      integer, intent(out)::                 ivals(*)
    end function nf_get_varm_int

    integer function nf_get_varm_real(ncid, varid, &
      & start, count, stride, imap, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_REAL' :: NF_GET_VARM_REAL
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      real, intent(out)::                 rvals(*)
    end function nf_get_varm_real

    integer function nf_get_varm_double(ncid, varid, &
      & start, count, stride, imap, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_DOUBLE' :: NF_GET_VARM_DOUBLE
      integer, intent(in)::                ncid, varid
      integer, intent(in)::                start(*), count(*)
      integer, intent(in)::                stride(*), imap(*)
      double precision, intent(out)::         dvals(*)
    end function nf_get_varm_double

  end interface
end module netcdf_f77
