!= dc_date ǻѤ, ѿ, ³
!= Internal constants, variables, procedures used in "dc_date"
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: dc_date_internal.f90,v 1.1 2009-05-25 10:01:34 morikawa Exp $
! Tag Name::  $Name: gtool5-20090602 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module dc_date_internal
  != dc_date ǻѤ, ѿ, ³
  != Internal constants, variables, procedures used in "dc_date"

  use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
  use dc_types, only: DP, STRING, TOKEN
  use dc_present, only: present_and_not_empty

  implicit none

  private
  public:: dcdate_normalize, dcdate_parse_unit, dcdate_set_day_seconds_scl
  public:: dcdate_nondimcheck

contains

  subroutine dcdate_normalize(day, sec, day_seconds, nondim_flag)
    !
    !=== ä
    !
    ! Υ֥롼ʤΤ dc_date ⥸塼볰Ǥ
    ! ϻѤʤǤ.
    !
    !  *day* ÿ *sec* Ԥޤ. *sec*  *day_seconds*
    ! (ά dc_date_types#day_seconds) Ķ, *day*
    ! ˷夲Ԥޤ.
    ! ޤ, *sec*  *day* 椬դξ, Ʊˤʤ褦
    ! ꤷޤ.
    !
    use dc_date_types, only: &
      & flag_set_day_seconds_scl, day_seconds_scl
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modulo, int, abs, sign
    implicit none
    type(DC_SCALED_SEC), intent(inout):: day
    type(DC_SCALED_SEC), intent(inout):: sec
    type(DC_SCALED_SEC), intent(in), optional:: day_seconds
    logical, intent(in):: nondim_flag
    type(DC_SCALED_SEC):: sgn, day_sec, zero_sec
  continue
    if ( nondim_flag ) return
    if (present(day_seconds)) then
      day_sec = day_seconds
    else
      if ( .not. flag_set_day_seconds_scl ) call dcdate_set_day_seconds_scl
      day_sec = day_seconds_scl
    end if
    if (abs(sec) >= day_sec) then
      day = day + int(sec / day_sec)
      sec = modulo(sec, day_sec)
    end if
!!    zero_sec = 0  (ǥե = 0 Ѥ). 
    if (      ( sec > zero_sec .and. day < zero_sec ) &
      &  .or. ( sec < zero_sec .and. day > zero_sec )   ) then
      sgn = sign(day, 1)
      day = day - sgn
      sec = sec + sgn * day_sec
    endif
  end subroutine dcdate_normalize

  subroutine dcdate_set_day_seconds_scl
    use dc_scaledsec, only: DC_SCALED_SEC, assignment(=)
    use dc_date_types, only: day_seconds,  &
      & flag_set_day_seconds_scl, day_seconds_scl
  continue
    if ( .not. flag_set_day_seconds_scl ) then
      flag_set_day_seconds_scl = .true.
      day_seconds_scl = day_seconds
    end if
  end subroutine dcdate_set_day_seconds_scl

  subroutine dcdate_nondimcheck(opr, diff1, diff2, rslt)
    !
    ! Υ֥롼ʤΤ dc_date ⥸塼볰Ǥ
    ! ϻѤʤǤ.
    !
    ! diff1  diff2 ξȤͭ⤷̵å, 
    ! ξƱǤ, η̤ rslt ŬѤޤ. 
    ! 2Ĥΰͭ, ⤦̵ξˤ
    ! 顼ȯޤ. 
    !
    use dc_error, only: StoreError, DC_EDIMTIME
    implicit none
    character(*), intent(in):: opr  ! 黻Ҥ̾
    type(DC_DIFFTIME), intent(in):: diff1, diff2
    type(DC_DIFFTIME), intent(inout):: rslt
  continue
    if (      (       diff1 % nondim_flag .and. .not. diff2 % nondim_flag ) &
      &  .or. ( .not. diff1 % nondim_flag .and.       diff2 % nondim_flag ) ) then
      call StoreError(DC_EDIMTIME, opr)
    end if
    rslt % nondim_flag = diff1 % nondim_flag
  end subroutine dcdate_nondimcheck

  function ParseTimeUnits(str) result(symbol)
    !
    !  *str* Ϳ줿ʸᤷ, ñ̤򼨤
    ! ܥ֤ޤ. 줾ʲʸñ̤ȤƲᤵޤ.
    ! ʸȾʸ϶̤ޤ.
    !
    ! ǯ         :: dc_date_types#UNIT_YEAR
    !          :: dc_date_types#UNIT_MONTH
    !          :: dc_date_types#UNIT_DAY
    !          :: dc_date_types#UNIT_HOUR
    ! ʬ         :: dc_date_types#UNIT_MIN
    !          :: dc_date_types#UNIT_SEC
    ! ̵ :: dc_date_types#UNIT_NONDIM
    !
    ! ֤륷ܥ () ϰʲ̤Ǥ. 
    !
    ! ǯ         :: dc_date_types#UNIT_SYMBOL_YEAR
    !          :: dc_date_types#UNIT_SYMBOL_MONTH
    !          :: dc_date_types#UNIT_SYMBOL_DAY
    !          :: dc_date_types#UNIT_SYMBOL_HOUR
    ! ʬ         :: dc_date_types#UNIT_SYMBOL_MIN
    !          :: dc_date_types#UNIT_SYMBOL_SEC
    ! ̵ :: dc_date_types#UNIT_SYMBOL_NONDIM
    !
    ! ˳ʤʸ *str* Ϳ, 
    ! dc_date_types#UNIT_SYMBOL_ERR ֤ޤ. 
    !
    use dc_types, only: TOKEN
    use dc_date_types, only: UNIT_YEAR, UNIT_MONTH, UNIT_DAY, &
      & UNIT_HOUR, UNIT_MIN, UNIT_SEC, UNIT_NONDIM, &
      & UNIT_SYMBOL_YEAR, UNIT_SYMBOL_MONTH, UNIT_SYMBOL_DAY, &
      & UNIT_SYMBOL_HOUR, UNIT_SYMBOL_MIN, UNIT_SYMBOL_SEC, &
      & UNIT_SYMBOL_NONDIM, UNIT_SYMBOL_ERR
    use dc_string, only: StriEq
    implicit none
    character(*), intent(in):: str
    integer:: symbol
    integer:: unit_str_size, i
    character(TOKEN):: unit
  continue
    unit = adjustl(str)
    unit_str_size = size(UNIT_NONDIM)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_NONDIM(i)))) then
        symbol = UNIT_SYMBOL_NONDIM
        return
      end if
    end do

    unit_str_size = size(UNIT_SEC)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_SEC(i)))) then
        symbol = UNIT_SYMBOL_SEC
        return
      end if
    end do

    unit_str_size = size(UNIT_MIN)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MIN(i)))) then
        symbol = UNIT_SYMBOL_MIN
        return
      end if
    end do

    unit_str_size = size(UNIT_HOUR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_HOUR(i)))) then
        symbol = UNIT_SYMBOL_HOUR
        return
      end if
    end do

    unit_str_size = size(UNIT_DAY)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_DAY(i)))) then
        symbol = UNIT_SYMBOL_DAY
        return
      end if
    end do

    unit_str_size = size(UNIT_MONTH)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MONTH(i)))) then
        symbol = UNIT_SYMBOL_MONTH
        return
      end if
    end do

    unit_str_size = size(UNIT_YEAR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_YEAR(i)))) then
        symbol = UNIT_SYMBOL_YEAR
        return
      end if
    end do

    symbol = UNIT_SYMBOL_ERR

  end function ParseTimeUnits

  character(TOKEN) function dcdate_parse_unit(str) result(unit)
    !
    ! Υ֥롼ʤΤ dc_date ⥸塼볰Ǥ
    ! ϻѤʤǤ.
    !
    !  *str* Ϳ줿ʸᤷ, ñ̤
    ! ֤ޤ. 줾ʲʸñ̤ȤƲᤵޤ.
    ! ʸȾʸ϶̤ޤ.
    ! ֤ʸϰʲʸƬʸǤ.
    ! (: *str*  'hrs.' Ϳ, dc_date_types#UNIT_HOUR
    ! Ƭʸ UNIT_HOUR(1) ֤ޤ.)
    !
    ! ǯ         :: dc_date_types#UNIT_YEAR
    !          :: dc_date_types#UNIT_MONTH
    !          :: dc_date_types#UNIT_DAY
    !          :: dc_date_types#UNIT_HOUR
    ! ʬ         :: dc_date_types#UNIT_MIN
    !          :: dc_date_types#UNIT_SEC
    ! ̵ :: dc_date_types#UNIT_NONDIM
    !
    ! ˳ʤʸ *str* Ϳ, ʸ֤ޤ.
    !
    use dc_types, only: TOKEN
    use dc_date_types, only: UNIT_YEAR, UNIT_MONTH, UNIT_DAY, &
      & UNIT_HOUR, UNIT_MIN, UNIT_SEC, UNIT_NONDIM
    use dc_string, only: StriEq
    implicit none
    character(*), intent(in):: str
    integer :: unit_str_size, i
  continue
    unit = adjustl(str)
    unit_str_size = size(UNIT_NONDIM)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_NONDIM(i)))) then
        unit = UNIT_NONDIM(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_SEC)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_SEC(i)))) then
        unit = UNIT_SEC(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_MIN)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MIN(i)))) then
        unit = UNIT_MIN(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_HOUR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_HOUR(i)))) then
        unit = UNIT_HOUR(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_DAY)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_DAY(i)))) then
        unit = UNIT_DAY(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_MONTH)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MONTH(i)))) then
        unit = UNIT_MONTH(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_YEAR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_YEAR(i)))) then
        unit = UNIT_YEAR(1)
        return
      end if
    end do

    unit = ''

  end function dcdate_parse_unit

end module dc_date_internal
